/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;

public class MoveDetailFiltersToTabularQuery
extends RQPTransformation {
    public MoveDetailFiltersToTabularQuery() {
        this.mName = "Move Detail Filters to RQPTabularQuery.";
        this.mPassNumbers = new int[]{49};
        this.mTypes = new int[]{801011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery parentQuery = RQPNode.getRQPQuery(node);
        RQPTabularQuery tabularQuery = parentQuery.getDefaultTabularQuery();
        IXQEQueryNode[] detailFilters = node.getChildren();
        for (int i = 0; i < detailFilters.length; ++i) {
            detailFilters[i].detach();
            tabularQuery.addToDetailFilterList(environment, detailFilters[i]);
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        int[] types;
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery parentQuery = RQPNode.getRQPQuery(node);
        if (parentQuery.getType() != 801017) {
            this.traceNodeCondition(false, "The filters are already under the tabular query.", xqeTrace);
            return false;
        }
        if (parentQuery.isBridgeTabularQuery()) {
            this.traceNodeCondition(false, "This is a bridge tabular query.", xqeTrace);
            return false;
        }
        if (parentQuery.isBridgeWrapperQuery()) {
            this.traceNodeCondition(false, "This is a wrapped bridge query.", xqeTrace);
            return false;
        }
        if (parentQuery.getRootRQPQuery() == parentQuery && parentQuery.isMultiFactQuery()) {
            this.traceNodeCondition(false, "The filters after the stitch of fact queries should not be moved to tabular query.", xqeTrace);
            return false;
        }
        RQPProjectionList projList = parentQuery.getProjectionList();
        if (0 == projList.getDescendantsOfTypes(types = new int[]{801009, 201116, 201097, 201060}, false).length) {
            return false;
        }
        this.traceNodeCondition(true, "The detail filters need to be moved to the tabular query.", xqeTrace);
        return true;
    }
}

