/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.OData;

import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemFolder;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.IUndirectedGraph;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ODataUtilities {
    public static IRelationship createArelationship(IMetadata left, IMetadata right, IRelationship.Cardinality lCard, IRelationship.Cardinality rCard, boolean b) {
        return new ODataRelationship(left, right, lCard, rCard, b);
    }

    public static IMetadata getOwnerQuerySubjectOrMultiSetFolder(IMetadata qi) {
        for (IMetadata parent = qi; parent != null; parent = parent.getParentObject()) {
            IDataType dt;
            if (!(parent instanceof IQueryItemFolder ? MultisetType.MULTISETTYPE.equals(dt = parent.getDataType()) : parent instanceof IQuerySubject)) continue;
            return parent;
        }
        return null;
    }

    public static boolean getQuerySubjectAndMultiSetFoldersAndRelationships(IQuerySubject qs, Set<IMetadata> rtQuerySubjects, List<IMetadata> allJoins) {
        LinkedList<IMetadata> stack = new LinkedList<IMetadata>();
        return ODataUtilities.buildDummyJoins(qs, stack, rtQuerySubjects, allJoins);
    }

    private static boolean buildDummyJoins(IMetadata obj, LinkedList<IMetadata> stack, Set<IMetadata> rtQuerySubjects, List<IMetadata> allJoins) {
        IDataType dt;
        boolean bPop = false;
        if (obj instanceof IQuerySubject) {
            stack.addLast(obj);
            bPop = true;
            if (rtQuerySubjects != null) {
                rtQuerySubjects.add(obj);
            }
        }
        if (obj instanceof IQueryItemFolder && MultisetType.MULTISETTYPE.equals(dt = ((IQueryItemFolder)obj).getDataType())) {
            stack.addLast(obj);
            bPop = true;
            if (rtQuerySubjects != null) {
                rtQuerySubjects.add(obj);
            }
        }
        List<IMetadata> children = obj.getChildMetadataObjects();
        for (IMetadata child : children) {
            IDataType dt2;
            if (child instanceof IQueryItemFolder && MultisetType.MULTISETTYPE.equals(dt2 = ((IQueryItemFolder)child).getDataType())) {
                IQueryItemFolder folder = (IQueryItemFolder)child;
                IRelationship.Cardinality parentCard = folder.getParentCardinality();
                IRelationship.Cardinality card = folder.getCardinality();
                if (parentCard == null || card == null) {
                    return false;
                }
                if (allJoins != null) {
                    ODataRelationship dummy = new ODataRelationship(stack.getLast(), child, parentCard, card, true);
                    allJoins.add(dummy);
                }
            }
            if (ODataUtilities.buildDummyJoins(child, stack, rtQuerySubjects, allJoins)) continue;
            return false;
        }
        if (bPop) {
            stack.removeLast();
        }
        return true;
    }

    public static FactFinder createFactFinder(PlanningEnvironment environment, IQuerySubject qs, Set<IMetadata> usedItems, Set<IMetadata> involvedQS) {
        HashMap<String, IMetadata> mapLookUp = new HashMap<String, IMetadata>();
        HashMap<String, IMetadata> idToJoin = new HashMap<String, IMetadata>();
        IUndirectedGraph graph = ODataUtilities.createUndirectedGraph(environment, qs, usedItems, involvedQS, mapLookUp, idToJoin);
        if (graph == null) {
            return null;
        }
        int[] totalWeight = new int[1];
        ArrayList<String> myNodes = new ArrayList<String>();
        for (IMetadata m : involvedQS) {
            myNodes.add(m.getID());
        }
        ArrayList<String> nodesInPath = new ArrayList<String>();
        ArrayList<String> onlyPath = new ArrayList<String>();
        graph.getShortestPathTree(myNodes, nodesInPath, onlyPath, totalWeight);
        FactFinder ff = new FactFinder(environment);
        ArrayList<IMetadata> path = new ArrayList<IMetadata>();
        for (String sj : onlyPath) {
            path.add(mapLookUp.get(sj));
        }
        ff.addJoinPath(path);
        return ff;
    }

    public static IUndirectedGraph createUndirectedGraph(PlanningEnvironment environment, IQuerySubject qs, Set<IMetadata> usedItems, Set<IMetadata> involvedQS, HashMap<String, IMetadata> mapLookUp, HashMap<String, IMetadata> idToJoin) {
        for (IMetadata modelObj : usedItems) {
            IQuerySubject theParentQS;
            IMetadata ownerQS = null;
            if (modelObj instanceof IQueryItem) {
                theParentQS = ((IQueryItem)modelObj).getQuerySubject();
                if (qs != theParentQS) {
                    return null;
                }
                ownerQS = ODataUtilities.getOwnerQuerySubjectOrMultiSetFolder(modelObj);
            } else if (modelObj instanceof IQuerySubject) {
                if (qs != modelObj) {
                    return null;
                }
                ownerQS = modelObj;
            } else if (modelObj instanceof IQueryItemFolder) {
                theParentQS = ((IQueryItemFolder)modelObj).getQuerySubject();
                if (qs != theParentQS) {
                    return null;
                }
                ownerQS = ODataUtilities.getOwnerQuerySubjectOrMultiSetFolder(modelObj);
            }
            if (ownerQS == null) continue;
            involvedQS.add(ownerQS);
        }
        if (involvedQS.size() <= 1) {
            return null;
        }
        ArrayList<IMetadata> allJoins = new ArrayList<IMetadata>();
        if (!ODataUtilities.getQuerySubjectAndMultiSetFoldersAndRelationships(qs, null, allJoins) || allJoins.isEmpty()) {
            return null;
        }
        for (IMetadata j : allJoins) {
            mapLookUp.put(j.getID(), j);
        }
        return RQPUtilities.buildGraph(environment, allJoins, idToJoin, null);
    }

    public static boolean isUsingOData(PlanningEnvironment environment) {
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        List<IModelDataSource> datasources = metadataConnection.getModelDataSources();
        for (IModelDataSource datasource : datasources) {
            if (!DataSourceTypeEnum.isOData(datasource.getInterface())) continue;
            return true;
        }
        return false;
    }

    public static boolean isUsingJSON(PlanningEnvironment environment) {
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        List<IModelDataSource> datasources = metadataConnection.getModelDataSources();
        for (IModelDataSource datasource : datasources) {
            if (!DataSourceTypeEnum.isJSON(datasource.getInterface())) continue;
            return true;
        }
        return false;
    }

    private static final class ODataRelationship
    implements IRelationship {
        private static final String SP = " <--> ";
        private final IMetadata leftObj;
        private final IMetadata rightObj;
        private final IRelationship.Cardinality leftCard;
        private final IRelationship.Cardinality rightCard;
        private final String id;
        private boolean isDummy;

        private ODataRelationship(IMetadata left, IMetadata right, IRelationship.Cardinality lCard, IRelationship.Cardinality rCard, boolean b) {
            this.leftObj = left;
            this.rightObj = right;
            this.leftCard = lCard;
            this.rightCard = rCard;
            this.id = this.leftObj.getID() + SP + this.rightObj.getID();
            this.isDummy = b;
        }

        @Override
        public String getUniqueName() {
            return this.id;
        }

        @Override
        public Object getProperty(String propertyName) {
            return null;
        }

        @Override
        public IDataType getDataType() {
            return null;
        }

        @Override
        public MetadataConnection getConnection() {
            return null;
        }

        @Override
        public IMetadata getParentObject() {
            return null;
        }

        @Override
        public String getV5UniqueName() {
            return this.id;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public boolean hasChildMetadataObjects() {
            return false;
        }

        @Override
        public String getDescription() {
            return this.id;
        }

        @Override
        public String getScreenTip() {
            return this.id;
        }

        @Override
        public String getUniqueID() {
            return this.id;
        }

        @Override
        public String getCaption() {
            return this.id;
        }

        @Override
        public BeanPropertySupport getBeanPropertySupport() {
            return null;
        }

        @Override
        public boolean isDMR() {
            return false;
        }

        @Override
        public boolean isMFW() {
            return false;
        }

        @Override
        public IMetadata getParentObjectSkipFolders() {
            return null;
        }

        @Override
        public boolean isAccessible() {
            return false;
        }

        @Override
        public void setParentMetadataObject(IMetadata parent) {
        }

        @Override
        public IMultiRequestHandle[] getHandles() {
            return null;
        }

        @Override
        public String getName() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof ODataRelationship) {
                return this.id.equals(((ODataRelationship)other).getID());
            }
            return false;
        }

        @Override
        public int compareTo(Object other) {
            if (this.equals(other)) {
                return 0;
            }
            if (other instanceof ODataRelationship) {
                return this.id.compareTo(((ODataRelationship)other).getID());
            }
            return -1;
        }

        @Override
        public IMetadata getLeftRefObject() {
            return this.leftObj;
        }

        @Override
        public IMetadata getRightRefObject() {
            return this.rightObj;
        }

        @Override
        public String getLeftRefObjectId() {
            return this.leftObj.getID();
        }

        @Override
        public String getRightRefObjectId() {
            return this.rightObj.getID();
        }

        @Override
        public String getExpression() {
            return null;
        }

        @Override
        public Enum<IRelationship.Cardinality> getLeftCardinality() {
            return this.leftCard;
        }

        @Override
        public Enum<IRelationship.Cardinality> getRightCardinality() {
            return this.rightCard;
        }

        @Override
        public boolean isMany(Enum<IRelationship.Cardinality> card) {
            return card == IRelationship.Cardinality.ZERO_MANY || card == IRelationship.Cardinality.ONE_MANY;
        }

        @Override
        public boolean isOne(Enum<IRelationship.Cardinality> card) {
            return card == IRelationship.Cardinality.ZERO_ONE || card == IRelationship.Cardinality.ONE_ONE;
        }

        @Override
        public boolean isDummy() {
            return this.isDummy;
        }

        @Override
        public Set<String> getAvailableProperties() {
            return null;
        }

        @Override
        public IRelationship.JoinFilterType getJoinFilterType() {
            return null;
        }

        @Override
        public MetadataType getObjectType() {
            return null;
        }

        @Override
        public List<IMetadata> getChildMetadataObjects() {
            return null;
        }

        @Override
        public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
            return null;
        }

        @Override
        public String getFJOAdvancedProperty() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isVisible(boolean inShortcut) {
            return false;
        }
    }
}

