/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5CastFunction;
import com.cognos.xqe.ast.v5Exp.V5CastTarget;
import com.cognos.xqe.ast.v5Exp.V5IfExpression;
import com.cognos.xqe.ast.v5Exp.V5IsNullExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DetectNoOpAggregates;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.util.Governors;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class ProcessNoOpAggregates
extends RQPTransformation {
    public static final String ZERO_STRING = "0";

    public ProcessNoOpAggregates() {
        this.mName = "ProcessNoOpAggregates";
        this.mPassNumbers = new int[]{54};
        this.mTypes = new int[]{201031, 201033};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Governors.AggregateOverHigherLevelAggregate aggregateOverHigherLevelAggregate = node.getGovernors().getAggregateOverHigherLevelAggregate();
        this.handleNoopGovernor(node, environment, aggregateOverHigherLevelAggregate);
        if (node.getType() == 201033) {
            IXQEQueryNode[] forChildren = DetectNoOpAggregates.getScope((V5AggregateFunction)node, null);
            V5AggregateBreakClause forClause = ((V5AggregateFunction)node).getForClause();
            if (forChildren != null && forClause != null && 0 < forClause.getNumberChildren()) {
                IXQEQueryNode innerAggr = DetectNoOpAggregates.getInnerStandardAggregate(node, environment);
                IXQEQueryNode[] innerGroupingItems = DetectNoOpAggregates.getScope((V5AggregateFunction)innerAggr, environment);
                IXQEQueryNode[] forItem = new IXQEQueryNode[1];
                IXQEQueryNode[] iXQEQueryNodeArray = forChildren;
                int n = iXQEQueryNodeArray.length;
                for (int i = 0; i < n; ++i) {
                    IXQEQueryNode forChild;
                    forItem[0] = forChild = iXQEQueryNodeArray[i];
                    if (innerGroupingItems != null && RQPSummaryQuery.groupingItemsAreSubsetOf(forItem, innerGroupingItems)) continue;
                    forClause.removeForClauseItem(forChild);
                }
            }
            node.removeProperty("noop");
            return;
        }
        V5AggregateBreakClause forClause = ((V5AggregateFunction)node).getForClause();
        if (forClause != null) {
            forClause.detach();
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        int outerAggrSubType = ((V5ValueSummaryFunction)node).getSubType();
        IXQEQueryNode simplifiedExpr = null;
        switch (outerAggrSubType) {
            case 2: 
            case 34: {
                simplifiedExpr = ProcessNoOpAggregates.buildIfExpressionForCount(node, nodeFactory);
                break;
            }
            case 7: 
            case 10: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: {
                V5CastTarget castTarget = (V5CastTarget)nodeFactory.createNode(201052);
                castTarget.setDataType(DataTypeFactory.getDoubleType());
                V5CastFunction castFunction = (V5CastFunction)nodeFactory.createNode(201051);
                castFunction.addChild(nodeFactory.createNode(201023));
                castFunction.addChild(castTarget);
                simplifiedExpr = castFunction;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 33: 
            case 43: {
                simplifiedExpr = node.getChild(0);
                break;
            }
            case 8: 
            case 11: 
            case 29: 
            case 30: 
            case 38: 
            case 39: 
            case 40: {
                V5CastTarget castTarget = (V5CastTarget)nodeFactory.createNode(201052);
                castTarget.setDataType(DataTypeFactory.getDoubleType());
                V5CastFunction castFunction = (V5CastFunction)nodeFactory.createNode(201051);
                V5LiteralValue literalZero = (V5LiteralValue)nodeFactory.createNode(201026);
                literalZero.setDataType(IntegerType.INTEGERTYPE);
                literalZero.setValue(ZERO_STRING);
                castFunction.addChild(literalZero);
                castFunction.addChild(castTarget);
                simplifiedExpr = castFunction;
                break;
            }
            case 32: {
                simplifiedExpr = node.getChild(1);
                break;
            }
            default: {
                return;
            }
        }
        if (RQPNode.getRQPQuery(node).isSummarizedQuery()) {
            RQPDataItem rqpDataItem = (RQPDataItem)node.getAncestorOfType(801008);
            if (rqpDataItem != null && !rqpDataItem.isGroupingItem() && this.allNestedAggregatesHaveHigherScope(node, simplifiedExpr)) {
                rqpDataItem.updateReferencesWithExpression(environment, simplifiedExpr);
                rqpDataItem.detach();
            } else {
                node.exchange(simplifiedExpr);
            }
        } else {
            node.exchange(simplifiedExpr);
        }
    }

    private boolean allNestedAggregatesHaveHigherScope(IXQEQueryNode outerAggr, IXQEQueryNode innerExpr) {
        if (innerExpr != null) {
            IXQEQueryNode[] aggrs;
            RQPGroupByList groupByList = RQPNode.getRQPQuery(outerAggr).getGroupByList();
            if (groupByList == null) {
                return false;
            }
            IXQEQueryNode[] groupByItems = groupByList.getChildren();
            for (IXQEQueryNode aggr : aggrs = ExpressionAnalyzer.getAggregateNodes(innerExpr)) {
                IXQEQueryNode forClause = aggr.getFirstChildByType(201037);
                if (forClause == null) {
                    return false;
                }
                if (forClause.getNumberChildren() >= groupByItems.length) {
                    return false;
                }
                if (RQPSummaryQuery.groupingItemsAreSubsetOf(forClause.getChildren(), groupByItems)) continue;
                return false;
            }
        }
        return true;
    }

    private void handleNoopGovernor(IXQEQueryNode node, PlanningEnvironment environment, Governors.AggregateOverHigherLevelAggregate noopGovernorSetting) {
        String allNoOpAggregates = "";
        if (noopGovernorSetting == Governors.AggregateOverHigherLevelAggregate.DENY || noopGovernorSetting == Governors.AggregateOverHigherLevelAggregate.WARN) {
            RQPQuery rootQuery = RQPNode.getRQPQuery(node).getRootRQPQuery();
            List<IXQEQueryNode> aggregates = rootQuery.getDescendantsOfTypesOrdered(new int[]{201031, 201033}, false);
            for (IXQEQueryNode aggregate : aggregates) {
                if (null == aggregate.getPropertyValue("noop")) continue;
                allNoOpAggregates = allNoOpAggregates + ((V5AggregateFunction)aggregate).getNativeName() + ",";
            }
            if (noopGovernorSetting == Governors.AggregateOverHigherLevelAggregate.DENY) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_AggregateOverHigherLevelAggregate, allNoOpAggregates);
            }
        }
        if (noopGovernorSetting == Governors.AggregateOverHigherLevelAggregate.WARN) {
            ExecutionEnvironment ee = (ExecutionEnvironment)environment.getExecutionEnvironment();
            String nagMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_AggregateOverHigherLevelAggregate, XQEMessages.getCurrProductLocale(), allNoOpAggregates);
            ee.addNag(nagMsg);
        }
    }

    public static V5IfExpression buildIfExpressionForCount(IXQEQueryNode outerCount, XQENodeFactory nodeFactory) {
        IXQEQueryNode[] children = outerCount.getChildren();
        outerCount.detachChildren();
        V5IsNullExpression nullExpr = (V5IsNullExpression)nodeFactory.createNode(201010);
        nullExpr.addChildren(children, 0);
        V5LiteralValue literalZero = (V5LiteralValue)nodeFactory.createNode(201026);
        literalZero.setDataType(IntegerType.INTEGERTYPE);
        literalZero.setValue(ZERO_STRING);
        String oneString = "1";
        V5LiteralValue literalOne = (V5LiteralValue)nodeFactory.createNode(201026);
        literalOne.setDataType(IntegerType.INTEGERTYPE);
        literalOne.setValue(oneString);
        V5IfExpression ifExpr = (V5IfExpression)nodeFactory.createNode(201017);
        ifExpr.addChild(nullExpr);
        ifExpr.addChild(literalZero);
        ifExpr.addChild(literalOne);
        return ifExpr;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        return null != node.getPropertyValue("noop");
    }
}

