/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ProcessNonProjectedSortItems
extends RQPTransformation {
    public ProcessNonProjectedSortItems() {
        this.mName = "Add non-projected sort items into projections and group-by lists.";
        this.mPassNumbers = new int[]{12};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mTypes = new int[]{101056};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rootQuery = (RQPQuery)node.getAncestorOfType(801017);
        V5Selection v5Selection = rootQuery.getRefV5Query().getV5Selection();
        V5SortItem sortItem = (V5SortItem)node;
        String refDataItem = sortItem.getRefDataItem();
        V5DataItem v5DataItem = v5Selection.getDataItemByRefName(refDataItem);
        RQPDataItem rqpDataItemRQ = null;
        V5ValueSet valueSetOfSortItem = (V5ValueSet)sortItem.getAncestorOfType(101057);
        V5ValueSet nestedValueSet = RQPUtilities.getNestedValueSet(rootQuery, valueSetOfSortItem);
        rqpDataItemRQ = rootQuery.createRQPDataItem(environment, refDataItem);
        rqpDataItemRQ.addChild(environment.getNodeFactory().deepCopyNode(v5DataItem));
        if (rootQuery.isAutoSummaryTRUE() && nestedValueSet == null && !v5DataItem.isAggregate()) {
            rqpDataItemRQ.setGroupingItem(true);
            rqpDataItemRQ.setBelongsToLastValueSet(true);
        }
        if (nestedValueSet != null) {
            rqpDataItemRQ.setValueSet(nestedValueSet);
            rqpDataItemRQ.setIsFooterItem(true);
        } else {
            rqpDataItemRQ.setValueSet(valueSetOfSortItem);
        }
        rqpDataItemRQ.setIsNonProjectedSortItem();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] valueSets;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        V5SortItem v5SortItem = (V5SortItem)node;
        V5ValueSet v5ValueSet = (V5ValueSet)v5SortItem.getParent();
        String valueSetKey = v5ValueSet.getRefDataItemProperty();
        String sortItemName = v5SortItem.getRefDataItem();
        V5GroupBody v5GroupBody = (V5GroupBody)v5ValueSet.getFirstChildByType(101051);
        if (valueSetKey != null && valueSetKey.equals(sortItemName) || this.isSortItemInGroupBody(sortItemName, v5GroupBody)) {
            this.traceNodeCondition(false, "V5SortItem is a projected item.", xqeTrace);
            return false;
        }
        V5Edge edge = (V5Edge)node.getAncestorOfType(101049);
        for (IXQEQueryNode current : valueSets = edge.getDescendantsOfType(101057, false)) {
            V5ValueSet groupValueSet = (V5ValueSet)current;
            String qRef = groupValueSet.getRefDataItemProperty();
            if (qRef == null || !sortItemName.equals(qRef)) continue;
            this.traceNodeCondition(false, "V5SortItem is projected as a grouping item", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "V5SortItem is not a projected item.", xqeTrace);
        return true;
    }

    private boolean isSortItemInGroupBody(String sortItemName, V5GroupBody v5GroupBody) {
        if (v5GroupBody != null) {
            for (int iChild = 0; iChild < v5GroupBody.getNumberChildren(); ++iChild) {
                IXQEQueryNode gbItem = v5GroupBody.getChild(iChild);
                String gbItemName = (String)gbItem.getPropertyValue("refDataItem");
                if (!sortItemName.equals(gbItemName)) continue;
                return true;
            }
        }
        return false;
    }
}

