/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.SplitSummaryQueryToAvoidGeneratingNestedStdAggregates;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class PushAggregateToOperandToAvoidStitchingTQandSQ
extends SplitSummaryQueryToAvoidGeneratingNestedStdAggregates {
    public PushAggregateToOperandToAvoidStitchingTQandSQ() {
        this.mName = "PushAggregateToOperandToAvoidStitchingTQandSQ";
        this.mPassNumbers = new int[]{75};
        this.mTypes = new int[]{201031};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent = node.getParent();
        V5ValueExpression valueExpression = (V5ValueExpression)node.getChild(0);
        IXQEQueryNode leftOperand = valueExpression.getChild(0);
        IXQEQueryNode rightOperand = valueExpression.getChild(1);
        valueExpression.move(parent);
        node.detach();
        if (valueExpression.getSubType() == 3) {
            leftOperand.insertParent(node);
        } else if (ExpressionAnalyzer.exprOrRefExprHasStandardAggregate(leftOperand)) {
            rightOperand.insertParent(node);
        } else {
            leftOperand.insertParent(node);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        if (super.passesNodeCondition(node, environment)) {
            V5ValueSummaryFunction sf = (V5ValueSummaryFunction)node;
            switch (sf.getSubType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: {
                    break;
                }
                default: {
                    this.traceNodeCondition(false, "The V5SummaryFunction cannot be pushed to operand.", xqeTrace);
                    return false;
                }
            }
            IXQEQueryNode child = node.getChild(0);
            if (child.getType() != 201014) {
                this.traceNodeCondition(false, "The V5SummaryFunction is not wrapping a valueExpression.", xqeTrace);
                return false;
            }
            V5ValueExpression valueExpression = (V5ValueExpression)child;
            if (valueExpression.getSubType() != 4 && valueExpression.getSubType() != 3) {
                this.traceNodeCondition(false, "The V5SummaryFunction is not wrapping multiply or divide.", xqeTrace);
                return false;
            }
            IXQEQueryNode leftOperand = valueExpression.getChild(0);
            IXQEQueryNode rightOperand = valueExpression.getChild(1);
            if (valueExpression.getSubType() == 3) {
                if (ExpressionAnalyzer.exprOrRefExprHasStandardAggregate(leftOperand)) {
                    this.traceNodeCondition(false, "The numerator is already aggregated.", xqeTrace);
                    return false;
                }
                List<IXQEQueryNode> summaryFunctionsUnderRightOperand = rightOperand.getDescendantsOfTypesOrdered(new int[]{201031}, true);
                int numberOfAggregatesUnderConditionalClause = 0;
                for (IXQEQueryNode aggr : summaryFunctionsUnderRightOperand) {
                    IXQEQueryNode conditionalNode = ((V5ValueSummaryFunction)aggr).getAncestorOfType(new int[]{201017, 201018, 201019});
                    if (conditionalNode == null || !conditionalNode.isDescendantOfNodeInSubtree(valueExpression, 1)) continue;
                    ++numberOfAggregatesUnderConditionalClause;
                }
                if (numberOfAggregatesUnderConditionalClause == summaryFunctionsUnderRightOperand.size()) {
                    return false;
                }
            } else if (ExpressionAnalyzer.exprOrRefExprHasStandardAggregate(leftOperand) && ExpressionAnalyzer.exprOrRefExprHasStandardAggregate(rightOperand)) {
                this.traceNodeCondition(false, "The V5SummaryFunction cannot be pushed: both operands are aggregated.", xqeTrace);
                return false;
            }
            this.traceNodeCondition(true, "PushAggregateToOperandToAvoidStitchingTQandSQ passes conditions", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "PushAggregateToOperandToAvoidStitchingTQandSQ does not pass conditions", xqeTrace);
        return false;
    }
}

