/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueAnalyticFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.UpdateExplicitForClauseOfAnalyticAndRunningMovingFunctions;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class PutForClauseItemsInMinOrGroupByForAnalyticFunctions
extends RQPTransformation {
    private static final String PROP_PUT_FOR_CLAUSE_ITEMS_IN_MIN_OR_GROUPBY_OR_MIN_DONE = "PutForClauseItemsInMinOrGroupBy";
    private static final String CONFIG_PUT_FOR_CLAUSE_ITEMS_IN_MIN_FUNCTION = "queryPlanning.PutForClauseItemsInMinFunction[@value]";

    public PutForClauseItemsInMinOrGroupByForAnalyticFunctions() {
        this.mName = "Put For Clause Items In Min Or GroupBy For Analytic Functions";
        this.mPassNumbers = new int[]{126};
        this.mTypes = new int[]{201037, 201114};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getType() == 201114) {
            this.processOrderByItems(environment, node);
        } else {
            this.processForClauseItems(environment, node);
        }
        node.setPropertyValue(PROP_PUT_FOR_CLAUSE_ITEMS_IN_MIN_OR_GROUPBY_OR_MIN_DONE, Boolean.TRUE);
    }

    private void getListOfTerms(IXQEQueryNode v5ValueExpression, List<IXQEQueryNode> terms) {
        IXQEQueryNode[] children = v5ValueExpression.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (this.isDecompositionPoint(children[i])) {
                this.getListOfTerms(children[i], terms);
                continue;
            }
            terms.add(children[i]);
        }
    }

    private boolean isDecompositionPoint(IXQEQueryNode node) {
        V5SimpleNode simpleNode;
        boolean isDecompositionPoint = false;
        if (node.isOfCategory(201120) && ((simpleNode = (V5SimpleNode)node).getType() == 201014 && (simpleNode.getSubType() == 1 || simpleNode.getSubType() == 2 || simpleNode.getSubType() == 3 || simpleNode.getSubType() == 4) || simpleNode.getType() == 201040 || simpleNode.getType() == 201018 || simpleNode.getType() == 201019 || simpleNode.getType() == 201010 || simpleNode.getType() == 201003)) {
            isDecompositionPoint = true;
        }
        return isDecompositionPoint;
    }

    private void processOrderByItems(PlanningEnvironment environment, IXQEQueryNode orderByNode) {
        RQPQuery rqpQuery = RQPNode.getRQPQuery(orderByNode);
        ArrayList<IXQEQueryNode> terms = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode child = orderByNode.getChild(0);
        if (this.isDecompositionPoint(child)) {
            this.getListOfTerms(child, terms);
        } else {
            terms.add(child);
        }
        for (IXQEQueryNode term : terms) {
            if (RQPUtilities.hasAggregateInExpression(term) || PutForClauseItemsInMinOrGroupByForAnalyticFunctions.forClauseItemfoundInGroupBy(rqpQuery, term) || !PutForClauseItemsInMinOrGroupByForAnalyticFunctions.allReferencesHasHigherScope(rqpQuery, term)) continue;
            this.wrapForClauseItemWithMinFunction(environment.getNodeFactory(), term.getParent(), term);
        }
    }

    public static boolean allReferencesHasHigherScope(RQPQuery rqpQuery, IXQEQueryNode expression) {
        boolean result = false;
        for (IXQEQueryNode descendant : expression.getDescendantsOfType(801009, true)) {
            RQPDataItemRef rqpDataItemRef = (RQPDataItemRef)descendant;
            RQPQuery refQuery = rqpDataItemRef.getQuery();
            if (!refQuery.isSummarizedQuery()) {
                result = false;
                break;
            }
            IXQEQueryNode[] refQueryGroupingItems = refQuery.getGroupingItems();
            if (refQueryGroupingItems == null || refQueryGroupingItems.length == 0) {
                result = true;
                continue;
            }
            IXQEQueryNode[] rqpQueryGroupingItems = rqpQuery.getGroupingItems();
            if (!RQPSummaryQuery.groupingItemsAreSubsetOf(refQueryGroupingItems, rqpQueryGroupingItems)) {
                result = false;
                break;
            }
            result = true;
        }
        return result;
    }

    private void processForClauseItems(PlanningEnvironment environment, IXQEQueryNode forClauseNode) {
        RQPQuery rqpQuery = RQPNode.getRQPQuery(forClauseNode);
        RQPDataItem rqpDI = (RQPDataItem)forClauseNode.getAncestorOfType(801008);
        boolean olapAggInGroupingColumn = rqpDI != null && rqpDI.isGroupingItem();
        for (IXQEQueryNode forClauseChild : forClauseNode.getChildren()) {
            if (PutForClauseItemsInMinOrGroupByForAnalyticFunctions.forClauseItemfoundInGroupBy(rqpQuery, forClauseChild)) continue;
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            boolean doMin = config.getBooleanProperty(CONFIG_PUT_FOR_CLAUSE_ITEMS_IN_MIN_FUNCTION, true);
            if (doMin && !olapAggInGroupingColumn) {
                if (ExpressionAnalyzer.isStandardAggregate(forClauseChild)) continue;
                this.wrapForClauseItemWithMinFunction(environment.getNodeFactory(), forClauseNode, forClauseChild);
                continue;
            }
            if (UpdateExplicitForClauseOfAnalyticAndRunningMovingFunctions.areForClauseItemsStdAggregates(forClauseNode)) continue;
            this.putForClauseItemInGroupBy(environment, rqpQuery, forClauseNode, forClauseChild);
        }
    }

    private void putForClauseItemInGroupBy(PlanningEnvironment environment, RQPQuery rqpQuery, IXQEQueryNode v5AggregateBreakClause, IXQEQueryNode forClauseChild) {
        XQENodeFactory factory = environment.getNodeFactory();
        RQPDataItem rqpDataItemInTargetSubQuery = rqpQuery.getRQPDataItemWithSameExpression(forClauseChild);
        if (rqpDataItemInTargetSubQuery == null) {
            String rqpDataItemName = forClauseChild.getType() == 801009 ? ((RQPDataItemRef)forClauseChild).getName() : RQPNameGenerator.generateNameForNewRQPDataItem(forClauseChild, rqpQuery);
            rqpDataItemName = RQPNameGenerator.generateUniqueRQPDataItemName(rqpQuery, rqpDataItemName);
            rqpDataItemInTargetSubQuery = RQPDataItem.create(environment, rqpDataItemName);
            rqpDataItemInTargetSubQuery.addChild(factory.deepCopyNode(forClauseChild));
            rqpDataItemInTargetSubQuery.copyPropertiesFrom(v5AggregateBreakClause);
            rqpQuery.addToProjectionList(environment, rqpDataItemInTargetSubQuery);
            rqpQuery.addToGroupByList(environment, RQPDataItemSelfRef.create(environment, rqpDataItemName));
        } else {
            String rqpDataItemName = rqpDataItemInTargetSubQuery.getName();
            rqpQuery.addToGroupByList(environment, RQPDataItemSelfRef.create(environment, rqpDataItemName));
        }
    }

    private void wrapForClauseItemWithMinFunction(XQENodeFactory factory, IXQEQueryNode v5AggregateBreakClause, IXQEQueryNode forClauseChild) {
        if (forClauseChild.getType() == 201026) {
            return;
        }
        IXQEQueryNode newNode = factory.createNode(201031);
        V5ValueSummaryFunction minFunction = (V5ValueSummaryFunction)newNode;
        minFunction.setSubType(6);
        int position = v5AggregateBreakClause.getPositionOfChild(forClauseChild);
        IXQEQueryNode temp = forClauseChild.detach();
        newNode.addChild(temp);
        v5AggregateBreakClause.addChild(newNode, position);
    }

    public static boolean forClauseItemfoundInGroupBy(RQPQuery rqpQuery, IXQEQueryNode forClauseItem) {
        for (IXQEQueryNode gi : rqpQuery.getGroupingItems()) {
            RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)gi;
            IXQEQueryNode refExpression = selfRef.getExpression();
            if (!refExpression.isSameExpression(forClauseItem, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        int position;
        V5ValueAnalyticFunction analyticFunction;
        XQETrace xqeTrace = environment.getTrace();
        Object alreadyDone = node.getPropertyValue(PROP_PUT_FOR_CLAUSE_ITEMS_IN_MIN_OR_GROUPBY_OR_MIN_DONE);
        if (alreadyDone != null) {
            this.traceNodeCondition(false, "Transformation already processed FOR clause items.", xqeTrace);
            return false;
        }
        if (node.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "The V5AggregateBreakClause node has no children", xqeTrace);
            return false;
        }
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The V5AggregateBreakClause node is not under a RQP query", xqeTrace);
            return false;
        }
        if (RQPNode.isUnderRMQuery(node)) {
            this.traceNodeCondition(false, "The node cannot be transformed while under the RMQuery.", xqeTrace);
            return false;
        }
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        RQPQuery rootQuery = (RQPQuery)node.getAncestorOfType(801017);
        if (rootQuery.isAutoSummaryFALSE() && !rqpQuery.isSummarizedQuery()) {
            this.traceNodeCondition(false, "This transformation is not applied for non-summarized queries that have autoSummary=false", xqeTrace);
            return false;
        }
        if (rqpQuery.getType() == 801025) {
            this.traceNodeCondition(false, "The V5AggregateBreakClause node is under a RQPTabularQuery.", xqeTrace);
            return false;
        }
        IXQEQueryNode[] groupingItems = rqpQuery.getGroupingItems();
        if (groupingItems == null || groupingItems.length == 0) {
            this.traceNodeCondition(false, "Not a GROUP BY query.", xqeTrace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent != null && parent.getType() == 201033 && (analyticFunction = (V5ValueAnalyticFunction)parent).getSubType() == 17 && (position = parent.getPositionOfChild(node)) == 1) {
            this.traceNodeCondition(false, "The order clause belongs to the 2nd child of the quantile function.", xqeTrace);
            return false;
        }
        if (parent != null && parent.getType() != 201031) {
            this.traceNodeCondition(true, "The break clause belongs to a window aggregate", xqeTrace);
            return true;
        }
        this.traceNodeCondition(false, "The break clause does not belong to a window aggregate", xqeTrace);
        return false;
    }
}

