/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.transformation.v5.util.V5FormatResolver;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;

public class ResolveResultFormat
extends RQPTransformation {
    public ResolveResultFormat() {
        this.mName = "Resolve result format.";
        this.mPassNumbers = new int[]{23};
        this.mTypes = new int[]{801008};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        try (MetadataConnectionContext metadataConnContext = null;){
            V5Query v5Query;
            RQPQuery rqpQuery;
            if (environment.isMultimodelCase() && (rqpQuery = (RQPQuery)node.getAncestorOfType(801017)) != null && (v5Query = rqpQuery.getRefV5Query()) != null) {
                metadataConnContext = environment.pushMetadataConnectionContext(v5Query);
            }
            IXQEQueryNode expression = ((RQPDataItem)node).getExpression();
            V5FormatResolver formatResolver = new V5FormatResolver(environment);
            String formatStr = null;
            try {
                formatStr = formatResolver.getFormat(expression);
            }
            catch (XQERuntimeException xre) {
                if (((RequestEnvironment)environment.getRequestEnvironment()).isValidateRequest()) {
                    IMessageKey.Param1 msgParam = XQEMessageKeys.PLN_LoopInModelExpression;
                    ResponseMessage msg = new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, xre.getXQEMessage());
                    ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(msg, node, null);
                    formatStr = "";
                }
                throw xre;
            }
            RSAPIDataItem rsapiDataItem = (RSAPIDataItem)node.getPropertyValue("RSAPIRefDataItem");
            if (formatStr.length() != 0) {
                rsapiDataItem.setFormat(formatStr);
                FormatId id = V5FormatResolver.getFormatId(formatStr);
                rsapiDataItem.setFormatID(id);
            }
        }
        node.setPropertyValue("formatResolved", "true");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = requestEnvironment.getRequestParameters();
        if (parameters.hasUnresolvedParameters()) {
            return false;
        }
        IXQEQueryNode rqpQuery = node.getAncestorOfType(801017);
        if (rqpQuery != ((RQPDataItem)node).getRootRQPQuery()) {
            return false;
        }
        RSAPIDataItem rsapiDataItem = (RSAPIDataItem)node.getPropertyValue("RSAPIRefDataItem");
        if (rsapiDataItem == null) {
            return false;
        }
        return null == node.getPropertyValue("formatResolved");
    }
}

