/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5.query.V5SummaryFilterLevel;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateAtClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DistributeAggregatesInAppropriateSubQueries;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DistributeProjectionsInFactQueries;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ProcessDataItemRefInValueSet;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TransformTypedInAtClauseToInnerForClause
extends RQPTransformation {
    public TransformTypedInAtClauseToInnerForClause(int[] passNumbers) {
        this.mName = "TransformTypedInAtClauseToInnerForClause";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201036};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5AggregateAtClause atClause = (V5AggregateAtClause)node;
        V5AggregateFunction v5OuterAggregate = (V5AggregateFunction)atClause.getParent();
        int atPosition = v5OuterAggregate.getPositionOfChild(atClause);
        ArrayList<IXQEQueryNode> innerAggregates = new ArrayList<IXQEQueryNode>();
        RQPDataItem rqpDataItem = (RQPDataItem)v5OuterAggregate.getAncestorOfType(801008);
        V5SummaryFilter summaryFilter = (V5SummaryFilter)v5OuterAggregate.getAncestorOfType(101011);
        boolean inFilter = false;
        if (summaryFilter != null) {
            inFilter = true;
        }
        RQPQuery parentQuery = (RQPQuery)v5OuterAggregate.getAncestorOfType(801017);
        RQPQuery rootQuery = parentQuery.getRootRQPQuery();
        ArrayList<IXQEQueryNode> mergedAtFor = new ArrayList<IXQEQueryNode>(Arrays.asList(atClause.getChildren()));
        V5AggregateBreakClause outerForClauseNode = v5OuterAggregate.getForClause();
        if (outerForClauseNode != null) {
            for (IXQEQueryNode outerForClauseItem : outerForClauseNode.getChildren()) {
                if (this.listContainsSameExpression(mergedAtFor, outerForClauseItem)) continue;
                mergedAtFor.add(nodeFactory.deepCopyNode(outerForClauseItem));
            }
        }
        List<RQPDataItem> groupingItemsOfDefaultSummaryQuery = rootQuery.getProjectionsMarkedAsGroupingColumns();
        for (int i = 0; i < atPosition; ++i) {
            IXQEQueryNode[] descendants = v5OuterAggregate.getChild(i).getDescendantsOfType(201031, true);
            innerAggregates.addAll(Arrays.asList(descendants));
        }
        if (innerAggregates.size() == 0) {
            if (inFilter) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidAtClauseFilter, v5OuterAggregate.getNativeName(), summaryFilter.getOriginalExpression());
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidAtClause, v5OuterAggregate.getNativeName(), rqpDataItem.getOriginalName());
        }
        for (IXQEQueryNode innerAggregate : innerAggregates) {
            IXQEQueryNode rqpSortList;
            RQPDataItem proj;
            V5AggregateBreakClause innerForClause = ((V5AggregateFunction)innerAggregate).getForClause();
            if (innerForClause == null) {
                innerForClause = inFilter ? this.resolveScopeOfInnerForClauseInFilter(environment, rootQuery, summaryFilter, (V5AggregateFunction)innerAggregate, groupingItemsOfDefaultSummaryQuery) : this.resolveScopeOfInnerForClauseInProjection(nodeFactory, rqpDataItem, rootQuery, groupingItemsOfDefaultSummaryQuery);
                innerAggregate.addChild(innerForClause);
            }
            if (innerForClause.getChildren().length != 0) {
                List<IXQEQueryNode> intersection = this.intersection(mergedAtFor, Arrays.asList(innerForClause.getChildren()));
                if (intersection.size() != mergedAtFor.size()) {
                    if (inFilter) {
                        throw new XQERuntimeException(XQEMessageKeys.PLN_AtClauseInconsistentFilter, (Object)summaryFilter.getOriginalExpression(), (Object)((V5AggregateFunction)innerAggregate).getNativeName(), (Object)v5OuterAggregate.getNativeName());
                    }
                    throw new XQERuntimeException(XQEMessageKeys.PLN_AtClauseInconsistent, (Object)rqpDataItem.getOriginalName(), (Object)((V5AggregateFunction)innerAggregate).getNativeName(), (Object)v5OuterAggregate.getNativeName());
                }
                innerForClause.detachChildren();
            }
            for (IXQEQueryNode child : mergedAtFor) {
                innerForClause.addChild(nodeFactory.deepCopyNode(child));
            }
            if (ExpressionAnalyzer.isRunningMovingFunction(v5OuterAggregate) && (proj = (RQPDataItem)v5OuterAggregate.getAncestorOfType(801008)) != null && proj.isFooterHeaderItem()) {
                rqpSortList = rootQuery.getFirstChildByType(801020);
                int pos = -1;
                IXQEQueryNode[] sortItems = new ArrayList();
                RQPQuery rqpQuery = RQPNode.getRQPQuery(proj);
                for (int i = rqpSortList.getNumberChildren() - 1; i >= 0; --i) {
                    RQPDataItemSelfRef projRef = (RQPDataItemSelfRef)rqpSortList.getChild(i).getChild(0);
                    IXQEQueryNode sortItemExpr = projRef.getExpression();
                    if (null == rqpQuery.getRQPDataItemWithSameExpression(sortItemExpr)) continue;
                    sortItems.add(sortItemExpr);
                    if (this.listContainsSameExpression(Arrays.asList(innerForClause.getChildren()), sortItemExpr)) {
                        pos = i;
                        continue;
                    }
                    if (pos != -1) {
                        innerForClause.addChild(nodeFactory.deepCopyNode(sortItemExpr));
                        continue;
                    }
                    if (i != 0) continue;
                    for (int j = 0; j < sortItems.size(); ++j) {
                        innerForClause.addChild((IXQEQueryNode)sortItems.get(j));
                    }
                }
            }
            if (!ExpressionAnalyzer.isRunningMovingFunction(v5OuterAggregate) || !ExpressionAnalyzer.isHigherScope(mergedAtFor, groupingItemsOfDefaultSummaryQuery) || ((V5AggregateFunction)innerAggregate).getRollupAggregateNode()) continue;
            IXQEQueryNode innerAggregateParent = innerAggregate.getParent();
            rqpSortList = rootQuery.getFirstChildByType(801020);
            ArrayList<IXQEQueryNode> sortitems = new ArrayList();
            if (rqpSortList == null || rqpSortList.getChildren().length == 0) {
                sortitems = mergedAtFor;
            } else {
                for (IXQEQueryNode sort : rqpSortList.getChildren()) {
                    sortitems.add(sort.getChild(0));
                }
            }
            IXQEQueryNode rowNumberExpr = ExpressionAnalyzer.createRowNumberExpr(nodeFactory, mergedAtFor, sortitems);
            IXQEQueryNode caseExpr = ExpressionAnalyzer.createCaseExpression(nodeFactory, rowNumberExpr, innerAggregate);
            innerAggregateParent.addChild(caseExpr);
        }
        atClause.detach();
    }

    private V5AggregateBreakClause resolveScopeOfInnerForClauseInFilter(PlanningEnvironment environment, RQPQuery rootQuery, V5SummaryFilter summaryFilter, V5AggregateFunction innerAggregate, List<RQPDataItem> groupingItemsOfDefaultSummaryQuery) {
        V5AggregateBreakClause innerForClause = (V5AggregateBreakClause)environment.getNodeFactory().createNode(201037);
        RQPSummaryFilterList.AggregateScope aggScope = DistributeAggregatesInAppropriateSubQueries.determineScopeOfAggregateInFilterExpression(summaryFilter, innerAggregate, environment, innerAggregate);
        switch (aggScope) {
            case explicitForClause: {
                break;
            }
            case forReportScope: {
                break;
            }
            case defaultSummaryScope: {
                for (RQPDataItem groupingItem : groupingItemsOfDefaultSummaryQuery) {
                    innerForClause.addChild(environment.getNodeFactory().deepCopyNode(groupingItem.getExpression()));
                }
                break;
            }
            case summaryFilterLevelScope: {
                V5SummaryFilterLevel summaryFilterLevel = (V5SummaryFilterLevel)summaryFilter.getFirstChildByType(101012);
                String levelRef = summaryFilterLevel.getRefDataItem();
                this.adjustScopeToLevelRef(environment, innerForClause, rootQuery, levelRef);
                break;
            }
            case contextLevelScope: {
                String levelRef = (String)innerAggregate.getPropertyValue("contextLevel");
                this.adjustScopeToLevelRef(environment, innerForClause, rootQuery, levelRef);
                break;
            }
        }
        return innerForClause;
    }

    private V5AggregateBreakClause resolveScopeOfInnerForClauseInProjection(XQENodeFactory nodeFactory, RQPDataItem rqpDataItem, RQPQuery rootQuery, List<RQPDataItem> groupingItemsOfDefaultSummaryQuery) {
        V5AggregateBreakClause innerForClause = (V5AggregateBreakClause)nodeFactory.createNode(201037);
        V5ValueSet v5ValueSet = rqpDataItem.getRollupScope();
        if (v5ValueSet != null) {
            List<V5DataItem> groupingItemsOfFooter = ProcessDataItemRefInValueSet.getGroupingItems(v5ValueSet, rootQuery, true);
            List<RQPDataItem> rqpGroupingItems = DistributeProjectionsInFactQueries.convertListV5DataItemToListRQPDataItem(rootQuery, groupingItemsOfFooter);
            for (RQPDataItem rqpGroupingItem : rqpGroupingItems) {
                innerForClause.addChild(nodeFactory.deepCopyNode(rqpGroupingItem.getExpression()));
            }
        } else {
            for (RQPDataItem groupingItem : groupingItemsOfDefaultSummaryQuery) {
                innerForClause.addChild(nodeFactory.deepCopyNode(groupingItem.getExpression()));
            }
        }
        return innerForClause;
    }

    private boolean listContainsSameExpression(List<IXQEQueryNode> list, IXQEQueryNode expression) {
        for (IXQEQueryNode element : list) {
            if (!element.isSameExpression(expression, false)) continue;
            return true;
        }
        return false;
    }

    private List<IXQEQueryNode> intersection(List<IXQEQueryNode> list1, List<IXQEQueryNode> list2) {
        ArrayList<IXQEQueryNode> intersection = new ArrayList<IXQEQueryNode>();
        block0: for (IXQEQueryNode itemList1 : list1) {
            for (IXQEQueryNode itemList2 : list2) {
                if (!itemList1.isSameExpression(itemList2, false)) continue;
                intersection.add(itemList1);
                continue block0;
            }
        }
        return intersection;
    }

    private void adjustScopeToLevelRef(PlanningEnvironment environment, V5AggregateBreakClause innerForClause, RQPQuery rootQuery, String levelRef) {
        List<IXQEQueryNode> v5VS = rootQuery.getDescendantsOfTypeOrdered(101057, false);
        List<V5DataItem> v5GroupingItems = null;
        List<Object> groupingItems = new ArrayList();
        for (IXQEQueryNode v5vs : v5VS) {
            if (!levelRef.equals(((V5ValueSet)v5vs).getRefDataItemProperty())) continue;
            v5GroupingItems = ProcessDataItemRefInValueSet.getGroupingItems(v5vs, rootQuery, false);
            groupingItems = DistributeProjectionsInFactQueries.convertListV5DataItemToListRQPDataItem(rootQuery, v5GroupingItems);
            break;
        }
        for (RQPDataItem groupingItem : groupingItems) {
            innerForClause.addChild(environment.getNodeFactory().deepCopyNode(groupingItem.getExpression()));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        V5AggregateAtClause atClause = (V5AggregateAtClause)node;
        if (!super.passesNodeCondition(node, environment)) {
            this.traceNodeCondition(false, "The V5AggregateAtClause node is not under a RQP query", xqeTrace);
            return false;
        }
        if (ExpressionAnalyzer.isStandardAggregate(atClause.getParent())) {
            V5ValueSummaryFunction parent = (V5ValueSummaryFunction)atClause.getParent();
            RQPDataItem rqpDataItem = (RQPDataItem)parent.getAncestorOfType(801008);
            if (rqpDataItem != null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_V5AtClauseNotSupportedInStdAggr, rqpDataItem.getOriginalName(), parent.getNativeName());
            }
            V5SummaryFilter summaryFilter = (V5SummaryFilter)parent.getAncestorOfType(101011);
            throw new XQERuntimeException(XQEMessageKeys.PLN_V5AtClauseNotSupportedInStdAggrFilter, summaryFilter.getOriginalExpression(), parent.getNativeName());
        }
        this.traceNodeCondition(true, "The V5AggregateAtClause will get transformed to the FOR-clause of the inner aggregate", xqeTrace);
        return true;
    }
}

