/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.optimization.JoinSummaryQueries;

public class GenerateDistinctForOuterQuery
extends RQPTransformation {
    public GenerateDistinctForOuterQuery() {
        this.mName = "GenerateDistinctForOuterQuery";
        this.mPassNumbers = new int[]{119};
        this.mTypes = new int[]{801017};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ((RQPQuery)node).setDistinct(true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPQuery rootQuery = ((RQPQuery)node).getRootRQPQuery();
        if (rootQuery.isAutoSummaryFALSE()) {
            this.traceNodeCondition(false, "Autosummary=false", xqeTrace);
            return false;
        }
        RQPGroupByList groupByList = rqpQuery.getGroupByList();
        if (groupByList != null && groupByList.getNumberChildren() > 0) {
            this.traceNodeCondition(false, "No need for distinct in a grouped query", xqeTrace);
            return false;
        }
        RQPQuery llSQ = JoinSummaryQueries.getLowestLevelSummaryQueryReferenced(rqpQuery);
        if (llSQ == null) {
            llSQ = rqpQuery.getLowestLevelSummaryQuery();
        }
        if (llSQ == null) {
            this.traceNodeCondition(false, "There is no lowest level Summary for this root query", xqeTrace);
            return false;
        }
        if (llSQ.isSubqueryForSummaryFilters()) {
            llSQ = llSQ.getLowestLevelSummaryQuery();
        }
        if (llSQ == null) {
            this.traceNodeCondition(false, "There is no lowest level Summary for this Summary Filter query", xqeTrace);
            return false;
        }
        if (!this.projectingAnalyticSubquery(rqpQuery, llSQ) && ((RQPSummaryQuery)llSQ).groupColumnsArePresentInProjections(rqpQuery)) {
            this.traceNodeCondition(false, "All the data items in Group By are projected", xqeTrace);
            return false;
        }
        this.traceNodeCondition(false, "Generate the Distinct to the root Query.", xqeTrace);
        return true;
    }

    private boolean projectingAnalyticSubquery(RQPQuery topQuery, RQPQuery llSQ) {
        IXQEQueryNode[] subQueries;
        if (llSQ.isAnalyticSubquery()) {
            return true;
        }
        for (IXQEQueryNode subQuery : subQueries = topQuery.getSubqueryList().getChildren()) {
            RQPQuery rqpSubQuery = (RQPQuery)subQuery;
            if (!rqpSubQuery.isAnalyticSubquery()) continue;
            return true;
        }
        return false;
    }
}

