/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.optimization.RewriteSummariesAsWindowedAggregates;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;

public class PushMedianOverDetailValueExprToTabularQuery
extends RQPTransformation {
    public PushMedianOverDetailValueExprToTabularQuery() {
        this.mName = "PushMedianOverDetailValueInFooterExprToTabularQuery";
        this.mPassNumbers = new int[]{73};
        this.mTypes = new int[]{801024, 801012};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = (RQPQuery)node;
        RQPProjectionList projList = rqpQuery.getProjectionList();
        RQPTabularQuery tabQuery = rqpQuery.getParentRQPQuery().getDefaultTabularQuery();
        ArrayList<IXQEQueryNode> footerItemsToRewrite = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode child : projList.getChildren()) {
            if (!this.containsMedianOverDetailValue((RQPDataItem)child, tabQuery)) continue;
            footerItemsToRewrite.add(child);
        }
        for (IXQEQueryNode child : footerItemsToRewrite) {
            RQPDataItem newTabItem = PushMedianOverDetailValueExprToTabularQuery.pushAggregateToTabularQuery(environment, tabQuery, rqpQuery, (RQPDataItem)child);
            this.rewriteFooterExpression(environment, (V5ValueSummaryFunction)child.getChild(0), newTabItem.getName());
        }
        tabQuery.setPropertyValue("canNotBeCollapsed", true);
    }

    private void rewriteFooterExpression(PlanningEnvironment environment, V5ValueSummaryFunction medianExpr, String tabItemName) {
        medianExpr.setSubType(6);
        RQPDataItemRef operand = (RQPDataItemRef)medianExpr.getChild(0);
        operand.setName(tabItemName);
    }

    public static RQPDataItem pushAggregateToTabularQuery(PlanningEnvironment environment, RQPTabularQuery tabQuery, RQPQuery queryOfAggregate, RQPDataItem aggregateProjection) {
        IXQEQueryNode[] aggregates;
        RQPDataItem newDataItem = tabQuery.createRQPDataItem(environment, aggregateProjection.getName());
        IXQEQueryNode clonedExp = environment.getNodeFactory().deepCopyNode(aggregateProjection.getExpression());
        newDataItem.addChild(clonedExp);
        for (IXQEQueryNode aggr : aggregates = clonedExp.getDescendantsOfTypes(new int[]{201031, 201033, 201035}, true)) {
            V5AggregateFunction aggregate = (V5AggregateFunction)aggr;
            if (aggregate.getForClause() != null) continue;
            RewriteSummariesAsWindowedAggregates.addForClause(environment, aggregate, queryOfAggregate.getGroupByList());
        }
        PushMedianOverDetailValueExprToTabularQuery.replaceReferencesToSubQuery(environment, tabQuery, newDataItem);
        return newDataItem;
    }

    public static void replaceReferencesToSubQuery(PlanningEnvironment environment, RQPQuery subQuery, RQPDataItem rqpDataItem) {
        IXQEQueryNode[] diRefs;
        for (IXQEQueryNode ref : diRefs = rqpDataItem.getDescendantsOfType(801009, false)) {
            RQPDataItemRef operandRef = (RQPDataItemRef)ref;
            RQPDataItem operandItem = subQuery.getRQPDataItemByName(operandRef.getName());
            if (operandItem == null || operandItem == rqpDataItem) continue;
            operandRef.exchange(environment.getNodeFactory().deepCopyNode(operandItem.getExpression()));
        }
    }

    private boolean containsMedianOverDetailValue(RQPDataItem projection, RQPTabularQuery tabQuery) {
        if (projection.isGroupingItem()) {
            return false;
        }
        IXQEQueryNode expression = projection.getExpression();
        if (!ExpressionAnalyzer.isStandardAggregate(expression)) {
            return false;
        }
        V5ValueSummaryFunction aggregate = (V5ValueSummaryFunction)expression;
        if (aggregate.getSubType() != 5) {
            return false;
        }
        IXQEQueryNode operand = aggregate.getChild(0);
        if (operand.getType() != 801009) {
            return false;
        }
        RQPDataItemRef diRef = (RQPDataItemRef)operand;
        return diRef.getQuery() == tabQuery;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery rqpQuery = (RQPQuery)node;
        if (rqpQuery == rqpQuery.getParentRQPQuery().getDefaultSummaryQuery()) {
            this.traceNodeCondition(false, "The summary query is the default summary query.", xqeTrace);
            return false;
        }
        RQPProjectionList projList = rqpQuery.getProjectionList();
        if (projList != null) {
            RQPTabularQuery tabQuery = rqpQuery.getParentRQPQuery().getDefaultTabularQuery();
            for (IXQEQueryNode child : projList.getChildren()) {
                if (!this.containsMedianOverDetailValue((RQPDataItem)child, tabQuery)) continue;
                this.traceNodeCondition(true, "The summary query contains median over detail values.", xqeTrace);
                return true;
            }
        }
        this.traceNodeCondition(false, "The summary query does not contain median over detail values.", xqeTrace);
        return false;
    }
}

