/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.GenerateSubqueriesForSelfReferencingCalcs;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class RemoveRedundantRQPSubqueries
extends RQPTransformation {
    public RemoveRedundantRQPSubqueries() {
        this.mName = "Remove redundant RQP sub-Query blocks";
        this.mPassNumbers = new int[]{118, 122};
        this.mTypes = new int[]{801024, 801012, 801017};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] summaryFilterLists;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        RQPQuery parentQuery = (RQPQuery)node;
        if (parentQuery.containsJoins()) {
            this.traceNodeCondition(false, "RQP Query will NOT be flattened because parent query contains joins.", xqeTrace);
            return false;
        }
        RQPQuery subquery = parentQuery.getOnlySubquerySourceOfParentQuery();
        if (subquery == null) {
            this.traceNodeCondition(false, "RQP Query will NOT be flattened because its data comes from multiple sources.", xqeTrace);
            return false;
        }
        if (null != subquery.getPropertyValue("canNotBeCollapsed")) {
            return false;
        }
        if (parentQuery.isSummarizedQuery() && subquery.isSummarizedQuery()) {
            this.traceNodeCondition(false, "RQP Query will NOT be flattened because both parent and this query are summarized.", xqeTrace);
            return false;
        }
        if (parentQuery.getType() == 801017 && parentQuery.getCanRewriteAsWindowedAggregates() && this.parentContainsFooterAggregateOverSummaryQuery(parentQuery, subquery)) {
            this.traceNodeCondition(false, "RQP Query contains footer aggregates computed over summary query.", xqeTrace);
            return false;
        }
        if (parentQuery.getType() == 801017 && this.hasAnalyticFunction(parentQuery) && subquery.isSummarizedQuery()) {
            return false;
        }
        if (subquery.getType() != 801025 && this.hasSubqueryForSummaryFilterOnly(subquery)) {
            return false;
        }
        if (subquery.getType() == 801017) {
            return false;
        }
        if (subquery.getType() == 801025 && ExpressionAnalyzer.hasAnalyticMovingRunningFunctions(subquery)) {
            return false;
        }
        if (subquery.getType() == 801025 && (summaryFilterLists = subquery.getChildrenOfType(801023)).length > 0) {
            return false;
        }
        IXQEQueryNode[] projectionLists = parentQuery.getChildrenOfType(801016);
        if (projectionLists.length > 0 && this.hasNestedAggregates(subquery, projectionLists[0])) {
            this.traceNodeCondition(false, "RQP Query will NOT be flattened because it will have nested aggregates.", xqeTrace);
            return false;
        }
        if (!GenerateSubqueriesForSelfReferencingCalcs.getDataItemReferences(parentQuery.getProjectionList()).isEmpty()) {
            return false;
        }
        if (parentQuery.getPropertyValue("needDistinctRecompute") != null) {
            this.traceNodeCondition(false, "RQP Query will NOT be flattened because there are distinct aggregates and summary filters.", xqeTrace);
            return false;
        }
        this.traceNodeCondition(true, "RQP Query will be flattened.", xqeTrace);
        return true;
    }

    private boolean hasNestedAggregates(RQPQuery subquery, IXQEQueryNode projectionList) {
        IXQEQueryNode[] projections;
        for (IXQEQueryNode projection : projections = projectionList.getDescendantsOfType(801009, false)) {
            IXQEQueryNode[] summaryFunctions;
            RQPDataItem referredDataItem;
            RQPDataItemRef dataItemRef = (RQPDataItemRef)projection;
            IXQEQueryNode dataItemRefParent = dataItemRef.getParent();
            if (dataItemRefParent.getType() != 201031 || (referredDataItem = subquery.findProjection(dataItemRef.getName())) == null || (summaryFunctions = referredDataItem.getDescendantsOfType(201031, false)).length <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasSubqueryForSummaryFilterOnly(RQPQuery query) {
        IXQEQueryNode[] queries;
        for (IXQEQueryNode q : queries = query.getParent().getChildren()) {
            if (q == query || !((RQPQuery)q).isSummarizedQuery() || query != ((RQPQuery)q).getOnlySubquerySourceOfParentQuery() || null == q.getFirstChildByType(801023)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnalyticFunction(RQPQuery parentQuery) {
        return parentQuery.getDescendantsOfType(201033, false).length > 0;
    }

    private boolean parentContainsFooterAggregateOverSummaryQuery(RQPQuery parentQuery, RQPQuery subquery) {
        if (!subquery.isSummarizedQuery()) {
            return false;
        }
        int[] listsToCheck = new int[]{801016, 801011, 801023};
        for (int i = 0; i < listsToCheck.length; ++i) {
            IXQEQueryNode listChild = parentQuery.getFirstChildByType(listsToCheck[i]);
            if (listChild == null || !RQPUtilities.hasAggregateInExpression(listChild)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery parentQuery = (RQPQuery)node;
        RQPQuery subquery = parentQuery.getOnlySubquerySourceOfParentQuery();
        if (this.subqueryOnlyReferencedByParentQuery(subquery, parentQuery)) {
            this.moveSubqueryContentsToParentQuery(subquery, parentQuery, environment);
        } else {
            this.copySubqueryContentsToParentQuery(subquery, parentQuery, environment);
        }
    }

    private void copySubqueryContentsToParentQuery(RQPQuery subquery, RQPQuery parentQuery, PlanningEnvironment environment) {
        this.moveOrCopySubqueryContentsToParentQuery(subquery, parentQuery, environment, true);
    }

    private void moveOrCopySubqueryContentsToParentQuery(RQPQuery subquery, RQPQuery parentQuery, PlanningEnvironment environment, boolean copyNodes) {
        this.replaceRQPDataItemRefsToSubquery(subquery, parentQuery, environment, copyNodes);
        this.moveOrCopyFilters(subquery, parentQuery, copyNodes, environment);
        this.moveOrCopyGroupByList(subquery, parentQuery, copyNodes, environment);
        this.moveOrCopyJoinPaths(subquery, parentQuery, copyNodes, environment);
        if (!copyNodes) {
            subquery.detach();
        }
    }

    private boolean subqueryOnlyReferencedByParentQuery(RQPQuery subquery, RQPQuery parentQuery) {
        RQPQuery rootQuery = subquery.getParentRQPQuery();
        List<IXQEQueryNode> dataItemRefs = rootQuery.getDescendantsOfTypeOrdered(801009, subquery);
        if (dataItemRefs.size() == 0) {
            return false;
        }
        String subqueryName = subquery.getName();
        String parentQueryName = parentQuery.getName();
        for (IXQEQueryNode dataItemRef : dataItemRefs) {
            RQPDataItemRef rqpDataItemRef = (RQPDataItemRef)dataItemRef;
            if (!subqueryName.equals(rqpDataItemRef.getQueryName()) || parentQueryName.equals(rqpDataItemRef.getParentQueryName())) continue;
            return false;
        }
        return true;
    }

    public void moveSubqueryContentsToParentQuery(RQPQuery subquery, RQPQuery parentQuery, PlanningEnvironment environment) {
        this.moveOrCopySubqueryContentsToParentQuery(subquery, parentQuery, environment, false);
    }

    private void replaceRQPDataItemRefsToSubquery(RQPQuery subquery, RQPQuery parentQuery, PlanningEnvironment environment, boolean copyNodes) {
        int i;
        int[] listsToCheck = new int[]{801016, 801011, 801023};
        IXQEQueryNode[][] dataItemRefs = new IXQEQueryNode[listsToCheck.length][];
        for (i = 0; i < listsToCheck.length; ++i) {
            IXQEQueryNode list = parentQuery.getFirstChildByType(listsToCheck[i]);
            if (list == null) continue;
            dataItemRefs[i] = list.getDescendantsOfType(801009, false);
        }
        for (i = 0; i < dataItemRefs.length; ++i) {
            if (dataItemRefs[i] == null) continue;
            for (int j = 0; j < dataItemRefs[i].length; ++j) {
                RQPDataItemRef dataItemRef = (RQPDataItemRef)dataItemRefs[i][j];
                RQPDataItem childProjection = subquery.findProjection(dataItemRef.getName());
                if (null == childProjection) continue;
                IXQEQueryNode childExpression = childProjection.getExpression();
                if (copyNodes || this.dataItemReferencedMoreThanOnce(dataItemRef.getName(), dataItemRefs)) {
                    dataItemRef.exchange(environment.getNodeFactory().deepCopyNode(childExpression), true);
                    continue;
                }
                childExpression.detach();
                dataItemRef.exchange(childExpression, true);
            }
        }
    }

    private void moveOrCopyFilters(RQPQuery subquery, RQPQuery parentQuery, boolean copyNodes, PlanningEnvironment environment) {
        this.moveOrCopyListItemsOfType(subquery, parentQuery, 801011, copyNodes, environment);
        this.moveOrCopyListItemsOfType(subquery, parentQuery, 801023, copyNodes, environment);
    }

    private void moveOrCopyListItemsOfType(RQPQuery sourceQuery, RQPQuery targetQuery, int sourceListType, boolean copyNodes, PlanningEnvironment environment) {
        IXQEQueryNode sourceList = sourceQuery.getFirstChildByType(sourceListType);
        if (sourceList == null) {
            return;
        }
        IXQEQueryNode targetList = copyNodes ? targetQuery.getOrCreateList(environment, sourceListType) : targetQuery.getFirstChildByType(sourceListType);
        this.moveOrCopySelfRefsToProjectionList(environment, sourceList, sourceQuery, targetQuery, copyNodes);
        if (targetList == null) {
            sourceList.move(targetQuery);
        } else if (copyNodes) {
            for (int i = 0; i < sourceList.getNumberChildren(); ++i) {
                IXQEQueryNode newNode = environment.getNodeFactory().deepCopyNode(sourceList.getChild(i));
                targetList.addChild(newNode);
            }
        } else {
            while (sourceList.getNumberChildren() > 0) {
                sourceList.getChild(0).move(targetList);
            }
        }
    }

    private void moveOrCopySelfRefsToProjectionList(PlanningEnvironment environment, IXQEQueryNode sourceList, RQPQuery sourceQuery, RQPQuery targetQuery, boolean copyNodes) {
        IXQEQueryNode[] selfRefs = sourceList.getDescendantsOfType(801010, false);
        for (int i = 0; i < selfRefs.length; ++i) {
            RQPDataItemSelfRef selfRef = (RQPDataItemSelfRef)selfRefs[i];
            RQPDataItem sourceProjection = selfRef.getRefProjection();
            if (sourceProjection == null || sourceProjection.getNumberChildren() == 0) continue;
            IXQEQueryNode refExpression = sourceProjection.getExpression();
            RQPDataItem existingRQPDataItem = targetQuery.findProjection(selfRef.getName());
            if (existingRQPDataItem != null && existingRQPDataItem.getExpression().isSameExpression(refExpression, false)) continue;
            if (copyNodes) {
                RQPDataItem newProjection = targetQuery.createRQPDataItem(environment, selfRef.getName());
                newProjection.addChild(environment.getNodeFactory().deepCopyNode(refExpression));
                continue;
            }
            RQPProjectionList targetProjList = targetQuery.getOrCreateProjectionList(environment);
            sourceProjection.move(targetProjList);
        }
    }

    private void moveOrCopyGroupByList(RQPQuery subquery, RQPQuery parentQuery, boolean copyNodes, PlanningEnvironment environment) {
        this.moveOrCopyListItemsOfType(subquery, parentQuery, 801013, copyNodes, environment);
    }

    private void moveOrCopyJoinPaths(RQPQuery subquery, RQPQuery parentQuery, boolean copyNodes, PlanningEnvironment environment) {
        IXQEQueryNode[] joinPaths = subquery.getDescendantsOfType(801039, false);
        if (joinPaths.length > 0) {
            if (copyNodes) {
                IXQEQueryNode newNode = environment.getNodeFactory().deepCopyNode(joinPaths[0]);
                parentQuery.addChild(newNode);
            } else {
                RQPJoinPath rqpJoinPath = (RQPJoinPath)joinPaths[0];
                rqpJoinPath.move(parentQuery);
            }
        }
    }

    private boolean dataItemReferencedMoreThanOnce(String name, IXQEQueryNode[][] allDataItemRefs) {
        int numRefs = 0;
        for (int i = 0; i < allDataItemRefs.length; ++i) {
            if (allDataItemRefs[i] == null) continue;
            for (int j = 0; j < allDataItemRefs[i].length; ++j) {
                if (((RQPDataItemRef)allDataItemRefs[i][j]).getName().equals(name)) {
                    ++numRefs;
                }
                if (numRefs <= 1) continue;
                return true;
            }
        }
        return false;
    }
}

