/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS.CreateV5QueryForDynamicSQS;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ExpressionAnalyzer;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqe.transformation.v5tocogsql.optimization.RewriteNestedMaxMinSum;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class RewriteAggregateToAvoidDoubleCounting
extends RQPTransformation {
    public static final String PROJECTION_ROW_NUMBER = "rowNumber";

    public RewriteAggregateToAvoidDoubleCounting() {
        this.mName = "RewriteAggregateToAvoidDoubleCounting";
        this.mPassNumbers = new int[]{96};
        this.mTypes = new int[]{201031};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] diRefsInAggregate;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        int[] types = new int[]{801024, 801012};
        RQPQuery queryOfAggregate = (RQPQuery)node.getAncestorOfTypes(types);
        RQPQuery outerQuery = queryOfAggregate.getParentRQPQuery();
        RQPQuery llsq = outerQuery.getLowestLevelSummaryQuery();
        RQPProjectionList projListInLLSQ = llsq.getProjectionList();
        for (IXQEQueryNode diRef : diRefsInAggregate = node.getDescendantsOfType(801009, false)) {
            RQPDataItem rqpDataItem;
            if (this.referToSameSubquery(diRefsInAggregate)) {
                RQPDataItemRef aggregateOperand = (RQPDataItemRef)diRef;
                if (aggregateOperand.getPropertyValue("higherScopeQueryName") != null) {
                    this.replaceAggregateWithRowNumberCaseExpr(environment, outerQuery, aggregateOperand);
                    continue;
                }
                this.replaceAggregateWithRowNumberCaseExpr(environment, nodeFactory, llsq, projListInLLSQ, aggregateOperand);
                continue;
            }
            RQPQuery refQuery = ((RQPDataItemRef)diRef).getQuery();
            if (refQuery == llsq || refQuery.getType() == 801025 || !(rqpDataItem = (RQPDataItem)diRef.getAncestorOfType(801008)).hasHigherScopeThanValueSetOfReferenceDataItemInParentQuery()) continue;
            RQPDataItemRef aggregateOperand = (RQPDataItemRef)diRef;
            this.replaceAggregateWithRowNumberCaseExpr(environment, nodeFactory, llsq, projListInLLSQ, aggregateOperand);
        }
    }

    private void replaceAggregateWithRowNumberCaseExpr(PlanningEnvironment environment, RQPQuery outerQuery, RQPDataItemRef aggregateOperand) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ArrayList<IXQEQueryNode> partitionByOperands = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> orderByOperands = new ArrayList<IXQEQueryNode>();
        RQPDataItem rqpDi = aggregateOperand.getReferencedItem();
        IXQEQueryNode expr = rqpDi.getExpression();
        if (expr.getType() != 201060) {
            return;
        }
        String queryWithHigherScopeName = (String)expr.getPropertyValue("higherScopeQueryName");
        List groupingColumns = (List)expr.getPropertyValue("gcInHigherScopeQuery");
        if (groupingColumns != null && groupingColumns.size() > 0) {
            for (V5DataItem gc : groupingColumns) {
                partitionByOperands.add(CreateV5QueryForDynamicSQS.createV5QueryRefItem(nodeFactory, gc, queryWithHigherScopeName));
                orderByOperands.add(CreateV5QueryForDynamicSQS.createV5QueryRefItem(nodeFactory, gc, queryWithHigherScopeName));
            }
        } else {
            List lowestGroupingLevelColumns = (List)expr.getPropertyValue("lowestGroupingLevelColumns");
            if (lowestGroupingLevelColumns != null && lowestGroupingLevelColumns.size() > 0) {
                orderByOperands.addAll(lowestGroupingLevelColumns);
            } else {
                return;
            }
        }
        RQPTabularQuery tabQuery = outerQuery.getDefaultTabularQuery();
        IXQEQueryNode rowNumberExpr = ExpressionAnalyzer.createRowNumberExpr(nodeFactory, partitionByOperands, orderByOperands);
        IXQEQueryNode caseExpr = ExpressionAnalyzer.createCaseExpression(nodeFactory, rowNumberExpr, nodeFactory.deepCopyNode(rqpDi.getExpression()));
        String newProjectionName = RQPNameGenerator.generateUniqueRQPDataItemName(tabQuery, aggregateOperand.getName() + "_u");
        RQPDataItem newProjection = RQPDataItem.create(environment, newProjectionName);
        newProjection.addChild(caseExpr);
        tabQuery.addToProjectionList(environment, newProjection);
        tabQuery.setPropertyValue("canNotBeCollapsed", true);
        aggregateOperand.setName(newProjection.getName());
    }

    private void replaceAggregateWithRowNumberCaseExpr(PlanningEnvironment environment, IXQENodeFactory nodeFactory, RQPQuery llsq, RQPProjectionList projListInLLSQ, RQPDataItemRef aggregateOperand) {
        IXQEQueryNode[] nestedAggregateScope = aggregateOperand.getQuery().getGroupingItems();
        ArrayList<IXQEQueryNode> partitionByOperands = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> orderByOperands = new ArrayList<IXQEQueryNode>();
        if (nestedAggregateScope != null) {
            block0: for (IXQEQueryNode gi : nestedAggregateScope) {
                RQPDataItemSelfRef groupingItem = (RQPDataItemSelfRef)gi;
                for (int i = 0; i < projListInLLSQ.getNumberChildren(); ++i) {
                    RQPDataItem projection = (RQPDataItem)projListInLLSQ.getChild(i);
                    if (!RQPSummaryQuery.isSameGroupingColumnExpression(groupingItem, projection)) continue;
                    IXQEQueryNode diRefInCaseExpr = nodeFactory.deepCopyNode(projection.getChild(0));
                    partitionByOperands.add(diRefInCaseExpr);
                    orderByOperands.add(nodeFactory.deepCopyNode(diRefInCaseExpr));
                    continue block0;
                }
            }
        }
        IXQEQueryNode rowNumberExpr = ExpressionAnalyzer.createRowNumberExpr(nodeFactory, partitionByOperands, orderByOperands);
        String rowNumberName = RQPNameGenerator.generateUniqueRQPDataItemName(llsq, PROJECTION_ROW_NUMBER);
        RQPDataItem rowNumberProjection = RQPDataItem.create(environment, rowNumberName);
        rowNumberProjection.addChild(rowNumberExpr);
        llsq.addToProjectionList(environment, rowNumberProjection);
        RQPDataItemRef diRefToRowNumber = RQPDataItemRef.create(environment, rowNumberProjection);
        IXQEQueryNode caseExpr = ExpressionAnalyzer.createCaseExpression(nodeFactory, diRefToRowNumber, nodeFactory.deepCopyNode(aggregateOperand));
        aggregateOperand.exchange(caseExpr);
        aggregateOperand.detach();
    }

    private boolean referToSameSubquery(IXQEQueryNode[] diRefs) {
        for (int i = 0; i < diRefs.length; ++i) {
            for (int j = i + 1; j < diRefs.length; ++j) {
                RQPDataItemRef refi = (RQPDataItemRef)diRefs[i];
                RQPDataItemRef refj = (RQPDataItemRef)diRefs[j];
                if (refi.getQueryName().equals(refj.getQueryName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] diRefsInAggregate;
        String higherScopeQueryName;
        RQPDataItem rqpDi;
        IXQEQueryNode expr;
        IXQEQueryNode operand;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace xqeTrace = environment.getTrace();
        V5AggregateFunction aggregate = (V5AggregateFunction)node;
        if (aggregate.getAncestorOfType(101072) != null) {
            this.traceNodeCondition(false, "The transformation is not applicable for a DMR prePlan query.", xqeTrace);
            return false;
        }
        if (aggregate.getDistinct()) {
            this.traceNodeCondition(false, "The transformation is not applicable for this distinct-aggregate.", xqeTrace);
            return false;
        }
        if (aggregate.getSubType() == 4 || aggregate.getSubType() == 6) {
            this.traceNodeCondition(false, "MAX and MIN don't get double-counted.", xqeTrace);
            return false;
        }
        int[] types = new int[]{801024, 801012};
        RQPQuery queryOfAggregate = (RQPQuery)node.getAncestorOfTypes(types);
        if (queryOfAggregate == null) {
            this.traceNodeCondition(false, "The aggregate is not in the Summary Query.", xqeTrace);
            return false;
        }
        if (aggregate.getNumberChildren() > 0 && (operand = node.getChild(0)).getType() == 801009 && (expr = (rqpDi = ((RQPDataItemRef)operand).getReferencedItem()).getExpression()).getType() == 201060 && (higherScopeQueryName = (String)expr.getPropertyValue("higherScopeQueryName")) != null) {
            List gcInHigherScopeQuery = (List)expr.getPropertyValue("gcInHigherScopeQuery");
            if (gcInHigherScopeQuery != null) {
                operand.setPropertyValue("gcInHigherScopeQuery", gcInHigherScopeQuery);
                operand.setPropertyValue("higherScopeQueryName", higherScopeQueryName);
                return true;
            }
            List lowestLevelGrouping = (List)expr.getPropertyValue("lowestGroupingLevelColumns");
            if (lowestLevelGrouping != null && lowestLevelGrouping.size() > 0) {
                operand.setPropertyValue("lowestGroupingLevelColumns", lowestLevelGrouping);
                operand.setPropertyValue("higherScopeQueryName", higherScopeQueryName);
                return true;
            }
            return false;
        }
        RQPQuery outerQuery = queryOfAggregate.getParentRQPQuery();
        RQPQuery llsq = outerQuery.getLowestLevelSummaryQuery();
        if (queryOfAggregate == llsq) {
            this.traceNodeCondition(false, "The aggregate is already in the lowest-level summary query.", xqeTrace);
            return false;
        }
        if (aggregate.getNumberChildren() == 0) {
            return false;
        }
        boolean status = false;
        for (IXQEQueryNode diRef : diRefsInAggregate = aggregate.getDescendantsOfType(801009, false)) {
            RQPQuery refQuery = ((RQPDataItemRef)diRef).getQuery();
            if (refQuery == llsq || refQuery.getType() == 801025) continue;
            if (this.referToSameSubquery(diRefsInAggregate)) {
                status = true;
                break;
            }
            RQPDataItem rqpDataItem = (RQPDataItem)diRef.getAncestorOfType(801008);
            if (!rqpDataItem.hasHigherScopeThanValueSetOfReferenceDataItemInParentQuery()) continue;
            status = true;
            break;
        }
        if (!status) {
            this.traceNodeCondition(false, "The aggregate does not need to be rewritten.", xqeTrace);
            return false;
        }
        if (!RewriteNestedMaxMinSum.innerAggregateGroupingCanBeSkipped(aggregate)) {
            return false;
        }
        this.traceNodeCondition(true, "The aggregate will be rewritten to avoid double-counting.", xqeTrace);
        return true;
    }
}

