/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.RQPTransformation;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class SetCanRewriteFootersInTermsOfLowestLevel
extends RQPTransformation {
    public SetCanRewriteFootersInTermsOfLowestLevel() {
        this.mName = "Set property canRewriteAsWindowedAggregates";
        this.mPassNumbers = new int[]{94};
        this.mTypes = new int[]{801024, 801012, 801017};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ((RQPQuery)node).setCanRewriteAsWindowedAggregates(true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPQuery rqpQuery = (RQPQuery)node;
        XQETrace xqeTrace = environment.getTrace();
        if (rqpQuery.hasPropertyCanRewriteAsWindowedAggregates()) {
            this.traceNodeCondition(false, "The property CanRewriteAsWindowedAggregates is already set to this query.", xqeTrace);
            return false;
        }
        if (rqpQuery.getType() == 801017) {
            if (!this.hasSubqueriesWithCanRewriteAsWindowedAggregtesOn(rqpQuery)) {
                this.traceNodeCondition(false, "There exists one subquery that cannot be rewritten in terms of lowest level.", xqeTrace);
                return false;
            }
        } else {
            if (this.queryContainsAnalyticFunctionsThatCanNotBeRewritten(rqpQuery)) {
                this.traceNodeCondition(false, "The query contains analytic functions that can not be rewritten in olap form.", xqeTrace);
                return false;
            }
            if (this.isReferencedInOrderByClause(rqpQuery)) {
                this.traceNodeCondition(false, "The query is referenced in an ORDER BY clause of another olap aggregate.", xqeTrace);
                return false;
            }
            if (this.hasNonDecomposableAggregates(rqpQuery)) {
                return false;
            }
            RQPTabularQuery tabQuery = rqpQuery.getParentRQPQuery().getDefaultTabularQuery();
            if (rqpQuery.getsDataFromSubquery(tabQuery)) {
                this.traceNodeCondition(false, "Data comes from detail query. Potential to double count.", xqeTrace);
                return false;
            }
        }
        this.traceNodeCondition(true, "Footers can be rewritten as windowed aggregates over lowest level summary query.", xqeTrace);
        return true;
    }

    private boolean hasNonDecomposableAggregates(RQPQuery rqpQuery) {
        int[] listsToCheck = new int[]{801016, 801011, 801023};
        for (int i = 0; i < listsToCheck.length; ++i) {
            IXQEQueryNode[] aggregates;
            IXQEQueryNode listChild = rqpQuery.getFirstChildByType(listsToCheck[i]);
            if (listChild == null) continue;
            for (IXQEQueryNode aggregate : aggregates = listChild.getDescendantsOfType(201031, false)) {
                if (((V5ValueSummaryFunction)aggregate).isDecomposable()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isReferencedInOrderByClause(RQPQuery rqpQuery) {
        IXQEQueryNode[] nodes;
        RQPQuery parentQuery = rqpQuery.getParentRQPQuery();
        for (IXQEQueryNode node : nodes = parentQuery.getDescendantsOfType(801009, false)) {
            RQPDataItemRef ref = (RQPDataItemRef)node;
            if (ref.getQuery() != rqpQuery || ref.getAncestorOfType(301020) == null) continue;
            return true;
        }
        return false;
    }

    private boolean hasSubqueriesWithCanRewriteAsWindowedAggregtesOn(RQPQuery rqpQuery) {
        RQPQuery lowestLevelSQ = rqpQuery.getLowestLevelSummaryQuery();
        if (lowestLevelSQ == null) {
            return false;
        }
        int[] listsToCheck = new int[]{801016, 801011, 801023};
        for (int i = 0; i < listsToCheck.length; ++i) {
            IXQEQueryNode listChild = rqpQuery.getFirstChildByType(listsToCheck[i]);
            if (listChild == null) continue;
            IXQEQueryNode[] dataItemRefs = listChild.getDescendantsOfType(801009, false);
            for (int j = 0; j < dataItemRefs.length; ++j) {
                RQPDataItemRef dataItemRef = (RQPDataItemRef)dataItemRefs[j];
                if (dataItemRef.getQuery() == lowestLevelSQ || !dataItemRef.getQuery().getCanRewriteAsWindowedAggregates()) continue;
                return true;
            }
        }
        return false;
    }

    boolean queryContainsAnalyticFunctionsThatCanNotBeRewritten(RQPQuery rqpQuery) {
        int[] listsToCheck = new int[]{801016, 801011, 801023};
        for (int i = 0; i < listsToCheck.length; ++i) {
            IXQEQueryNode[] aggregates;
            IXQEQueryNode listChild = rqpQuery.getFirstChildByType(listsToCheck[i]);
            if (listChild == null) continue;
            int[] aggregateTypes = new int[]{201033, 201035};
            for (IXQEQueryNode aggregate : aggregates = listChild.getDescendantsOfTypes(aggregateTypes, false)) {
                if (aggregate.getAncestorOfType(201031) != null) continue;
                return true;
            }
        }
        return false;
    }
}

