/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.prePlan;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5PrePlan;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class AddFiltersToRelationalQuery
extends Transformation {
    public AddFiltersToRelationalQuery(int[] passNumbers) {
        this.mName = "AddFiltersToRelationalQuery";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{1007};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getParent();
        V5PrePlan prePlan = (V5PrePlan)mdxQuery.getFirstChildByType(101072);
        V5Query v5Query = (V5Query)prePlan.getChild(0);
        MDXFromCube mdxFromCube = (MDXFromCube)node;
        CubeWrapper cube = (CubeWrapper)mdxFromCube.getCube();
        List<CogMDXDetailFilter> dfs = cube.getDetailFilters();
        for (IXQEQueryNode iXQEQueryNode : dfs) {
            IXQEQueryNode[] mpis;
            CogMDXDetailFilter filter = (CogMDXDetailFilter)iXQEQueryNode;
            String filterExpression = this.getFilterUniqueName(filter);
            V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            v5Query.addChild(detailFilter);
            detailFilter.setOriginalExpression(filterExpression);
            detailFilter.addChild(nodeFactory.deepCopyNode(filter.getChild(0)));
            for (IXQEQueryNode mpi : mpis = detailFilter.getDescendantsOfType(201030, false)) {
                V5MultiPartIdentifier multiPartIdentifier = (V5MultiPartIdentifier)mpi;
                IMetadata metadata = (IMetadata)multiPartIdentifier.getPropertyValue("dmrLevelMetadata");
                if (metadata == null) continue;
                V5BoundModelIdentifier boundMultiPartIdentifier = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
                boundMultiPartIdentifier.setMetadata(metadata);
                multiPartIdentifier.exchange(boundMultiPartIdentifier);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getParent();
        if (!mdxQuery.isDMR()) {
            this.traceNodeCondition(false, "Not a DMR query.", trace);
            return false;
        }
        V5PrePlan prePlan = (V5PrePlan)mdxQuery.getFirstChildByType(101072);
        if (prePlan == null) {
            this.traceNodeCondition(false, "No prePlan query.", trace);
            return false;
        }
        MDXFromCube mdxFromCube = (MDXFromCube)node;
        if (!(mdxFromCube.getCube() instanceof CubeWrapper)) {
            this.traceNodeCondition(false, "No CubeWrapper.", trace);
            return false;
        }
        CubeWrapper cube = (CubeWrapper)mdxFromCube.getCube();
        List<CogMDXDetailFilter> dfs = cube.getDetailFilters();
        if (dfs == null || dfs.size() == 0) {
            this.traceNodeCondition(false, "No filters to process.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Add the cubeWrapper filters to the prePlan query.", trace);
        return true;
    }

    String getFilterUniqueName(IXQEQueryNode node) {
        String filterExpression = (String)node.getPropertyValue("originalExpression");
        if (filterExpression == null) {
            String name = "DetailFilterFromWrapper";
            return name;
        }
        return filterExpression;
    }
}

