/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class QuerySubjectSQLGenerator {
    private static final CharSequence MACRO_MARKER = "#";
    private QuerySubjectSQL qsSql = null;
    private String macroExpandedSQL = null;
    private IXQEQueryNode parentNodeOfMacroExpander = null;
    private boolean hasMacroInCMDataSource = false;

    public QuerySubjectSQLGenerator() {
    }

    public QuerySubjectSQLGenerator(IXQEQueryNode node) {
        this.parentNodeOfMacroExpander = node;
    }

    public IXQEQueryNode generateSQLAST(PlanningEnvironment environment, IQuerySubject qs) throws ParseException {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        String sqlToParse = this.getUnexpandedSQL(qs);
        if (sqlToParse.contains(MACRO_MARKER)) {
            sqlToParse = this.getMacroExpandedSQL(environment, sqlToParse, this.qsSql.getSqlType(), qs);
        }
        return this.buildSQLAST(environment, nodeFactory, qs, sqlToParse, this.qsSql.getSqlType());
    }

    private IXQEQueryNode buildSQLAST(PlanningEnvironment environment, IXQENodeFactory factory, IQuerySubject qs, String sqlToParse, SqlType type) throws ParseException {
        IXQEQueryNode sqlAST = null;
        if (type.equals((Object)SqlType.COGNOS)) {
            sqlAST = this.parseSQL(factory, sqlToParse);
            this.resolveDSRefOfSQLRelation(qs, sqlAST, environment);
            QuerySubjectSQLGenerator.replaceDSRefs(qs, sqlAST, environment);
        } else {
            ExecutionEnvironment executionEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
            IDataSource dataSource = null;
            if (qs.getDataSources() != null && !qs.getDataSources().isEmpty()) {
                dataSource = executionEnv.getOrAddDataSource(qs.getDataSources().get(0));
                if (MacroExpander.isMacro(dataSource.getCMDataSourceName())) {
                    this.hasMacroInCMDataSource = true;
                }
                SQLBinderUtil.expandDataSourceCMDataSourceNameWithMacro(environment, dataSource);
            }
            SQLNativeSql sqlNativeSQL = (SQLNativeSql)factory.createNode(301012);
            if (type.equals((Object)SqlType.NATIVE)) {
                sqlNativeSQL.setIsPassThrough(false);
            } else if (type.equals((Object)SqlType.PASS_THROUGH)) {
                sqlNativeSQL.setIsPassThrough(true);
            } else {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The SQL Type is unknown.");
            }
            sqlNativeSQL.setDataSource(dataSource);
            sqlNativeSQL.setSqlString(sqlToParse);
            if (dataSource != null) {
                ConnectionUtil.connect(executionEnv, dataSource);
            }
            sqlAST = sqlNativeSQL;
        }
        sqlAST = this.generateRangeVarOnTopOfSQLAST(sqlAST, qs, environment, factory);
        return sqlAST;
    }

    void resolveDSRefOfSQLRelation(IQuerySubject qs, IXQEQueryNode sqlAST, PlanningEnvironment planEnv) {
        ArrayList<IXQEQueryNode> updateRelations = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> allRelations = new ArrayList<IXQEQueryNode>();
        List<IXQEQueryNode> relations = sqlAST.getDescendantsOfTypeOrdered(301016, false);
        for (IXQEQueryNode relation : relations) {
            if (((SQLIdentifier)relation).getSchemaName() != null) continue;
            allRelations.add(relation);
        }
        for (IXQEQueryNode relationNode : allRelations) {
            if (this.bindCommonTableExpression(relationNode)) continue;
            updateRelations.add(relationNode);
        }
        if (updateRelations.isEmpty()) {
            return;
        }
        StringBuilder dsRef = new StringBuilder();
        List<IModelDataSource> qsDS = qs.getDataSources();
        if (qsDS != null && !qsDS.isEmpty()) {
            ExecutionEnvironment executionEnv = (ExecutionEnvironment)planEnv.getExecutionEnvironment();
            IDataSource dataSource = executionEnv.getOrAddDataSource(qsDS.get(0));
            dsRef.append("[");
            dsRef.append(dataSource.getName());
            dsRef.append("]");
            for (IXQEQueryNode relation : updateRelations) {
                ((SQLIdentifier)relation).setSchemaName(dsRef.toString());
            }
        }
    }

    boolean bindCommonTableExpression(IXQEQueryNode relationNode) {
        for (IXQEQueryNode withSpec = relationNode.getAncestorOfType(301022); withSpec != null; withSpec = withSpec.getAncestorOfType(301022)) {
            int i;
            int n = withSpec.getNumberChildren() - 1;
            for (i = 0; i < n; ++i) {
                if (!relationNode.isAncestor(withSpec.getChild(i))) continue;
                n = i + 1;
                break;
            }
            for (i = 0; i < n; ++i) {
                SQLRangeVar rangeVar = (SQLRangeVar)withSpec.getChild(i);
                if (!rangeVar.getName().equals(((SQLRelation)relationNode).getName())) continue;
                return true;
            }
        }
        return false;
    }

    private IXQEQueryNode generateRangeVarOnTopOfSQLAST(IXQEQueryNode sqlAST, IQuerySubject qs, PlanningEnvironment environment, IXQENodeFactory nodeFactory) {
        IAccessedViaShortcut asc;
        IShortcut shortcut;
        boolean treatedAsAlias;
        SQLRangeVar rangeVar = (SQLRangeVar)nodeFactory.createNode(301007);
        String rangeVarName = QuerySubjectSQLGenerator.getNameInDefaultLocale(qs);
        boolean explicitShortcutProcessing = RQPUtilities.getShortcutProcessing(environment);
        if (qs instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)((Object)qs)).isAccessedViaShortcut() && (treatedAsAlias = RQPUtilities.isShortcutTreatedAsAlias(shortcut = (asc = (IAccessedViaShortcut)((Object)qs)).getShortcut(), explicitShortcutProcessing))) {
            rangeVarName = shortcut.getName();
        }
        rangeVar.setName(rangeVarName);
        rangeVar.addChild(sqlAST);
        return rangeVar;
    }

    public static boolean isTrivialSql(SQLRangeVar sqlRangeVar) {
        IXQEQueryNode sqlProject = null;
        boolean projectIsParent = false;
        if (sqlRangeVar.getChild(0).getType() == 301015) {
            sqlProject = sqlRangeVar.getChild(0);
        } else if (sqlRangeVar.getParent() != null && sqlRangeVar.getParent().getType() == 301015 && sqlRangeVar.getChild(0).getType() == 301092) {
            sqlProject = sqlRangeVar.getParent();
            projectIsParent = true;
        }
        if (sqlProject == null) {
            return false;
        }
        IXQEQueryNode sqlValueList = sqlProject.getFirstChildByType(301030);
        if (sqlValueList == null) {
            return false;
        }
        if (sqlValueList.getNumberChildren() != 1) {
            return false;
        }
        if (sqlValueList.getChild(0).getType() != 301006) {
            return false;
        }
        IXQEQueryNode child = null;
        if (projectIsParent) {
            child = sqlRangeVar.getChild(0).getChild(0);
        } else {
            IXQEQueryNode[] children = sqlProject.getChildrenOfTypes(new int[]{301016, 301007, 301092});
            if (children.length != 1) {
                return false;
            }
            child = children[0];
            if (child.getType() == 301007) {
                if (child.getNumberChildren() != 1 || child.getChild(0).getType() != 301016) {
                    return false;
                }
                child = child.getChild(0);
            }
        }
        SQLRelation relation = (SQLRelation)child;
        return relation.isDatabaseTable();
    }

    private IXQEQueryNode parseSQL(IXQENodeFactory nodeFactory, String sqlToParse) throws ParseException {
        SQLProcessor parser = new SQLProcessor(nodeFactory);
        IXQEQueryNode node = null;
        node = parser.parseQuery(sqlToParse);
        return node;
    }

    private QuerySubjectSQL getUntaggedModelSQL(IQuerySubject qs) {
        Element rootElement;
        if (this.qsSql != null) {
            return this.qsSql;
        }
        String sqlText = qs.getSql();
        if (null == sqlText) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "QuerySubjectSQLGenerator.getUntaggedModelSQL requires sqlText");
        }
        try {
            rootElement = RQPUtilities.parseString(sqlText);
        }
        catch (Exception e) {
            String uniqueID = qs.getUniqueID();
            if (uniqueID == null) {
                uniqueID = qs.getID();
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidSQL, (Throwable)e, "QS: " + uniqueID);
        }
        this.qsSql = new QuerySubjectSQL();
        SqlType sqlType = this.getSqlType(rootElement);
        this.qsSql.setSqlType(sqlType);
        StringBuilder sqlToParseBuf = new StringBuilder();
        int numColumns = 0;
        int numTables = 0;
        for (int i = 0; i < rootElement.nodeCount(); ++i) {
            Node node = rootElement.node(i);
            if (node instanceof Element && node.getName().equals("column")) {
                if (numColumns > 0) {
                    sqlToParseBuf.append(',');
                } else {
                    sqlToParseBuf.append(' ');
                }
                ++numColumns;
                sqlToParseBuf.append(node.getText());
                continue;
            }
            if (node instanceof Element && node.getName().equals("table")) {
                if (numTables > 0) {
                    sqlToParseBuf.append(',');
                } else {
                    sqlToParseBuf.append(' ');
                }
                ++numTables;
                sqlToParseBuf.append(node.getText());
                continue;
            }
            sqlToParseBuf.append(' ');
            sqlToParseBuf.append(node.getText());
        }
        this.qsSql.setSql(sqlToParseBuf.toString());
        return this.qsSql;
    }

    public static void replaceDSRefs(IQuerySubject qs, IXQEQueryNode sqlAST, PlanningEnvironment planEnv) {
        MetadataConnection mdConnection = qs.getConnection();
        if (mdConnection == null) {
            return;
        }
        List<IModelDataSource> dataSources = mdConnection.getModelDataSources();
        List<IXQEQueryNode> children = sqlAST.getDescendantsOfTypesOrdered(new int[]{301061, 301016}, false);
        for (IXQEQueryNode child : children) {
            String catalogName;
            IModelDataSource ds;
            String schemaName;
            SQLIdentifier identifier = (SQLIdentifier)child;
            QuerySubjectSQLGenerator.replaceDSRefs(dataSources, identifier, planEnv);
            if (identifier.getDatabaseName() != null || (schemaName = identifier.getSchemaName()) == null || schemaName.charAt(0) == '[') continue;
            List<IModelDataSource> qsDatasources = qs.getDataSources();
            if (qsDatasources != null && qsDatasources.size() > 0) {
                dataSources = qsDatasources;
            }
            if ((ds = RQPUtilities.getModelDataSourceUsingSchemaName(dataSources, identifier.getSchemaName(), identifier.getCatalogName())) == null) continue;
            String cmDatasourceName = ds.getCMDataSourceName();
            if (cmDatasourceName != null && cmDatasourceName.length() > 0) {
                identifier.setDatabaseName(cmDatasourceName);
            }
            if (ds.getCatalog() == null || (catalogName = ds.getCatalog().getUniqueName()) == null || catalogName.length() <= 0) continue;
            identifier.setCatalogName(catalogName);
        }
    }

    public static void replaceDSRefs(List<IModelDataSource> dataSources, SQLIdentifier identifier, PlanningEnvironment planEnv) {
        String dsRef;
        IModelDataSource ds;
        String schemaName = identifier.getSchemaName();
        if (schemaName != null && schemaName.charAt(0) == '[' && schemaName.charAt(schemaName.length() - 1) == ']' && (ds = RQPUtilities.getModelDataSource(dataSources, dsRef = schemaName.substring(1, schemaName.length() - 1))) != null) {
            String schema;
            String catalogName;
            identifier.setModelDatasourceName(ds.getName());
            String cmDataSourceName = ds.getCMDataSourceName();
            identifier.setDatabaseName(cmDataSourceName);
            if (ds.getCatalog() != null && (catalogName = ds.getCatalog().getUniqueName()) != null && catalogName.length() > 0) {
                identifier.setCatalogName(catalogName);
            }
            if ((schema = ds.getSchema()) != null && schema.length() > 0) {
                identifier.setSchemaName(schema);
            } else {
                identifier.removeProperty("schema");
            }
        }
    }

    public static void expandMacrosinSQLIdentifier(SQLIdentifier identifier, PlanningEnvironment environment) {
        String schema;
        String catalog;
        String database = identifier.getDatabaseName();
        if (database != null && database.contains(MACRO_MARKER)) {
            identifier.setRawCmDatabaseName(database);
            identifier.setDatabaseName(QuerySubjectSQLGenerator.getMacroExpandedString(database, environment));
        }
        if ((catalog = identifier.getCatalogName()) != null && catalog.contains(MACRO_MARKER)) {
            identifier.setRawCatalogName(catalog);
            identifier.setCatalogName(QuerySubjectSQLGenerator.getMacroExpandedString(catalog, environment));
        }
        if ((schema = identifier.getSchemaName()) != null && schema.contains(MACRO_MARKER)) {
            identifier.setRawSchemaName(schema);
            identifier.setSchemaName(QuerySubjectSQLGenerator.getMacroExpandedString(schema, environment));
        }
    }

    private SqlType getSqlType(Element element) {
        String sqlTypeStr = element.attributeValue("type");
        return QuerySubjectSQLGenerator.getSqlType(sqlTypeStr);
    }

    public SqlType getSqlType() {
        if (this.qsSql != null) {
            return this.qsSql.getSqlType();
        }
        return null;
    }

    public static SqlType getSqlType(String sqlTypeStr) {
        if (sqlTypeStr.equals("cognos")) {
            return SqlType.COGNOS;
        }
        if (sqlTypeStr.equals("native") || sqlTypeStr.equals("sql99")) {
            return SqlType.NATIVE;
        }
        if (sqlTypeStr.equals("passThrough")) {
            return SqlType.PASS_THROUGH;
        }
        return SqlType.UNKNOWN;
    }

    public String getUnexpandedSQL(IQuerySubject querySubject) {
        if (this.qsSql == null) {
            this.qsSql = this.getUntaggedModelSQL(querySubject);
        }
        return this.qsSql.getSql();
    }

    public String getMacroExpandedSQL(PlanningEnvironment environment, String unexpandedSQL, SqlType sqlType, IQuerySubject qs) {
        if (this.macroExpandedSQL == null) {
            this.parentNodeOfMacroExpander.setPropertyValue("sqlType", (Object)sqlType);
            MacroExpander expander = new MacroExpander();
            expander.setLocalParameters(MetadataContext.getLocalParameters(qs));
            this.macroExpandedSQL = expander.expandSQL(this.parentNodeOfMacroExpander, environment, unexpandedSQL);
        }
        return this.macroExpandedSQL;
    }

    public boolean hasMacroInCMDataSource() {
        return this.hasMacroInCMDataSource;
    }

    public static String getNameInDefaultLocale(IMetadata mdObject) {
        try {
            return UniqueNameParser.parseLastIdentifier(mdObject.getV5UniqueName());
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnableToParseV5UniqueName, mdObject.getV5UniqueName());
        }
    }

    public static String getMacroExpandedString(String str, PlanningEnvironment planEnv) {
        if (MacroExpander.isMacro(str)) {
            MacroExpander expander = new MacroExpander();
            return expander.expand(null, planEnv, str);
        }
        return str;
    }

    private class QuerySubjectSQL {
        private String sql;
        private SqlType sqlType;

        private QuerySubjectSQL() {
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String theSQL) {
            this.sql = theSQL;
        }

        public SqlType getSqlType() {
            return this.sqlType;
        }

        public void setSqlType(SqlType qsSqlType) {
            this.sqlType = qsSqlType;
        }
    }

    public static enum SqlType {
        COGNOS,
        NATIVE,
        PASS_THROUGH,
        UNKNOWN;

    }
}

