/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5ProjectionList;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryItem;
import com.cognos.xqe.ast.v5.query.V5QueryOperation;
import com.cognos.xqe.ast.v5.query.V5QueryRef;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParserException;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.ReplaceV5SummaryFunction;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS.CreateV5QueryForDynamicSQS;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SummaryQuerySubjectUtilities {
    public static final String PROP_BOOL_SUMMARY_QS = "summaryQuerySubject";
    public static final String STRING_PAA_TRUE = "(PAA=true)";
    public static final String PROP_STRING_DYNAMIC_SQS = "dynamic SQS";
    public static final String PROP_DYNAMIC_SQS_QUERY = "dynamicSQSQuery";
    public static final String PROP_REFERENCED_DYNAMIC_SQS = "referencedDynamicSQS";
    public static final String PROP_BOOL_STATIC = "static";
    public static final String STR_APPLY_TO_PARAMETER_MAP = "$ApplyToDynamicSQS{";
    public static final String STR_APPLY_TO_DSQS = "applyToDSQS";
    public static final String STR_APPLY_TO_ALL_DSQS = "apply_To_All_DSQS";
    public static final String STR_PREPLAN_UNWOUND_DSQS = "prePlanUnwoundDSQS";
    private static final String STRING_ORDERBY_KEYWORD = "ORDER_BY={";
    public static final int NUMBER_THREE = 3;
    public static final String STR_UNDERSCORE = "_";
    public static final String STRING_SET_OPERATION = "setOperation";
    public static final String STRING_DUPLICATES = "duplicates";
    public static final String STRING_NAME = "name";
    private static final String STRING_DOUBLE_QUOTE = "\"";
    public static final String STRING_ASC_ORDER = "ASC";
    private static final String STRING_DESC_ORDER = "DESC";
    public static final String STR_AUTO = "AUTO ";
    private static final String STR_IN_DSQS = " in DSQS ";
    private static final String PROP_HAS_ORDER_BY = "hasOrderBy";
    public static final String PROP_ORDER_BY = "orderBy";

    public static boolean isSummaryQuerySubject(IQuerySubject qs) {
        return qs.getQuerySubjectUsage().equals((Object)IQuerySubject.QuerySubjectUsageEnum.SUMMARY_QUERY);
    }

    public static boolean getUseLocalCache(IQuerySubject qs) {
        return IQuerySubject.QuerySubjectUseLocalCacheEnum.TRUE.equals((Object)qs.getQuerySubjectUseLocalCache());
    }

    public static V5Query generateV5QueryForSummaryQS(PlanningEnvironment env, IQuerySubject querySubject, V5Query currentQuery) {
        return SummaryQuerySubjectUtilities.generateV5QueryForSummaryQS(env, querySubject, currentQuery, true);
    }

    public static V5Query generateV5QueryForSummaryQS(PlanningEnvironment env, IQuerySubject querySubject, V5Query currentQuery, boolean updateSource) {
        V5QuerySet v5QuerySet = V5QuerySet.getRootQuerySet(env, currentQuery);
        V5Query query = SummaryQuerySubjectUtilities.getMatchingDSQSUnderSameRoot(v5QuerySet, querySubject, currentQuery);
        if (query != null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidSharedDSQS, querySubject.getID());
        }
        V5Query newV5Query = SummaryQuerySubjectUtilities.createV5Query(env, querySubject, currentQuery, SummaryQuerySubjectUtilities.buildQueryNameForSQS(querySubject, currentQuery));
        if (SummaryQuerySubjectUtilities.needsToUpdateSource(updateSource, currentQuery)) {
            SummaryQuerySubjectUtilities.updateV5Source(env, querySubject, currentQuery, newV5Query);
        }
        SummaryQuerySubjectUtilities.generateSelectionAndDataItems(env, querySubject, newV5Query);
        SummaryQuerySubjectUtilities.generateDetailFilters(env, querySubject, newV5Query);
        return newV5Query;
    }

    private static V5Query getMatchingDSQSUnderSameRoot(V5QuerySet v5QuerySet, IQuerySubject querySubject, V5Query currentRootDSQSQuery) {
        for (IXQEQueryNode node : v5QuerySet.getChildren()) {
            V5Query query;
            IQuerySubject qs;
            if (node.getType() != 101006 || (qs = (query = (V5Query)node).getDynamicSQS()) == null || qs != querySubject || query.getPropertyValue("rootDSQSQuery") != currentRootDSQSQuery) continue;
            return query;
        }
        return null;
    }

    private static void updateV5Source(PlanningEnvironment env, IQuerySubject querySubject, V5Query currentQuery, V5Query newV5Query) {
        V5Source sourceOfOriginalV5Query = currentQuery.getV5Source();
        Set<String> referencedQueries = sourceOfOriginalV5Query.getReferencedQueries();
        if (referencedQueries != null && !referencedQueries.isEmpty() && querySubject != null) {
            Governors governors = currentQuery.getGovernors();
            if (Governors.GovernorPermission.DENY == governors.getCrossProdAllowed()) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_CrossJoinsNotPermitted, currentQuery.getV5QueryName() + ", " + querySubject.getV5UniqueName());
            }
            if (Governors.GovernorPermission.WARN == governors.getCrossProdAllowed()) {
                ExecutionEnvironment ee = (ExecutionEnvironment)env.getExecutionEnvironment();
                String nagMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_CrossJoinsDetected, XQEMessages.getCurrProductLocale());
                ee.addNag(nagMsg);
            }
        } else {
            referencedQueries = new TreeSet<String>();
            referencedQueries.add(newV5Query.getV5QueryName());
            sourceOfOriginalV5Query.removeProperty("model");
        }
        sourceOfOriginalV5Query.setReferencedQueries(referencedQueries);
    }

    public static V5Query createV5Query(PlanningEnvironment env, IQuerySubject querySubject, V5Query currentQuery, String nameForNewQuery) {
        V5Query rootDSQSQuery;
        V5QuerySet v5QuerySet = V5QuerySet.getRootQuerySet(currentQuery);
        XQENodeFactory nodeFactory = env.getNodeFactory();
        V5Query newV5Query = (V5Query)nodeFactory.createNode(101006);
        newV5Query.setPropertyValue(STRING_NAME, nameForNewQuery);
        newV5Query.setPropertyValue("isTabular", true);
        newV5Query.setPropertyValue("isRelStyle", true);
        if (querySubject != null) {
            newV5Query.setPropertyValue(PROP_DYNAMIC_SQS_QUERY, querySubject);
        }
        newV5Query.initializeCount();
        v5QuerySet.addChild(newV5Query, 0);
        v5QuerySet.addResolvedQuery(newV5Query.getV5QueryName());
        Governors governor = currentQuery.getGovernors().copy();
        if (querySubject != null) {
            boolean localCache = SummaryQuerySubjectUtilities.getUseLocalCache(querySubject);
            governor.setLocalCache(Boolean.toString(localCache));
        }
        newV5Query.setGovernors(governor);
        V5Source sourceOfCurrentQuery = currentQuery.getV5Source();
        newV5Query.addChild(nodeFactory.copyNode(sourceOfCurrentQuery));
        String rootQueryName = currentQuery.getRootQueryName();
        if (rootQueryName != null) {
            newV5Query.setPropertyValue("rootQueryName", rootQueryName);
        }
        if ((rootDSQSQuery = (V5Query)currentQuery.getPropertyValue("rootDSQSQuery")) != null) {
            newV5Query.setPropertyValue("rootDSQSQuery", rootDSQSQuery);
        }
        V5Selection selection = (V5Selection)nodeFactory.createNode(101009);
        newV5Query.addChild(selection);
        return newV5Query;
    }

    private static boolean needsToUpdateSource(boolean updateSource, V5Query currentQuery) {
        if (!updateSource) {
            return false;
        }
        return !SummaryQuerySubjectUtilities.isQueryOperationOrJoinQuery(currentQuery);
    }

    public static String buildQueryNameForSQS(IQuerySubject querySubject, V5Query currentQuery) {
        String[] parts;
        UniqueNameParser unp = new UniqueNameParser();
        try {
            parts = unp.parse(querySubject.getV5UniqueName());
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(e);
        }
        String name = "SQS_" + parts[0].substring(0, parts[0].length()) + STR_UNDERSCORE + parts[1].substring(0, parts[1].length());
        V5QuerySet querySet = V5QuerySet.getRootQuerySet(currentQuery);
        V5Query query = querySet.getV5Query(name);
        if (query == null) {
            return name;
        }
        V5Query rootQuery = (V5Query)currentQuery.getPropertyValue("rootDSQSQuery");
        if (rootQuery != null) {
            return rootQuery.getV5QueryName() + name;
        }
        String message = "The root DSQS is missing, can not build query name for DSQS:" + querySubject.getID();
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, message);
    }

    private static boolean isQueryOperationOrJoinQuery(V5Query currentQuery) {
        V5Source source = currentQuery.getV5Source();
        if (source == null) {
            return false;
        }
        if (source.getNumberChildren() != 1) {
            return false;
        }
        return source.getChild(0).getType() == 101018 || source.getChild(0).getType() == 101019;
    }

    public static String determineAggAttribute(IQueryItem queryItem) {
        if (!queryItem.isFact()) {
            return "none";
        }
        String regAgg = queryItem.getRegularAggregate();
        if ("unknown".equals(regAgg) || "unsupported".equals(regAgg)) {
            return "none";
        }
        if ("sum".equals(regAgg)) {
            return "total";
        }
        return regAgg;
    }

    public static void generateDetailFilters(PlanningEnvironment env, IQuerySubject querySubject, V5Query sqsQuery) {
        List<IEmbeddedFilter> filters = querySubject.getFilters();
        if (filters == null || filters.isEmpty()) {
            return;
        }
        XQENodeFactory nodeFactory = env.getNodeFactory();
        V5Selection selection = sqsQuery.getV5Selection();
        for (IEmbeddedFilter filter : filters) {
            IXQEQueryNode v5ValueExpression;
            V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            detailFilter.setPropertyValue(PROP_BOOL_STATIC, true);
            String useProperty = SummaryQuerySubjectUtilities.getUseProperty(filter);
            if (useProperty != null) {
                detailFilter.setUseProperty(SummaryQuerySubjectUtilities.getUseProperty(filter));
            }
            if ((v5ValueExpression = RQPUtilities.createV5ExpressionFromFilter(env, filter, sqsQuery)) == null) continue;
            v5ValueExpression = SummaryQuerySubjectUtilities.bindAndUnwindSelfReferences(env, v5ValueExpression, querySubject, selection);
            detailFilter.addChild(v5ValueExpression);
            if (SummaryQuerySubjectUtilities.getPostAutoAggregate(filter)) {
                detailFilter.setPostAutoAggregation(true);
            }
            sqsQuery.addChild(detailFilter);
        }
    }

    public static void unwindSelfReferencesInExpr(IXQEQueryNode v5ValueExpression, IQuerySubject querySubject, V5Selection selection, IXQENodeFactory factory) {
        IXQEQueryNode[] v5Ids;
        LoopDetectionChain ldc = new LoopDetectionChain();
        for (IXQEQueryNode v5Id : v5Ids = v5ValueExpression.getDescendantsOfType(201116, true)) {
            SummaryQuerySubjectUtilities.unwindSelfReferences((V5BoundModelIdentifier)v5Id, querySubject, selection, factory, ldc);
        }
    }

    public static void unwindSelfReferences(V5BoundModelIdentifier boundId, IQuerySubject querySubject, V5Selection selection, IXQENodeFactory factory, LoopDetectionChain ldc) {
        V5DataItem di;
        if (!ldc.push(boundId.getIdentifier())) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, "Model Expression", ldc.serialize());
        }
        if (boundId.getQuerySubject() == querySubject && (di = CreateV5QueryForDynamicSQS.getDataItemByRefName(selection, boundId.getNameParts()[2])) != null) {
            IXQEQueryNode[] v5Ids;
            V5DataItem copiedDi = (V5DataItem)factory.deepCopyNode(di);
            copiedDi.setOriginalV5DataItem(di);
            boundId.exchange(copiedDi);
            di.setIsReferenced();
            for (IXQEQueryNode v5Id : v5Ids = copiedDi.getDescendantsOfType(201116, true)) {
                SummaryQuerySubjectUtilities.unwindSelfReferences((V5BoundModelIdentifier)v5Id, querySubject, selection, factory, ldc);
            }
        }
        ldc.pop();
    }

    private static String getUseProperty(IEmbeddedFilter filter) {
        String useProperty = filter.getApplyAttribute();
        if ("always".equals(useProperty)) {
            return "required";
        }
        if ("asNeeded".equals(useProperty)) {
            return "optional";
        }
        return null;
    }

    public static boolean getPostAutoAggregate(IEmbeddedFilter filter) {
        if (filter.getExpression() != null && filter.getExpression().contains(STRING_PAA_TRUE)) {
            return true;
        }
        return filter.getApplicationAttribute().equals((Object)IEmbeddedFilter.FilterApplicationEnum.AFTER_AUTO_AGGREGATION);
    }

    public static boolean isQueryOperationUsingSQS(IQuerySubject qs) {
        IQuerySubject[] querySubjects;
        if (qs.getQuerySubjectType() != IQuerySubject.QuerySubjectTypeEnum.QUERYOPERATION) {
            return false;
        }
        for (IQuerySubject legQS : querySubjects = qs.getQuerySubjectRefs()) {
            if (!SummaryQuerySubjectUtilities.isSummaryQuerySubject(legQS)) continue;
            return true;
        }
        return false;
    }

    public static void generateV5QueryForQueryOperationInvolvingSQS(PlanningEnvironment env, IQuerySubject querySubject, V5Query currentQuery) {
        V5Query newV5Query = SummaryQuerySubjectUtilities.generateV5QueryForSummaryQS(env, querySubject, currentQuery);
        V5Source source = newV5Query.getV5Source();
        if (source.getNumberChildren() == 1) {
            return;
        }
        XQENodeFactory nodeFactory = env.getNodeFactory();
        V5QueryOperation v5QueryOperation = (V5QueryOperation)nodeFactory.createNode(101018);
        v5QueryOperation.setPropertyValue(STRING_SET_OPERATION, querySubject.getProperty(STRING_SET_OPERATION));
        v5QueryOperation.setPropertyValue(STRING_DUPLICATES, querySubject.getProperty(STRING_DUPLICATES));
        v5QueryOperation.setPropertyValue(STRING_NAME, querySubject.getProperty(STRING_SET_OPERATION) + STR_UNDERSCORE + SummaryQuerySubjectUtilities.buildQueryNameForSQS(querySubject, currentQuery));
        source.addChild(v5QueryOperation);
        for (IQuerySubject refQuerySubject : querySubject.getQuerySubjectRefs()) {
            V5Query legQuery = null;
            legQuery = SummaryQuerySubjectUtilities.isSummaryQuerySubject(refQuerySubject) ? SummaryQuerySubjectUtilities.generateV5QueryForSummaryQS(env, refQuerySubject, newV5Query) : SummaryQuerySubjectUtilities.generateV5QueryForNormalQS(env, refQuerySubject, newV5Query);
            V5QueryRef queryRef = (V5QueryRef)nodeFactory.createNode(101023);
            queryRef.setRefQuery(legQuery.getRootQueryName());
            v5QueryOperation.addChild(queryRef);
        }
        V5ProjectionList projList = (V5ProjectionList)nodeFactory.createNode(101020);
        v5QueryOperation.addChild(projList);
        for (IMetadata qi : querySubject.getQueryItemsAndMeasures()) {
            V5QueryItem v5Qi = (V5QueryItem)nodeFactory.createNode(101022);
            v5Qi.setPropertyValue(STRING_NAME, qi.getName());
            projList.addChild(v5Qi);
        }
    }

    private static void generateSelectionAndDataItems(PlanningEnvironment env, IQuerySubject qs, V5Query newV5Query) {
        IXQEQueryNode[] dataItems;
        XQENodeFactory nodeFactory = env.getNodeFactory();
        V5Selection selection = newV5Query.getV5Selection();
        for (IMetadata qi : qs.getQueryItemsAndMeasures()) {
            IQueryItem queryItem = (IQueryItem)qi;
            IXQEQueryNode v5ValueExpression = RQPUtilities.getV5ValueExpression(queryItem, env);
            if (v5ValueExpression == null) {
                String qiUniqueName = qi.getV5UniqueName();
                if (qiUniqueName == null) continue;
                V5MultiPartIdentifier v5BoundId = (V5MultiPartIdentifier)nodeFactory.createNode(201030);
                v5BoundId.setIdentifier(qiUniqueName);
                v5ValueExpression = v5BoundId;
            }
            v5ValueExpression = RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(env, v5ValueExpression);
            IXQEQueryNode di = (V5DataItem)nodeFactory.createNode(101003);
            ((XQEBaseQueryNode)di).addChild(v5ValueExpression);
            ((V5DataItem)di).setNameProperty(qi.getName());
            ((V5DataItem)di).setAggregateProperty(SummaryQuerySubjectUtilities.determineAggAttribute(queryItem));
            ((V5DataItem)di).setRollupAggregateProperty("none");
            ((V5DataItem)di).setIsOriginal();
            if (((V5DataItem)di).getAggregateProperty().equals("none")) {
                ((XQEQueryNode)di).setPropertyValue(PROP_BOOL_STATIC, true);
            }
            SummaryQuerySubjectUtilities.collectOrderByForRMFunctions(queryItem, (V5DataItem)di, newV5Query);
            selection.addChild(di);
        }
        for (IXQEQueryNode di : dataItems = selection.getChildren()) {
            SummaryQuerySubjectUtilities.unwindSelfReferencesInExpr(di, qs, selection, nodeFactory);
        }
        SummaryQuerySubjectUtilities.validateAndPropagateOrderBy(newV5Query, dataItems);
    }

    private static void validateAndPropagateOrderBy(V5Query newV5Query, IXQEQueryNode[] dataItems) {
        if (newV5Query.getPropertyValue(PROP_HAS_ORDER_BY) != null) {
            for (IXQEQueryNode di : dataItems) {
                List orderByItems = (List)di.getPropertyValue(PROP_ORDER_BY);
                if (orderByItems == null) continue;
                SummaryQuerySubjectUtilities.checkValidityOrderByExpr((V5DataItem)di, newV5Query);
                List<IXQEQueryNode> aggregates = di.getDescendantsOfTypeOrdered(201035, true);
                for (IXQEQueryNode aggregate : aggregates) {
                    aggregate.setPropertyValue(PROP_ORDER_BY, orderByItems);
                }
            }
        }
    }

    private static void collectOrderByForRMFunctions(IQueryItem queryItem, V5DataItem v5Di, V5Query dsqsQuery) {
        List<Pair> orderByItems;
        String desc;
        List<IXQEQueryNode> aggregates = v5Di.getChild(0).getDescendantsOfTypeOrdered(201035, true);
        if (aggregates != null && aggregates.size() > 0 && (desc = queryItem.getDescription()) != null && (orderByItems = SummaryQuerySubjectUtilities.getOrderBy(desc, dsqsQuery)) != null) {
            v5Di.setPropertyValue(PROP_ORDER_BY, orderByItems);
            dsqsQuery.setPropertyValue(PROP_HAS_ORDER_BY, true);
        }
    }

    private static List<Pair> getOrderBy(String desc, V5Query dsqsQuery) {
        int start = desc.indexOf(STRING_ORDERBY_KEYWORD);
        if (start == -1) {
            return null;
        }
        int startOrderByItems = start + STRING_ORDERBY_KEYWORD.length();
        int endOrderByItems = desc.indexOf("}");
        String orderByItems = desc.substring(startOrderByItems, endOrderByItems);
        String[] obItems = orderByItems.split(";");
        ArrayList<Pair> obItemList = new ArrayList<Pair>();
        for (String obItem : obItems) {
            int startQI;
            int endQI = startQI = obItem.indexOf(STRING_DOUBLE_QUOTE);
            String qiName = null;
            if (startQI != -1) {
                endQI = obItem.substring(startQI + 1).indexOf(STRING_DOUBLE_QUOTE);
                qiName = obItem.substring(startQI + 1, endQI + 1);
            } else {
                startQI = obItem.indexOf(STR_AUTO);
                if (startQI == -1) {
                    String message = "Invalid ORDER_BY item:" + obItem + STR_IN_DSQS + dsqsQuery.getDynamicSQS().getID();
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, message);
                }
                endQI = startQI + STR_AUTO.length();
                qiName = STR_AUTO;
            }
            String sortOrder = null;
            int ascendingIndex = obItem.substring(endQI).indexOf(STRING_ASC_ORDER);
            if (ascendingIndex != -1) {
                sortOrder = STRING_ASC_ORDER;
            } else {
                int descendingIndex = obItem.substring(endQI).indexOf(STRING_DESC_ORDER);
                if (descendingIndex != -1) {
                    sortOrder = STRING_DESC_ORDER;
                } else {
                    String message = "Invalid sort direction in ORDER_BY item:" + obItem + STR_IN_DSQS + dsqsQuery.getDynamicSQS().getID();
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, message);
                }
            }
            Pair p = new Pair(qiName, sortOrder);
            obItemList.add(p);
        }
        return obItemList;
    }

    private static void checkValidityOrderByExpr(V5DataItem v5Di, V5Query dsqsQuery) {
        List orderByItems = (List)v5Di.getPropertyValue(PROP_ORDER_BY);
        V5Selection selection = dsqsQuery.getV5Selection();
        String errorMsg = "query item:" + dsqsQuery.getDynamicSQS().getID() + "[" + v5Di.getNameProperty() + "] has ORDER_BY item:";
        for (Pair p : orderByItems) {
            String qiName = (String)p.getFirst();
            if (qiName.equals(STR_AUTO)) continue;
            V5DataItem di = selection.getDataItemByRefName(qiName);
            if (di == null) {
                String message = errorMsg + qiName + " that does not exist in query subject.";
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, message);
            }
            if (!ReplaceV5SummaryFunction.hasMovingRunningInExpression(di.getChild(0))) continue;
            String message = errorMsg + qiName + " not valid because it contains a window aggregate.";
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, message);
        }
    }

    private static IXQEQueryNode bindAndUnwindSelfReferences(PlanningEnvironment env, IXQEQueryNode v5ValueExpression, IQuerySubject dynamicSQS, V5Selection selection) {
        v5ValueExpression = RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(env, v5ValueExpression);
        SummaryQuerySubjectUtilities.unwindSelfReferencesInExpr(v5ValueExpression, dynamicSQS, selection, env.getNodeFactory());
        return v5ValueExpression;
    }

    public static boolean involveSQS(IQuerySubject querySubject) {
        if (SummaryQuerySubjectUtilities.isSummaryQuerySubject(querySubject)) {
            return true;
        }
        return SummaryQuerySubjectUtilities.isQueryOperationUsingSQS(querySubject);
    }

    private static V5Query generateV5QueryForNormalQS(PlanningEnvironment env, IQuerySubject querySubject, V5Query v5Query) {
        V5Query newV5Query = SummaryQuerySubjectUtilities.generateV5QueryForSummaryQS(env, querySubject, v5Query);
        V5Selection selection = newV5Query.getV5Selection();
        selection.setAutoSummary(false);
        return newV5Query;
    }

    public static boolean isDynamicSQS(IQuerySubject querySubject) {
        String desc = querySubject.getDescription();
        return desc != null && desc.contains(PROP_STRING_DYNAMIC_SQS);
    }

    public static void registerDynamicSQS(V5Query v5Query, IQuerySubject dynamicSQS) {
        if (v5Query == null) {
            return;
        }
        TreeSet<IQuerySubject> existingDynamicSQSs = (TreeSet<IQuerySubject>)v5Query.getPropertyValue(PROP_REFERENCED_DYNAMIC_SQS);
        if (existingDynamicSQSs == null) {
            existingDynamicSQSs = new TreeSet<IQuerySubject>();
            v5Query.setPropertyValue(PROP_REFERENCED_DYNAMIC_SQS, existingDynamicSQSs);
        }
        existingDynamicSQSs.add(dynamicSQS);
    }
}

