/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.aggregateAwareness;

import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5tocogsql.util.aggregateAwareness.IAggregateAwareness;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AggregateAwareness
implements IAggregateAwareness {
    private static final XQELogger INFO_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "AggregateAwareness", LogLevel.INFO);
    private static final String BASE_QS_KW = "BASEAGG=";
    private static final String AGGR_QS_KW = "AGGS=";
    private static final String BRACKET = "[";
    private static final String LINE_FEED = "\n";
    private static final String NOT_MATCH = " does not match the base fact query subject ";
    private static final String NOT_EXIST = " does not exist in ";
    private static final String UNSUPPORTED = "unsupported";
    private static final String SORT_NUM_GROUPING = " uses the number of grouping items to find aggregate query subject.";
    private static final String SORT_AGGREGATE_LIST = " finds aggregate query subject based on the list: .";
    private final TreeMap<String, BaseFactTableDefinition> baseFactQSNameToDefinition = new TreeMap();
    private final AtomicBoolean bInitialized = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLRangeVar cloneAggregateQsSQLRangeVar(PlanningEnvironment environment, String baseQSUName, String aggregateQSUName) {
        SummaryTableInformation summaryFactDefinition;
        BaseFactTableDefinition baseFactdefinition = this.baseFactQSNameToDefinition.get(baseQSUName);
        if (baseFactdefinition != null && (summaryFactDefinition = (SummaryTableInformation)baseFactdefinition.summaryTables.get(aggregateQSUName)) != null) {
            TreeMap<String, String> cacheKey = ((RequestEnvironment)environment.getRequestEnvironment()).getResolvedMacros();
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            SQLRangeVar v = (SQLRangeVar)summaryFactDefinition.plannedSQLRangeVar.get(cacheKey);
            if (v != null) {
                SQLRangeVar sQLRangeVar = v;
                synchronized (sQLRangeVar) {
                    return (SQLRangeVar)nodeFactory.deepCopyNode(v);
                }
            }
        }
        return null;
    }

    @Override
    public void addPlannedSQLRangeVarAggregateQs(Pair baseAggregateQSUNames, TreeMap<String, String> cacheKey, SQLRangeVar plannedSQLRangeVar) {
        SummaryTableInformation summaryFactDefinition;
        BaseFactTableDefinition baseFactDefinition = this.baseFactQSNameToDefinition.get((String)baseAggregateQSUNames.getFirst());
        if (baseFactDefinition != null && (summaryFactDefinition = (SummaryTableInformation)baseFactDefinition.summaryTables.get((String)baseAggregateQSUNames.getSecond())) != null) {
            summaryFactDefinition.plannedSQLRangeVar.putIfAbsent(cacheKey, plannedSQLRangeVar);
        }
    }

    @Override
    public TreeSet<String> getUnresolvedAggregateQuerySubjects(TreeMap<String, String> cacheKey, String baseQSUName) {
        TreeSet<String> rt = new TreeSet<String>();
        BaseFactTableDefinition baseFactDefinition = this.baseFactQSNameToDefinition.get(baseQSUName);
        if (baseFactDefinition != null) {
            for (Map.Entry e : baseFactDefinition.summaryTables.entrySet()) {
                if (((SummaryTableInformation)e.getValue()).plannedSQLRangeVar.containsKey(cacheKey)) continue;
                rt.add((String)e.getKey());
            }
        }
        return rt;
    }

    @Override
    public boolean isBaseFactQuerySubject(String uName) {
        return this.baseFactQSNameToDefinition.containsKey(uName);
    }

    @Override
    public boolean hasBaseFactTableDefinition() {
        return !this.baseFactQSNameToDefinition.isEmpty();
    }

    @Override
    public boolean isGroupingItem(String baseQSUName, String uName) {
        BaseFactTableDefinition baseFactDefiniton = this.baseFactQSNameToDefinition.get(baseQSUName);
        if (baseFactDefiniton == null) {
            return false;
        }
        Integer idx = (Integer)baseFactDefiniton.quickSearchMap.get(uName);
        if (idx == null) {
            return false;
        }
        return baseFactDefiniton.keyItems.containsKey(idx);
    }

    @Override
    public String getGroupingItemUNameAggregateQs(String baseQSUName, String baseQSGroupingItemUName, String aggregateQSUName) {
        BaseFactTableDefinition baseFactDefinition = this.baseFactQSNameToDefinition.get(baseQSUName);
        if (baseFactDefinition == null) {
            return null;
        }
        Integer idx = (Integer)baseFactDefinition.quickSearchMap.get(baseQSGroupingItemUName);
        if (idx == null) {
            return null;
        }
        SummaryTableInformation aggregateFactDefinition = (SummaryTableInformation)baseFactDefinition.summaryTables.get(aggregateQSUName);
        if (aggregateFactDefinition == null) {
            return null;
        }
        return (String)aggregateFactDefinition.keyItems.get(idx);
    }

    @Override
    public Pair getAggregateQsAndFactItemUNames(String baseQSUName, String baseQsFactItemUName, String aggrType, TreeSet<String> baseQsGroupingItems) {
        BaseFactTableDefinition baseDef = this.baseFactQSNameToDefinition.get(baseQSUName);
        if (baseDef == null) {
            return null;
        }
        Integer colIdx = (Integer)baseDef.quickSearchMap.get(baseQsFactItemUName);
        if (colIdx == null) {
            return null;
        }
        TreeSet<Integer> grps = new TreeSet<Integer>();
        for (String s : baseQsGroupingItems) {
            Integer idx = (Integer)baseDef.quickSearchMap.get(s);
            if (idx == null) {
                return null;
            }
            grps.add(idx);
        }
        for (String sTab : baseDef.listOfAggregateTables) {
            SummaryTableInformation summaryDef = (SummaryTableInformation)baseDef.summaryTables.get(sTab);
            String summaryCol = summaryDef.matchAggregate(colIdx, grps, aggrType);
            if (summaryCol == null) continue;
            return new Pair(sTab, summaryCol);
        }
        Integer sz = XQEIntegerPool.getInteger(baseQsGroupingItems.size());
        SortedMap tailMap = baseDef.numGrpToSummary.tailMap(sz);
        for (Map.Entry e : tailMap.entrySet()) {
            for (String st : (TreeSet)e.getValue()) {
                SummaryTableInformation summaryDef = (SummaryTableInformation)baseDef.summaryTables.get(st);
                String summaryCol = summaryDef.matchAggregate(colIdx, grps, aggrType);
                if (summaryCol == null) continue;
                return new Pair(st, summaryCol);
            }
        }
        return null;
    }

    @Override
    public synchronized void initialize(PlanningEnvironment environment) {
        if (this.bInitialized.get()) {
            return;
        }
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean bEnabled = config.getBooleanProperty("general.aggregateAwareness[@enabled]", true);
        if (!bEnabled) {
            this.bInitialized.set(true);
            return;
        }
        StringBuilder msg = null;
        if (INFO_LOGGER.isOn()) {
            msg = new StringBuilder();
        }
        MetadataConnection con = environment.getMetadataConnection();
        List<IMetadata> qs = con.getEntities();
        for (IMetadata o : qs) {
            int idx;
            String baseTable;
            if (!(o instanceof IQuerySubject) || (baseTable = o.getDescription()) == null || (idx = baseTable.indexOf(BASE_QS_KW)) == -1 || (idx = (baseTable = baseTable.substring(idx + BASE_QS_KW.length())).indexOf(BRACKET)) == -1) continue;
            baseTable = baseTable.substring(idx);
            V5NameBinding nameBinding = new V5NameBinding(environment);
            IMetadata metadata = nameBinding.bindModelIdentifier(baseTable = baseTable.trim(), true);
            if (metadata == null || !(metadata instanceof IQuerySubject)) continue;
            baseTable = ((IQuerySubject)metadata).getV5UniqueName();
            if (msg != null) {
                msg.append("Base Fact QuerySubject: ");
                msg.append(baseTable);
            }
            this.insertSummaryTable(environment, (IQuerySubject)o, baseTable, msg);
            if (msg == null) continue;
            msg.append(LINE_FEED);
            msg.append(LINE_FEED);
            msg.append(LINE_FEED);
            msg.append(LINE_FEED);
        }
        this.checkCircularDefinition();
        this.createListOfAggregateTables(environment, msg);
        if (INFO_LOGGER.isOn()) {
            INFO_LOGGER.log(msg.toString());
        }
        this.bInitialized.set(true);
    }

    private void createListOfAggregateTables(PlanningEnvironment environment, StringBuilder msg) {
        for (Map.Entry<String, BaseFactTableDefinition> e : this.baseFactQSNameToDefinition.entrySet()) {
            String[] parts;
            String baseTableName = e.getKey();
            BaseFactTableDefinition def = e.getValue();
            V5NameBinding nameBinding = new V5NameBinding(environment);
            IMetadata metadata = nameBinding.bindModelIdentifier(baseTableName, true);
            String desc = metadata.getDescription();
            if (desc == null) {
                if (msg == null) continue;
                msg.append(LINE_FEED);
                msg.append(baseTableName);
                msg.append(SORT_NUM_GROUPING);
                continue;
            }
            int idx = desc.indexOf(AGGR_QS_KW);
            if (idx == -1) {
                if (msg == null) continue;
                msg.append(LINE_FEED);
                msg.append(baseTableName);
                msg.append(SORT_NUM_GROUPING);
                continue;
            }
            desc = desc.substring(idx + AGGR_QS_KW.length());
            for (String part : parts = desc.split(",")) {
                IMetadata aggregateQS;
                String summaryTable = part.trim();
                if (summaryTable.isEmpty() || (aggregateQS = nameBinding.bindModelIdentifier(summaryTable, true)) == null || !(aggregateQS instanceof IQuerySubject)) continue;
                def.addSummaryAggregateTable(((IQuerySubject)aggregateQS).getV5UniqueName());
            }
            if (msg == null) continue;
            msg.append(LINE_FEED);
            msg.append(baseTableName);
            msg.append(SORT_AGGREGATE_LIST);
            msg.append(def.listOfAggregateTables.toString());
        }
    }

    private void checkCircularDefinition() {
        Set<String> allBaseQSs = this.baseFactQSNameToDefinition.keySet();
        for (String baseQS : allBaseQSs) {
            LinkedList<String> stack;
            if (!this.hasCircular(baseQS, stack = new LinkedList<String>())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Aggregate Awareness definition has ");
            for (int i = 0; i < stack.size(); ++i) {
                if (i > 0) {
                    sb.append(" --> ");
                }
                sb.append(stack.get(i));
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInModel, sb.toString());
        }
    }

    private boolean hasCircular(String baseQS, LinkedList<String> stack) {
        if (stack.contains(baseQS)) {
            stack.addLast(baseQS);
            return true;
        }
        stack.addLast(baseQS);
        BaseFactTableDefinition d = this.baseFactQSNameToDefinition.get(baseQS);
        if (d != null) {
            Set aggrTables = d.summaryTables.keySet();
            for (String a : aggrTables) {
                if (!this.hasCircular(a, stack)) continue;
                return true;
            }
        }
        stack.removeLast();
        return false;
    }

    private void insertSummaryTable(PlanningEnvironment environment, IQuerySubject qs, String baseFactTable, StringBuilder msg) {
        BaseFactTableDefinition baseTab;
        TreeMap<String, String> keys = new TreeMap<String, String>();
        TreeMap<String, TreeMap<String, String>> facts = new TreeMap<String, TreeMap<String, String>>();
        for (IMetadata qi : qs.getQueryItemsAndMeasures()) {
            IQueryItem queryItem = (IQueryItem)qi;
            String qiDesc = qi.getDescription();
            if (qiDesc == null) {
                qiDesc = UniqueNameGenerator.join(baseFactTable, UniqueNameGenerator.createSingleNamePart(queryItem.getName()));
            } else {
                int idx = qiDesc.indexOf(BRACKET);
                if (idx == -1) {
                    qiDesc = UniqueNameGenerator.join(baseFactTable, UniqueNameGenerator.createSingleNamePart(queryItem.getName()));
                } else {
                    qiDesc = qiDesc.substring(idx);
                    qiDesc = qiDesc.trim();
                }
            }
            String aggrType = queryItem.getRegularAggregate();
            if ("maximum".equalsIgnoreCase(aggrType)) {
                aggrType = SQLAggregate.SubType.MAX.toString();
            } else if ("minimum".equalsIgnoreCase(aggrType)) {
                aggrType = SQLAggregate.SubType.MIN.toString();
            }
            if (aggrType.equals(UNSUPPORTED)) {
                keys.put(qiDesc, qi.getV5UniqueName());
                continue;
            }
            TreeMap<String, String> s = (TreeMap<String, String>)facts.get(qiDesc);
            if (s == null) {
                s = new TreeMap<String, String>();
                facts.put(qiDesc, s);
            }
            s.put(qi.getV5UniqueName(), aggrType);
        }
        TreeSet<String> validFacts = new TreeSet<String>();
        StringBuilder sb = null;
        if (msg != null) {
            sb = new StringBuilder();
        }
        if (!this.verifyQueryItemsMapping(environment, keys.keySet(), facts.keySet(), validFacts, baseFactTable, sb)) {
            if (msg != null) {
                msg.append(LINE_FEED);
                msg.append("the aggregate query subject: ");
                msg.append(qs.getV5UniqueName());
                msg.append(" is ignored because some grouping items don't exist in the base fact query subject. ");
                msg.append((CharSequence)sb);
            }
            return;
        }
        if (msg != null) {
            msg.append(LINE_FEED);
            msg.append("aggregate query subject: ");
            msg.append(qs.getV5UniqueName());
            msg.append(" is available for the grouping items: ");
            msg.append(keys.keySet().toString());
            msg.append(" for the fact items: ");
            msg.append(validFacts.toString());
        }
        if ((baseTab = this.baseFactQSNameToDefinition.get(baseFactTable)) == null) {
            baseTab = new BaseFactTableDefinition();
            this.baseFactQSNameToDefinition.put(baseFactTable, baseTab);
        }
        baseTab.addKeys(qs.getV5UniqueName(), keys);
        baseTab.addFacts(qs.getV5UniqueName(), facts, validFacts);
    }

    private boolean verifyQueryItemsMapping(PlanningEnvironment environment, Set<String> keys, Set<String> facts, TreeSet<String> validFacts, String baseFactTable, StringBuilder msg) {
        String uniName;
        IQuerySubject qs;
        IMetadata metadata;
        V5NameBinding nameBinding = new V5NameBinding(environment);
        for (String n : keys) {
            metadata = nameBinding.bindModelIdentifier(n, true);
            if (metadata == null || !(metadata instanceof IQueryItem)) {
                if (msg != null) {
                    msg.append("grouping item: ");
                    msg.append(n);
                    msg.append(NOT_EXIST);
                    msg.append(baseFactTable);
                }
                return false;
            }
            qs = ((IQueryItem)metadata).getQuerySubject();
            if (qs == null) {
                return false;
            }
            uniName = qs.getV5UniqueName();
            if (baseFactTable.equals(uniName)) continue;
            if (msg != null) {
                msg.append(uniName);
                msg.append(NOT_MATCH);
                msg.append(baseFactTable);
            }
            return false;
        }
        for (String n : facts) {
            metadata = nameBinding.bindModelIdentifier(n, true);
            if (metadata == null || !(metadata instanceof IQueryItem)) {
                if (msg == null) continue;
                msg.append("fact item: ");
                msg.append(n);
                msg.append(NOT_EXIST);
                msg.append(baseFactTable);
                continue;
            }
            qs = ((IQueryItem)metadata).getQuerySubject();
            if (qs == null) {
                return false;
            }
            uniName = qs.getV5UniqueName();
            if (!baseFactTable.equals(uniName)) {
                if (msg == null) continue;
                msg.append(uniName);
                msg.append(NOT_MATCH);
                msg.append(baseFactTable);
                continue;
            }
            validFacts.add(n);
        }
        return true;
    }

    private class SummaryTableInformation {
        private final TreeMap<Integer, String> keyItems = new TreeMap();
        private final TreeMap<Integer, TreeMap<String, String>> factItems = new TreeMap();
        private final ConcurrentMap<TreeMap<String, String>, SQLRangeVar> plannedSQLRangeVar = new ConcurrentHashMap<TreeMap<String, String>, SQLRangeVar>();

        private SummaryTableInformation() {
        }

        private void addKey(Integer id, String uName) {
            this.keyItems.put(id, uName);
        }

        private void addFacts(Integer id, TreeMap<String, String> uName) {
            TreeMap<String, String> f = this.factItems.get(id);
            if (f == null) {
                f = new TreeMap();
                this.factItems.put(id, f);
            }
            for (Map.Entry<String, String> e : uName.entrySet()) {
                f.put(e.getKey(), e.getValue());
            }
        }

        private String matchAggregate(Integer colIdx, TreeSet<Integer> grps, String aggrType) {
            if (!this.keyItems.keySet().containsAll(grps)) {
                return null;
            }
            TreeMap<String, String> summaryCols = this.factItems.get(colIdx);
            if (summaryCols == null) {
                return null;
            }
            for (Map.Entry<String, String> e : summaryCols.entrySet()) {
                if (!e.getValue().equalsIgnoreCase(aggrType)) continue;
                return e.getKey();
            }
            return null;
        }
    }

    private class BaseFactTableDefinition {
        private final TreeMap<String, SummaryTableInformation> summaryTables = new TreeMap();
        private final TreeMap<Integer, TreeSet<String>> numGrpToSummary = new TreeMap();
        private final ArrayList<String> listOfAggregateTables = new ArrayList();
        private int nQueryItems = 0;
        private final TreeMap<Integer, String> keyItems = new TreeMap();
        private final TreeMap<Integer, String> factItems = new TreeMap();
        private final TreeMap<String, Integer> quickSearchMap = new TreeMap();

        private BaseFactTableDefinition() {
        }

        private void addSummaryAggregateTable(String summaryTable) {
            Set<String> existSummaryTables = this.summaryTables.keySet();
            if (existSummaryTables.contains(summaryTable)) {
                this.listOfAggregateTables.add(summaryTable);
            }
        }

        private Integer addQueryItem(String uName) {
            Integer id = this.quickSearchMap.get(uName);
            if (id == null) {
                id = XQEIntegerPool.getInteger(this.nQueryItems);
                ++this.nQueryItems;
                this.quickSearchMap.put(uName, id);
            }
            return id;
        }

        private void addKeys(String summaryTabUniqueName, TreeMap<String, String> keysMapping) {
            Integer nKey;
            TreeSet<String> sumTables;
            SummaryTableInformation sDef = this.summaryTables.get(summaryTabUniqueName);
            if (sDef == null) {
                sDef = new SummaryTableInformation();
                this.summaryTables.put(summaryTabUniqueName, sDef);
            }
            if ((sumTables = this.numGrpToSummary.get(nKey = XQEIntegerPool.getInteger(keysMapping.size()))) == null) {
                sumTables = new TreeSet();
                this.numGrpToSummary.put(nKey, sumTables);
            }
            sumTables.add(summaryTabUniqueName);
            for (Map.Entry<String, String> e : keysMapping.entrySet()) {
                Integer id = this.addQueryItem(e.getKey());
                sDef.addKey(id, e.getValue());
                this.keyItems.put(id, e.getKey());
            }
        }

        private void addFacts(String summaryTabUniqueName, TreeMap<String, TreeMap<String, String>> factsMapping, TreeSet<String> validFacts) {
            SummaryTableInformation sDef = this.summaryTables.get(summaryTabUniqueName);
            if (sDef == null) {
                sDef = new SummaryTableInformation();
                this.summaryTables.put(summaryTabUniqueName, sDef);
            }
            for (Map.Entry<String, TreeMap<String, String>> e : factsMapping.entrySet()) {
                if (!validFacts.contains(e.getKey())) continue;
                Integer id = this.addQueryItem(e.getKey());
                sDef.addFacts(id, e.getValue());
                this.factItems.put(id, e.getKey());
            }
        }
    }
}

