/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.transformation.moser.GenerateJoinGraph;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.OData.ODataUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.GraphEdge;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.IUndirectedGraph;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.UndirectedGraph;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.Timer;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqemoser.MoserMetadataConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class RQPJoinPathFinder {
    private IUndirectedGraph mGraph = null;
    private List<IMetadata> mEntitiesToJoin = null;
    private HashMap<String, IMetadata> mIdToJoin = null;
    private List<List<IMetadata>> mShortestJoinPaths = null;
    private Governors mGovernors = null;
    private PlanningEnvironment mEnvironment = null;
    private boolean mConnected;

    public boolean isConnected() {
        return this.mConnected;
    }

    public RQPJoinPathFinder(IUndirectedGraph graph, HashMap<String, IMetadata> idToJoin, List<IMetadata> qsListToJoin, Set<IMetadata> preferredQS, Governors governors, PlanningEnvironment environment) {
        this.mGovernors = governors;
        this.mEnvironment = environment;
        if (graph == null) {
            this.mGraph = environment.getMetadataConnection().getGraph(governors);
            this.mIdToJoin = environment.getMetadataConnection().getIdToJoinMap(governors);
            if (MetadataContext.hasWrappers(qsListToJoin)) {
                this.mIdToJoin = MetadataContext.addWrappers(qsListToJoin, this.mGraph, this.mIdToJoin);
            }
        } else {
            this.mGraph = graph;
            this.mIdToJoin = idToJoin;
        }
        boolean modifyJoinWeights = false;
        this.initialize(qsListToJoin, modifyJoinWeights, preferredQS);
    }

    public RQPJoinPathFinder(IUndirectedGraph graph, HashMap<String, IMetadata> idToJoin, List<IMetadata> qsListToJoin, Governors governors, PlanningEnvironment environment) {
        this(graph, idToJoin, qsListToJoin, null, governors, environment);
    }

    public RQPJoinPathFinder(List<IMetadata> qsListToJoin, Set<IMetadata> preferredQS, Governors governors, PlanningEnvironment environment) {
        this.mGraph = environment.getMetadataConnection().getGraph(governors);
        this.mIdToJoin = environment.getMetadataConnection().getIdToJoinMap(governors);
        if (MetadataContext.hasWrappers(qsListToJoin)) {
            this.mIdToJoin = MetadataContext.addWrappers(qsListToJoin, this.mGraph, this.mIdToJoin);
        }
        this.mGovernors = governors;
        this.mEnvironment = environment;
        boolean modifyJoinWeights = false;
        this.initialize(qsListToJoin, modifyJoinWeights, preferredQS);
    }

    public RQPJoinPathFinder(List<IMetadata> qsListToJoin, Governors governors, PlanningEnvironment environment) {
        this(qsListToJoin, null, governors, environment);
    }

    public RQPJoinPathFinder(List<IMetadata> qsListToJoin, PlanningEnvironment environment, Governors governors) {
        this.mGraph = environment.getMetadataConnection().getGraph(governors);
        this.mIdToJoin = environment.getMetadataConnection().getIdToJoinMap(governors);
        this.mEnvironment = environment;
        this.mGovernors = governors;
        this.mShortestJoinPaths = new ArrayList<List<IMetadata>>();
        this.mEntitiesToJoin = this.computeEntitiesToJoin(qsListToJoin);
        MetadataConnection mdConn = environment.getMetadataConnection();
        Set<IMetadata> joinPaths = GenerateJoinGraph.getJoinPaths(mdConn, (UndirectedGraph)this.mGraph, this.mEntitiesToJoin, this.mIdToJoin);
        this.mShortestJoinPaths.add(new ArrayList<IMetadata>(joinPaths));
    }

    private void initialize(List<IMetadata> qsListToJoin, boolean preferredJoin, Set<IMetadata> preferredMetadataObject) {
        this.mShortestJoinPaths = new ArrayList<List<IMetadata>>();
        this.mEntitiesToJoin = this.computeEntitiesToJoin(qsListToJoin);
        boolean addPreferred = false;
        if (addPreferred) {
            if (preferredMetadataObject == null) {
                preferredMetadataObject = new TreeSet<IMetadata>();
            }
            preferredMetadataObject.addAll(qsListToJoin);
        }
        MetadataConnection metadataConnection = this.mEnvironment.getMetadataConnection();
        if (this.mGraph.getEdges().size() == 0 && !ODataUtilities.isUsingOData(this.mEnvironment)) {
            this.checkGovernorSettings();
            return;
        }
        ArrayList<String> edgesToReset = new ArrayList<String>();
        if (preferredMetadataObject != null) {
            if (preferredJoin) {
                for (IMetadata mdObj : preferredMetadataObject) {
                    if (!(mdObj instanceof IRelationship)) continue;
                    IRelationship joinObj = (IRelationship)mdObj;
                    int weight = Weight.BothEndsInFolder.getWeight();
                    this.mGraph.setEdgeWeight(this.getNormalizedID(metadataConnection, joinObj), weight);
                    edgesToReset.add(joinObj.getV5UniqueName());
                }
            } else {
                Set<String> normalizedIDs = this.getNormalizedIDsForPreferredQuerySubjects(metadataConnection, preferredMetadataObject);
                ArrayList<GraphEdge> edges = this.mGraph.getEdges();
                HashMap<String, IMetadata> idToJoinMap = metadataConnection.getIdToJoinMap(this.mGovernors);
                for (GraphEdge e : edges) {
                    String idOfJoin = e.getEdgeId();
                    IMetadata mdObj = idToJoinMap.get(idOfJoin);
                    if (!(mdObj instanceof IRelationship)) continue;
                    IRelationship joinObj = (IRelationship)mdObj;
                    int weight = Weight.Default.getWeight();
                    String left = this.getNormalizedID(metadataConnection, joinObj.getLeftRefObject());
                    String right = this.getNormalizedID(metadataConnection, joinObj.getRightRefObject());
                    if (normalizedIDs.contains(left) && normalizedIDs.contains(right)) {
                        weight = Weight.BothEndsInFolder.getWeight();
                    } else if (normalizedIDs.contains(left) || normalizedIDs.contains(right)) {
                        weight = Weight.SingleEndInFolder.getWeight();
                    }
                    if (weight == Weight.Default.getWeight()) continue;
                    this.mGraph.setEdgeWeight(metadataConnection.getID(joinObj), weight);
                    edgesToReset.add(metadataConnection.getID(joinObj));
                }
            }
        }
        this.computeJoinPaths();
        for (String joinName : edgesToReset) {
            this.mGraph.setEdgeWeight(joinName, Weight.Default.getWeight());
        }
        this.removeUnsupportedJoinPaths();
        this.checkGovernorSettings();
    }

    private Set<String> getNormalizedIDsForPreferredQuerySubjects(MetadataConnection mdConnection, Set<IMetadata> mdObjs) {
        HashSet<String> normalizedIDs = new HashSet<String>();
        for (IMetadata mdObj : mdObjs) {
            IAccessedViaShortcut accessViaSCObj;
            normalizedIDs.add(this.getNormalizedID(mdConnection, mdObj));
            if (!(mdObj instanceof IAccessedViaShortcut) || !(accessViaSCObj = (IAccessedViaShortcut)mdObj).isAccessedViaShortcut()) continue;
            IShortcut sc = accessViaSCObj.getShortcut();
            normalizedIDs.add(mdConnection.getID(sc.getTarget()));
        }
        return normalizedIDs;
    }

    private String getNormalizedID(MetadataConnection mdConnection, IMetadata ent) {
        IAccessedViaShortcut accessViaSCObj;
        if (ent instanceof IAccessedViaShortcut && (accessViaSCObj = (IAccessedViaShortcut)ent).isAccessedViaShortcut()) {
            return mdConnection.getID(accessViaSCObj.getShortcut());
        }
        return mdConnection.getID(ent);
    }

    private void dumpRQPJoinPathFinder(List<IMetadata> qsListToJoin) {
        this.dumpMetadata("qsListToJoin", qsListToJoin);
        this.dumpMetadata("repositoryEntities", this.mEnvironment.getMetadataConnection().getEntities());
        this.dumpMetadata("repositoryJoins", this.mEnvironment.getMetadataConnection().getJoins(this.mGovernors));
        this.dumpJoinPaths();
        this.dumpFactFinderOutput();
    }

    private void dumpMetadata(String description, List<IMetadata> qsListToJoin) {
        XQEDebugLog.out.println(description);
        XQEDebugLog.out.println("=================");
        for (IMetadata m : qsListToJoin) {
            XQEDebugLog.out.println(m.getV5UniqueName());
        }
        XQEDebugLog.out.println();
        XQEDebugLog.out.println();
    }

    public List<List<IMetadata>> getAllJoinPaths() {
        return this.mShortestJoinPaths;
    }

    public int getPathWeight(List<IMetadata> path) {
        ArrayList<String> joinIds = new ArrayList<String>();
        for (int iJoin = 0; iJoin < path.size(); ++iJoin) {
            IMetadata joinObj = path.get(iJoin);
            joinIds.add(joinObj.getV5UniqueName());
        }
        return this.mGraph.getWeight(joinIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeJoinPaths() {
        MetadataConnection mdConnection = this.mEnvironment.getMetadataConnection();
        ArrayList<String> entityIdsToJoin = new ArrayList<String>();
        for (int iEnt = 0; iEnt < this.mEntitiesToJoin.size(); ++iEnt) {
            IMetadata mdObj = this.mEntitiesToJoin.get(iEnt);
            entityIdsToJoin.add(mdConnection.getID(mdObj));
        }
        int[] pathWeight = new int[1];
        ArrayList<ArrayList<String>> shortestJoinPaths = new ArrayList<ArrayList<String>>();
        Timer timer = null;
        if (UsageTrackingService.isEnabled()) {
            timer = new Timer();
            try {
                timer.start();
                this.mConnected = this.mGraph.getAllShortestPathTrees(entityIdsToJoin, shortestJoinPaths, pathWeight, false);
            }
            finally {
                timer.stop();
                this.mGraph.recordGetShortestPathTime(timer.getElapsedTimeInMilliseconds());
            }
        } else {
            this.mConnected = this.mGraph.getAllShortestPathTrees(entityIdsToJoin, shortestJoinPaths, pathWeight, false);
        }
        this.setAllJoinPaths(shortestJoinPaths, true);
    }

    protected void setAllJoinPaths(ArrayList<ArrayList<String>> shortestJoinPaths, boolean bSort) {
        for (int iPath = 0; iPath < shortestJoinPaths.size(); ++iPath) {
            List joinIdsInPath = shortestJoinPaths.get(iPath);
            if (bSort && joinIdsInPath.size() > 1) {
                Collections.sort(joinIdsInPath);
            }
            ArrayList<IMetadata> joinObjInPath = new ArrayList<IMetadata>();
            for (int iJoin = 0; iJoin < joinIdsInPath.size(); ++iJoin) {
                String joinId = (String)joinIdsInPath.get(iJoin);
                IMetadata joinObj = this.mIdToJoin.get(joinId);
                if (joinObj == null) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "computeJoinPaths():  Unable to find an IRelationship matching a join id.");
                }
                joinObjInPath.add(joinObj);
            }
            this.mShortestJoinPaths.add(joinObjInPath);
        }
    }

    private List<IMetadata> computeEntitiesToJoin(List<IMetadata> entitiesCollected) {
        ArrayList<IMetadata> entitiesToJoin = new ArrayList<IMetadata>();
        HashSet<String> tmp = new HashSet<String>();
        MetadataConnection mdConnection = this.mEnvironment.getMetadataConnection();
        for (IMetadata ent : entitiesCollected) {
            if (ent instanceof IAccessedViaShortcut) {
                String id;
                IAccessedViaShortcut accessViaSCObj = (IAccessedViaShortcut)ent;
                if (accessViaSCObj.isAccessedViaShortcut()) {
                    id = mdConnection.getID(accessViaSCObj.getShortcut());
                    if (tmp.contains(id)) continue;
                    tmp.add(id);
                    entitiesToJoin.add(accessViaSCObj.getShortcut());
                    continue;
                }
                id = mdConnection.getID(ent);
                if (tmp.contains(id)) continue;
                tmp.add(id);
                entitiesToJoin.add(ent);
                continue;
            }
            String id = mdConnection.getID(ent);
            if (tmp.contains(id)) continue;
            tmp.add(id);
            entitiesToJoin.add(ent);
        }
        return entitiesToJoin;
    }

    private void checkGovernorSettings() {
        if (null == this.mGovernors || null == this.mEnvironment) {
            return;
        }
        if (!this.mConnected) {
            if (this.mEntitiesToJoin.size() < 2) {
                return;
            }
            RQPJoinPathFinder.checkCrossProdAllowed(this.mEntitiesToJoin, this.mGovernors, this.mEnvironment);
        }
    }

    public static void checkCrossProdAllowed(List<IMetadata> mEntitiesToJoin, Governors mGovernors, PlanningEnvironment mEnvironment) {
        TreeSet<String> entNames = new TreeSet<String>();
        for (IMetadata ent : mEntitiesToJoin) {
            entNames.add(ent.getV5UniqueName());
        }
        if (entNames.size() < 2) {
            return;
        }
        if (Governors.GovernorPermission.DENY == mGovernors.getCrossProdAllowed()) {
            MetadataConnection mdConn;
            boolean doCheck;
            boolean bl = doCheck = !mEnvironment.isMultiModelForQueryEnabled() || !((RequestEnvironment)mEnvironment.getRequestEnvironment()).isGetParametersRequest();
            if (!(!doCheck || (mdConn = mEnvironment.getMetadataConnection()) instanceof MoserMetadataConnection && ((MoserMetadataConnection)mdConn).throwNoRelationship(mEntitiesToJoin, mEnvironment))) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_CrossJoinsNotPermitted, RQPJoinPathFinder.getNameListOfEntitiesToJoin(entNames));
            }
        } else if (Governors.GovernorPermission.WARN == mGovernors.getCrossProdAllowed()) {
            ExecutionEnvironment ee = (ExecutionEnvironment)mEnvironment.getExecutionEnvironment();
            String nagMsg = XQEMessages.getMessage(XQEMessageKeys.PLN_CrossJoinsDetected, XQEMessages.getCurrProductLocale());
            ee.addNag(nagMsg);
        }
    }

    private static String getNameListOfEntitiesToJoin(TreeSet<String> entNames) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = entNames.iterator();
        boolean isTopElement = true;
        while (iter.hasNext()) {
            if (!isTopElement) {
                sb.append(", ");
            } else {
                isTopElement = false;
            }
            sb.append(iter.next());
        }
        return sb.toString();
    }

    private void dumpJoinPaths() {
        String reportName = ((RequestEnvironment)this.mEnvironment.getRequestEnvironment()).getReportName();
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Testcase:  " + reportName + "\n\n");
        sb.append("Entities that were joined: \n");
        for (IMetadata ent : this.mEntitiesToJoin) {
            String entName = ent.getV5UniqueName();
            sb.append("      ");
            sb.append(entName);
            sb.append("\n");
        }
        sb.append("\n");
        int iPath = 0;
        for (List<IMetadata> path : this.mShortestJoinPaths) {
            sb.append("Path ");
            sb.append(String.valueOf(iPath++));
            sb.append("\n");
            for (IMetadata join : path) {
                String joinName = this.getName(join.getV5UniqueName());
                sb.append("     Join  \"");
                sb.append(joinName);
                sb.append("\"");
                sb.append("\n");
            }
        }
        XQEDebugLog.out.println(sb.toString());
    }

    private void dumpFactFinderOutput() {
        FactFinder factFinder = new FactFinder(this.mEnvironment);
        factFinder.addJoinPaths(this.mShortestJoinPaths);
        StringBuilder sb = new StringBuilder();
        factFinder.dump(sb, true, true);
        XQEDebugLog.out.println(sb.toString());
    }

    private String getName(String id) {
        int openSquareBracket = id.lastIndexOf(91);
        int closeSquareBracket = id.lastIndexOf(93);
        return id.substring(openSquareBracket + 1, closeSquareBracket);
    }

    private void removeUnsupportedJoinPaths() {
        ArrayList<IRelationship> unsupportedJoins = new ArrayList<IRelationship>();
        Iterator<List<IMetadata>> pathIter = this.mShortestJoinPaths.iterator();
        block0: while (pathIter.hasNext()) {
            List<IMetadata> path = pathIter.next();
            for (IMetadata pathMember : path) {
                IRelationship join = (IRelationship)pathMember;
                if (this.isSupportedByRelationalPlanning(join)) continue;
                pathIter.remove();
                if (unsupportedJoins.contains(join)) continue block0;
                unsupportedJoins.add(join);
                this.issueWarningForUnsupportedJoin(join);
                continue block0;
            }
        }
    }

    private boolean isSupportedByRelationalPlanning(IRelationship join) {
        IMetadata left = join.getLeftRefObject();
        IMetadata right = join.getRightRefObject();
        return this.isSupportedByRelationalPlanning(left) && this.isSupportedByRelationalPlanning(right);
    }

    private boolean isSupportedByRelationalPlanning(IMetadata metadataObj) {
        if (metadataObj instanceof IDimension) {
            IDimension dim = (IDimension)metadataObj;
            return dim.convertedFromDBQuerySubject();
        }
        return true;
    }

    private void issueWarningForUnsupportedJoin(IRelationship unsupportedJoin) {
        IMetadata modelDimension = null;
        modelDimension = !this.isSupportedByRelationalPlanning(unsupportedJoin.getLeftRefObject()) ? unsupportedJoin.getLeftRefObject() : unsupportedJoin.getRightRefObject();
        ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.PLN_UnsupportedJoinByRelationalPlanning, unsupportedJoin.getV5UniqueName(), modelDimension.getV5UniqueName());
        this.mEnvironment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
    }

    public static enum Weight {
        Mandatory(2),
        Shortcut(2),
        SingleEndInFolder(7),
        BothEndsInFolder(3),
        Default(17),
        Unwanted(888);

        private int mWeight;

        private Weight(int assignedWeight) {
            this.mWeight = assignedWeight;
        }

        public int getWeight() {
            return this.mWeight;
        }
    }
}

