/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPPathInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class RQPJoinPathSelector {
    private static final String NEWLINE = "\n";
    private boolean doRankingBasedOnNumberOfFacts = true;
    private TreeSet<RQPPathInfo> rankedJoinPaths = null;

    public void doNotRankBasedOnNumberOfFact() {
        this.doRankingBasedOnNumberOfFacts = false;
    }

    public List<IMetadata> selectBestJoinPath(List<List<IMetadata>> joinPaths) {
        if (joinPaths.size() == 0) {
            return null;
        }
        int bestPathIndex = 0;
        List<List<IMetadata>> rankedJoinPathsList = this.rankJoinPaths(joinPaths);
        return rankedJoinPathsList.get(bestPathIndex);
    }

    public List<List<IMetadata>> getAllRankedJoinPaths(List<List<IMetadata>> joinPaths) {
        if (joinPaths.size() == 0) {
            return null;
        }
        return this.rankJoinPaths(joinPaths);
    }

    private List<List<IMetadata>> rankJoinPaths(List<List<IMetadata>> joinPaths) {
        this.rankedJoinPaths = new TreeSet();
        for (List<IMetadata> path : joinPaths) {
            RQPPathInfo pathInfo = new RQPPathInfo(path, this.doRankingBasedOnNumberOfFacts);
            this.rankedJoinPaths.add(pathInfo);
        }
        ArrayList<List<IMetadata>> rankedJoinPathsList = new ArrayList<List<IMetadata>>();
        for (RQPPathInfo pInfo : this.rankedJoinPaths) {
            rankedJoinPathsList.add(pInfo.mPath);
        }
        return rankedJoinPathsList;
    }

    public ResponseMessage getRankedJoinPathWarning(String qsName) {
        if (this.rankedJoinPaths.size() <= 1) {
            return null;
        }
        int numFacts = -1;
        boolean differentNumberOfFacts = false;
        String bestPath = null;
        StringBuilder sb = new StringBuilder();
        for (RQPPathInfo pathInfo : this.rankedJoinPaths) {
            if (numFacts == -1) {
                bestPath = NEWLINE + pathInfo.mPath;
                numFacts = pathInfo.getNumberFacts();
            }
            differentNumberOfFacts = numFacts != pathInfo.getNumberFacts();
            sb.append(NEWLINE);
            sb.append(pathInfo.mPath.toString());
        }
        if (this.doRankingBasedOnNumberOfFacts && differentNumberOfFacts) {
            if (qsName != null) {
                return new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.WRN_UseQSJoinPathBasedOnNumFactsAndAlphabeticallyFirst, qsName, bestPath, sb.toString());
            }
            return new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.WRN_UseJoinPathBasedOnNumFactsAndAlphabeticallyFirst, bestPath, sb.toString());
        }
        if (qsName != null) {
            return new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.WRN_UseQSJoinPathBasedOnAndAlphabeticallyFirst, qsName, bestPath, sb.toString());
        }
        return new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.WRN_UseJoinPathBasedOnAndAlphabeticallyFirst, bestPath, sb.toString());
    }
}

