/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.metadataContext;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IColumnDependency;
import com.cognos.xqe.metadata.IDeterminant;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.IProcParameter;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.AbstractDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.parameters.SimpleParameterValueItem;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.IMetadataContextManager;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.IUndirectedGraph;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;

public final class MetadataContext {
    private final String uOwnerName;
    private final int id;
    private final Parameters parameters = new Parameters();
    private final HashMap<String, QuerySubjectWrapper> wrappedQuerySubject = new HashMap();
    private final ArrayList<RelationshipWrapper> wrappedRelationship = new ArrayList();
    private final AtomicInteger idCount = new AtomicInteger(0);

    public String getName() {
        return this.uOwnerName;
    }

    private static int compareInt(int a, int b) {
        if (a == b) {
            return 0;
        }
        if (a > b) {
            return 1;
        }
        return -1;
    }

    protected MetadataContext(String n, int d, JSONObject jObj) {
        this.uOwnerName = n;
        this.id = d;
        Set keys = jObj.keySet();
        for (Object k : keys) {
            JSONObject v;
            Parameter parameter = this.createParameter((String)k, v = (JSONObject)jObj.get(k));
            if (parameter == null) continue;
            this.parameters.addParameter((String)k, parameter);
        }
    }

    public List<Parameter> getParameters() {
        ArrayList<Parameter> rt = new ArrayList<Parameter>();
        rt.addAll(this.parameters.values());
        return rt;
    }

    public boolean compatibleWithPrimaryMetadataContext(MetadataContext pc) {
        TreeMap<String, TreeSet<IValue>> checkparamInThis = new TreeMap<String, TreeSet<IValue>>();
        ArrayList<Parameter> lstThis = new ArrayList<Parameter>(this.getParameters());
        for (Parameter p : lstThis) {
            ParameterWrapper pr = (ParameterWrapper)p;
            if (!pr.checkPrimarySecondary) continue;
            checkparamInThis.put(pr.getName(), new TreeSet<IValue>(Arrays.asList(pr.getParameterValues())));
        }
        if (checkparamInThis.isEmpty()) {
            return true;
        }
        if (pc == null) {
            return false;
        }
        ArrayList<Parameter> lstPC = new ArrayList<Parameter>(pc.getParameters());
        boolean b = false;
        for (Parameter p : lstPC) {
            ParameterWrapper pr = (ParameterWrapper)p;
            if (!pr.checkPrimarySecondary) continue;
            b = true;
            TreeSet thisV = (TreeSet)checkparamInThis.get(pr.getName());
            if (thisV == null) {
                return false;
            }
            TreeSet<IValue> pcV = new TreeSet<IValue>(Arrays.asList(pr.getParameterValues()));
            if (thisV.equals(pcV)) continue;
            return false;
        }
        return b;
    }

    private String getMCName() {
        return "_MC_" + this.id;
    }

    protected Parameter createParameter(String n, JSONObject jObj) {
        if (n == null || jObj == null) {
            return null;
        }
        String v = (String)jObj.get((Object)"value");
        if (v == null) {
            return null;
        }
        boolean b = false;
        String f = (String)jObj.get((Object)"checkPS");
        if (f != null && f.equals("true")) {
            b = true;
        }
        ParameterWrapper p = new ParameterWrapper(n, b);
        p.setDataType(DataTypeFactory.getStringType());
        ((Parameter)p).addValue(v);
        return p;
    }

    public String toString() {
        return this.uOwnerName + this.getMCName();
    }

    public static MetadataContext getMetadataContextForDynamicMetadata(IMetadata meta) {
        IDimension dim;
        if (meta instanceof QuerySubjectWrapper) {
            return ((QuerySubjectWrapper)meta).getMetadataContext();
        }
        if (meta instanceof QueryItemWrapper) {
            return ((QueryItemWrapper)meta).getOuterMetadataContext();
        }
        if (meta instanceof RelationshipWrapper) {
            return ((RelationshipWrapper)meta).getOuterMetadataContext();
        }
        IHierarchy hier = V5BoundModelIdentifier.getHierarchyFromIMetadata(meta);
        if (hier != null && (dim = hier.getDimension()) instanceof AbstractDimensionWrapper && !dim.isMeasuresDimension()) {
            return ((AbstractDimensionWrapper)dim).getMetadataContext();
        }
        return null;
    }

    public static boolean isQSforQIName(IMetadata qs, String qiName) {
        if (!(qs instanceof QuerySubjectWrapper)) {
            return false;
        }
        QuerySubjectWrapper theQS = (QuerySubjectWrapper)qs;
        return theQS.queryItemMap.containsKey(qiName);
    }

    public static void flagMetadataObjectIfRequired(IMetadata meta, IXQEQueryNode theNode) {
        if (meta instanceof ILevel && !(meta instanceof LevelWrapper)) {
            MetadataContext context;
            IMetadataContextManager contextMgr;
            IDimension dim = ((ILevel)meta).getDimension();
            String desc = dim.getDescription();
            MetadataConnection conn = dim.getConnection();
            if (conn != null && (contextMgr = conn.getMetadataContextManager()) != null && (context = contextMgr.generateContextIfRequired(dim.getV5UniqueName(), desc)) != null) {
                context.setMetadataContextOnV5MultiPartIdentifier(theNode);
            }
            return;
        }
        if (meta instanceof LevelWrapper) {
            meta = ((LevelWrapper)meta).getDimension();
        }
        if (meta instanceof AbstractDimensionWrapper) {
            MetadataContext context = ((AbstractDimensionWrapper)meta).getMetadataContext();
            if (context != null) {
                context.setMetadataContextOnV5MultiPartIdentifier(theNode);
            }
        } else if (meta instanceof QuerySubjectWrapper) {
            MetadataContext context = ((QuerySubjectWrapper)meta).getMetadataContext();
            context.setMetadataContextOnV5MultiPartIdentifier(theNode);
        } else if (meta instanceof RelationshipWrapper) {
            ((RelationshipWrapper)meta).setMetadataContextOnV5MultiPartIdentifier(theNode);
        }
    }

    public void setMetadataContextOnV5MultiPartIdentifier(IXQEQueryNode theNode) {
        IXQEQueryNode[] objs;
        for (IXQEQueryNode obj : objs = theNode.getDescendantsOfType(201030, true)) {
            obj.setPropertyValue("metadataContext", this);
        }
    }

    public static List<Parameter> getLocalParameters(IQuerySubject qs) {
        if (qs instanceof QuerySubjectWrapper) {
            return ((QuerySubjectWrapper)qs).getMetadataContext().getParameters();
        }
        return new ArrayList<Parameter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMetadata> getRelationships(IMetadata qs) {
        ArrayList<IMetadata> rt = new ArrayList<IMetadata>();
        if (qs instanceof QuerySubjectWrapper) {
            MetadataContext c;
            MetadataContext metadataContext = c = ((QuerySubjectWrapper)qs).getMetadataContext();
            synchronized (metadataContext) {
                rt.addAll(c.wrappedRelationship);
            }
        }
        return rt;
    }

    public IMetadata wrapMetadata(IMetadata metadata) {
        if (metadata.getObjectType() != MetadataType.QUERY_ITEM) {
            return metadata;
        }
        IQuerySubject qs = ((IQueryItem)metadata).getQuerySubject();
        if (qs == null) {
            return metadata;
        }
        return this.wrapIntoQuerySubject(qs, metadata);
    }

    private synchronized IMetadata wrapIntoQuerySubject(IQuerySubject qs, IMetadata qi) {
        QuerySubjectWrapper qsWrapper = this.wrappedQuerySubject.get(qs.getV5UniqueName());
        if (qsWrapper == null) {
            qsWrapper = new QuerySubjectWrapper(qs);
            this.wrappedQuerySubject.put(qs.getV5UniqueName(), qsWrapper);
            List<IMetadata> joins = qs.getConnection().getRelationships();
            for (IMetadata jn : joins) {
                QuerySubjectWrapper existQS;
                if (!(jn instanceof IRelationship)) continue;
                IRelationship join = (IRelationship)jn;
                IMetadata leftObj = join.getLeftRefObject();
                IMetadata rightObj = join.getRightRefObject();
                if (qs.getID().equals(leftObj.getID())) {
                    this.wrappedRelationship.add(new RelationshipWrapper(qsWrapper, rightObj, join));
                    existQS = this.wrappedQuerySubject.get(rightObj.getID());
                    if (existQS == null) continue;
                    this.wrappedRelationship.add(new RelationshipWrapper(qsWrapper, existQS, join));
                    continue;
                }
                if (!qs.getID().equals(rightObj.getID())) continue;
                this.wrappedRelationship.add(new RelationshipWrapper(leftObj, qsWrapper, join));
                existQS = this.wrappedQuerySubject.get(leftObj.getID());
                if (existQS == null) continue;
                this.wrappedRelationship.add(new RelationshipWrapper(existQS, qsWrapper, join));
            }
        }
        return qsWrapper.getQueryItemWrapper(qi.getV5UniqueName());
    }

    public static boolean hasWrappers(List<IMetadata> qsListToJoin) {
        for (IMetadata qs : qsListToJoin) {
            if (!MetadataContext.isMetadataContextWrapper(qs)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMetadataContextWrapper(IMetadata meta) {
        if (meta instanceof QuerySubjectWrapper || meta instanceof QueryItemWrapper) {
            return true;
        }
        IDimension dim = null;
        if (meta != null) {
            MetadataType objectType = meta.getObjectType();
            switch (objectType) {
                case HIERARCHY: {
                    dim = ((IHierarchy)meta).getDimension();
                    break;
                }
                case LEVEL: {
                    dim = ((ILevel)meta).getHierarchy().getDimension();
                    break;
                }
                case MEMBER: {
                    ILevel level = ((IMember)meta).getLevel();
                    if (level == null) break;
                    dim = level.getHierarchy().getDimension();
                    break;
                }
                case DIMENSION: {
                    dim = (IDimension)meta;
                    break;
                }
                case QUERY_ITEM: {
                    if (!(meta instanceof IProperty)) break;
                    dim = ((IProperty)meta).getHierarchy().getDimension();
                    break;
                }
            }
        }
        if (dim instanceof AbstractDimensionWrapper) {
            return ((AbstractDimensionWrapper)dim).getMetadataContext() != null;
        }
        return false;
    }

    public static HashMap<String, IMetadata> addWrappers(List<IMetadata> qsListToJoin, IUndirectedGraph graph, HashMap<String, IMetadata> mp) {
        HashMap<String, MetadataContext> requiredMetadataContexts = new HashMap<String, MetadataContext>();
        for (IMetadata qs : qsListToJoin) {
            if (!(qs instanceof QuerySubjectWrapper)) continue;
            QuerySubjectWrapper wrapper = (QuerySubjectWrapper)qs;
            MetadataContext mc = wrapper.getMetadataContext();
            requiredMetadataContexts.put(mc.getMCName(), mc);
        }
        HashMap<String, IMetadata> newMap = new HashMap<String, IMetadata>(mp);
        for (MetadataContext mc : requiredMetadataContexts.values()) {
            mc.addWrappers(graph, newMap);
        }
        return newMap;
    }

    private synchronized void addWrappers(IUndirectedGraph graph, HashMap<String, IMetadata> mp) {
        for (QuerySubjectWrapper q : this.wrappedQuerySubject.values()) {
            graph.addNode(q.getID());
        }
        for (RelationshipWrapper r : this.wrappedRelationship) {
            int weight = RQPJoinPathFinder.Weight.Default.getWeight();
            graph.addEdge(r.getV5UniqueName(), r.getLeftRefObjectId(), r.getRightRefObjectId(), weight, false);
            mp.put(r.getV5UniqueName(), r);
        }
    }

    private final class ParameterWrapper
    extends Parameter {
        private final ParameterValues localValues;
        private final boolean checkPrimarySecondary;

        private ParameterWrapper(String aParameterName, boolean b) {
            super(aParameterName);
            this.localValues = new ParameterValues(this);
            this.checkPrimarySecondary = b;
        }

        @Override
        public void addValue(String value) {
            this.localValues.addValue(value);
        }

        @Override
        public IValue[] getParameterValues() {
            IValue[] values = new Value[this.localValues.size()];
            for (int i = 0; i < values.length; ++i) {
                SimpleParameterValueItem valueItem = (SimpleParameterValueItem)this.localValues.get(i);
                values[i] = valueItem.getValueFromInternalValue();
            }
            return values;
        }
    }

    private final class RelationshipWrapper
    implements IRelationship {
        private final IRelationship srcRelationship;
        private final IMetadata left;
        private final IMetadata right;
        private final String idString;
        private final int uId;

        private RelationshipWrapper(IMetadata l, IMetadata r, IRelationship src) {
            this.uId = MetadataContext.this.idCount.getAndIncrement();
            this.left = l;
            this.right = r;
            this.srcRelationship = src;
            this.idString = "RelationshipWrapper" + MetadataContext.this.getMCName() + this.left.getID() + "_to_" + this.right.getID();
        }

        public String toString() {
            return this.idString;
        }

        private MetadataContext getOuterMetadataContext() {
            return MetadataContext.this;
        }

        @Override
        public int compareTo(Object o) {
            MetadataContext otherMc;
            if (this.equals(o)) {
                return 0;
            }
            if (!(o instanceof RelationshipWrapper)) {
                return -1;
            }
            RelationshipWrapper other = (RelationshipWrapper)o;
            MetadataContext thisMc = this.getOuterMetadataContext();
            if (thisMc == (otherMc = other.getOuterMetadataContext())) {
                return MetadataContext.compareInt(this.uId, other.uId);
            }
            return MetadataContext.compareInt(thisMc.id, otherMc.id);
        }

        @Override
        public String getUniqueName() {
            return this.srcRelationship.getUniqueName();
        }

        @Override
        public Set<String> getAvailableProperties() {
            return this.srcRelationship.getAvailableProperties();
        }

        @Override
        public Object getProperty(String propertyName) {
            if ("metadataContext".equals(propertyName)) {
                return MetadataContext.this;
            }
            return this.srcRelationship.getProperty(propertyName);
        }

        @Override
        public IDataType getDataType() {
            return this.srcRelationship.getDataType();
        }

        @Override
        public MetadataConnection getConnection() {
            return this.srcRelationship.getConnection();
        }

        @Override
        public IMetadata getParentObject() {
            return this.srcRelationship.getParentObject();
        }

        @Override
        public IMetadata getLeftRefObject() {
            return this.left;
        }

        @Override
        public IMetadata getRightRefObject() {
            return this.right;
        }

        @Override
        public String getLeftRefObjectId() {
            return this.left.getID();
        }

        @Override
        public List<IMetadata> getChildMetadataObjects() {
            return this.srcRelationship.getChildMetadataObjects();
        }

        @Override
        public String getRightRefObjectId() {
            return this.right.getID();
        }

        @Override
        public MetadataType getObjectType() {
            return this.srcRelationship.getObjectType();
        }

        @Override
        public String getExpression() {
            return this.srcRelationship.getExpression();
        }

        @Override
        public Enum<IRelationship.Cardinality> getLeftCardinality() {
            return this.srcRelationship.getLeftCardinality();
        }

        @Override
        public Enum<IRelationship.Cardinality> getRightCardinality() {
            return this.srcRelationship.getRightCardinality();
        }

        @Override
        public String getV5UniqueName() {
            return this.getID();
        }

        @Override
        public boolean isMany(Enum<IRelationship.Cardinality> card) {
            return this.srcRelationship.isMany(card);
        }

        @Override
        public boolean isOne(Enum<IRelationship.Cardinality> card) {
            return this.srcRelationship.isOne(card);
        }

        @Override
        public String getID() {
            return this.idString;
        }

        @Override
        public boolean isDummy() {
            return this.srcRelationship.isDummy();
        }

        @Override
        public boolean hasChildMetadataObjects() {
            return this.srcRelationship.hasChildMetadataObjects();
        }

        @Override
        public String getName() {
            return this.getID();
        }

        @Override
        public IRelationship.JoinFilterType getJoinFilterType() {
            return this.srcRelationship.getJoinFilterType();
        }

        @Override
        public String getDescription() {
            return this.srcRelationship.getDescription();
        }

        @Override
        public String getScreenTip() {
            return this.srcRelationship.getScreenTip();
        }

        @Override
        public String getUniqueID() {
            return this.getID();
        }

        @Override
        public String getCaption() {
            return this.srcRelationship.getCaption();
        }

        @Override
        public BeanPropertySupport getBeanPropertySupport() {
            return this.srcRelationship.getBeanPropertySupport();
        }

        @Override
        public boolean isDMR() {
            return this.srcRelationship.isDMR();
        }

        private MetadataContext getMetadataContext() {
            return MetadataContext.this;
        }

        private void setMetadataContextOnV5MultiPartIdentifier(IXQEQueryNode theNode) {
            IXQEQueryNode[] objs;
            for (IXQEQueryNode obj : objs = theNode.getDescendantsOfType(201030, true)) {
                V5MultiPartIdentifier identifier = (V5MultiPartIdentifier)obj;
                String[] parts = identifier.getNameParts();
                if (parts.length <= 2) continue;
                String uName = UniqueNameGenerator.createUniqueName(parts[0], parts[1]);
                if (this.left instanceof QuerySubjectWrapper && uName.equals(((QuerySubjectWrapper)this.left).srcQuerySubject.getID())) {
                    obj.setPropertyValue("metadataContext", this.getMetadataContext());
                }
                if (!(this.right instanceof QuerySubjectWrapper) || !uName.equals(((QuerySubjectWrapper)this.right).srcQuerySubject.getID())) continue;
                obj.setPropertyValue("metadataContext", this.getMetadataContext());
            }
        }

        @Override
        public boolean isMFW() {
            return this.srcRelationship.isMFW();
        }

        @Override
        public String getFJOAdvancedProperty() {
            return this.srcRelationship.getFJOAdvancedProperty();
        }

        @Override
        public IMetadata getParentObjectSkipFolders() {
            return this.srcRelationship.getParentObjectSkipFolders();
        }

        @Override
        public void setParentMetadataObject(IMetadata parent) {
        }

        @Override
        public boolean isAccessible() {
            return this.srcRelationship.isAccessible();
        }

        @Override
        public IMultiRequestHandle[] getHandles() {
            return this.srcRelationship.getHandles();
        }

        @Override
        public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
            return this.srcRelationship.getDescendantMetadataObjectsSkipFolders();
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isVisible(boolean inShortcut) {
            return false;
        }
    }

    private final class QueryItemWrapper
    implements IQueryItem {
        private final QuerySubjectWrapper qsWrapper;
        private final IQueryItem srcQueryItem;
        private String idString;
        private final int uId;

        private QueryItemWrapper(QuerySubjectWrapper qsOwner, IQueryItem qi) {
            this.uId = MetadataContext.this.idCount.getAndIncrement();
            this.qsWrapper = qsOwner;
            this.srcQueryItem = qi;
        }

        public String toString() {
            return this.getID();
        }

        private MetadataContext getOuterMetadataContext() {
            return MetadataContext.this;
        }

        @Override
        public int compareTo(Object o) {
            MetadataContext otherMc;
            if (this.equals(o)) {
                return 0;
            }
            if (!(o instanceof QueryItemWrapper)) {
                return -1;
            }
            QueryItemWrapper other = (QueryItemWrapper)o;
            MetadataContext thisMc = this.getOuterMetadataContext();
            if (thisMc == (otherMc = other.getOuterMetadataContext())) {
                return MetadataContext.compareInt(this.uId, other.uId);
            }
            return MetadataContext.compareInt(thisMc.id, otherMc.id);
        }

        @Override
        public String getUniqueName() {
            return this.srcQueryItem.getUniqueName();
        }

        @Override
        public Set<String> getAvailableProperties() {
            return this.srcQueryItem.getAvailableProperties();
        }

        @Override
        public String getUsage() {
            return this.srcQueryItem.getUsage();
        }

        @Override
        public String getExpression() {
            return this.srcQueryItem.getExpression();
        }

        @Override
        public Object getProperty(String propertyName) {
            if ("metadataContext".equals(propertyName)) {
                return MetadataContext.this;
            }
            return this.srcQueryItem.getProperty(propertyName);
        }

        @Override
        public ILevel getLevel() {
            return this.srcQueryItem.getLevel();
        }

        @Override
        public IDataType getDataType() {
            return this.srcQueryItem.getDataType();
        }

        @Override
        public IHierarchy getHierarchy() {
            return this.srcQueryItem.getHierarchy();
        }

        @Override
        public MetadataConnection getConnection() {
            return this.srcQueryItem.getConnection();
        }

        @Override
        public boolean isFact() {
            return this.srcQueryItem.isFact();
        }

        @Override
        public IMetadata getParentObject() {
            return this.qsWrapper;
        }

        @Override
        public IQuerySubject getQuerySubject() {
            return this.qsWrapper;
        }

        @Override
        public String getRegularAggregate() {
            return this.srcQueryItem.getRegularAggregate();
        }

        @Override
        public String getSemiAggregate() {
            return this.srcQueryItem.getSemiAggregate();
        }

        @Override
        public List<IMetadata> getChildMetadataObjects() {
            return this.srcQueryItem.getChildMetadataObjects();
        }

        @Override
        public boolean isNullable() {
            return this.srcQueryItem.isNullable();
        }

        @Override
        public int getDatatypeSize() {
            return this.srcQueryItem.getDatatypeSize();
        }

        @Override
        public int getDatatypePrecision() {
            return this.srcQueryItem.getDatatypePrecision();
        }

        @Override
        public MetadataType getObjectType() {
            return this.srcQueryItem.getObjectType();
        }

        @Override
        public int getDatatypeScale() {
            return this.srcQueryItem.getDatatypeScale();
        }

        @Override
        public String getDatatypeName() {
            return this.srcQueryItem.getDatatypeName();
        }

        @Override
        public String getFormat() {
            return this.srcQueryItem.getFormat();
        }

        @Override
        public String getV5UniqueName() {
            return this.getID();
        }

        @Override
        public String getCurrency() {
            return this.srcQueryItem.getCurrency();
        }

        @Override
        public boolean isProperty() {
            return this.srcQueryItem.isProperty();
        }

        @Override
        public boolean isBusinessKey() {
            return this.srcQueryItem.isBusinessKey();
        }

        @Override
        public synchronized String getID() {
            if (this.idString != null) {
                return this.idString;
            }
            this.idString = UniqueNameGenerator.appendUniqueName(this.qsWrapper.getV5UniqueName(), this.srcQueryItem.getName());
            return this.idString;
        }

        @Override
        public String getExpressionOrExternalName() {
            return this.srcQueryItem.getExpressionOrExternalName();
        }

        @Override
        public boolean hasChildMetadataObjects() {
            return this.srcQueryItem.hasChildMetadataObjects();
        }

        @Override
        public String getName() {
            return this.srcQueryItem.getName();
        }

        @Override
        public String getDescription() {
            return this.srcQueryItem.getDescription();
        }

        @Override
        public String getScreenTip() {
            return this.srcQueryItem.getScreenTip();
        }

        @Override
        public String getUniqueID() {
            return this.srcQueryItem.getUniqueID();
        }

        @Override
        public String getCaption() {
            return this.srcQueryItem.getCaption();
        }

        @Override
        public BeanPropertySupport getBeanPropertySupport() {
            return this.srcQueryItem.getBeanPropertySupport();
        }

        @Override
        public boolean isDMR() {
            return this.srcQueryItem.isDMR();
        }

        @Override
        public boolean isMFW() {
            return this.srcQueryItem.isMFW();
        }

        @Override
        public boolean isAccessible() {
            return this.srcQueryItem.isAccessible();
        }

        @Override
        public IMultiRequestHandle[] getHandles() {
            return this.srcQueryItem.getHandles();
        }

        @Override
        public IMetadata getParentObjectSkipFolders() {
            return this.srcQueryItem.getParentObjectSkipFolders();
        }

        @Override
        public void setParentMetadataObject(IMetadata parent) {
        }

        @Override
        public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
            return this.srcQueryItem.getDescendantMetadataObjectsSkipFolders();
        }

        @Override
        public IFacet getFacet() {
            return this.srcQueryItem.getFacet();
        }

        @Override
        public boolean isVisible(boolean inShortcut) {
            return false;
        }

        @Override
        public boolean isHidden() {
            return false;
        }
    }

    private final class QuerySubjectWrapper
    implements IAccessedViaShortcut,
    IQuerySubject {
        private final IQuerySubject srcQuerySubject;
        private final List<String> queryItemUNames = new ArrayList<String>();
        private final HashMap<String, QueryItemWrapper> queryItemMap = new HashMap();
        private IXQEQueryNode sqlASTCache = null;
        private String idString;
        private String nameString;
        private final int uId;

        public String toString() {
            return this.nameString;
        }

        private QuerySubjectWrapper(IQuerySubject qs) {
            this.uId = MetadataContext.this.idCount.getAndIncrement();
            this.srcQuerySubject = qs;
            this.nameString = qs.getName() + MetadataContext.this.getMCName();
            List<IMetadata> srcQIs = this.srcQuerySubject.getQueryItemsAndMeasures();
            for (IMetadata qi : srcQIs) {
                String qiUName = qi.getV5UniqueName();
                this.queryItemUNames.add(qiUName);
                this.queryItemMap.put(qiUName, new QueryItemWrapper(this, (IQueryItem)qi));
            }
        }

        private MetadataContext getMetadataContext() {
            return MetadataContext.this;
        }

        private IMetadata getQueryItemWrapper(String uQIName) {
            return this.queryItemMap.get(uQIName);
        }

        @Override
        public MetadataConnection getConnection() {
            return this.srcQuerySubject.getConnection();
        }

        @Override
        public boolean isAccessible() {
            return this.srcQuerySubject.isAccessible();
        }

        @Override
        public void setParentMetadataObject(IMetadata parent) {
        }

        @Override
        public IMetadata getParentObjectSkipFolders() {
            return this.srcQuerySubject.getParentObjectSkipFolders();
        }

        @Override
        public boolean isMFW() {
            return this.srcQuerySubject.isMFW();
        }

        @Override
        public double getOrderOfMagnitude() {
            return this.srcQuerySubject.getOrderOfMagnitude();
        }

        @Override
        public List<IProcParameter> getStoredProcArgs() {
            return this.srcQuerySubject.getStoredProcArgs();
        }

        @Override
        public IMultiRequestHandle[] getHandles() {
            return this.srcQuerySubject.getHandles();
        }

        @Override
        public boolean getUseInJoinPath() {
            return this.srcQuerySubject.getUseInJoinPath();
        }

        @Override
        public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
            return this.srcQuerySubject.getDescendantMetadataObjectsSkipFolders();
        }

        @Override
        public boolean isAccessedViaShortcut() {
            return ((IAccessedViaShortcut)((Object)this.srcQuerySubject)).isAccessedViaShortcut();
        }

        @Override
        public IShortcut getShortcut() {
            return ((IAccessedViaShortcut)((Object)this.srcQuerySubject)).getShortcut();
        }

        @Override
        public void setShortcut(IShortcut scObj) {
            ((IAccessedViaShortcut)((Object)this.srcQuerySubject)).setShortcut(scObj);
        }

        private MetadataContext getOuterMetadataContext() {
            return MetadataContext.this;
        }

        @Override
        public int compareTo(Object o) {
            MetadataContext otherMc;
            if (this.equals(o)) {
                return 0;
            }
            if (!(o instanceof QuerySubjectWrapper)) {
                return -1;
            }
            QuerySubjectWrapper other = (QuerySubjectWrapper)o;
            MetadataContext thisMc = this.getOuterMetadataContext();
            if (thisMc == (otherMc = other.getOuterMetadataContext())) {
                return MetadataContext.compareInt(this.uId, other.uId);
            }
            return MetadataContext.compareInt(thisMc.id, otherMc.id);
        }

        @Override
        public String getUniqueName() {
            return this.srcQuerySubject.getUniqueName();
        }

        @Override
        public Set<String> getAvailableProperties() {
            return this.srcQuerySubject.getAvailableProperties();
        }

        @Override
        public Object getProperty(String propertyName) {
            if ("metadataContext".equals(propertyName)) {
                return MetadataContext.this;
            }
            return this.srcQuerySubject.getProperty(propertyName);
        }

        @Override
        public IDataType getDataType() {
            return this.srcQuerySubject.getDataType();
        }

        @Override
        public IMetadata getParentObject() {
            return this.srcQuerySubject.getParentObject();
        }

        @Override
        public String getDefinitionType() {
            return this.srcQuerySubject.getDefinitionType();
        }

        @Override
        public String getGeneratedSQLOption() {
            return this.srcQuerySubject.getGeneratedSQLOption();
        }

        @Override
        public List<IMetadata> getChildMetadataObjects() {
            ArrayList<IMetadata> children = new ArrayList<IMetadata>();
            children.addAll(this.queryItemMap.values());
            return children;
        }

        @Override
        public List<IModelDataSource> getDataSources() {
            return this.srcQuerySubject.getDataSources();
        }

        @Override
        public List<IEmbeddedFilter> getFilters() {
            return this.srcQuerySubject.getFilters();
        }

        @Override
        public MetadataType getObjectType() {
            return this.srcQuerySubject.getObjectType();
        }

        @Override
        public List<IEmbeddedFilter> getPreviewFilters() {
            return this.srcQuerySubject.getPreviewFilters();
        }

        @Override
        public List<IEmbeddedFilter> getSecurityFilters() {
            return this.srcQuerySubject.getSecurityFilters();
        }

        @Override
        public String getV5UniqueName() {
            return this.getID();
        }

        @Override
        public List<IDeterminant> getDeterminants() {
            return this.srcQuerySubject.getDeterminants();
        }

        @Override
        public List<IColumnDependency> getColumnDependencies() {
            return this.srcQuerySubject.getColumnDependencies();
        }

        @Override
        public List<IMetadata> getQueryItemsAndMeasures() {
            ArrayList<IMetadata> rt = new ArrayList<IMetadata>();
            for (String s : this.queryItemUNames) {
                rt.add(this.queryItemMap.get(s));
            }
            return rt;
        }

        @Override
        public synchronized String getID() {
            if (this.idString != null) {
                return this.idString;
            }
            try {
                String[] parts = UniqueNameParser.parse(this.srcQuerySubject.getV5UniqueName(), -1);
                this.idString = UniqueNameGenerator.createSingleNamePart(parts[0]) + "." + UniqueNameGenerator.createSingleNamePart(parts[1] + MetadataContext.this.getMCName());
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException(e);
            }
            return this.idString;
        }

        @Override
        public boolean hasUniqueIndex() {
            return this.srcQuerySubject.hasUniqueIndex();
        }

        @Override
        public boolean hasChildMetadataObjects() {
            return this.srcQuerySubject.hasChildMetadataObjects();
        }

        @Override
        public String getSql() {
            return this.srcQuerySubject.getSql();
        }

        @Override
        public String getName() {
            return this.nameString;
        }

        @Override
        public IQuerySubject[] getQuerySubjectRefs() {
            return this.srcQuerySubject.getQuerySubjectRefs();
        }

        @Override
        public String getDescription() {
            return this.srcQuerySubject.getDescription();
        }

        @Override
        public String getScreenTip() {
            return this.srcQuerySubject.getScreenTip();
        }

        @Override
        public String getUniqueID() {
            return this.srcQuerySubject.getUniqueID();
        }

        @Override
        public synchronized IXQEQueryNode generateSQLAST(PlanningEnvironment environment, IXQEQueryNode ownerNode, IQuerySubject querySubject) throws ParseException {
            if (this.sqlASTCache == null) {
                this.sqlASTCache = this.srcQuerySubject.generateSQLAST(environment, ownerNode, this);
            }
            return this.sqlASTCache;
        }

        @Override
        public String getCaption() {
            return this.srcQuerySubject.getCaption();
        }

        @Override
        public BeanPropertySupport getBeanPropertySupport() {
            return this.srcQuerySubject.getBeanPropertySupport();
        }

        @Override
        public IQuerySubject.QuerySubjectTypeEnum getQuerySubjectType() {
            return this.srcQuerySubject.getQuerySubjectType();
        }

        @Override
        public IQuerySubject.QuerySubjectUsageEnum getQuerySubjectUsage() {
            return this.srcQuerySubject.getQuerySubjectUsage();
        }

        @Override
        public boolean isDMR() {
            return this.srcQuerySubject.isDMR();
        }

        @Override
        public IQuerySubject.QuerySubjectUseLocalCacheEnum getQuerySubjectUseLocalCache() {
            return this.srcQuerySubject.getQuerySubjectUseLocalCache();
        }

        @Override
        public String getQuerySubjectDataCacheExpiry() {
            return this.srcQuerySubject.getQuerySubjectDataCacheExpiry();
        }

        @Override
        public Boolean getInvolvedInJoins() {
            return this.srcQuerySubject.getInvolvedInJoins();
        }

        @Override
        public void setInvolvedInJoins(boolean b) {
            this.srcQuerySubject.setInvolvedInJoins(b);
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isVisible(boolean inShortcut) {
            return false;
        }

        @Override
        public IQuerySubject.SelectListControl getSelectListControl() {
            return IQuerySubject.SelectListControl.AUTOMATIC;
        }
    }
}

