/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph;

import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.GraphEdge;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.GraphEdgeListNode;
import java.util.ArrayList;

public class GraphEdgeList {
    private ArrayList<GraphEdgeListNode> mQNodes = null;
    private int mHead = -1;
    private int mTail = -1;

    GraphEdgeList(int size) {
        this.mQNodes = new ArrayList(size);
        for (int idx = 0; idx < size; ++idx) {
            GraphEdgeListNode elem = new GraphEdgeListNode();
            this.mQNodes.add(elem);
        }
    }

    public void pushBack(GraphEdge edge) {
        int newNode = edge.getToNode();
        if (this.mHead == -1) {
            this.mHead = newNode;
        } else {
            this.mQNodes.get(this.mTail).setNext(newNode);
        }
        this.mQNodes.get(newNode).setData(edge);
        this.mQNodes.get(newNode).setNext(-1);
        this.mQNodes.get(newNode).setPrevious(this.mTail);
        this.mTail = newNode;
    }

    public void remove(GraphEdge edge) {
        int deleteNode = edge.getToNode();
        if (this.mQNodes.get(deleteNode).getPrevious() != -1) {
            int deleteNodePrev = this.mQNodes.get(deleteNode).getPrevious();
            int deleteNodeNext = this.mQNodes.get(deleteNode).getNext();
            this.mQNodes.get(deleteNodePrev).setNext(deleteNodeNext);
        }
        if (this.mQNodes.get(deleteNode).getNext() != -1) {
            int deleteNodeNext = this.mQNodes.get(deleteNode).getNext();
            int deleteNodePrev = this.mQNodes.get(deleteNode).getPrevious();
            this.mQNodes.get(deleteNodeNext).setPrevious(deleteNodePrev);
        }
        if (deleteNode == this.mHead) {
            this.mHead = this.mQNodes.get(this.mHead).getNext();
        }
        if (deleteNode == this.mTail) {
            this.mTail = this.mQNodes.get(this.mTail).getPrevious();
        }
    }

    public ArrayList<GraphEdgeListNode> getQNodes() {
        return this.mQNodes;
    }

    public int getHead() {
        return this.mHead;
    }
}

