/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph;

import com.cognos.xqe.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

public class ShortestDistance
implements Comparable<Object> {
    private TreeMap<IdPair, OnePath> mIslandsJoins = null;
    private int mWeight;
    private int mFromIdx;
    private int mToIdx;

    public ShortestDistance() {
        this.mIslandsJoins = new TreeMap();
        this.mWeight = -1;
        this.mFromIdx = -1;
        this.mToIdx = -1;
    }

    public TreeMap<IdPair, OnePath> getIslandsJoins() {
        return this.mIslandsJoins;
    }

    public int getWeight() {
        return this.mWeight;
    }

    public void clearIslandsJoins() {
        this.mIslandsJoins.clear();
    }

    public void setWeight(int weight) {
        this.mWeight = weight;
    }

    public int getFromIdx() {
        return this.mFromIdx;
    }

    public void setFromIdx(int newIndex) {
        this.mFromIdx = newIndex;
    }

    public int getToIdx() {
        return this.mToIdx;
    }

    public void setToIdx(int newIndex) {
        this.mFromIdx = newIndex;
    }

    public ShortestDistance(String from, String to, ArrayList<ArrayList<String>> nodes, ArrayList<ArrayList<String>> joins, int weight, int fromIdx, int toIdx) {
        this.mIslandsJoins = new TreeMap();
        this.mWeight = weight;
        this.mFromIdx = fromIdx;
        this.mToIdx = toIdx;
        OnePath t = new OnePath();
        t.mFrom = from;
        t.mTo = to;
        t.mNodes = new ArrayList<ArrayList<String>>(nodes);
        t.mJoins = new ArrayList<ArrayList<String>>(joins);
        if (from.compareTo(to) <= 0) {
            IdPair keyPair = new IdPair(from, to);
            this.mIslandsJoins.put(keyPair, t);
        } else {
            IdPair keyPair = new IdPair(to, from);
            this.mIslandsJoins.put(keyPair, t);
        }
    }

    public ShortestDistance(ShortestDistance anotherSD) {
        this.mIslandsJoins = new TreeMap<IdPair, OnePath>((SortedMap<IdPair, OnePath>)anotherSD.mIslandsJoins);
        this.mWeight = anotherSD.mWeight;
        this.mFromIdx = anotherSD.mFromIdx;
        this.mToIdx = anotherSD.mToIdx;
    }

    @Override
    public int compareTo(Object anotherSD) {
        ShortestDistance rhs = (ShortestDistance)anotherSD;
        if (this.mWeight == rhs.mWeight) {
            return 0;
        }
        if (this.mWeight < rhs.mWeight) {
            return -1;
        }
        return 1;
    }

    boolean isIndexEqual(ShortestDistance rhs) {
        return this.mFromIdx == rhs.mFromIdx && this.mToIdx == rhs.mToIdx || this.mToIdx == rhs.mFromIdx && this.mFromIdx == rhs.mToIdx;
    }

    public OnePath getOnePathIDs(IdPair keyPair) {
        return this.mIslandsJoins.get(keyPair);
    }

    public int getOtherIndex(int idx) {
        if (this.mFromIdx == idx) {
            return this.mToIdx;
        }
        if (this.mToIdx == idx) {
            return this.mFromIdx;
        }
        return -1;
    }

    public void addPath(String from, String to, OnePath path) {
        IdPair sk = null;
        sk = from.compareTo(to) <= 0 ? new IdPair(from, to) : new IdPair(to, from);
        if (this.mIslandsJoins.get(sk) == null) {
            OnePath t = new OnePath(path);
            t.mFrom = from;
            t.mTo = to;
            this.mIslandsJoins.put(sk, t);
        }
    }

    public void addPath(ShortestDistance anotherSD) {
        for (OnePath t : anotherSD.mIslandsJoins.values()) {
            this.addPath(t.mFrom, t.mTo, t);
        }
    }

    static void getStarts(ArrayList<ShortestDistance> shortestDistances, ArrayList<ShortestDistance> starts) {
        starts.clear();
        Collections.sort(shortestDistances);
        int weight = -1;
        for (int i = 0; i < shortestDistances.size(); ++i) {
            ShortestDistance sd = shortestDistances.get(i);
            if (-1 != weight && sd.mWeight > weight) break;
            weight = sd.mWeight;
            starts.add(sd);
        }
    }

    static class IdPair
    extends Pair
    implements Comparable<Object> {
        public IdPair(String key, String value) {
            super(key, value);
        }

        @Override
        public int compareTo(Object idPair) {
            String lhsKey = (String)this.getFirst();
            String lhsValue = (String)this.getSecond();
            IdPair rhs = (IdPair)idPair;
            String rhsKey = (String)rhs.getFirst();
            String rhsValue = (String)rhs.getSecond();
            if (lhsKey.compareTo(rhsKey) == 0 && lhsValue.compareTo(rhsValue) == 0) {
                return 0;
            }
            if (lhsKey.compareTo(rhsKey) < 0 || lhsKey.compareTo(rhsKey) == 0 && lhsValue.compareTo(rhsValue) < 0) {
                return -1;
            }
            return 1;
        }
    }

    static class OnePath {
        String mFrom;
        String mTo;
        ArrayList<ArrayList<String>> mNodes;
        ArrayList<ArrayList<String>> mJoins;

        public OnePath() {
        }

        public OnePath(OnePath rhs) {
            this.mFrom = rhs.mFrom;
            this.mTo = rhs.mTo;
        }

        public ArrayList<ArrayList<String>> getNodes() {
            return this.mNodes;
        }

        public ArrayList<ArrayList<String>> getJoins() {
            return this.mJoins;
        }
    }
}

