/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

public final class BigArray {
    private static final int DEFAULT_NUM_ROWS = 100;
    private static final int DEFAULT_NUM_COLUMNS = 1000;
    private int numRows;
    private final int numColumns;
    private Object[][] data;
    private long size = 0L;
    private long lastIndex = -1L;

    public BigArray() {
        this(100, 1000);
    }

    public BigArray(int initialRows, int columns) {
        if (initialRows < 1 || columns < 1) {
            throw new IllegalArgumentException();
        }
        this.numRows = initialRows;
        this.numColumns = columns;
        this.data = new Object[this.numRows][];
        this.data[0] = new Object[this.numColumns];
    }

    public Object get(long index) {
        if (index < 0L) {
            throw new IllegalArgumentException();
        }
        if (index < (long)this.numColumns) {
            return this.data[0][(int)index];
        }
        int rowNumber = (int)(index / (long)this.numColumns);
        if (rowNumber >= this.numRows) {
            return null;
        }
        if (this.data[rowNumber] == null) {
            return null;
        }
        int offset = (int)(index % (long)this.numColumns);
        return this.data[rowNumber][offset];
    }

    public Object put(long index, Object value) {
        if (index < 0L || value == null) {
            throw new IllegalArgumentException();
        }
        if (index < (long)this.numColumns) {
            Object oldValue = this.data[0][(int)index];
            this.data[0][(int)index] = value;
            if (oldValue == null) {
                ++this.size;
            }
            if (index > this.lastIndex) {
                this.lastIndex = index;
            }
            return oldValue;
        }
        int rowNumber = (int)(index / (long)this.numColumns);
        if (rowNumber >= this.numRows) {
            this.growArray(rowNumber + 1);
        }
        if (this.data[rowNumber] == null) {
            this.data[rowNumber] = new Object[this.numColumns];
        }
        int offset = (int)(index % (long)this.numColumns);
        Object oldValue = this.data[rowNumber][offset];
        this.data[rowNumber][offset] = value;
        if (oldValue == null) {
            ++this.size;
        }
        if (index > this.lastIndex) {
            this.lastIndex = index;
        }
        return oldValue;
    }

    private void growArray(int minRows) {
        int newSize;
        for (newSize = this.numRows; newSize < minRows; newSize *= 2) {
        }
        Object[][] newData = new Object[newSize][];
        System.arraycopy(this.data, 0, newData, 0, this.numRows);
        this.data = newData;
        this.numRows = newSize;
    }

    public long lastIndex() {
        return this.lastIndex;
    }

    public long size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public Object lastNonNull() {
        if (this.lastIndex == -1L) {
            return null;
        }
        return this.get(this.lastIndex);
    }
}

