/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.util.ExcessiveCollectionNotifier;
import com.cognos.xqe.util.ITimeStamped;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExcessiveCollectionNotificationDispatcher
implements ExcessiveCollectionNotifier.IExcessiveCollectionListener {
    private final Map<ExcessiveCollectionNotifier.IExcessiveCollectionListener, ExcessiveCollectionNotifier.IExcessiveCollectionListener> mRegularListeners = new ConcurrentHashMap<ExcessiveCollectionNotifier.IExcessiveCollectionListener, ExcessiveCollectionNotifier.IExcessiveCollectionListener>();
    private final Map<IStampedExcessiveCollectionNotifier, IStampedExcessiveCollectionNotifier> mStampedListeners = new ConcurrentHashMap<IStampedExcessiveCollectionNotifier, IStampedExcessiveCollectionNotifier>();

    public ExcessiveCollectionNotifier.IExcessiveCollectionListener registerListener(ExcessiveCollectionNotifier.IExcessiveCollectionListener listener) {
        return this.mRegularListeners.put(listener, listener);
    }

    public ExcessiveCollectionNotifier.IExcessiveCollectionListener unregisterListener(ExcessiveCollectionNotifier.IExcessiveCollectionListener listener) {
        return this.mRegularListeners.remove(listener);
    }

    public IStampedExcessiveCollectionNotifier registerStampedListener(IStampedExcessiveCollectionNotifier listener) {
        return this.mStampedListeners.put(listener, listener);
    }

    public IStampedExcessiveCollectionNotifier unregisterStampedListener(IStampedExcessiveCollectionNotifier listener) {
        return this.mStampedListeners.remove(listener);
    }

    @Override
    public void onExcessiveCollection(int consecutiveInvocationCount) {
        this.notifyRegularListeners(consecutiveInvocationCount);
        this.notifyStampedListeners(consecutiveInvocationCount);
    }

    private void notifyRegularListeners(int consecutiveInvocationCount) {
        for (ExcessiveCollectionNotifier.IExcessiveCollectionListener listener : this.mRegularListeners.keySet()) {
            listener.onExcessiveCollection(consecutiveInvocationCount);
        }
    }

    private void notifyStampedListeners(int consecutiveInvocationCount) {
        for (int i = 1; i < consecutiveInvocationCount; ++i) {
            IStampedExcessiveCollectionNotifier mostRecent = null;
            for (IStampedExcessiveCollectionNotifier listener : this.mStampedListeners.keySet()) {
                if (null == mostRecent) {
                    mostRecent = listener;
                    continue;
                }
                if (mostRecent.getLastAccessTime() >= listener.getLastAccessTime()) continue;
                mostRecent = listener;
            }
            if (null == mostRecent) continue;
            this.unregisterStampedListener(mostRecent);
            mostRecent.onExcessiveCollection(consecutiveInvocationCount);
        }
    }

    public static interface IStampedExcessiveCollectionNotifier
    extends ExcessiveCollectionNotifier.IExcessiveCollectionListener,
    ITimeStamped {
    }
}

