/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class ExcessiveCollectionNotifier {
    private static final String NURSERY_MBEAN_NAME = "Copy";
    private ExcessiveCollectionTimerTask mExcessiveCollectionTimerTask = null;

    public ExcessiveCollectionNotifier(Timer timer, double elapsedTimeThreshold, long elapsedTimeCheckPeriod, IExcessiveCollectionListener excessiveCollectionListener) {
        List<GarbageCollectorMXBean> gcBeansToMonitor = this.getBeansToMonitor();
        if (gcBeansToMonitor != null) {
            this.mExcessiveCollectionTimerTask = new ExcessiveCollectionTimerTask(elapsedTimeThreshold, excessiveCollectionListener, gcBeansToMonitor);
            timer.schedule((TimerTask)this.mExcessiveCollectionTimerTask, elapsedTimeCheckPeriod, elapsedTimeCheckPeriod);
        } else {
            XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources", LogLevel.INFO);
            if (logger != null) {
                logger.log(LogLevel.INFO, "Excessive garbage collection monitor is not enabled due to not finding a MXBean that we can accurately measure.");
            }
        }
    }

    public void stop() {
        if (this.mExcessiveCollectionTimerTask != null) {
            this.mExcessiveCollectionTimerTask.cancel();
        }
    }

    private List<GarbageCollectorMXBean> getBeansToMonitor() {
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        GarbageCollectorMXBean nurseryBean = null;
        for (GarbageCollectorMXBean gcBean : garbageCollectorMXBeans) {
            if (!NURSERY_MBEAN_NAME.equalsIgnoreCase(gcBean.getName())) continue;
            nurseryBean = gcBean;
            break;
        }
        if (nurseryBean != null) {
            garbageCollectorMXBeans = new ArrayList<GarbageCollectorMXBean>();
            garbageCollectorMXBeans.add(nurseryBean);
        } else {
            garbageCollectorMXBeans = null;
        }
        return garbageCollectorMXBeans;
    }

    private static final class ExcessiveCollectionTimerTask
    extends TimerTask {
        private final IExcessiveCollectionListener mExcessiveCollectionListener;
        private final double mElapsedTimeThreshold;
        private final GarbageCollectorMXBean[] mGarbageCollectorMXBeans;
        private final long[] mLastCollectionElapsedTimes;
        private int mConsecutiveInvocationCount;
        private long mLastCheckTimeStamp;

        private ExcessiveCollectionTimerTask(double elapsedTimeThreshold, IExcessiveCollectionListener excessiveCollectionListener, List<GarbageCollectorMXBean> gcBeansToMonitor) {
            this.mExcessiveCollectionListener = excessiveCollectionListener;
            this.mElapsedTimeThreshold = elapsedTimeThreshold;
            this.mGarbageCollectorMXBeans = gcBeansToMonitor.toArray(new GarbageCollectorMXBean[gcBeansToMonitor.size()]);
            this.mLastCollectionElapsedTimes = new long[this.mGarbageCollectorMXBeans.length];
            Arrays.fill(this.mLastCollectionElapsedTimes, 0L);
            this.mConsecutiveInvocationCount = 0;
            this.mLastCheckTimeStamp = 0L;
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - this.mLastCheckTimeStamp;
            this.mLastCheckTimeStamp = currentTime;
            long excessiveElapsedTimeThreshold = (long)((double)elapsedTime * this.mElapsedTimeThreshold);
            long allGCsElapsedTimeDiff = 0L;
            for (int i = 0; i < this.mGarbageCollectorMXBeans.length; ++i) {
                long gcCurrentElapsedTime = this.mGarbageCollectorMXBeans[i].getCollectionTime();
                long gcElapsedTimeDiff = gcCurrentElapsedTime - this.mLastCollectionElapsedTimes[i];
                allGCsElapsedTimeDiff += gcElapsedTimeDiff;
                this.mLastCollectionElapsedTimes[i] = gcCurrentElapsedTime;
            }
            this.mConsecutiveInvocationCount = allGCsElapsedTimeDiff > excessiveElapsedTimeThreshold ? ++this.mConsecutiveInvocationCount : 0;
            this.mExcessiveCollectionListener.onExcessiveCollection(this.mConsecutiveInvocationCount);
        }
    }

    public static interface IExcessiveCollectionListener {
        public void onExcessiveCollection(int var1);
    }
}

