/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;

public class FileUtil {
    private static final int WINDOWS_XP = 255;
    private static final int OTHERS = 254;
    public static final String ALLOWED_JAVA_IDENTIFIER_CHARS = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";

    public static int getMaxFileNameLength() {
        String arch = System.getProperty("os.name");
        if (arch.equals("Windows XP")) {
            return 255;
        }
        return 254;
    }

    public static String makeJavaIdentifier(String value) {
        StringBuilder sb = new StringBuilder();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (ALLOWED_JAVA_IDENTIFIER_CHARS.indexOf(chars[i]) < 0) continue;
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static String makeJavaIdentifier(String value, char replacement) {
        StringBuilder sb = new StringBuilder();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (ALLOWED_JAVA_IDENTIFIER_CHARS.indexOf(chars[i]) >= 0) {
                sb.append(chars[i]);
                continue;
            }
            if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == replacement || sb.length() == 1) continue;
            sb.append(replacement);
        }
        if (sb.charAt(sb.length() - 1) == replacement) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String parseClassName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        String className = null;
        className = index == -1 ? fullClassName : fullClassName.substring(index + 1);
        return className;
    }

    public static String normalizePath(String path) {
        File tmp = new File(path);
        if (!tmp.isAbsolute()) {
            String cwd = SystemUtils.getUserDir().getAbsolutePath();
            return FilenameUtils.concat((String)cwd, (String)path);
        }
        return FilenameUtils.normalize((String)path);
    }

    public static enum FileType {
        JSON("JSON"),
        XML("XML"),
        UNKNOWN("UNKNOWN");

        private final String fileType;

        private FileType(String afileType) {
            this.fileType = afileType;
        }

        public String getFileType() {
            return this.fileType;
        }
    }
}

