/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.util.IParameterMaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ParameterAccessCoordinator
implements IParameterMaps {
    private final ArrayList<IParameterMaps> listOfMaps = new ArrayList();
    private final ArrayList<ParameterAccessCoordinator> listOfPACs = new ArrayList();

    public void addParameterAccessCoordinator(ParameterAccessCoordinator aPAC) {
        this.listOfPACs.add(aPAC);
    }

    public void addParameterMap(IParameterMaps parameterMap) {
        this.listOfMaps.add(parameterMap);
    }

    public void removeParameterMap(IParameterMaps parameterMap) {
        this.listOfMaps.remove(parameterMap);
    }

    public ArrayList<IParameterMaps> getMaps() {
        ArrayList<IParameterMaps> result = new ArrayList<IParameterMaps>(this.listOfMaps.size());
        result.addAll(this.listOfMaps);
        return result;
    }

    public ArrayList<IParameterMaps> getAllMaps() {
        ArrayList<IParameterMaps> allMaps = new ArrayList<IParameterMaps>();
        allMaps.addAll(this.listOfMaps);
        for (ParameterAccessCoordinator pac : this.listOfPACs) {
            if (pac == null) continue;
            allMaps.addAll(pac.getAllMaps());
        }
        return allMaps;
    }

    public ArrayList<IParameterMaps> getAllMapsWithMapName(String mapName) {
        ArrayList<IParameterMaps> allMaps = this.getAllMaps();
        ArrayList<IParameterMaps> mapsWithMapName = new ArrayList<IParameterMaps>();
        for (IParameterMaps paramMap : allMaps) {
            String[] supportedMapNames;
            for (String aMapName : supportedMapNames = paramMap.getMapNames()) {
                if (!aMapName.equals(mapName)) continue;
                mapsWithMapName.add(paramMap);
            }
        }
        return mapsWithMapName;
    }

    public boolean containsGlobalParametersMap() {
        for (IParameterMaps paramMap : this.getAllMaps()) {
            if (paramMap.getPriority() != IParameterMaps.EPRIORITY.GLOBAL_PARAMETERS.getKey()) continue;
            return true;
        }
        return false;
    }

    public IParameterMaps getSpecificMap(String mapName, String key) {
        ArrayList<IParameterMaps> mapsWithMapName = this.getAllMapsWithMapName(mapName);
        IParameterMaps[] mapsWithMapNameArray = mapsWithMapName.toArray(new IParameterMaps[0]);
        Arrays.sort(mapsWithMapNameArray, new ParameterMapComparator());
        IParameterMaps aMap = null;
        for (IParameterMaps paramMap : mapsWithMapNameArray) {
            String val = paramMap.get(mapName, key);
            if (val == null) continue;
            aMap = paramMap;
        }
        return aMap;
    }

    public String get(String nameOfMap, String key, boolean useDefaultValue) {
        String value = null;
        ArrayList<IParameterMaps> mapsWithMapName = this.getAllMapsWithMapName(nameOfMap);
        IParameterMaps[] mapsWithMapNameArray = mapsWithMapName.toArray(new IParameterMaps[0]);
        Arrays.sort(mapsWithMapNameArray, new ParameterMapComparator());
        for (IParameterMaps paramMap : mapsWithMapNameArray) {
            String val = paramMap.get(nameOfMap, key);
            if (val == null) continue;
            value = val;
        }
        if (useDefaultValue && value == null) {
            value = this.getDefault(nameOfMap);
        }
        return value;
    }

    @Override
    public String get(String nameOfMap, String key) {
        return this.get(nameOfMap, key, true);
    }

    @Override
    public String get(String key) {
        return this.get("_env", key);
    }

    @Override
    public Map<String, String> getAllEntries(String nameOfMap) {
        HashMap<String, String> allEntriesMap = new HashMap<String, String>();
        ArrayList<IParameterMaps> mapsWithMapName = this.getAllMapsWithMapName(nameOfMap);
        IParameterMaps[] mapsWithMapNameArray = mapsWithMapName.toArray(new IParameterMaps[0]);
        Arrays.sort(mapsWithMapNameArray, new ParameterMapComparator());
        for (IParameterMaps paramMap : mapsWithMapNameArray) {
            Map<String, String> mapEntries = paramMap.getAllEntries(nameOfMap);
            Set<String> keySet = mapEntries.keySet();
            for (String key : keySet) {
                allEntriesMap.put(key, mapEntries.get(key));
            }
        }
        return allEntriesMap;
    }

    @Override
    public String[] getMapNames() {
        ArrayList<String> allMapNames = new ArrayList<String>();
        for (IParameterMaps paramMap : this.listOfMaps) {
            String[] mapNamesFound;
            for (String aMapName : mapNamesFound = paramMap.getMapNames()) {
                allMapNames.add(aMapName);
            }
        }
        return allMapNames.toArray(new String[allMapNames.size()]);
    }

    @Override
    public String getDefault(String nameOfMap) {
        String defaultValue = null;
        ArrayList<IParameterMaps> mapsWithMapName = this.getAllMapsWithMapName(nameOfMap);
        IParameterMaps[] mapsWithMapNameArray = mapsWithMapName.toArray(new IParameterMaps[0]);
        Arrays.sort(mapsWithMapNameArray, new ParameterMapComparator());
        for (IParameterMaps paramMap : mapsWithMapName) {
            String val = paramMap.getDefault(nameOfMap);
            if (val == null) continue;
            defaultValue = val;
        }
        return defaultValue;
    }

    @Override
    public ArrayList<String> getArray(String nameOfMap, String key) {
        ArrayList<String> value = null;
        ArrayList<IParameterMaps> mapsWithMapName = this.getAllMapsWithMapName(nameOfMap);
        IParameterMaps[] mapsWithMapNameArray = mapsWithMapName.toArray(new IParameterMaps[0]);
        Arrays.sort(mapsWithMapNameArray, new ParameterMapComparator());
        for (IParameterMaps paramMap : mapsWithMapNameArray) {
            ArrayList<String> val = paramMap.getArray(nameOfMap, key);
            if (val == null) continue;
            value = val;
        }
        return value;
    }

    @Override
    public ArrayList<String> getArray(String key) {
        return this.getArray("_env", key);
    }

    @Override
    public Map<String, ArrayList<String>> getArrayAllEntries(String nameOfMap) {
        HashMap<String, ArrayList<String>> allEntriesMap = new HashMap<String, ArrayList<String>>();
        ArrayList<IParameterMaps> mapsWithMapName = this.getAllMapsWithMapName(nameOfMap);
        IParameterMaps[] mapsWithMapNameArray = mapsWithMapName.toArray(new IParameterMaps[0]);
        Arrays.sort(mapsWithMapNameArray, new ParameterMapComparator());
        for (IParameterMaps paramMap : mapsWithMapNameArray) {
            Map<String, ArrayList<String>> mapEntries = paramMap.getArrayAllEntries(nameOfMap);
            Set<String> keySet = mapEntries.keySet();
            for (String key : keySet) {
                allEntriesMap.put(key, mapEntries.get(key));
            }
        }
        return allEntriesMap;
    }

    @Override
    public void setPriority(int newPriority) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPriority() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefault(String mapName, String value) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (IParameterMaps param : this.listOfMaps) {
            buffer.append(param.toString());
            buffer.append("\n");
        }
        for (ParameterAccessCoordinator o : this.listOfPACs) {
            buffer.append(o.toString());
        }
        return buffer.toString();
    }

    public String getEnvMapAsCSV() {
        String sCOMMA = ",";
        String sNL = "\n";
        String sEnv = "_env";
        StringBuilder bld = new StringBuilder("");
        Map<String, String> entries = this.getAllEntries("_env");
        int maxKeyLen = -1;
        for (String k : entries.keySet()) {
            maxKeyLen = Math.max(maxKeyLen, this.csvValue(k).length());
        }
        TreeSet<String> sortedKeys = new TreeSet<String>(entries.keySet());
        for (String key : sortedKeys) {
            String v = entries.get(key);
            String k = this.csvValue(key);
            int len = k.length();
            int numSpaces = maxKeyLen - len;
            bld.append(k);
            bld.append(",");
            for (int j = 0; j < numSpaces; ++j) {
                bld.append(' ');
            }
            bld.append(",");
            bld.append(this.csvValue(v));
            bld.append("\n");
        }
        return bld.toString();
    }

    private String csvValue(String v) {
        if (v == null) {
            return "";
        }
        String retVal = v;
        if (v.contains(",") || v.contains("\"")) {
            retVal = retVal.replace("\"", "\"\"");
            retVal = "\"" + retVal + "\"";
        }
        return retVal;
    }

    @Override
    public boolean isModelMap() {
        return false;
    }

    @Override
    public boolean isQueryItemMap() {
        return false;
    }

    @Override
    public boolean getHiddenProperty(String mapName) {
        return false;
    }

    private static class ParameterMapComparator
    implements Comparator<IParameterMaps> {
        private ParameterMapComparator() {
        }

        @Override
        public int compare(IParameterMaps pm1, IParameterMaps pm2) {
            if (pm1.getPriority() == pm2.getPriority()) {
                return 0;
            }
            if (pm1.getPriority() < pm2.getPriority()) {
                return -1;
            }
            return 1;
        }
    }
}

