/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.util.IQueryReuseManager;
import java.util.HashMap;

public class QueryReuseEntry {
    private String name;
    private IXQEQueryNode reusableSQLAST;
    private IQueryReuseManager.CursorInfo cursorInfo;
    private long timeLastUsed;
    private long timeCreated;
    private long dataCacheExpiry = 0L;
    private HashMap<String, ParameterValues> cachedParameterValues = null;

    public QueryReuseEntry(String theName, long theDataCacheExpiry) {
        this.name = theName;
        this.setTimeCreated(System.currentTimeMillis());
        this.setTimeLastUsed(this.getTimeCreated());
        this.setDataCacheExpiry(theDataCacheExpiry);
        this.cachedParameterValues = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public void setReusableSQLAST(IXQEQueryNode theReusableSQLAST) {
        this.reusableSQLAST = theReusableSQLAST;
    }

    public IXQEQueryNode getReusableSQLAST() {
        return this.reusableSQLAST;
    }

    public void setTimeLastUsed(long theTimeLastUsed) {
        this.timeLastUsed = theTimeLastUsed;
    }

    public long getTimeLastUsed() {
        return this.timeLastUsed;
    }

    public void setTimeCreated(long theTimeCreated) {
        this.timeCreated = theTimeCreated;
    }

    public long getDataCacheExpiry() {
        return this.dataCacheExpiry;
    }

    public void setDataCacheExpiry(long theDataCacheExpiry) {
        this.dataCacheExpiry = theDataCacheExpiry;
    }

    public boolean dataCacheHasExpired(long currentTime) {
        return currentTime > this.timeCreated + this.dataCacheExpiry * 1000L;
    }

    public boolean dataCacheIsTooOld(long requestStartTime, long newDataCacheExpiry) {
        return requestStartTime - this.timeCreated > newDataCacheExpiry * 1000L;
    }

    public long getCurrentExpiry(long currentTime) {
        if (this.dataCacheExpiry != 0L) {
            return (this.timeCreated + this.dataCacheExpiry * 1000L - currentTime) / 1000L;
        }
        return (this.timeCreated + 3600000L - currentTime) / 1000L;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public void setCachedParameterValues(HashMap<String, ParameterValues> pvMap) {
        this.cachedParameterValues = pvMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQueryReuseManager.CursorInfo addCursorInfo(SQLQueryBlock qBlock, XNode ep) {
        Object ret = null;
        if (qBlock == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The SQL Block is null while it shouldn't be.");
        }
        SQLQueryItemList qil = qBlock.getQueryItemList();
        IDataSource aDataSource = qBlock.getDataSource();
        QueryReuseEntry queryReuseEntry = this;
        synchronized (queryReuseEntry) {
            String key = this.getName();
            if (this.cursorInfo == null) {
                this.cursorInfo = new IQueryReuseManager.CursorInfo(key, qil, ep, aDataSource);
            }
        }
        return this.cursorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQueryReuseManager.CursorInfo addCursorInfo(String key, SQLQueryItemList qil, XNode ep, IDataSource aDataSource) {
        QueryReuseEntry queryReuseEntry = this;
        synchronized (queryReuseEntry) {
            if (this.cursorInfo == null) {
                this.cursorInfo = new IQueryReuseManager.CursorInfo(key, qil, ep, aDataSource);
            }
        }
        return this.cursorInfo;
    }

    public IQueryReuseManager.CursorInfo getCursorInfo() {
        return this.cursorInfo;
    }

    public void setCursorInfo(IQueryReuseManager.CursorInfo theCursorInfo) {
        this.cursorInfo = theCursorInfo;
    }

    public String toString() {
        return this.getName();
    }

    public HashMap<String, ParameterValues> getCachedParameterValues() {
        return this.cachedParameterValues;
    }
}

