/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.ast.sql.SQLGroupByList;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQEUnrecoverableConnectionException;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSetManagerAdapter;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IQueryReuseManager;
import com.cognos.xqe.util.QueryReuseEntry;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.cognos.xqemoser.MoserDataSource;
import com.cognos.xqemoser.MoserModuleUtil;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class QueryReuseManager
implements IQueryReuseManager,
XQEConfigurationListener {
    public static final String REUSE_ENABLED = "general.queryReuse[@enabled]";
    public static final String SIZE = "general.queryReuse[@size]";
    public static final String MAX_AGE = "general.queryReuse.retention[@maxAge]";
    public static final String MAX_IDLE = "general.queryReuse.retention[@maxIdle]";
    public static final String THRESHOLD = "general.queryReuse.data[@threshold]";
    public static final String MAX_MEMORY = "general.queryReuse.data[@maxMemory]";
    public static final String ALLOW_PARAM_QUERY_REUSE = "general.queryReuse.allowReuseOfParameterizedQueries[@value]";
    private static final int CLEANUP_INTERVAL_MULTIPLIER = 10;
    private static final int MILLISECONDS_IN_ONE_SECOND = 1000;
    private static final int DEFAULT_SIZE = 25;
    private static final int DEFAULT_MAX_ATTEMPTS_DUE_TO_CONNECTION = 3;
    private boolean isQueryReuseEnabled = true;
    private boolean allowReuseOfParameterizedQueries = true;
    private boolean optimizeXtabRelational = true;
    private int maxAttemptsToRecoverFromConnection = 3;
    private boolean forceNewConnectionOnLastAttempt = true;
    private int size = 25;
    private AtomicInteger index = new AtomicInteger(0);
    private static final String STRING_SCROLL_CURSOR_NAME = "ScrollCursor_";
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryReuseManager", LogLevel.INFO);
    private static boolean loggingEnabled = false;
    private static final int DEFAULT_MAXIMUM_AGE = 3600;
    private static final int DEFAULT_MAXIMUM_IDLE = 300;
    private CachedResultSetManagerAdapter rsCache = new CachedResultSetManagerAdapter();
    private ConcurrentMap<Object, ConcurrentLinkedQueue<QueryReuseEntry>> qrm;
    private ReleasableResourceTracker tracker = new ReleasableResourceTracker();
    private Timer cleanupTimer = null;
    private int maximumAge = 3600;
    private int maximumIdle = 300;
    private static SingletonHelper<QueryReuseManager> singletonHelper = new SingletonHelper<QueryReuseManager>(){

        @Override
        protected QueryReuseManager newInstance() {
            return new QueryReuseManager();
        }

        @Override
        protected void releaseImpl(QueryReuseManager theInstance) {
        }

        @Override
        protected void initializeImpl(QueryReuseManager theInstance) {
        }
    };
    private CleanupTask cleanupTask;

    public static QueryReuseManager getInstance() {
        return singletonHelper.getInstance();
    }

    private QueryReuseManager() {
        this.configure();
        this.qrm = new ConcurrentHashMap<Object, ConcurrentLinkedQueue<QueryReuseEntry>>();
        this.startCleanupService(QueryEngine.getInstance().getTimer());
        XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).registerConfigurationListener(this);
    }

    private void configure() {
        this.rsCache.configure();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.setQueryReuseEnabled(config.getBooleanProperty(REUSE_ENABLED, true));
        this.setReuseOfParameterizedQueriesAllowed(config.getBooleanProperty(ALLOW_PARAM_QUERY_REUSE, true));
        this.setSize(config.getIntProperty(SIZE, 25));
        this.setMaximumIdle(1000 * config.getIntProperty(MAX_IDLE, config.getIntProperty("providers.defaultIdleConnectionTimeout", 300)));
        this.setMaximumAge(1000 * config.getIntProperty(MAX_AGE, 3600));
        this.setOptimizedXtabRelational(config.getBooleanProperty("general.queryReuse.optimizeCrosstabRelational[@enabled]", true));
        this.maxAttemptsToRecoverFromConnection = config.getIntProperty("general.unrecoverableConnectionRecovery[@maxAttempts]", 3);
        this.forceNewConnectionOnLastAttempt = config.getBooleanProperty("general.unrecoverableConnectionRecovery[@forceNewConnectionOnLastAttempt]", true);
        this.logToXQELog("Query Reuse Manager configured");
        if (this.isQueryReuseEnabled()) {
            this.logToXQELog(String.format("Query Reuse Feature is ON [maxIdle=%1$d, maxAge=%2$d, maxMemory=%3$d, size=%4$d, threshold=%5$d]", this.getMaximumIdle() / 1000, this.getMaximumAge() / 1000, this.rsCache.getMaxMemory(), this.size, this.rsCache.getThreshold()));
        } else {
            this.logToXQELog("Query Reuse Feature is OFF");
        }
        if (this.isOptimizeXtabRelationalEnabled()) {
            this.logToXQELog("Query Reuse: Optimize Crosstab-Relational Query is ON");
        } else {
            this.logToXQELog("Query Reuse: Optimize Crosstab-Relational Query is OFF");
        }
        if (TRACE_LOGGER.isOn()) {
            loggingEnabled = true;
        }
    }

    public QueryReuseEntry addQueryReuseEntry(String name, IXQEQueryNode ast, Object sc, HashMap<String, ParameterValues> paramValuesMap, long dataCacheExpiry) {
        QueryReuseEntry qre = new QueryReuseEntry(new String(name), dataCacheExpiry);
        qre.setReusableSQLAST(ast);
        if (paramValuesMap != null) {
            qre.setCachedParameterValues(paramValuesMap);
        }
        ConcurrentLinkedQueue<QueryReuseEntry> queryList = this.getSecurityContextMatches(sc);
        if (dataCacheExpiry > 0L && queryList.size() >= this.size) {
            long currentTime = System.currentTimeMillis();
            Iterator<QueryReuseEntry> iterator = queryList.iterator();
            while (iterator.hasNext()) {
                QueryReuseEntry queryReuseEntry = iterator.next();
                if (queryReuseEntry.getDataCacheExpiry() <= 0L || !queryReuseEntry.dataCacheHasExpired(currentTime)) continue;
                iterator.remove();
            }
        }
        if (queryList.size() >= this.size) {
            QueryReuseEntry queryReuseEntry = (QueryReuseEntry)queryList.remove();
            if (this.loggingEnabled()) {
                this.logToXQELog(String.format("Query Reuse cursor %s is evicted because size limit of %d is reached", queryReuseEntry.getName(), this.getSize()));
            }
        }
        queryList.add(qre);
        return qre;
    }

    @Override
    public void removeQueryByName(String name) {
        boolean done = false;
        Iterator iterator = this.qrm.values().iterator();
        block0: while (!done && iterator.hasNext()) {
            ConcurrentLinkedQueue set = (ConcurrentLinkedQueue)iterator.next();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                QueryReuseEntry queryReuseEntry = (QueryReuseEntry)iterator2.next();
                if (!queryReuseEntry.getName().equals(name)) continue;
                iterator2.remove();
                done = true;
                continue block0;
            }
        }
        this.rsCache.removeResultSet(name);
    }

    public CachedResultSetManagerAdapter getCache() {
        return this.rsCache;
    }

    @Override
    public ITabularResultSet getResultSet(IQueryReuseManager.CursorInfo ci, XDataContext context) {
        XNode executionPlan = ci.getExecutionPlan();
        String key = ci.getName();
        ITabularResultSet tabularResultSet = null;
        boolean retry = true;
        int attempt = 0;
        while (retry) {
            retry = false;
            if (this.maxAttemptsToRecoverFromConnection != 0 && attempt == this.maxAttemptsToRecoverFromConnection && this.forceNewConnectionOnLastAttempt) {
                context.setProperty("forceNewConnection", Boolean.TRUE);
            }
            try {
                tabularResultSet = this.rsCache.getOrCreateResultSet(context, executionPlan, this.tracker, key);
            }
            catch (XQEUnrecoverableConnectionException xuce) {
                if (!xuce.attemptedToRecover() && ++attempt <= this.maxAttemptsToRecoverFromConnection) {
                    TRACE_LOGGER.log(LogLevel.ERROR, (Throwable)xuce);
                    retry = true;
                    continue;
                }
                this.removeQueryByName(key);
                xuce.setAttemptedToRecover(true);
                throw xuce;
            }
            catch (XQERuntimeException xre) {
                this.removeQueryByName(key);
                throw xre;
            }
            finally {
                if (this.maxAttemptsToRecoverFromConnection == 0 || attempt < this.maxAttemptsToRecoverFromConnection || !this.forceNewConnectionOnLastAttempt || context.getProperty("forceNewConnection") != Boolean.TRUE) continue;
                context.setProperty("forceNewConnection", Boolean.FALSE);
            }
        }
        return tabularResultSet;
    }

    public String createCursorName() {
        return STRING_SCROLL_CURSOR_NAME + this.index.incrementAndGet();
    }

    @Override
    public boolean isQueryReuseEnabled() {
        return this.isQueryReuseEnabled;
    }

    @Override
    public boolean isReuseOfParameterizedQueriesAllowed() {
        return this.allowReuseOfParameterizedQueries;
    }

    public boolean isOptimizeXtabRelationalEnabled() {
        return this.isQueryReuseEnabled() && this.optimizeXtabRelational;
    }

    public void logToXQELog(String text) {
        TRACE_LOGGER.log(LogLevel.INFO, text);
    }

    public void logToXQELog(LogLevel aLogLevel, String text) {
        TRACE_LOGGER.log(aLogLevel, text);
    }

    public boolean loggingEnabled() {
        return loggingEnabled;
    }

    public QueryReuseEntry find(Governors.LocalCachePolicy localCachePolicy, IXQEQueryNode inputQuery, Object sc, HashMap<String, ParameterValues> paramValuesMap, Parameters reqParams, long dataCacheExpiry, IExecutionEnvironment execEnv) {
        ConcurrentLinkedQueue<QueryReuseEntry> queryList = this.getSecurityContextMatches(sc);
        HashSet<String> dependentQueriesOfInputQuery = new HashSet();
        if (localCachePolicy != Governors.LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY) {
            V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(inputQuery);
            dependentQueriesOfInputQuery = this.getDependentQueries(inputQuery, rootQuerySet);
        }
        QueryReuseEntry mostRecentQueryReuseEntry = null;
        long mostRecentTimeCreated = 0L;
        long requestStartTime = System.currentTimeMillis();
        for (QueryReuseEntry queryReuseEntry : queryList) {
            IXQEQueryNode reusableSQLAST = queryReuseEntry.getReusableSQLAST();
            if (dataCacheExpiry != 0L && queryReuseEntry.dataCacheHasExpired(requestStartTime) || (reusableSQLAST != null || inputQuery != null) && (reusableSQLAST == null || inputQuery == null || localCachePolicy != Governors.LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY && !this.dependentQueriesCompatible(inputQuery, dependentQueriesOfInputQuery, reusableSQLAST) || !this.areConnectionStringsCompatible(inputQuery, reusableSQLAST) || !this.areSingleTablesCompatible(inputQuery, reusableSQLAST) || !this.areMultipleTablesCompatible(inputQuery, reusableSQLAST) || !this.isEmbeddedSQLCompatible(inputQuery, reusableSQLAST) || !this.isGroupByListsCompatible(inputQuery, reusableSQLAST) || !this.isProjectionListsCompatible(inputQuery, reusableSQLAST) || !this.isJoinListsCompatible(inputQuery, reusableSQLAST) || !this.isFilterListsCompatible(inputQuery, reusableSQLAST, false) || !this.areCachedParameterValuesEquivalentToRequestParameterValues(queryReuseEntry.getCachedParameterValues(), reqParams) || null != execEnv && !this.areFlintDatasetsStillValid(reusableSQLAST, execEnv))) continue;
            if (dataCacheExpiry != 0L && queryReuseEntry.dataCacheIsTooOld(requestStartTime, dataCacheExpiry)) {
                queryReuseEntry.setTimeCreated(0L);
                continue;
            }
            if (mostRecentQueryReuseEntry == null) {
                mostRecentQueryReuseEntry = queryReuseEntry;
                mostRecentTimeCreated = queryReuseEntry.getTimeCreated();
                continue;
            }
            if (queryReuseEntry.getTimeCreated() <= mostRecentTimeCreated) continue;
            mostRecentQueryReuseEntry = queryReuseEntry;
            mostRecentTimeCreated = queryReuseEntry.getTimeCreated();
        }
        if (mostRecentQueryReuseEntry != null) {
            queryList.remove(mostRecentQueryReuseEntry);
            queryList.add(mostRecentQueryReuseEntry);
            mostRecentQueryReuseEntry.setTimeLastUsed(System.currentTimeMillis());
            return mostRecentQueryReuseEntry;
        }
        return null;
    }

    private Set<String> getDependentQueries(IXQEQueryNode inputQuery, V5QuerySet rootQuerySet) {
        HashSet<String> dependentQueries = new HashSet();
        int nbRangeVars = 0;
        if (inputQuery.getType() == 801041) {
            IXQEQueryNode sqlWith = inputQuery.getChild(0);
            if (sqlWith.getType() == 301022) {
                nbRangeVars = sqlWith.getNumberChildren() - 1;
                for (int i = 0; i < nbRangeVars; ++i) {
                    SQLRangeVar rv = (SQLRangeVar)sqlWith.getChild(i);
                    dependentQueries.add(rv.getName());
                }
            }
        } else {
            dependentQueries = rootQuerySet.getDependentQueriesOf(((SQLRangeVar)inputQuery).getName());
        }
        return dependentQueries;
    }

    private boolean dependentQueriesCompatible(IXQEQueryNode inputQuery, Set<String> dependentQueriesOfInputQuery, IXQEQueryNode reusableSQLAST) {
        IXQEQueryNode sqlWithOfCursor = reusableSQLAST.getChild(0);
        if (dependentQueriesOfInputQuery == null || dependentQueriesOfInputQuery.isEmpty()) {
            return sqlWithOfCursor.getType() != 301022;
        }
        if (sqlWithOfCursor.getType() != 301022) {
            return false;
        }
        IXQEQueryNode sqlWithOfInputQuery = null;
        int nbCTEsInCursor = sqlWithOfCursor.getNumberChildren() - 1;
        sqlWithOfInputQuery = inputQuery.getType() == 801041 ? inputQuery.getChild(0) : inputQuery.getParent();
        int nbCTEsInInputQuery = sqlWithOfInputQuery.getNumberChildren() - 1;
        if (inputQuery.getType() == 801041 && nbCTEsInCursor != nbCTEsInInputQuery) {
            return false;
        }
        for (int i = 0; i < nbCTEsInCursor; ++i) {
            SQLRangeVar cursorRangeVar = (SQLRangeVar)sqlWithOfCursor.getChild(i);
            String rangeVarName = cursorRangeVar.getName();
            int j = 0;
            SQLRangeVar inputQueryRangeVar = null;
            for (j = 0; j < nbCTEsInInputQuery && !rangeVarName.equals((inputQueryRangeVar = (SQLRangeVar)sqlWithOfInputQuery.getChild(j)).getName()); ++j) {
            }
            if (j == nbCTEsInInputQuery) {
                return false;
            }
            int status = this.embeddedCursorsCompatible(inputQueryRangeVar, cursorRangeVar);
            if (status == 2) {
                return false;
            }
            if (!(status == 1 ? !this.isFilterListsCompatible(inputQueryRangeVar, cursorRangeVar, true) : !inputQueryRangeVar.isSameExpression(cursorRangeVar, false))) continue;
            return false;
        }
        return true;
    }

    private int embeddedCursorsCompatible(SQLRangeVar inputQueryRangeVar, SQLRangeVar cursorRangeVar) {
        SQLRangeVar inputQuerySource = (SQLRangeVar)inputQueryRangeVar.getChild(0).getFirstDescendantOfTypeOrdered(301007, false);
        SQLRangeVar cursorQuerySource = (SQLRangeVar)cursorRangeVar.getChild(0).getFirstDescendantOfTypeOrdered(301007, false);
        if (inputQuerySource == null && cursorQuerySource == null) {
            return 0;
        }
        if (inputQuerySource == null || cursorQuerySource == null) {
            return 2;
        }
        String cursorName1 = this.getCursorName(inputQuerySource);
        String cursorName2 = this.getCursorName(cursorQuerySource);
        if (cursorName1 != null && cursorName2 == null || cursorName1 == null && cursorName2 != null) {
            return 2;
        }
        if (cursorName1 == null) {
            return 0;
        }
        if (cursorName1.equals(cursorName2)) {
            return 1;
        }
        return 2;
    }

    private String getCursorName(SQLRangeVar rangeVar) {
        SQLTableFunction cursorFunc;
        QueryReuseEntry qre = (QueryReuseEntry)rangeVar.getReusableQuery();
        if (qre != null) {
            return qre.getName();
        }
        if (rangeVar.getChild(0).getType() == 301038 && (cursorFunc = (SQLTableFunction)rangeVar.getChild(0)).getSubType() == SQLTableFunction.SubType.CURSOR) {
            SQLLiteral literal = (SQLLiteral)cursorFunc.getChild(0);
            ObjectValue literalValue = (ObjectValue)literal.getValue();
            return literalValue.getObject().toString();
        }
        return null;
    }

    public ConcurrentLinkedQueue<QueryReuseEntry> getSecurityContextMatches(Object sc) {
        ConcurrentLinkedQueue<QueryReuseEntry> map = new ConcurrentLinkedQueue<QueryReuseEntry>();
        ConcurrentLinkedQueue<QueryReuseEntry> value = this.qrm.putIfAbsent(sc, map);
        if (value == null) {
            return map;
        }
        return value;
    }

    public void clear() {
        this.qrm.clear();
        this.rsCache.clearCache();
    }

    public void clearQREntriesAndResultSetCache() {
        this.qrm.clear();
        this.rsCache.clearCache();
        this.logToXQELog("Query Reuse Manager cleared all query reuse entries and their result set cache");
    }

    public int getQRMSize() {
        return this.qrm.size();
    }

    public void setSize(int theSize) {
        this.size = theSize;
    }

    public int getSize() {
        return this.size;
    }

    public void setQueryReuseEnabled(boolean enabled) {
        this.isQueryReuseEnabled = enabled;
    }

    public void setReuseOfParameterizedQueriesAllowed(boolean enabled) {
        this.allowReuseOfParameterizedQueries = enabled;
    }

    public void setOptimizedXtabRelational(boolean enabled) {
        this.optimizeXtabRelational = enabled;
    }

    public void setMaximumAge(int theMaximumAge) {
        this.maximumAge = theMaximumAge;
    }

    public int getMaximumAge() {
        return this.maximumAge;
    }

    public void setMaximumIdle(int theMaximumIdle) {
        this.maximumIdle = theMaximumIdle;
    }

    public int getMaximumIdle() {
        return this.maximumIdle;
    }

    public void setCleanupTimer(Timer theTimer) {
        this.cleanupTimer = theTimer;
    }

    public Timer getCleanupTimer() {
        return this.cleanupTimer;
    }

    public void startCleanupService(Timer timer) {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
        }
        this.cleanupTask = new CleanupTask();
        long delay = Math.max(0, this.maximumIdle / 10);
        long period = Math.max(1, this.maximumIdle / 10);
        timer.scheduleAtFixedRate((TimerTask)this.cleanupTask, delay, period);
        this.logToXQELog("Query Reuse cleanup task started");
    }

    private boolean isGroupByListsCompatible(IXQEQueryNode sqlAst1, IXQEQueryNode sqlAst2) {
        IXQEQueryNode sqlGroupbyList2;
        int numGroupByItems2;
        IXQEQueryNode sqlGroupbyList1 = this.getSQLGroupByList(sqlAst1);
        int numGroupByItems1 = sqlGroupbyList1 == null ? 0 : sqlGroupbyList1.getNumberChildren();
        if (numGroupByItems1 != (numGroupByItems2 = (sqlGroupbyList2 = this.getSQLGroupByList(sqlAst2)) == null ? 0 : sqlGroupbyList2.getNumberChildren())) {
            return false;
        }
        for (int i = 0; i < numGroupByItems1; ++i) {
            IXQEQueryNode sqlGBList2;
            IXQEQueryNode sqlGBList1 = sqlGroupbyList1.getChild(i);
            if (sqlGBList1.isSameExpression(sqlGBList2 = sqlGroupbyList2.getChild(i), false)) continue;
            return false;
        }
        return true;
    }

    private boolean isProjectionListsCompatible(IXQEQueryNode sqlAst1, IXQEQueryNode sqlAst2) {
        IXQEQueryNode sqlValueList1 = this.getSQLValueList(sqlAst1);
        IXQEQueryNode sqlValueList2 = this.getSQLValueList(sqlAst2);
        for (int i = 0; i < sqlValueList1.getNumberChildren(); ++i) {
            IXQEQueryNode sqlVList1 = sqlValueList1.getChild(i);
            boolean found = false;
            for (int j = 0; j < sqlValueList2.getNumberChildren(); ++j) {
                IXQEQueryNode sqlVList2 = sqlValueList2.getChild(j);
                if (!sqlVList1.getChild(0).isSameExpression(sqlVList2.getChild(0), false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean isFilterListsCompatible(IXQEQueryNode sqlAST1, IXQEQueryNode sqlAST2, boolean filtersMustBeEquivalent) {
        IXQEQueryNode sqlFilter1 = QueryReuseManager.getSQLFilter(sqlAST1);
        IXQEQueryNode sqlFilter2 = QueryReuseManager.getSQLFilter(sqlAST2);
        ArrayList<IXQEQueryNode> filterExprs1 = new ArrayList<IXQEQueryNode>();
        QueryReuseManager.getFilterExpressions(sqlFilter1, filterExprs1);
        ArrayList<IXQEQueryNode> filterExprs2 = new ArrayList<IXQEQueryNode>();
        QueryReuseManager.getFilterExpressions(sqlFilter2, filterExprs2);
        if (filterExprs1.size() == 0 && filterExprs2.size() == 0) {
            return true;
        }
        ArrayList<IXQEQueryNode> matchingExprs = new ArrayList<IXQEQueryNode>();
        ArrayList<IXQEQueryNode> nonMatchingExprs = new ArrayList<IXQEQueryNode>();
        QueryReuseManager.bucketFilterExpressions(filterExprs1, filterExprs2, matchingExprs, nonMatchingExprs);
        if (matchingExprs.size() < filterExprs2.size()) {
            return false;
        }
        if (matchingExprs.size() == filterExprs1.size() && matchingExprs.size() == filterExprs2.size()) {
            return true;
        }
        if (filtersMustBeEquivalent) {
            return false;
        }
        IXQEQueryNode sqlValueList = this.getSQLValueList(sqlAST2);
        for (IXQEQueryNode nonMatchingExpr : nonMatchingExprs) {
            IXQEQueryNode[] columns = nonMatchingExpr.getDescendantsOfType(301005, true);
            if (this.areColumnsSupportedInProjection(sqlValueList, columns)) continue;
            return false;
        }
        return !this.filtersHaveDatabaseOnlyFunction(nonMatchingExprs);
    }

    private boolean filtersHaveDatabaseOnlyFunction(List<IXQEQueryNode> filterExpressions) {
        for (IXQEQueryNode filterExpr : filterExpressions) {
            IXQEQueryNode[] functions = filterExpr.getDescendantsOfType(301033, true);
            if (functions == null || functions.length == 0) continue;
            for (IXQEQueryNode f : functions) {
                IFunction udf;
                SQLFunction sqlFunction = (SQLFunction)f;
                if (!sqlFunction.isUdf() || (udf = FunctionManager.getUserDefinedFunction(sqlFunction.getFunctionName(), sqlFunction.getParameterTypes())) != null && !udf.isDbFunction()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areColumnsSupportedInProjection(IXQEQueryNode sqlValueList, IXQEQueryNode[] columns) {
        if (columns.length == 0) {
            return true;
        }
        for (IXQEQueryNode column : columns) {
            boolean columnSupported = false;
            for (IXQEQueryNode projItem : sqlValueList.getChildren()) {
                if (projItem.getType() != 301028 || !projItem.getChild(0).isSameExpression(column, false)) continue;
                columnSupported = true;
                break;
            }
            if (columnSupported) continue;
            return false;
        }
        return true;
    }

    public static void bucketFilterExpressions(List<IXQEQueryNode> filterExprs1, List<IXQEQueryNode> filterExprs2, List<IXQEQueryNode> matchingExprs, List<IXQEQueryNode> nonMatchingExprs) {
        for (IXQEQueryNode filterExpr1 : filterExprs1) {
            if (filterExprs2.size() == 0) {
                nonMatchingExprs.add(filterExpr1);
                continue;
            }
            boolean matched = false;
            for (IXQEQueryNode filterExpr2 : filterExprs2) {
                if (!filterExpr1.isSameExpression(filterExpr2, false)) continue;
                matched = true;
                break;
            }
            if (matched) {
                matchingExprs.add(filterExpr1);
                continue;
            }
            nonMatchingExprs.add(filterExpr1);
        }
    }

    private boolean isJoinListsCompatible(IXQEQueryNode sqlAst1, IXQEQueryNode sqlAst2) {
        IXQEQueryNode sqlJoin1 = this.getSQLJoin(sqlAst1);
        IXQEQueryNode sqlJoin2 = this.getSQLJoin(sqlAst2);
        if (sqlJoin1 == null && sqlJoin2 == null) {
            return true;
        }
        if (sqlJoin1 == null || sqlJoin2 == null) {
            return false;
        }
        return sqlJoin1.isSameExpression(sqlJoin2, false);
    }

    private boolean areConnectionStringsCompatible(IXQEQueryNode sqlAst1, IXQEQueryNode sqlAst2) {
        HashSet<String> inputQueryConnStrings = new HashSet<String>();
        HashSet<String> reuseQueryConnStrings = new HashSet<String>();
        IXQEQueryNode[] inputQuerySQLRelNodes = sqlAst1.getDescendantsOfType(301016, false);
        IXQEQueryNode[] queryReuseSQLRelNodes = sqlAst2.getDescendantsOfType(301016, false);
        for (IXQEQueryNode node : inputQuerySQLRelNodes) {
            inputQueryConnStrings.add(((SQLRelation)node).getConnectionString());
        }
        for (IXQEQueryNode node : queryReuseSQLRelNodes) {
            reuseQueryConnStrings.add(((SQLRelation)node).getConnectionString());
        }
        return reuseQueryConnStrings.containsAll(inputQueryConnStrings);
    }

    private boolean areFlintDatasetsStillValid(IXQEQueryNode sqlAst, IExecutionEnvironment execEnv) {
        IXQEQueryNode[] queryReuseSQLRelNodes;
        for (IXQEQueryNode node : queryReuseSQLRelNodes = sqlAst.getDescendantsOfType(301016, false)) {
            IDataSource ds;
            SQLRelation sqlNode = (SQLRelation)node;
            if (sqlNode.isWithClauseQueryRef() || null == (ds = sqlNode.getDataSource()) || !DataSourceTypeEnum.isFlint(ds.getType())) continue;
            MoserDataSource mDS = new MoserDataSource(1L, sqlNode.getModelDatasourceName());
            mDS.setCMDataSource(mDS.getName());
            mDS.setInterface("PARQUET");
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : ds.getMetadataProperties().entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
            String pqVersion = (String)properties.get("version");
            String logicalName = (String)properties.get("dsLogicalName");
            String pqConnectionString = (String)properties.remove("fallbackConnectionString");
            properties.put("connectionString", pqConnectionString);
            MoserModuleUtil.tryToPromoteDSForFlint(mDS, properties, execEnv, LocalDateTime.now(), pqVersion, false, logicalName, true);
            if ("FLINT".equals(mDS.getInterface())) continue;
            return false;
        }
        return true;
    }

    private boolean areSingleTablesCompatible(IXQEQueryNode sqlAst1, IXQEQueryNode sqlAst2) {
        IXQEQueryNode tableRef1 = this.getSingleSubqueryReference(sqlAst1);
        IXQEQueryNode tableRef2 = this.getSingleSubqueryReference(sqlAst2);
        if (tableRef1 == null && tableRef2 == null) {
            return true;
        }
        if (tableRef1 == null || tableRef2 == null) {
            return false;
        }
        return tableRef1.isSameExpression(tableRef2, false);
    }

    private boolean areMultipleTablesCompatible(IXQEQueryNode sqlAst1, IXQEQueryNode sqlAst2) {
        IXQEQueryNode sqlProductNode1 = this.getSQLProductNode(sqlAst1);
        IXQEQueryNode sqlProudctNode2 = this.getSQLProductNode(sqlAst2);
        if (sqlProductNode1 == null && sqlProudctNode2 == null) {
            return true;
        }
        if (sqlProductNode1 == null || sqlProudctNode2 == null) {
            return false;
        }
        return sqlProductNode1.isSameExpression(sqlProudctNode2, false);
    }

    private boolean isEmbeddedSQLCompatible(IXQEQueryNode sqlAst1, IXQEQueryNode sqlAst2) {
        IXQEQueryNode queryBlock1 = this.getEmbeddedSQL(sqlAst1);
        IXQEQueryNode queryBlock2 = this.getEmbeddedSQL(sqlAst2);
        if (queryBlock1 == null && queryBlock2 == null) {
            return true;
        }
        if (queryBlock1 == null || queryBlock2 == null) {
            return false;
        }
        return queryBlock1.isSameExpression(queryBlock2, false);
    }

    private IXQEQueryNode getEmbeddedSQL(IXQEQueryNode inputQuery) {
        IXQEQueryNode projectionNode = RQPUtilities.getProjectionNode(inputQuery);
        if (projectionNode == null) {
            return null;
        }
        for (IXQEQueryNode child : projectionNode.getChildren()) {
            if (child.getType() != 301004) continue;
            return child;
        }
        return null;
    }

    private IXQEQueryNode getSingleSubqueryReference(IXQEQueryNode inputQuery) {
        IXQEQueryNode grandChild;
        int grandChildType;
        IXQEQueryNode projectionNode = RQPUtilities.getProjectionNode(inputQuery);
        if (projectionNode == null) {
            return null;
        }
        IXQEQueryNode tableRef = null;
        IXQEQueryNode firstChild = projectionNode.getChild(0);
        int firstChildType = firstChild.getType();
        if (firstChildType == 301007) {
            tableRef = firstChild;
        }
        if (firstChildType == 301009 && (grandChildType = (grandChild = firstChild.getChild(0)).getType()) == 301007) {
            tableRef = grandChild;
        }
        return tableRef;
    }

    private IXQEQueryNode getSQLProductNode(IXQEQueryNode inputQuery) {
        IXQEQueryNode grandChild;
        int grandChildType;
        IXQEQueryNode projectionNode = RQPUtilities.getProjectionNode(inputQuery);
        if (projectionNode == null) {
            return null;
        }
        IXQEQueryNode tableRef = null;
        IXQEQueryNode firstChild = projectionNode.getChild(0);
        int firstChildType = firstChild.getType();
        if (firstChildType == 301014) {
            tableRef = firstChild;
        }
        if (firstChildType == 301009 && (grandChildType = (grandChild = firstChild.getChild(0)).getType()) == 301014) {
            tableRef = grandChild;
        }
        return tableRef;
    }

    private IXQEQueryNode getSQLJoin(IXQEQueryNode inputQuery) {
        IXQEQueryNode grandChild;
        int grandChildType;
        IXQEQueryNode projectionNode = RQPUtilities.getProjectionNode(inputQuery);
        IXQEQueryNode firstChild = projectionNode.getChild(0);
        int firstChildType = firstChild.getType();
        if (firstChildType == 301011) {
            return (SQLJoin)firstChild;
        }
        if (firstChildType == 301009 && (grandChildType = (grandChild = firstChild.getChild(0)).getType()) == 301011) {
            return (SQLJoin)grandChild;
        }
        return null;
    }

    public static IXQEQueryNode getSQLFilter(IXQEQueryNode inputQuery) {
        IXQEQueryNode projectionNode = RQPUtilities.getProjectionNode(inputQuery);
        IXQEQueryNode firstChild = projectionNode.getChild(0);
        int firstChildType = firstChild.getType();
        if (firstChildType == 301009) {
            return firstChild;
        }
        return null;
    }

    public static void getFilterExpressions(IXQEQueryNode sqlFilter, List<IXQEQueryNode> expressions) {
        if (sqlFilter != null) {
            for (int i = 0; i < sqlFilter.getNumberChildren(); ++i) {
                IXQEQueryNode child = sqlFilter.getChild(i);
                if (child.getType() == 301007 || child.getType() == 301011) continue;
                if (child.getType() == 301027 && ((SQLLogical)child).getSubType() == SQLLogical.SubType.AND) {
                    QueryReuseManager.getFilterExpressions(child, expressions);
                    continue;
                }
                expressions.add(child);
            }
        }
    }

    private IXQEQueryNode getSQLGroupByList(IXQEQueryNode inputQuery) {
        IXQEQueryNode projectionNode = RQPUtilities.getProjectionNode(inputQuery);
        if (projectionNode == null) {
            return null;
        }
        if (projectionNode.getType() == 301010) {
            return (SQLGroupByList)projectionNode.getFirstChildByType(301029);
        }
        return null;
    }

    private IXQEQueryNode getSQLValueList(IXQEQueryNode inputQuery) {
        IXQEQueryNode projectionNode = RQPUtilities.getProjectionNode(inputQuery);
        return (SQLValueList)projectionNode.getFirstChildByType(301030);
    }

    public void setIndex(int value) {
        this.index.set(value);
    }

    public boolean areParameterValuesEquivalent(HashMap<String, ParameterValues> pvMap1, HashMap<String, ParameterValues> pvMap2) {
        if (pvMap1.size() > pvMap2.size()) {
            return false;
        }
        for (Map.Entry<String, ParameterValues> entry : pvMap1.entrySet()) {
            String paramName = entry.getKey();
            ParameterValues pv1 = entry.getValue();
            ParameterValues pv2 = pvMap2.get(paramName);
            if (pv2 == null) {
                return false;
            }
            if (pv1.containsAll(pv2) && pv2.containsAll(pv1)) continue;
            return false;
        }
        return true;
    }

    public boolean areCachedParameterValuesEquivalentToRequestParameterValues(HashMap<String, ParameterValues> paramValuesMap, Parameters reqParams) {
        for (Map.Entry<String, ParameterValues> entry : paramValuesMap.entrySet()) {
            String paramName = entry.getKey();
            ParameterValues pv1 = entry.getValue();
            Parameter param = (Parameter)reqParams.get(paramName);
            if (param == null) {
                return false;
            }
            ParameterValues pv2 = param.getParameterValueItems();
            if (pv1.containsAll(pv2) && pv2.containsAll(pv1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void configurationChanged(XQEConfigurationEvent event) {
        if (REUSE_ENABLED.equals(event.getPropertyName())) {
            this.setQueryReuseEnabled(Boolean.parseBoolean((String)event.getPropertyValue()));
            if (this.loggingEnabled()) {
                this.logToXQELog("queryReuse changed to: " + this.isQueryReuseEnabled());
            }
        }
        if (SIZE.equals(event.getPropertyName())) {
            this.setSize(Integer.parseInt((String)event.getPropertyValue()));
            if (this.loggingEnabled()) {
                this.logToXQELog("queryReuse size changed to: " + this.getSize());
            }
        }
        if (MAX_AGE.equals(event.getPropertyName())) {
            this.setMaximumAge(Integer.parseInt((String)event.getPropertyValue()));
            if (this.loggingEnabled()) {
                this.logToXQELog("queryReuse retention maxAge changed to: " + this.getMaximumAge());
            }
        }
        if (MAX_IDLE.equals(event.getPropertyName())) {
            int valueInSeconds = Integer.parseInt((String)event.getPropertyValue());
            this.setMaximumIdle(1000 * valueInSeconds);
            this.startCleanupService(QueryEngine.getInstance().getTimer());
            if (this.loggingEnabled()) {
                this.logToXQELog("queryReuse retention maxIdle changed to: " + this.getMaximumIdle());
            }
        }
        if (THRESHOLD.equals(event.getPropertyName())) {
            this.rsCache.setThreshold(Integer.parseInt((String)event.getPropertyValue()));
            if (this.loggingEnabled()) {
                this.logToXQELog("queryReuse retention threshold changed to: " + this.rsCache.getThreshold());
            }
        }
        if (MAX_MEMORY.equals(event.getPropertyName())) {
            this.rsCache.setMaxMemory(Integer.parseInt((String)event.getPropertyValue()));
            if (this.loggingEnabled()) {
                this.logToXQELog("queryReuse data maxMemory changed to: " + this.rsCache.getMaxMemory());
            }
        }
        if (ALLOW_PARAM_QUERY_REUSE.equals(event.getPropertyName())) {
            this.setReuseOfParameterizedQueriesAllowed(Boolean.parseBoolean((String)event.getPropertyValue()));
            if (this.loggingEnabled()) {
                this.logToXQELog("queryReuse allow reuse of parameterized queries changed to: " + this.isReuseOfParameterizedQueriesAllowed());
            }
        }
    }

    private class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            long idleTime = currentTime - (long)QueryReuseManager.this.maximumIdle;
            long age = idleTime - (long)Math.max(QueryReuseManager.this.maximumAge - QueryReuseManager.this.maximumIdle, 0);
            Collection lists = QueryReuseManager.this.qrm.values();
            for (ConcurrentLinkedQueue concurrentLinkedQueue : lists) {
                Iterator iterator2 = concurrentLinkedQueue.iterator();
                while (iterator2.hasNext()) {
                    QueryReuseEntry queryReuseEntry = (QueryReuseEntry)iterator2.next();
                    if (queryReuseEntry.getTimeLastUsed() < idleTime) {
                        if (QueryReuseManager.this.loggingEnabled()) {
                            QueryReuseManager.this.logToXQELog(String.format("Query Reuse removes cursor %1$s because its TimeLastUsed(%2$s) < idleTime(%3$s)", queryReuseEntry.getName(), new Timestamp(queryReuseEntry.getTimeLastUsed()), new Timestamp(idleTime)));
                        }
                        iterator2.remove();
                        QueryReuseManager.this.rsCache.removeResultSet(queryReuseEntry.getName());
                        continue;
                    }
                    if ((queryReuseEntry.getDataCacheExpiry() != 0L || queryReuseEntry.getTimeCreated() >= age) && (queryReuseEntry.getDataCacheExpiry() <= 0L || !queryReuseEntry.dataCacheHasExpired(currentTime))) continue;
                    if (QueryReuseManager.this.loggingEnabled()) {
                        if (queryReuseEntry.getDataCacheExpiry() > 0L) {
                            age = currentTime;
                        }
                        QueryReuseManager.this.logToXQELog(String.format("Query Reuse removes cursor %1$s because its TimeCreated(%2$s) < age(%3$s)", queryReuseEntry.getName(), new Timestamp(queryReuseEntry.getTimeCreated()), new Timestamp(age)));
                    }
                    iterator2.remove();
                    QueryReuseManager.this.rsCache.removeResultSet(queryReuseEntry.getName());
                }
            }
            QueryReuseManager.this.rsCache.clearCachedResultSet(idleTime);
        }
    }
}

