/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.trace.XQEDebugLog;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class ResourceLocator {
    static final Logger JUL = Logger.getLogger(ResourceLocator.class.getName());
    private static final String SLASH = "/";
    private static final String STRING = "%s";

    public static URL findURL(String resourceName, IResourceMatcher ... paths) {
        for (IResourceMatcher path : paths) {
            if (!path.contains(resourceName)) continue;
            URL answer = path.getURL(resourceName);
            if (JUL.isLoggable(Level.CONFIG)) {
                JUL.config(String.format(STRING, answer));
            }
            return answer;
        }
        return null;
    }

    public static URL findURL(String resourceName, List<IResourceMatcher> paths) {
        for (IResourceMatcher path : paths) {
            if (!path.contains(resourceName)) continue;
            URL answer = path.getURL(resourceName);
            if (JUL.isLoggable(Level.CONFIG)) {
                JUL.config(String.format(STRING, answer));
            }
            return answer;
        }
        return null;
    }

    public static Iterable<URL> findMatchingURLs(String resourceName, List<IResourceMatcher> paths) {
        final ArrayList<Iterator<URL>> matcherIterators = new ArrayList<Iterator<URL>>();
        for (IResourceMatcher matcher : paths) {
            matcherIterators.add(matcher.getMatchingURLs(resourceName));
        }
        return new Iterable<URL>(){

            @Override
            public Iterator<URL> iterator() {
                return IteratorUtils.chainedIterator((Collection)matcherIterators);
            }
        };
    }

    public static class ClassResourceMatcher
    implements IResourceMatcher {
        Class<?> klass;
        String root;

        public ClassResourceMatcher(Class<?> theKlass) {
            this(theKlass, ResourceLocator.SLASH);
        }

        public ClassResourceMatcher(Class<?> theKlass, String theRoot) {
            this.klass = theKlass;
            this.root = theRoot;
        }

        @Override
        public boolean contains(String resourceName) {
            return this.getURL(resourceName) != null;
        }

        @Override
        public URL getURL(String resourceName) {
            String prefix = this.root;
            if (!prefix.endsWith(ResourceLocator.SLASH)) {
                prefix = prefix + ResourceLocator.SLASH;
            }
            return this.klass.getResource(prefix + resourceName);
        }

        @Override
        public Iterator<URL> getMatchingURLs(String resourceName) {
            return IteratorUtils.emptyIterator();
        }
    }

    public static class DirectoryResourceMatcher
    implements IResourceMatcher {
        File directory;

        public DirectoryResourceMatcher(File theDirectory) {
            this.directory = theDirectory;
        }

        @Override
        public boolean contains(String resourceName) {
            return new File(this.directory, resourceName).canRead();
        }

        @Override
        public URL getURL(String resourceName) {
            if (!this.contains(resourceName)) {
                return null;
            }
            try {
                String path = FilenameUtils.concat((String)this.directory.getAbsolutePath(), (String)resourceName);
                path = FilenameUtils.normalize((String)path);
                return new File(path).toURI().toURL();
            }
            catch (MalformedURLException e) {
                XQEDebugLog.out.printStackTrace(e);
                return null;
            }
        }

        @Override
        public Iterator<URL> getMatchingURLs(String resourceName) {
            if (!this.directory.canRead()) {
                return IteratorUtils.emptyIterator();
            }
            ArrayList<URL> answer = new ArrayList<URL>();
            for (File file : FileUtils.listFiles((File)this.directory, (IOFileFilter)new WildcardFileFilter(resourceName), null)) {
                try {
                    answer.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    XQEDebugLog.out.printStackTrace(e);
                }
            }
            return answer.iterator();
        }
    }

    public static interface IResourceMatcher {
        public boolean contains(String var1);

        public URL getURL(String var1);

        public Iterator<URL> getMatchingURLs(String var1);
    }
}

