/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.trace.XQEDebugLog;
import java.lang.management.ManagementFactory;

public class Timer {
    private long start;
    private long stop;
    private boolean started = false;
    private static boolean nanoTimeAvailable;
    public static final long MILLISECOND_MULTIPLIER = 1000000L;
    public static final long SECOND_MULTIPLIER = 1000000000L;
    private static boolean cpuTimeAvailable;

    public void reset() {
        this.started = false;
        this.start = 0L;
        this.stop = 0L;
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException();
        }
        this.started = true;
        this.start = Timer.getCurrentTime();
    }

    public long stop() {
        if (!this.started) {
            throw new IllegalStateException();
        }
        this.stop = Timer.getCurrentTime();
        this.started = false;
        return Math.abs(this.stop - this.start);
    }

    public long get() {
        return Math.abs(Timer.getCurrentTime() - this.start);
    }

    public long getElapsedTime() {
        if (this.started) {
            throw new IllegalStateException();
        }
        return Math.abs(this.stop - this.start);
    }

    public long getElapsedTimeInMilliseconds() {
        return this.getElapsedTime() / 1000000L;
    }

    public static long getCurrentTime() {
        if (nanoTimeAvailable) {
            return System.nanoTime();
        }
        return System.currentTimeMillis() * 1000000L;
    }

    public static long getCurrentThreadCpuTime() {
        if (cpuTimeAvailable || ManagementFactory.getThreadMXBean().isCurrentThreadCpuTimeSupported()) {
            try {
                return ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
            }
            catch (UnsupportedOperationException e) {
                return 0L;
            }
        }
        return 0L;
    }

    static {
        try {
            System.nanoTime();
            nanoTimeAvailable = true;
        }
        catch (NoSuchMethodError e) {
            XQEDebugLog.err.println("Warning: System.nanoTime() not available.  Timer accuracy reduced.");
            nanoTimeAvailable = false;
        }
        cpuTimeAvailable = ManagementFactory.getThreadMXBean().isThreadCpuTimeSupported();
    }
}

