/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class XQEManifest {
    private static Manifest instance = null;
    private static final String ATTR_PATH = "com/cognos/xqe";
    private static final char NASH = '/';
    private static final char DOT = '.';
    private static final String VERSION_SEPARATOR = "\\.";
    private static final int MAJOR_VERSION_INDEX = 0;
    private static final int MINOR_VERSION_INDEX = 1;
    private static final String CLASS = ".class";
    private static final String SPACE = " ";
    private static final String ENCODED_SPACE = "%20";
    private static final String URLJAR = "jar:file:";
    private static final String JAR = ".jar";

    private static synchronized void initialize() {
        String name;
        Class<XQEManifest> clazz;
        ClassLoader loader;
        URL res;
        if (instance == null && (res = (loader = (clazz = XQEManifest.class).getClassLoader()).getResource(name = clazz.getName().replace('.', '/') + CLASS)) != null) {
            String jarFileName = null;
            if (res.getProtocol().equals("jar")) {
                boolean isWindowsPlatform = System.getProperty("os.name").toLowerCase().contains("win");
                String loc = res.toString().replaceAll(ENCODED_SPACE, SPACE);
                int start = URLJAR.length();
                if (isWindowsPlatform) {
                    ++start;
                }
                jarFileName = loc.substring(start, loc.indexOf(JAR) + JAR.length());
            } else {
                ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
                XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                StringBuilder sb = new StringBuilder(config.getBinDirectory());
                sb.append("/../webapps/p2pd/WEB-INF/lib/xqeService.jar");
                jarFileName = cclConfig.resolveEffectivePath(sb.toString());
            }
            try {
                JarFile jarfile = new JarFile(jarFileName);
                instance = jarfile.getManifest();
            }
            catch (IOException e) {
                instance = new Manifest();
            }
        }
    }

    public static Manifest getInstance() {
        if (instance == null) {
            XQEManifest.initialize();
        }
        return instance;
    }

    public static int getMajorVersion() {
        String version = XQEManifest.getSpecificationVersion();
        if (version != null) {
            return Integer.valueOf(version.split(VERSION_SEPARATOR)[0]);
        }
        throw new XQERuntimeException();
    }

    public static int getMinorVersion() {
        String version = XQEManifest.getSpecificationVersion();
        if (version != null) {
            return Integer.valueOf(version.split(VERSION_SEPARATOR)[1]);
        }
        throw new XQERuntimeException();
    }

    public static String getSpecificationVersion() {
        Attributes attributes = XQEManifest.getInstance().getAttributes(ATTR_PATH);
        if (attributes != null) {
            return attributes.getValue("Specification-Version");
        }
        return null;
    }

    public static String getSpecificationTitle() {
        Attributes attributes = XQEManifest.getInstance().getAttributes(ATTR_PATH);
        if (attributes != null) {
            return attributes.getValue("Specification-Title");
        }
        return null;
    }
}

