/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.concurrent;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.concurrent.ThreadPoolTaskFactory;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadPool
extends ThreadPoolExecutor {
    private static final int ARCH_64_BIT = 64;
    private static final int KEEP_ALIVE_TIME = 10;
    private static ThreadPool threadPool;
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private final AtomicLong numTasks = new AtomicLong();
    private final AtomicLong totalTime = new AtomicLong();

    public static ThreadPool getInstance() {
        return threadPool;
    }

    private ThreadPool(int corePoolSize, int maxPoolSize) {
        super(corePoolSize, maxPoolSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolTaskFactory("XQEThreadPool"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        XQEDebugLog.out.println(String.format("Thread %s: start %s", t, r));
        this.startTime.set(System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            long endTime = System.nanoTime();
            long taskTime = endTime - this.startTime.get();
            this.numTasks.incrementAndGet();
            this.totalTime.addAndGet(taskTime);
            XQEDebugLog.out.println(String.format("Thread %s: end %s, time=%dns", r, t, taskTime));
        }
        finally {
            super.afterExecute(r, t);
        }
    }

    @Override
    protected void terminated() {
        try {
            XQEDebugLog.out.println(String.format("Terminated: avg time=%dns", this.totalTime.get() / this.numTasks.get()));
        }
        finally {
            super.terminated();
        }
    }

    static {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int maxWorkerThreads = configuration.getIntegerProperty("queryExecution.parallelism.maxWorkerThreads[@value]", 0);
        if (maxWorkerThreads == 0) {
            maxWorkerThreads = Runtime.getRuntime().availableProcessors() * 2 + 1;
            int arch = Integer.valueOf(System.getProperty("sun.arch.data.model"));
            if (arch == 64) {
                maxWorkerThreads *= 2;
            }
        }
        threadPool = new ThreadPool(maxWorkerThreads, maxWorkerThreads * 2);
    }
}

