/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.concurrent.locks;

import com.cognos.xqe.util.concurrent.locks.InterruptibleReadWriteLock;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class InterruptibleReadLock
extends ReentrantReadWriteLock.ReadLock {
    private static final long serialVersionUID = -34370972407157520L;
    private Queue<Thread> threadQueue = new ConcurrentLinkedQueue<Thread>();

    protected InterruptibleReadLock(InterruptibleReadWriteLock lock) {
        super(lock);
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        boolean acquired = super.tryLock(timeout, unit);
        if (acquired) {
            this.threadQueue.add(Thread.currentThread());
        }
        return acquired;
    }

    @Override
    public void unlock() {
        if (!this.isReadLockedByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        super.unlock();
        this.threadQueue.remove(Thread.currentThread());
    }

    protected boolean isReadLockedByCurrentThread() {
        return this.threadQueue.contains(Thread.currentThread());
    }

    @Override
    public void lock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        throw new UnsupportedOperationException();
    }
}

