/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.datasets;

import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqebifw.bibushandler.XQENodeSerializer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class DatasetInfoExtended {
    public static final String CURRENT_VERSION = "v1";
    public static final String ATTR_VERSION = "version";
    public static final String ELE_ROWSETINFO_EX = "rowsetInfoEx";
    private static final String ELE_REPORT_VERSION_ID = "reportVersionID";
    public static final String ELE_COLUMNINFO_EX = "columnInfoEx";
    public static final String ELE_COLUMNDEPENDENCY = "columnDependency";
    public static final String ELE_KEYREF = "keyRef";
    public static final String ATTR_AGGREGATE = "aggregate";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_REF = "ref";
    private final String queryName;
    private List<ColumnInfoExtended> columns = new ArrayList<ColumnInfoExtended>();
    private List<ColumnDependencyInfo> columnDependencys = new ArrayList<ColumnDependencyInfo>();

    public DatasetInfoExtended(String query) {
        this.queryName = query;
    }

    public ColumnInfoExtended addColumn(String name) {
        ColumnInfoExtended c = new ColumnInfoExtended(name);
        this.columns.add(c);
        return c;
    }

    public ColumnInfoExtended getColumnInfoExtendedByName(String name) {
        for (ColumnInfoExtended c : this.columns) {
            if (!c.columnName.equals(name)) continue;
            return c;
        }
        return null;
    }

    public ColumnDependencyInfo addColumnDependency(String ref, List<String> keyRef) {
        ColumnDependencyInfo c = new ColumnDependencyInfo(ref, keyRef);
        this.columnDependencys.add(c);
        return c;
    }

    public List<ColumnDependencyInfo> getColumnDependencies() {
        return this.columnDependencys;
    }

    public void serializeToXML(Writer writer, String reportVersion) throws IOException {
        TreeMap<String, Object> attributeMap = new TreeMap<String, Object>();
        attributeMap.put("name", "datasetInfoExtended");
        attributeMap.put("queryName", StringSubstitutionEngine.escapeString(this.queryName));
        attributeMap.put(ATTR_VERSION, CURRENT_VERSION);
        XQENodeSerializer.openTag(writer, "property", attributeMap);
        XQENodeSerializer.openTag(writer, ELE_ROWSETINFO_EX, Collections.EMPTY_MAP);
        for (ColumnInfoExtended c : this.columns) {
            c.serializeToXML(writer);
        }
        for (ColumnDependencyInfo d : this.columnDependencys) {
            d.serializeToXML(writer);
        }
        if (null != reportVersion && !reportVersion.isEmpty()) {
            XQENodeSerializer.openTag(writer, ELE_REPORT_VERSION_ID, Collections.EMPTY_MAP);
            writer.write(reportVersion);
            XQENodeSerializer.closeTag(writer, ELE_REPORT_VERSION_ID);
        }
        XQENodeSerializer.closeTag(writer, ELE_ROWSETINFO_EX);
        XQENodeSerializer.closeTag(writer, "property");
    }

    public static class ColumnDependencyInfo {
        private final String columnRef;
        private final List<String> keyColumnRefs;

        public ColumnDependencyInfo(String ref, List<String> keyRefs) {
            this.columnRef = ref;
            this.keyColumnRefs = new ArrayList<String>(keyRefs);
        }

        public String getColumnRef() {
            return this.columnRef;
        }

        public List<String> getKeyColumnRefs() {
            return this.keyColumnRefs;
        }

        public void serializeToXML(Writer writer) throws IOException {
            TreeMap<String, Object> attributeMap = new TreeMap<String, Object>();
            attributeMap.put(DatasetInfoExtended.ATTR_REF, StringSubstitutionEngine.escapeString(this.columnRef));
            XQENodeSerializer.openTag(writer, DatasetInfoExtended.ELE_COLUMNDEPENDENCY, attributeMap);
            for (String k : this.keyColumnRefs) {
                attributeMap.put(DatasetInfoExtended.ATTR_REF, StringSubstitutionEngine.escapeString(k));
                XQENodeSerializer.openTag(writer, DatasetInfoExtended.ELE_KEYREF, attributeMap, true);
            }
            XQENodeSerializer.closeTag(writer, DatasetInfoExtended.ELE_COLUMNDEPENDENCY);
        }
    }

    public static class ColumnInfoExtended {
        private final String columnName;
        private String aggregate;

        public ColumnInfoExtended(String name) {
            this.columnName = name;
        }

        public void setAggregate(String aggr) {
            this.aggregate = aggr;
        }

        public String getAggregate() {
            return this.aggregate;
        }

        public void serializeToXML(Writer writer) throws IOException {
            TreeMap<String, Object> attributeMap = new TreeMap<String, Object>();
            attributeMap.put("name", StringSubstitutionEngine.escapeString(this.columnName));
            if (this.aggregate != null) {
                attributeMap.put(DatasetInfoExtended.ATTR_AGGREGATE, this.aggregate);
            }
            XQENodeSerializer.openTag(writer, DatasetInfoExtended.ELE_COLUMNINFO_EX, attributeMap, true);
        }
    }
}

