/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.datasets;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ConfigService;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.datasets.DatasetBuilder;
import com.cognos.xqe.util.datasets.DatasetInfoExtended;
import com.cognos.xqe.util.datasets.DatasetUtilHelper;
import com.cognos.xqe.util.datasets.FlintUtils;
import com.cognos.xqemoser.ContentServiceClient;
import com.cognos.xqemoser.HTTPClientResponse;
import com.cognos.xqemoser.MoserServiceClient;
import com.ibm.bi.platform.datasetutils.converters.ConverterOptions;
import com.ibm.bi.platform.datasetutils.converters.DecimalPolicy;
import com.ibm.bi.platform.datasetutils.metadata.Column;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.metadata.TabularRowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.DecimalType;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;
import com.ibm.bi.platform.datasetutils.metadata.types.Type;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetWriterBuilder;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.ArrayRecord;
import com.ibm.bi.platform.datasetutils.utils.MetadataUtils;
import com.ibm.bi.platform.datasetutils.utils.WritableRecord;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;

public class ParquetDatasetBuilder
implements DatasetBuilder {
    private static final char UNDERSCORE_CHAR = '_';
    private static final String SLASH_STR = "/";
    private static final int K10 = 10000;
    private static final String UPLOAD_FOLDER_NAME = "upload";
    private static final String PARQUET_EXTENSION = ".data";
    private static final String VERSION_STR = "version";
    private static final String NAME_STR = "name";
    private static final String TYPE_STR = "type";
    private static final String DATA_STR = "data";
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "DatasetBuilder", LogLevel.INFO);
    private static final long ONE_SECOND_IN_NANOS = TimeUnit.SECONDS.toNanos(1L);
    static final ConverterOptions converterOpts = new ConverterOptions();
    public static final String ROW_TYPE = "rowType";
    private String storageLocation;
    private String uuid;
    private final IExecutionEnvironment execEnv;
    private long nextCheckRowCount = 10000L;
    private volatile boolean isCancelled = false;
    private final int blockSize;
    private final int pageSize;
    private final CompressionCodecName codec;
    private final ParquetVersionEnum parquetVersion;
    private final long maxSizeBytes;
    private final ContentServiceClient cmClient;
    private final MoserServiceClient moserClient;
    private boolean[] successfulPhases = new boolean[DatasetBuilderPhase.values().length];

    public ParquetDatasetBuilder(IExecutionEnvironment env) {
        this.execEnv = env;
        RequestEnvironment reqEnv = (RequestEnvironment)env.getRequestEnvironment();
        reqEnv.initializeRequestPAC(env.getConnectionElement());
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.blockSize = configuration.getIntegerProperty("dataset.parquet.blockSize[@value]", 0xA00000);
        this.pageSize = configuration.getIntegerProperty("dataset.parquet.pageSize[@value]", 0x100000);
        this.codec = CompressionCodecName.valueOf((String)configuration.getStringProperty("dataset.parquet.compression[@codec]", "GZIP"));
        this.parquetVersion = ParquetVersionEnum.valueOf((String)configuration.getStringProperty("dataset.parquet.parquetVersion[@value]", "VERSION_1"));
        this.maxSizeBytes = ConfigService.getInstance().getMaxUploadSizeMBytes() * 1024L * 1024L;
        TreeMap<String, String> cookies = new TreeMap<String, String>();
        Map<String, String> ck = reqEnv.getCookies();
        if (ck != null) {
            cookies.putAll(ck);
        }
        this.cmClient = new ContentServiceClient(reqEnv.getCAMPassport(), cookies);
        this.moserClient = new MoserServiceClient(reqEnv.getCAMPassport(), cookies);
        String path = env.getRequestEnvironment().getDatasetPath();
        if (path != null && !path.equals("")) {
            this.storageLocation = path;
        } else {
            this.uuid = UUID.randomUUID().toString();
            this.storageLocation = Paths.get(configuration.getXqeTempDirectory(), UPLOAD_FOLDER_NAME, this.uuid).toAbsolutePath().toString();
        }
        File file = new File(this.storageLocation);
        try {
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
        }
        catch (Exception e) {
            FileUtils.deleteQuietly((File)file);
            throw new XQERuntimeException(e);
        }
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(String theStorageLocation) {
        this.storageLocation = theStorageLocation;
    }

    private void throwIfCancelled() {
        if (this.isCancelled) {
            throw new OperationCanceledException(CancelRequestSourceEnum.USER);
        }
    }

    public static String generateValidColumnName(String name) {
        return name.replace(',', '_').replace(';', '_').replace('{', '_').replace('}', '_').replace('(', '_').replace(')', '_').replace('\n', '_').replace('\r', '_').replace('\t', '_').replace('\\', '_').replace('/', '_').replace(' ', '_');
    }

    public static Pair generateParquetRowSchema(RSAPIEdgeRowset rowsetInfo) {
        CaseInsensitiveMap existing = new CaseInsensitiveMap();
        HashMap<Integer, DecimalType> fieldIdToOriginalDecimalType = new HashMap<Integer, DecimalType>();
        TabularRowSchema rowSchema = new TabularRowSchema();
        int fieldId = 0;
        for (int i = 0; i < rowsetInfo.getNumColumns(); ++i) {
            RSAPIColumn columnInfo = rowsetInfo.getColumns()[i];
            if (!columnInfo.getColumnRepresentsDataItemValue()) continue;
            IDataType dt = columnInfo.getDatatype();
            String columnName = IdentifierUtil.makeUniqueAndValidIdentifier((String)columnInfo.getName(), (CaseInsensitiveMap)existing);
            existing.put((Object)columnName, (Object)Boolean.TRUE);
            ColumnMetadata columnMd = MetadataUtils.generateColumnFromRSVPMasterDataset((String)columnName, (byte)dt.getCCLTypeCode(), (int)dt.getPrecision(), (int)dt.getScale(), (int)(columnInfo.getNullsOK() ? 1 : 0));
            if (EIntrinsicType.DECIMAL == columnMd.getType().getIntrinsicType()) {
                DecimalType originalType = (DecimalType)columnMd.getType();
                DecimalType adjustedType = MetadataUtils.adjustDecimalType((String)columnMd.getName(), (DecimalType)originalType, (ConverterOptions)converterOpts);
                if (adjustedType != originalType) {
                    fieldIdToOriginalDecimalType.put(fieldId, originalType);
                }
                columnMd = new Column(columnMd.getName(), columnMd.isNullable(), (Type)adjustedType);
            }
            rowSchema.appendColumn(columnMd);
            ++fieldId;
        }
        return new Pair(rowSchema, fieldIdToOriginalDecimalType);
    }

    public static Pair generateParquetRowSchema(IRowsetInfo rowsetInfo) {
        HashMap<Integer, DecimalType> fieldIdToOriginalDecimalType = new HashMap<Integer, DecimalType>();
        TabularRowSchema rowSchema = new TabularRowSchema();
        for (int i = 0; i < rowsetInfo.getNumColumns(); ++i) {
            IColumnInfo columnInfo = rowsetInfo.getColumnInfo(i);
            IDataType dt = columnInfo.getDataType();
            String columnName = ParquetDatasetBuilder.generateValidColumnName(columnInfo.getName());
            ColumnMetadata columnMd = MetadataUtils.generateColumnFromRSVPMasterDataset((String)columnName, (byte)dt.getCCLTypeCode(), (int)dt.getPrecision(), (int)dt.getScale(), (int)(columnInfo.isNullable() ? 1 : 0));
            if (EIntrinsicType.DECIMAL == columnMd.getType().getIntrinsicType()) {
                DecimalType originalType = (DecimalType)columnMd.getType();
                DecimalType adjustedType = MetadataUtils.adjustDecimalType((String)columnMd.getName(), (DecimalType)originalType, (ConverterOptions)converterOpts);
                if (adjustedType != originalType) {
                    fieldIdToOriginalDecimalType.put(i, originalType);
                }
                columnMd = new Column(columnMd.getName(), columnMd.isNullable(), (Type)adjustedType);
            }
            rowSchema.appendColumn(columnMd);
        }
        return new Pair(rowSchema, fieldIdToOriginalDecimalType);
    }

    public static Element generateMasterDatasetAndExtendedInfo(RSAPIDataset dataset) {
        Element rootElement = DocumentHelper.createElement((String)"root");
        Element masterDatasetElement = rootElement.addElement("masterDataset");
        masterDatasetElement.addAttribute(VERSION_STR, "3.0");
        Element datasetInfoElement = masterDatasetElement.addElement("datasetInfo");
        datasetInfoElement.addAttribute(NAME_STR, dataset.getName());
        datasetInfoElement.addAttribute("refQuery", dataset.getRefQueryName());
        datasetInfoElement.addAttribute("numEdges", String.valueOf(dataset.getNumEdges()));
        LinkedList<String> columnNames = new LinkedList<String>();
        for (RSAPIEdge edge : dataset.getEdges()) {
            Element edgeInfoElement = datasetInfoElement.addElement("edgeInfo");
            edgeInfoElement.addAttribute("ordinal", String.valueOf(edge.getOrdinal()));
            edgeInfoElement.addAttribute(NAME_STR, edge.getName());
            edgeInfoElement.addAttribute("numRowsets", String.valueOf(edge.getNumRowsets()));
            for (RSAPIEdgeRowset rowsetInfo : edge.getRowsets()) {
                Element rowsetInfoElement = edgeInfoElement.addElement("rowsetInfo");
                rowsetInfoElement.addAttribute(NAME_STR, rowsetInfo.getName());
                rowsetInfoElement.addAttribute("id", String.valueOf(rowsetInfo.getRowsetId()));
                RSAPIEdgeRowset headerRowset = rowsetInfo.getHeaderRowset();
                if (null == headerRowset) {
                    rowsetInfoElement.addAttribute("headerRowsetId", "-1");
                } else {
                    rowsetInfoElement.addAttribute("headerRowsetId", String.valueOf(headerRowset.getRowsetId()));
                }
                RSAPIEdgeRowset footerRowset = rowsetInfo.getFooterRowset();
                if (null == footerRowset) {
                    rowsetInfoElement.addAttribute("footerRowsetId", "-1");
                } else {
                    rowsetInfoElement.addAttribute("footerRowsetId", String.valueOf(footerRowset.getRowsetId()));
                }
                RSAPIEdgeRowset parentRowset = rowsetInfo.getParentRowset();
                if (null == parentRowset) {
                    rowsetInfoElement.addAttribute("parentRowsetId", "-1");
                } else {
                    rowsetInfoElement.addAttribute("parentRowsetId", String.valueOf(parentRowset.getRowsetId()));
                }
                RSAPIEdgeRowset nestedRowset = rowsetInfo.getNestedRowset();
                if (null == nestedRowset) {
                    rowsetInfoElement.addAttribute("childRowsetId", "-1");
                } else {
                    rowsetInfoElement.addAttribute("childRowsetId", String.valueOf(nestedRowset.getRowsetId()));
                }
                RSAPIEdgeRowset nextRowset = rowsetInfo.getSiblingRowset();
                if (null == nextRowset) {
                    rowsetInfoElement.addAttribute("nextRowsetId", "-1");
                } else {
                    rowsetInfoElement.addAttribute("nextRowsetId", String.valueOf(nextRowset.getRowsetId()));
                }
                rowsetInfoElement.addAttribute("numColumns", String.valueOf(rowsetInfo.getNumColumns()));
                rowsetInfoElement.addAttribute("isMeasure", rowsetInfo.isMeasureRowset() ? "1" : "0");
                for (RSAPIColumn column : rowsetInfo.getColumns()) {
                    String columnName = column.getName();
                    if (25 != column.getDatatype().getCCLTypeCode()) {
                        columnNames.add(columnName);
                    }
                    Element columnInfoElement = rowsetInfoElement.addElement("columnInfo");
                    columnInfoElement.addAttribute(NAME_STR, columnName);
                    columnInfoElement.addAttribute(TYPE_STR, String.valueOf(column.getDatatype().getCCLTypeCode()));
                    columnInfoElement.addAttribute("nullsOk", column.getNullsOK() ? "1" : "0");
                    columnInfoElement.addAttribute("length", String.valueOf(column.getLength()));
                    columnInfoElement.addAttribute("precision", String.valueOf(column.getPrecision()));
                    columnInfoElement.addAttribute("scale", String.valueOf(column.getScale()));
                    columnInfoElement.addAttribute("label", column.getLabel());
                    columnInfoElement.addAttribute("format", column.getFormat());
                    columnInfoElement.addAttribute("subType", column.getUsage().toString());
                    columnInfoElement.addAttribute("formatIDStr", column.getFormatIDString());
                    columnInfoElement.addAttribute("isProperty", column.getIsCanonicalProperty() ? "1" : "0");
                    String currencyCodeValue = column.getCurrencyCode();
                    if (null == currencyCodeValue) {
                        currencyCodeValue = "";
                    }
                    columnInfoElement.addAttribute("currencyCode", currencyCodeValue);
                }
            }
        }
        Element responseElement = rootElement.addElement("response");
        responseElement.addAttribute("xmlns:SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        responseElement.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Element connectionIDElement = responseElement.addElement("connectionID");
        connectionIDElement.addAttribute("value", "QFSID_2");
        DatasetInfoExtended datasetInfoExtended = dataset.getExtendedDatasetInfo();
        if (null != datasetInfoExtended) {
            Element queryFeedbackResultElement = connectionIDElement.addElement("queryFeedbackResult");
            Element propertyElement = queryFeedbackResultElement.addElement("property");
            propertyElement.addAttribute(NAME_STR, "datasetInfoExtended");
            propertyElement.addAttribute("queryName", dataset.getName());
            propertyElement.addAttribute(VERSION_STR, "v1");
            Element rowsetInfoExElement = propertyElement.addElement("rowsetInfoEx");
            for (String columnName : columnNames) {
                DatasetInfoExtended.ColumnInfoExtended columnInfoExtended = datasetInfoExtended.getColumnInfoExtendedByName(columnName);
                Element columnInfoExElement = rowsetInfoExElement.addElement("columnInfoEx");
                columnInfoExElement.addAttribute("aggregate", columnInfoExtended.getAggregate());
                columnInfoExElement.addAttribute(NAME_STR, columnName);
            }
            for (DatasetInfoExtended.ColumnDependencyInfo columnDependencyInfo : datasetInfoExtended.getColumnDependencies()) {
                Element columnDependencyElement = rowsetInfoExElement.addElement("columnDependency");
                columnDependencyElement.addAttribute("ref", columnDependencyInfo.getColumnRef());
                for (String keyColumnRef : columnDependencyInfo.getKeyColumnRefs()) {
                    Element keyRefElement = columnDependencyElement.addElement("keyRef");
                    keyRefElement.addAttribute("ref", keyColumnRef);
                }
            }
        }
        responseElement.addElement("refParameters");
        responseElement.addElement("queryPlans");
        return rootElement;
    }

    public static JSONObject generateDataDescriptor(long ellapsedTimeNanos, long numRows, String pqVersion, int numColumns) {
        OrderedJSONObject dataDescriptor = new OrderedJSONObject();
        dataDescriptor.put((Object)"elapsedTimeMilli", (Object)(ellapsedTimeNanos / 1000000L));
        dataDescriptor.put((Object)"container", (Object)"parquet");
        dataDescriptor.put((Object)"numRows", (Object)numRows);
        dataDescriptor.put((Object)VERSION_STR, (Object)pqVersion);
        dataDescriptor.put((Object)"numColumns", (Object)numColumns);
        return dataDescriptor;
    }

    private String invokeUploadProcess(String reportPath, Element metadataField, JSONObject dataDescriptor, InputStream stream, long length, long begin) throws IOException {
        this.throwIfCancelled();
        LOGGER.log(String.format("Start, Creating the CM reportVersion entity - UUID: %s", this.uuid));
        long start = System.nanoTime();
        HTTPClientResponse response = this.cmClient.getSearchPathJSON(reportPath, new String[0]);
        if (response.getRespondeCode() >= 400) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_InvalidResponse, response.getRespondeCode(), (Object)response.toString());
        }
        JSONObject jsonResponse = response.getJSONObjectResponse();
        JSONArray dataArr = (JSONArray)jsonResponse.get((Object)DATA_STR);
        JSONObject dataSet2Info = (JSONObject)dataArr.get(0);
        String dataSet2EntiryStoreID = (String)dataSet2Info.get((Object)"id");
        JSONObject payload = new JSONObject();
        payload.put((Object)TYPE_STR, (Object)"reportVersion");
        response = this.cmClient.postWithReplace(dataSet2EntiryStoreID, payload.toString());
        if (response.getRespondeCode() >= 400) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_InvalidResponse, response.getRespondeCode(), (Object)response.toString());
        }
        String locationHeaderValue = ContentServiceClient.extractLocationHeader(response);
        String reportVersionStoreID = locationHeaderValue.substring(locationHeaderValue.lastIndexOf(SLASH_STR) + 1);
        long finish = System.nanoTime();
        LOGGER.log(String.format("End, CM reportVersion entity created - UUID: %s - elapsed time: %ds", this.uuid, (finish - start) / ONE_SECOND_IN_NANOS));
        this.successfulPhases[1] = true;
        this.throwIfCancelled();
        LOGGER.log(String.format("Start, Creating the CM output entity - UUID: %s", this.uuid));
        start = System.nanoTime();
        payload = new JSONObject();
        payload.put((Object)TYPE_STR, (Object)"output");
        payload.put((Object)"format", (Object)"dataSet");
        payload.put((Object)"dataDescriptor", (Object)dataDescriptor);
        StringWriter sw = new StringWriter();
        metadataField.write((Writer)sw);
        payload.put((Object)"metadata", (Object)sw.toString());
        response = this.cmClient.postWithReplace(reportVersionStoreID, payload.toString());
        if (response.getRespondeCode() >= 400) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_InvalidResponse, response.getRespondeCode(), (Object)response.toString());
        }
        finish = System.nanoTime();
        LOGGER.log(String.format("End, CM output entity created - UUID: %s - elapsed time: %ds", this.uuid, (finish - start) / ONE_SECOND_IN_NANOS));
        this.successfulPhases[2] = true;
        this.throwIfCancelled();
        LOGGER.log(String.format("Start, Uploading dataset to CM - UUID: %s", this.uuid));
        start = System.nanoTime();
        locationHeaderValue = ContentServiceClient.extractLocationHeader(response);
        String outputStoreID = locationHeaderValue.substring(locationHeaderValue.lastIndexOf(SLASH_STR) + 1);
        this.cmClient.putData(outputStoreID, length, stream);
        finish = System.nanoTime();
        LOGGER.log(String.format("End, Dataset successfully uploaded to CM - UUID: %s - elapsed time: %ds", this.uuid, (finish - start) / ONE_SECOND_IN_NANOS));
        this.successfulPhases[3] = true;
        this.throwIfCancelled();
        LOGGER.log(String.format("Start, Generating base and smarts modules and triggering sampling query - UUID: %s", this.uuid));
        start = System.nanoTime();
        response = this.moserClient.postBaseModule(reportVersionStoreID);
        if (response.getRespondeCode() >= 400) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_InvalidResponse, response.getRespondeCode(), (Object)response.toString());
        }
        finish = System.nanoTime();
        LOGGER.log(String.format("End, Base and smarts modules and sampling query succeeded - UUID: %s - elapsed time: %ds", this.uuid, (finish - start) / ONE_SECOND_IN_NANOS));
        this.successfulPhases[4] = true;
        this.throwIfCancelled();
        LOGGER.log(String.format("Start, Updating dataDescriptor on output CM entity with timing info - UUID: %s", this.uuid));
        start = System.nanoTime();
        dataDescriptor.put((Object)"elapsedTimeMilli", (Object)((System.nanoTime() - begin) / 1000000L));
        payload = new JSONObject();
        payload.put((Object)TYPE_STR, (Object)"output");
        payload.put((Object)"dataDescriptor", (Object)dataDescriptor);
        payload.put((Object)"locale", (Object)this.execEnv.getRequestEnvironment().getRunLocaleStr());
        int statusCode = this.cmClient.updateCMEntity(outputStoreID, payload.toString());
        if (statusCode >= 400) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_InvalidResponse, statusCode, null);
        }
        finish = System.nanoTime();
        LOGGER.log(String.format("End, Successfully updated output CM entity with timing info - UUID: %s - elapsed time: %ds", this.uuid, (finish - start) / ONE_SECOND_IN_NANOS));
        this.successfulPhases[5] = true;
        return reportVersionStoreID;
    }

    @Override
    public String createDataset(RSAPIDataset masterDataset, RSAPIPartialDataset resultSet, String name) throws IOException {
        String string;
        long begin;
        boolean needToRemoveCubeName;
        FileInputStream fis;
        ParquetWriter pqWriter;
        boolean attemptedToClosePQWriter;
        RSAPIEdgeIterator edgeIterator;
        block16: {
            LOGGER.log(String.format("Start, Dataset Generation - UUID: %s", this.uuid));
            edgeIterator = null;
            attemptedToClosePQWriter = false;
            pqWriter = null;
            String filePath = Paths.get(this.storageLocation, name + PARQUET_EXTENSION).toAbsolutePath().toString();
            fis = null;
            needToRemoveCubeName = false;
            LOGGER.log(String.format("Start, Generating parquet file - UUID: %s", this.uuid));
            begin = System.nanoTime();
            this.execEnv.getCancelManager().addCancelHandler(new ParquetDatasetBuilderCancelHandler());
            Configuration hadoopConf = FlintUtils.getHadoopConfiguration();
            Path hadoopPath = new Path(filePath);
            RSAPIEdge edge = masterDataset.getEdge(0);
            edgeIterator = resultSet.edgeIterator(edge.getName());
            RSAPIEdgeRowset rowsetInfo = edge.getRootRowset();
            Element metadataField = ParquetDatasetBuilder.generateMasterDatasetAndExtendedInfo(masterDataset);
            Pair rowSchemaAndOriginalDataTypes = ParquetDatasetBuilder.generateParquetRowSchema(rowsetInfo);
            TabularRowSchema rowSchema = (TabularRowSchema)rowSchemaAndOriginalDataTypes.getFirst();
            Map column2OriginalDecType = (Map)rowSchemaAndOriginalDataTypes.getSecond();
            pqWriter = ((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)new DatasetParquetWriterBuilder(hadoopPath, (RowSchema)rowSchema).withParquetVersion(this.parquetVersion).withTimeZoneId(this.parquetVersion != ParquetVersionEnum.LEGACY ? ZoneId.of("UTC") : null).withConf(hadoopConf)).withCompressionCodec(this.codec)).withRowGroupSize(this.blockSize)).withPageSize(this.pageSize)).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_1_0)).build();
            ArrayRecord pqRecord = new ArrayRecord(rowSchema.getNumOfColumns());
            DatasetUtilHelper.RecordAssigner[] assigners = new DatasetUtilHelper.RecordAssigner[rowSchema.getNumOfColumns()];
            for (int i2 = 0; i2 < assigners.length; ++i2) {
                ColumnMetadata columnMd = rowSchema.getColumnMetadata(i2);
                assigners[i2] = DatasetUtilHelper.createRecordAssigner(columnMd, converterOpts.shouldRemoveTrailingSpaces(), converterOpts.getDecimalPolicy(), (DecimalType)column2OriginalDecType.get(i2));
            }
            int numColumns = rowsetInfo.getNumColumns();
            long numRows = 0L;
            ArrayList<Integer> filteredIdsList = new ArrayList<Integer>();
            RowsetInfo filteredRowsetInfo = new RowsetInfo();
            for (int i3 = 0; i3 < numColumns; ++i3) {
                RSAPIColumn column = rowsetInfo.getColumns()[i3];
                if (!column.getColumnRepresentsDataItemValue()) continue;
                ColumnInfo columnInfo = new ColumnInfo(column.getName(), column.getDatatype());
                filteredRowsetInfo.addColumnInfo(columnInfo);
                filteredIdsList.add(i3);
            }
            int[] filteredIds = ((Stream)filteredIdsList.stream().sequential()).mapToInt(i -> i).toArray();
            RowValue filteredRow = DataValueFactory.createRowValue(filteredRowsetInfo);
            RSAPIRow currentRow = edgeIterator.next();
            ROLAPContext.queryEnter((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            needToRemoveCubeName = ROLAPContext.setCurrentCubeName(edge.getDataset().getPlanningEnvironment());
            while (null != currentRow) {
                ++numRows;
                for (int i4 = 0; i4 < filteredIds.length; ++i4) {
                    filteredRow.setColumn(i4, currentRow.getColumn(filteredIds[i4]));
                }
                DatasetUtilHelper.convertRowToRecord(numRows, (WritableRecord)pqRecord, filteredRow, assigners);
                pqWriter.write((Object)pqRecord);
                if (numRows == this.nextCheckRowCount) {
                    this.nextCheckRowCount += 10000L;
                    this.throwIfCancelled();
                }
                currentRow = edgeIterator.next();
            }
            this.throwIfCancelled();
            attemptedToClosePQWriter = true;
            pqWriter.close();
            pqWriter = null;
            long end = System.nanoTime();
            LOGGER.log(String.format("End, Parquet file generated - UUID: %s - elapsed time: %ds", this.uuid, (end - begin) / ONE_SECOND_IN_NANOS));
            JSONObject datasetDescriptor = ParquetDatasetBuilder.generateDataDescriptor(end - begin, numRows, this.parquetVersion.getValue(), rowSchema.getNumOfColumns());
            this.successfulPhases[0] = true;
            String reportPath = this.execEnv.getRequestEnvironment().getReportPath();
            File f = new File(filePath);
            fis = FileUtils.openInputStream((File)f);
            if (null == reportPath || reportPath.isEmpty()) break block16;
            String reportVersion = this.invokeUploadProcess(reportPath, metadataField, datasetDescriptor, fis, f.length(), begin);
            LOGGER.log(String.format("End, Dataset Generation Successful - UUID: %s - Total elapsed time: %ds - Parquet File Info: %s", this.uuid, (System.nanoTime() - begin) / ONE_SECOND_IN_NANOS, datasetDescriptor.toString()));
            String string2 = reportVersion;
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
            ROLAPContext.queryExit((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
            if (edgeIterator != null) {
                edgeIterator.release();
            }
            if (pqWriter != null && !attemptedToClosePQWriter) {
                pqWriter.close();
            }
            IOUtils.closeQuietly((InputStream)fis);
            this.deleteDataset(name);
            return string2;
        }
        try {
            string = "";
        }
        catch (Exception e) {
            try {
                String failingPhases = IntStream.range(0, this.successfulPhases.length).sequential().filter(idx -> !this.successfulPhases[idx]).mapToObj(idx -> DatasetBuilderPhase.getPhase(idx).getPhaseDescription()).collect(Collectors.joining(",", "[", "]"));
                String details = String.format("UUID: %s - Total elapsed time: %ds - Cancelled: %s - Failing phases: %s - Error Message: %s", this.uuid, (System.nanoTime() - begin) / ONE_SECOND_IN_NANOS, this.isCancelled, failingPhases, e.getMessage());
                LOGGER.log(LogLevel.ERROR, String.format("End, Dataset Generation Failed - %s", details));
                throw new XQERuntimeException(XQEMessageKeys.PDB_FailCreateDataset, (Throwable)e, details);
            }
            catch (Throwable throwable) {
                ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
                ROLAPContext.queryExit((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
                if (edgeIterator != null) {
                    edgeIterator.release();
                }
                if (pqWriter != null && !attemptedToClosePQWriter) {
                    pqWriter.close();
                }
                IOUtils.closeQuietly(fis);
                this.deleteDataset(name);
                throw throwable;
            }
        }
        ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
        ROLAPContext.queryExit((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
        if (edgeIterator != null) {
            edgeIterator.release();
        }
        if (pqWriter != null && !attemptedToClosePQWriter) {
            pqWriter.close();
        }
        IOUtils.closeQuietly((InputStream)fis);
        this.deleteDataset(name);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDataset(ITabularResultSet iResultSet, String name) throws IOException {
        IReleasable tableIterator = null;
        ParquetWriter pqWriter = null;
        String filePath = Paths.get(this.storageLocation, name + PARQUET_EXTENSION).toAbsolutePath().toString();
        try {
            this.execEnv.getCancelManager().addCancelHandler(new ParquetDatasetBuilderCancelHandler());
            Configuration hadoopConf = FlintUtils.getHadoopConfiguration();
            Path hadoopPath = new Path(filePath);
            tableIterator = iResultSet.getTabularIterator();
            IRowsetInfo rowsetInfo = iResultSet.getTabularRowsetInfo();
            Pair rowSchemaAndOriginalDataTypes = ParquetDatasetBuilder.generateParquetRowSchema(rowsetInfo);
            TabularRowSchema rowSchema = (TabularRowSchema)rowSchemaAndOriginalDataTypes.getFirst();
            Map column2OriginalDecType = (Map)rowSchemaAndOriginalDataTypes.getSecond();
            pqWriter = ((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)new DatasetParquetWriterBuilder(hadoopPath, (RowSchema)rowSchema).withParquetVersion(this.parquetVersion).withTimeZoneId(this.parquetVersion != ParquetVersionEnum.LEGACY ? ZoneId.of("UTC") : null).withConf(hadoopConf)).withCompressionCodec(this.codec)).withRowGroupSize(this.blockSize)).withPageSize(this.pageSize)).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_1_0)).build();
            ArrayRecord pqRecord = new ArrayRecord(rowSchema.getNumOfColumns());
            DatasetUtilHelper.RecordAssigner[] assigners = new DatasetUtilHelper.RecordAssigner[rowSchema.getNumOfColumns()];
            for (int i = 0; i < assigners.length; ++i) {
                ColumnMetadata columnMd = rowSchema.getColumnMetadata(i);
                assigners[i] = DatasetUtilHelper.createRecordAssigner(columnMd, converterOpts.shouldRemoveTrailingSpaces(), converterOpts.getDecimalPolicy(), (DecimalType)column2OriginalDecType.get(i));
            }
            long numRows = 0L;
            IRow row = (IRow)tableIterator.next();
            while (null != row) {
                DatasetUtilHelper.convertRowToRecord(++numRows, (WritableRecord)pqRecord, row, assigners);
                pqWriter.write((Object)pqRecord);
                if (numRows == this.nextCheckRowCount) {
                    this.nextCheckRowCount += 10000L;
                    this.throwIfCancelled();
                    if (pqWriter.getDataSize() > this.maxSizeBytes) {
                        throw new XQERuntimeException(XQEMessageKeys.MSR_SnapshotSizeLimitExceeded, this.maxSizeBytes / 1024L);
                    }
                }
                row = (IRow)tableIterator.next();
            }
            this.throwIfCancelled();
            if (pqWriter.getDataSize() > this.maxSizeBytes) {
                throw new XQERuntimeException(XQEMessageKeys.MSR_SnapshotSizeLimitExceeded, this.maxSizeBytes / 1024L);
            }
        }
        finally {
            if (tableIterator != null) {
                tableIterator.release();
            }
            if (pqWriter != null) {
                pqWriter.close();
            }
        }
    }

    @Override
    public boolean deleteDataset(String datasetName) {
        String filePath = Paths.get(this.storageLocation, datasetName + PARQUET_EXTENSION).toAbsolutePath().toString();
        File file = new File(filePath);
        FileUtils.deleteQuietly((File)file);
        if (null != this.uuid) {
            file = new File(this.storageLocation);
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file.exists();
    }

    static {
        converterOpts.put((Object)"decimalPolicy", (Object)DecimalPolicy.MOST_SIGNIFICANT_DIGITS_REMOVAL);
        converterOpts.put((Object)"removeTrailingSpaces", (Object)true);
    }

    private class ParquetDatasetBuilderCancelHandler
    implements ICancelable {
        ParquetDatasetBuilderCancelHandler() {
        }

        @Override
        public void cancel() {
            ParquetDatasetBuilder.this.isCancelled = true;
        }

        @Override
        public synchronized void cancel(CancelRequestSourceEnum cancelSource) {
            throw new CancelUnsuccessfulException();
        }
    }

    private static enum DatasetBuilderPhase {
        PARQUET_FILE_GENERATION(0, "Parquet File Generation"),
        REPORT_VERSION_CM_ENTITY(1, "ReportVersion CM Entity Generation"),
        OUTPUT_CM_ENTITY(2, "Output CM Entity Generation"),
        PARQUET_FILE_UPLOAD(3, "Uploading Parquet File to CM"),
        BASE_SMARTS_MODULES(4, "Base, Smarts module Generation - Sampling Query Execution"),
        UPDATE_TIMINGS(5, "Updating timing info");

        private final int id;
        private final String value;

        private DatasetBuilderPhase(int idx, String v) {
            this.id = idx;
            this.value = v;
        }

        int getPhaseId() {
            return this.id;
        }

        String getPhaseDescription() {
            return this.value;
        }

        static DatasetBuilderPhase getPhase(int phaseId) {
            if (phaseId < 0 || phaseId >= DatasetBuilderPhase.values().length) {
                throw new IndexOutOfBoundsException(String.format("Phase Id '%d' is out of bounds", phaseId));
            }
            for (DatasetBuilderPhase phase : DatasetBuilderPhase.values()) {
                if (phaseId != phase.getPhaseId()) continue;
                return phase;
            }
            return null;
        }
    }
}

