/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.eviction;

import com.cognos.xqe.util.eviction.IMapEvictionQueue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class AbstractMapEvictionQueue<K, V>
implements IMapEvictionQueue<K, V> {
    protected final int mRetainSize;
    protected final IMapEvictionQueue.IEvictionTarget<K, V> mEvictionTarget;

    AbstractMapEvictionQueue(int retainSize, IMapEvictionQueue.IEvictionTarget<K, V> evictionTarget) {
        if (0 >= retainSize) {
            throw new IllegalArgumentException("0 >= retainSizet");
        }
        if (null == evictionTarget) {
            throw new IllegalArgumentException("null == evictionTarget");
        }
        this.mRetainSize = retainSize;
        this.mEvictionTarget = evictionTarget;
    }

    @Override
    public abstract int size();

    @Override
    public Map<String, Object> getEvictionStatistics() {
        Map<String, Object> result = this.getEvictionInconsistency();
        int evictionTargetSize = this.mEvictionTarget.size();
        result.put("evictionTargetSize", new Integer(evictionTargetSize));
        return result;
    }

    @Override
    public Map<String, Object> getEvictionInconsistency() {
        Set<K> queueEntriesNotInTheMap;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int evictionTargetSize = this.mEvictionTarget.size();
        int size = this.size();
        if (size != evictionTargetSize) {
            result.put("size", new Integer(size));
        }
        if (!(queueEntriesNotInTheMap = this.queueEntriesNotInTheMap()).isEmpty()) {
            result.put("queueEntriesNotInTheMap", queueEntriesNotInTheMap);
        }
        Set<K> mapEntriesNotInTheQueue = this.mapEntriesNotInTheQueue();
        if (!queueEntriesNotInTheMap.isEmpty()) {
            result.put("mapEntriesNotInTheQueue", mapEntriesNotInTheQueue);
        }
        return result;
    }

    protected abstract Set<K> keySet();

    protected Set<K> queueEntriesNotInTheMap() {
        HashSet<K> result = new HashSet<K>();
        result.addAll(this.mEvictionTarget.keySet());
        result.removeAll(this.keySet());
        return result;
    }

    protected Set<K> mapEntriesNotInTheQueue() {
        Set<K> result = this.keySet();
        result.removeAll(this.mEvictionTarget.keySet());
        return result;
    }

    protected static abstract class Entry<K, V>
    implements IMapEvictionQueue.IEntry<K, V> {
        protected final K mKey;
        protected final V mValue;

        public Entry(K key, V value) {
            this.mKey = key;
            this.mValue = value;
        }

        @Override
        public K getKey() {
            return this.mKey;
        }

        @Override
        public V getValue() {
            return this.mValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof IMapEvictionQueue.IEntry) {
                IMapEvictionQueue.IEntry rhs = (IMapEvictionQueue.IEntry)o;
                if (null == this.mValue) {
                    return null == rhs.getValue();
                }
                return this.mValue.equals(rhs.getValue());
            }
            return false;
        }

        public int hashCode() {
            if (null == this.mValue) {
                return 0;
            }
            return this.mValue.hashCode();
        }
    }
}

