/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.eviction;

import com.cognos.xqe.util.eviction.IEvictable;
import com.cognos.xqe.util.eviction.IMapEvictionQueue;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentMapWithEviction<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
IEvictable<K, V> {
    private static final long serialVersionUID = 1L;
    private final Map<K, IMapEvictionQueue.IEntry<K, V>> mMapImpl;
    private final ConcurrentMap<K, IMapEvictionQueue.IEntry<K, V>> mConcurrentMapImpl;
    private final IMapEvictionQueue<K, V> mEvictionQueue;
    private final AtomicReference<Set<K>> mKeySetRef;
    private final AtomicReference<Set<Map.Entry<K, V>>> mEntrySetRef;
    private final AtomicReference<Collection<V>> mValueCollectionRef;
    private final boolean mUpdateOnlyOnGet;
    IEvictable.IEvictionListener<K, V> mExternalEvictionListener;

    public ConcurrentMapWithEviction(int retainSize, IMapEvictionQueue.IEvictionQueueFactory<K, V> evictionQueueFactory, boolean updateOnlyOnGet, boolean useConcurrentHashMap) {
        if (useConcurrentHashMap) {
            this.mConcurrentMapImpl = new ConcurrentHashMap<K, IMapEvictionQueue.IEntry<K, V>>();
            this.mMapImpl = this.mConcurrentMapImpl;
        } else {
            this.mMapImpl = new Hashtable<K, IMapEvictionQueue.IEntry<K, V>>();
            this.mConcurrentMapImpl = null;
        }
        this.mEvictionQueue = evictionQueueFactory.newEvictionQueue(retainSize, new EvictionTarget());
        this.mKeySetRef = new AtomicReference<Object>(null);
        this.mEntrySetRef = new AtomicReference<Object>(null);
        this.mValueCollectionRef = new AtomicReference<Object>(null);
        this.mUpdateOnlyOnGet = updateOnlyOnGet;
        this.mExternalEvictionListener = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ConcurrentMapWithEviction) {
            ConcurrentMapWithEviction rhs = (ConcurrentMapWithEviction)o;
            return this.mMapImpl.equals(rhs.mMapImpl);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mMapImpl.hashCode();
    }

    @Override
    public String toString() {
        return this.mEvictionQueue.toString();
    }

    @Override
    public void clear() {
        Iterator<K> iterator;
        while ((iterator = this.mMapImpl.keySet().iterator()).hasNext()) {
            this.remove(iterator.next());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mMapImpl.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mMapImpl.containsValue(this.mEvictionQueue.newEntry(null, value));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set entrySet = this.mEntrySetRef.get();
        if (null == entrySet && !this.mEntrySetRef.compareAndSet(null, entrySet = new EntrySet())) {
            entrySet = this.mEntrySetRef.get();
        }
        return entrySet;
    }

    @Override
    public V get(Object key) {
        V value;
        IMapEvictionQueue.IEntry<K, V> entry = this.mMapImpl.get(key);
        if (null != entry) {
            entry.updateOnRecentUse();
            value = entry.getValue();
        } else {
            value = null;
        }
        return value;
    }

    private static <K, V> V getValueFromEvictionEntry(IMapEvictionQueue.IEntry<K, V> entry, boolean updateOnRecentUse) {
        V value;
        if (null != entry) {
            if (updateOnRecentUse) {
                entry.updateOnRecentUse();
            }
            value = entry.getValue();
        } else {
            value = null;
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.mMapImpl.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        Set keySet = this.mKeySetRef.get();
        if (null == keySet && !this.mKeySetRef.compareAndSet(null, keySet = new KeySet())) {
            keySet = this.mKeySetRef.get();
        }
        return keySet;
    }

    @Override
    public V put(K key, V value) {
        V result;
        if (null == key) {
            throw new IllegalArgumentException("null == key");
        }
        IMapEvictionQueue.IEntry<K, V> newEntry = this.mEvictionQueue.newEntry(key, value);
        IMapEvictionQueue.IEntry<K, V> oldEntry = this.mMapImpl.put(key, newEntry);
        if (null == oldEntry) {
            newEntry.updateOnAdd();
            result = null;
        } else {
            oldEntry.updateOnRemove();
            newEntry.updateOnAdd();
            result = oldEntry.getValue();
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V result;
        IMapEvictionQueue.IEntry<K, V> oldEntry = this.mMapImpl.remove(key);
        if (null == oldEntry) {
            result = null;
        } else {
            oldEntry.updateOnRemove();
            result = oldEntry.getValue();
        }
        return result;
    }

    private IMapEvictionQueue.IEntry<K, V> removeEntry(IMapEvictionQueue.IEntry<K, V> entry) {
        IMapEvictionQueue.IEntry<K, V> oldEntry = this.mMapImpl.remove(entry.getKey());
        if (null != oldEntry) {
            oldEntry.updateOnRemove();
        }
        return oldEntry;
    }

    @Override
    public int size() {
        return this.mMapImpl.size();
    }

    public int evictionQueueSize() {
        return this.mEvictionQueue.size();
    }

    @Override
    public IEvictable.IEvictionListener<K, V> setEvictionListener(IEvictable.IEvictionListener<K, V> evictionListener) {
        IEvictable.IEvictionListener<K, V> previous = this.mExternalEvictionListener;
        this.mExternalEvictionListener = evictionListener;
        return previous;
    }

    @Override
    public Map<String, Object> getEvictionStatistics() {
        return this.mEvictionQueue.getEvictionStatistics();
    }

    @Override
    public Map<String, Object> getEvictionInconsistency() {
        return this.mEvictionQueue.getEvictionInconsistency();
    }

    @Override
    public Collection<V> values() {
        Collection valueCollection = this.mValueCollectionRef.get();
        if (null == valueCollection && !this.mValueCollectionRef.compareAndSet(null, valueCollection = new ValueCollection())) {
            valueCollection = this.mValueCollectionRef.get();
        }
        return valueCollection;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V result;
        if (null == this.mConcurrentMapImpl) {
            throw new UnsupportedOperationException();
        }
        IMapEvictionQueue.IEntry<K, V> newEntry = this.mEvictionQueue.newEntry(key, value);
        IMapEvictionQueue.IEntry<K, V> oldEntry = this.mConcurrentMapImpl.putIfAbsent(key, newEntry);
        if (null == oldEntry) {
            newEntry.updateOnAdd();
            result = null;
        } else {
            result = oldEntry.getValue();
        }
        return result;
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(K key, V value) {
        return this.put(key, value);
    }

    @Override
    public boolean replace(K key, V value1, V value2) {
        throw new UnsupportedOperationException();
    }

    private final class EvictionTarget
    implements IMapEvictionQueue.IEvictionTarget<K, V> {
        private EvictionTarget() {
        }

        @Override
        public IMapEvictionQueue.IEntry<K, V> evictEntry(IMapEvictionQueue.IEntry<K, V> entry) {
            IMapEvictionQueue.IEntry removedEntry = ConcurrentMapWithEviction.this.removeEntry(entry);
            if (null != ConcurrentMapWithEviction.this.mExternalEvictionListener && null != removedEntry) {
                ConcurrentMapWithEviction.this.mExternalEvictionListener.onEvicted(removedEntry.getKey(), removedEntry.getValue());
            }
            return removedEntry;
        }

        @Override
        public int size() {
            return ConcurrentMapWithEviction.this.size();
        }

        @Override
        public Set<K> keySet() {
            return ConcurrentMapWithEviction.this.keySet();
        }
    }

    private final class MapEntry
    implements Map.Entry<K, V> {
        final Map.Entry<K, IMapEvictionQueue.IEntry<K, V>> mEntry;

        MapEntry(Map.Entry<K, IMapEvictionQueue.IEntry<K, V>> entry) {
            this.mEntry = entry;
        }

        @Override
        public K getKey() {
            return this.mEntry.getKey();
        }

        @Override
        public V getValue() {
            return ConcurrentMapWithEviction.getValueFromEvictionEntry(this.mEntry.getValue(), !ConcurrentMapWithEviction.this.mUpdateOnlyOnGet);
        }

        @Override
        public V setValue(V value) {
            return ConcurrentMapWithEviction.this.replace(this.mEntry.getKey(), value);
        }

        @Override
        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (o instanceof Map.Entry) {
                Map.Entry rhs = (Map.Entry)o;
                result = this.getKey().equals(rhs.getKey()) ? (null == this.getValue() ? null == rhs.getValue() : this.getValue().equals(rhs.getValue())) : false;
            } else {
                result = false;
            }
            return result;
        }

        @Override
        public int hashCode() {
            return this.mEntry.hashCode();
        }
    }

    private final class ValueCollectionIterator
    implements Iterator<V> {
        private final Iterator<IMapEvictionQueue.IEntry<K, V>> mIterImpl;
        private IMapEvictionQueue.IEntry<K, V> mLast;

        ValueCollectionIterator(Iterator<IMapEvictionQueue.IEntry<K, V>> iterImpl) {
            this.mIterImpl = iterImpl;
            this.mLast = null;
        }

        @Override
        public boolean hasNext() {
            return this.mIterImpl.hasNext();
        }

        @Override
        public V next() {
            this.mLast = this.mIterImpl.next();
            return ConcurrentMapWithEviction.getValueFromEvictionEntry(this.mLast, !ConcurrentMapWithEviction.this.mUpdateOnlyOnGet);
        }

        @Override
        public void remove() {
            if (null == this.mLast) {
                throw new IllegalStateException();
            }
            ConcurrentMapWithEviction.this.remove(this.mLast.getKey());
            this.mLast = null;
        }
    }

    private final class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueCollectionIterator(ConcurrentMapWithEviction.this.mMapImpl.values().iterator());
        }

        @Override
        public int size() {
            return ConcurrentMapWithEviction.this.size();
        }

        @Override
        public void clear() {
            ConcurrentMapWithEviction.this.clear();
        }

        @Override
        public boolean contains(Object value) {
            return ConcurrentMapWithEviction.this.containsValue(value);
        }
    }

    private final class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, IMapEvictionQueue.IEntry<K, V>>> mIterImpl;
        private Map.Entry<K, IMapEvictionQueue.IEntry<K, V>> mLast;

        EntrySetIterator(Iterator<Map.Entry<K, IMapEvictionQueue.IEntry<K, V>>> iterImpl) {
            this.mIterImpl = iterImpl;
            this.mLast = null;
        }

        @Override
        public boolean hasNext() {
            return this.mIterImpl.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.mLast = this.mIterImpl.next();
            return new MapEntry(this.mLast);
        }

        @Override
        public void remove() {
            if (null == this.mLast) {
                throw new IllegalStateException();
            }
            ConcurrentMapWithEviction.this.remove(this.mLast.getKey());
            this.mLast = null;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(ConcurrentMapWithEviction.this.mMapImpl.entrySet().iterator());
        }

        @Override
        public boolean contains(Object o) {
            boolean result;
            if (!(o instanceof Map.Entry)) {
                result = false;
            } else {
                Map.Entry rhsEntry = (Map.Entry)o;
                IMapEvictionQueue.IEntry lhsEntry = (IMapEvictionQueue.IEntry)ConcurrentMapWithEviction.this.mMapImpl.get(rhsEntry.getKey());
                if (null == lhsEntry) {
                    result = false;
                } else {
                    Object rhsValue = rhsEntry.getValue();
                    Object lhsValue = lhsEntry.getValue();
                    if (null == lhsValue) {
                        result = null == rhsValue;
                    } else {
                        result = lhsValue.equals(rhsValue);
                        if (result && !ConcurrentMapWithEviction.this.mUpdateOnlyOnGet) {
                            lhsEntry.updateOnRecentUse();
                        }
                    }
                }
            }
            return result;
        }

        @Override
        public boolean remove(Object o) {
            boolean result;
            if (!(o instanceof Map.Entry)) {
                result = false;
            } else {
                Map.Entry mapEntry = (Map.Entry)o;
                result = ConcurrentMapWithEviction.this.remove(mapEntry.getKey(), mapEntry.getValue());
            }
            return result;
        }

        @Override
        public int size() {
            return ConcurrentMapWithEviction.this.size();
        }

        @Override
        public void clear() {
            ConcurrentMapWithEviction.this.clear();
        }
    }

    private final class KeySetIterator
    implements Iterator<K> {
        final Iterator<K> mMapImplKeySetIterator;
        private K mLast;

        KeySetIterator(Iterator<K> mapImplKeySetIterator) {
            this.mMapImplKeySetIterator = mapImplKeySetIterator;
            this.mLast = null;
        }

        @Override
        public boolean hasNext() {
            return this.mMapImplKeySetIterator.hasNext();
        }

        @Override
        public K next() {
            this.mLast = this.mMapImplKeySetIterator.next();
            return this.mLast;
        }

        @Override
        public void remove() {
            if (null == this.mLast) {
                throw new IllegalStateException();
            }
            ConcurrentMapWithEviction.this.remove(this.mLast);
            this.mLast = null;
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator(ConcurrentMapWithEviction.this.mMapImpl.keySet().iterator());
        }

        @Override
        public int size() {
            return ConcurrentMapWithEviction.this.size();
        }

        @Override
        public boolean contains(Object key) {
            return ConcurrentMapWithEviction.this.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            return ConcurrentMapWithEviction.this.remove(key) != null;
        }

        @Override
        public void clear() {
            ConcurrentMapWithEviction.this.clear();
        }
    }
}

