/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.fds;

import java.util.HashMap;
import java.util.Map;

public enum FDSDataTypeEnum {
    ANY("any"),
    BOOLEAN("boolean"),
    PARAMETER_DATA_TYPE_1("@1", 1),
    PARAMETER_DATA_TYPE_2("@2", 2),
    PARAMETER_DATA_TYPE_3("@3", 3),
    STRING("string"),
    ANY_VALUE("anyValueDatatype"),
    ARRAY("array"),
    PARAMETER_MAP_REFERENCE("parameterMapReference"),
    KEYWORD("keyword"),
    INTEGER("integer"),
    INT16("int16"),
    INT32("int32"),
    INT64("int64"),
    DECIMAL("decimal"),
    NUMERIC("numeric"),
    FLOAT("float"),
    FLOAT32("float32"),
    FLOAT64("float64"),
    BINARY("binary"),
    LENGTH16("length16"),
    DATE("date"),
    TIME("time"),
    DATETIME("dateTime"),
    TIMEINTERVAL("timeInterval"),
    CHARACTER("character"),
    CHARACTER_LENGTH16("characterLength16"),
    CHARACTER_LENGTH32("characterLength32"),
    BLOB("blob"),
    TEXTBLOB("textBlob"),
    BLOBARRAY("blobArray"),
    DATABASEKEY("databaseKey"),
    SET("set"),
    DIMENSION("dimension"),
    HIERARCHY("hierarchy"),
    LEVEL("level"),
    MEMBER("member"),
    TUPLE("tuple"),
    MEMBERSET("memberSet"),
    MEASURE("measure"),
    CRX_DTYPE_UNKNOWN("crxDTypeUnknown"),
    CRX_DTYPE_STRING("crxDTypeString"),
    CRX_DTYPE_INT8("crxDTypeInt8"),
    CRX_DTYPE_UINT8("crxDTypeUInt8"),
    CRX_DTYPE_INT16("crxDTypeInt16"),
    CRX_DTYPE_UINT16("crxDTypeUInt16"),
    CRX_DTYPE_INT32("crxDTypeInt32"),
    CRX_DTYPE_UINT32("crxDTypeUInt32"),
    CRX_DTYPE_INT64("crxDTypeInt64"),
    CRX_DTYPE_UINT64("crxDTypeUInt64"),
    CRX_DTYPE_FLOAT("crxDTypeFloat"),
    CRX_DTYPE_DOUBLE("crxDTypeDouble"),
    CRX_DTYPE_DECIMAL("crxDTypeDecimal"),
    CRX_DTYPE_DATE("crxDTypeDate"),
    CRX_DTYPE_TIME("crxDTypeTime"),
    CRX_DTYPE_DATETIME("crxDTypeDatetime"),
    CRX_DTYPE_DTINTERVAL("crxDTypeDTInterval"),
    CRX_DTYPE_YMINTERVAL("crxDTypeYMInterval"),
    CRX_DTYPE_BLOB("crxDTypeBlob"),
    CRX_DTYPE_ROW_ITERATOR("crxDTypeRowIterator"),
    CRX_DTYPE_DIM_ITERATOR("crxDTypeDimIterator"),
    CRX_DTYPE_MASTER_DATASET("crxDTypeMasterDataset"),
    CRX_DTYPE_VARIANT("crxDTypeVariant"),
    CRX_DTYPE_BINARY("crxDTypeBinary"),
    CRX_DTYPE_VARBINARY("crxDTypeVarBinary"),
    CRX_DTYPE_MEMBERUNIQUENAME("crxDTypeMemberUniqueName"),
    CRX_DTYPE_MEMBERCAPTION("crxDTypeMemberCaption"),
    CRX_DTYPE_DIMENSIONUNIQUENAME("crxDTypeDimensionUniqueName"),
    CRX_DTYPE_PARENTUNIQUENAME("crxDTypeParentUniqueName"),
    CRX_DTYPE_DESCRIPTION("crxDTypeDescription"),
    CRX_DTYPE_HIERARCHYUNIQUENAME("crxDTypeHierarchyUniqueName"),
    CRX_DTYPE_PARENTLEVEL("crxDTypeParentLevel"),
    CRX_DTYPE_LEVELUNIQUENAME("crxDTypeLevelUniqueName"),
    CRX_DTYPE_LEVELNUMBER("crxDTypeLevelNumber"),
    CRX_DTYPE_LEVELLABEL("crxDTypeLevelLabel"),
    CRX_DTYPE_FORMATTEDVALUE("crxDTypeFormattedValue"),
    CRX_DTYPE_FONT("crxDTypeFont"),
    CRX_DTYPE_FORECOLOR("crxDTypeForeColor"),
    CRX_DTYPE_BACKCOLOR("crxDTypeBackColor"),
    CRX_DTYPE_FONTFLAGS("crxDTypeFontFlags"),
    CRX_DTYPE_ORDINAL("crxDTypeOrdinal"),
    CRX_DTYPE_NESTEDDIM("crxDTypeNestedDim"),
    CRX_DTYPE_NUMBEROFPARENTS("crxDTypeNumberOfParents"),
    CRX_DTYPE_MEMBERTYPE("crxDTypeMemberType"),
    CRX_DTYPE_HASCHILDREN("crxDTypeHasChildren"),
    CRX_DTYPE_EXTERNALBUFFER("crxDTypeExternalBuffer"),
    CRX_DTYPE_TEXTBLOB("crxDTypeTextBlob"),
    CRX_DTYPE_MIME("crxDTypeMIME"),
    CRX_DTYPE_URL("crxDTypeURL"),
    CRX_DTYPE_CURRENCY("crxDTypeCurrency"),
    CRX_DTYPE_TIMETZ("crxDTypeTimeTZ"),
    CRX_DTYPE_DATETIMETZ("crxDTypeDatetimeTZ"),
    CRX_DTYPE_LISTTYPE1("crxDTypeArgumentListType1"),
    CRX_DTYPE_LISTTYPE2("crxDTypeArgumentListType2"),
    CRX_DTYPE_RESULTTYPE_CONTEXTDEPENDENT("crxDTypeResultTypeContextDependent");

    private final String fdsKeyword;
    private final int parameterDataTypePosition;
    private static final Map<String, FDSDataTypeEnum> FDS_ENUM_MAP;

    private FDSDataTypeEnum(String theFdsKeyword) {
        this(theFdsKeyword, -1);
    }

    private FDSDataTypeEnum(String theFdsKeyword, int theParameterDataTypePosition) {
        this.fdsKeyword = theFdsKeyword;
        this.parameterDataTypePosition = theParameterDataTypePosition;
    }

    public String toFDSKeyword() {
        return this.fdsKeyword;
    }

    public int getParameterDataTypePosition() {
        return this.parameterDataTypePosition;
    }

    public static FDSDataTypeEnum fromFDS(String fdsKeyword) {
        return FDS_ENUM_MAP.get(fdsKeyword);
    }

    public boolean isEquivalent(FDSDataTypeEnum targetDataType) {
        if (this == targetDataType || this == ANY_VALUE && targetDataType.isValueType() || this.isValueType() && targetDataType == ANY_VALUE || this == ANY || targetDataType == ANY) {
            return true;
        }
        if (this == NUMERIC && (targetDataType == FLOAT || targetDataType == INTEGER) || this == FLOAT && (targetDataType == NUMERIC || targetDataType == INTEGER) || this == INTEGER && (targetDataType == FLOAT || targetDataType == NUMERIC)) {
            return true;
        }
        if (this == SET && targetDataType == MEMBERSET || this == MEMBERSET && targetDataType == SET) {
            return true;
        }
        return this == STRING && targetDataType == CHARACTER || this == CHARACTER && targetDataType == STRING;
    }

    public boolean isValueType() {
        switch (this) {
            case ANY_VALUE: 
            case CHARACTER: 
            case DATE: 
            case DATETIME: 
            case FLOAT: 
            case INTEGER: 
            case NUMERIC: 
            case STRING: 
            case TIME: 
            case TIMEINTERVAL: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumeric() {
        switch (this) {
            case ANY_VALUE: 
            case FLOAT: 
            case INTEGER: 
            case NUMERIC: {
                return true;
            }
        }
        return false;
    }

    public boolean isOLAP() {
        switch (this) {
            case DIMENSION: 
            case HIERARCHY: 
            case LEVEL: 
            case MEASURE: 
            case MEMBER: 
            case MEMBERSET: 
            case SET: 
            case TUPLE: {
                return true;
            }
        }
        return false;
    }

    static {
        FDS_ENUM_MAP = new HashMap<String, FDSDataTypeEnum>(FDSDataTypeEnum.values().length);
        for (FDSDataTypeEnum e : FDSDataTypeEnum.values()) {
            FDS_ENUM_MAP.put(e.toFDSKeyword(), e);
        }
    }
}

