/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.fds;

import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import com.cognos.xqe.util.fds.FunctionDefinition;
import com.cognos.xqe.util.fds.FunctionParameter;
import com.cognos.xqe.util.fds.FunctionPoolDLL;
import com.cognos.xqe.util.fds.FunctionPoolNode;
import com.cognos.xqe.util.fds.FunctionPoolParameter;
import com.cognos.xqe.util.fds.IFunctionDLL;
import com.cognos.xqe.util.fds.IFunctionDefinition;
import com.cognos.xqe.util.fds.IFunctionNode;
import com.cognos.xqe.util.fds.IFunctionParameter;
import com.cognos.xqe.util.fds.MultiTreeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class FunctionNode
implements IFunctionNode {
    static ArrayList<String> emptyList = new ArrayList();
    private FunctionPoolNode poolNode;
    private ArrayList<IFunctionNode> children = new ArrayList();
    private FunctionDefinition functionDefinition;
    private String groupId;
    private String groupName;
    private boolean poolDataIsLoaded;

    public FunctionNode(FunctionDefinition owner, FunctionPoolNode pNode) {
        this.poolNode = pNode;
        this.functionDefinition = owner;
        this.poolDataIsLoaded = false;
        this.groupId = "";
        this.groupName = "";
    }

    public FunctionNode(FunctionDefinition owner, String id, String name) {
        this.functionDefinition = owner;
        this.groupId = id;
        this.groupName = name;
        this.poolDataIsLoaded = false;
    }

    @Override
    public boolean isGroup() {
        return this.getType() == IFunctionNode.FDSFunctionTypeEnum.GROUP;
    }

    @Override
    public ArrayList<IFunctionNode> getChildren() {
        if (!this.poolDataIsLoaded && this.poolNode != null) {
            this.poolDataIsLoaded = true;
            ArrayList<FunctionPoolNode> nodeList = this.poolNode.getChildList();
            if (null == nodeList) {
                return null;
            }
            ArrayList<IFunctionNode> temporaryChildren = new ArrayList<IFunctionNode>();
            temporaryChildren.addAll(this.children);
            this.children.clear();
            MultiTreeMap<String, FunctionNode> orderedChildrenMultiMap = new MultiTreeMap<String, FunctionNode>();
            ArrayList<FunctionNode> advancedGroup = new ArrayList<FunctionNode>();
            for (FunctionPoolNode fpNode : nodeList) {
                if (!this.functionDefinition.passesHiddenFilter(fpNode) || !this.functionDefinition.passesDimensionalFilter(fpNode) || !this.functionDefinition.passesTypeFilter(fpNode) || !this.functionDefinition.passesContextFilter(fpNode) || !this.functionDefinition.passesVendorFunctionSetFilter(fpNode) || !this.functionDefinition.passesQueryModeFilter(fpNode)) continue;
                FunctionNode fNode = this.functionDefinition.getNodeForPoolNode(fpNode);
                IFunctionNode.FDSFunctionTypeEnum nodeType = fNode.getType();
                if (nodeType != IFunctionNode.FDSFunctionTypeEnum.GROUP && nodeType != IFunctionNode.FDSFunctionTypeEnum.UNKNOWN && nodeType != IFunctionNode.FDSFunctionTypeEnum.OPERATION) {
                    String theName = fNode.getName();
                    orderedChildrenMultiMap.putValue(theName, fNode);
                    continue;
                }
                String functGroupId = fNode.getId();
                if (0 == functGroupId.indexOf("advanced")) {
                    advancedGroup.add(fNode);
                    continue;
                }
                this.children.add(fNode);
            }
            if (orderedChildrenMultiMap.size() > 0) {
                Collection funcNodes = orderedChildrenMultiMap.getAllValues();
                this.children.addAll(funcNodes);
            }
            for (int i = 0; i < advancedGroup.size(); ++i) {
                this.children.add((IFunctionNode)advancedGroup.get(i));
            }
            this.children.addAll(temporaryChildren);
        }
        ArrayList<IFunctionNode> updatedChildrenList = new ArrayList<IFunctionNode>();
        updatedChildrenList.addAll(this.children);
        return updatedChildrenList;
    }

    @Override
    public String getCanonical() {
        if (this.poolNode != null) {
            return this.poolNode.getCanonical();
        }
        return "";
    }

    @Override
    public String getCanonicalExpression() {
        if (this.poolNode != null) {
            return this.poolNode.getCanonicalExpression();
        }
        return "";
    }

    static ArrayList<String> getEmptyStringVector() {
        return emptyList;
    }

    ArrayList<String> getContexts() {
        if (this.poolNode != null) {
            return this.poolNode.getContexts();
        }
        return FunctionNode.getEmptyStringVector();
    }

    @Override
    public IFunctionDLL getDLL() {
        if (this.poolNode == null) {
            return null;
        }
        FunctionPoolDLL pdll = this.poolNode.getDLL();
        if (pdll == null) {
            return null;
        }
        return this.functionDefinition.getDLL(pdll.getDLLName());
    }

    @Override
    public String getId() {
        if (this.poolNode != null) {
            return this.poolNode.getId();
        }
        return this.groupId;
    }

    @Override
    public String getName() {
        if (this.poolNode != null) {
            return this.poolNode.getName(this.functionDefinition.getEffectiveLocale());
        }
        return this.groupName;
    }

    @Override
    public List<String> getParameterTypes() {
        ArrayList<String> types = new ArrayList<String>();
        if (this.poolNode != null) {
            ArrayList<FunctionPoolParameter> parms = this.poolNode.getParameters();
            for (int i = 0; i < parms.size(); ++i) {
                types.add(parms.get(i).getTypeString());
            }
        }
        return types;
    }

    @Override
    public ArrayList<IFunctionParameter> getParameters() {
        ArrayList<IFunctionParameter> paramList = new ArrayList<IFunctionParameter>();
        if (this.poolNode != null) {
            ArrayList<FunctionPoolParameter> parms = this.poolNode.getParameters();
            for (int i = 0; i < parms.size(); ++i) {
                FunctionParameter np = new FunctionParameter(this, parms.get(i));
                paramList.add(np);
            }
        }
        return paramList;
    }

    @Override
    public String getProperty(String prop) {
        if (this.poolNode != null) {
            return this.poolNode.getProperty(this.functionDefinition.getEffectiveLocale(), prop);
        }
        if (prop.length() == 0) {
            return this.groupName;
        }
        return "";
    }

    @Override
    public FDSDataTypeEnum getReturnType() {
        if (this.poolNode != null) {
            return this.poolNode.getReturnType();
        }
        return null;
    }

    @Override
    public String getFormatType() {
        if (this.poolNode != null) {
            return this.poolNode.getFormatType();
        }
        return "";
    }

    @Override
    public String getUsage() {
        if (this.poolNode != null) {
            return this.poolNode.getUsage();
        }
        return "";
    }

    @Override
    public String getTip() {
        if (this.poolNode != null) {
            String override = this.functionDefinition.getQoSReasonOverride(this.getId());
            if (override.length() > 0) {
                String tipAndReason = this.poolNode.getTip(this.functionDefinition.getEffectiveLocale());
                String updatedTipAndReason = tipAndReason + "\n" + override;
                return updatedTipAndReason;
            }
            return this.poolNode.getTip(this.functionDefinition.getEffectiveLocale());
        }
        return "";
    }

    @Override
    public IFunctionNode.FDSFunctionTypeEnum getType() {
        if (this.poolNode == null) {
            if (this.groupName != null) {
                return IFunctionNode.FDSFunctionTypeEnum.GROUP;
            }
            return IFunctionNode.FDSFunctionTypeEnum.UNKNOWN;
        }
        return this.poolNode.getType();
    }

    @Override
    public String getSyntax() {
        if (this.poolNode != null) {
            return this.poolNode.getSyntax(this.functionDefinition.getEffectiveLocale());
        }
        return "";
    }

    @Override
    public IFunctionNode.FDSQoSLevelEnum getQoSLevel() {
        IFunctionNode.FDSQoSLevelEnum qosLevel = this.functionDefinition.getQoSLevel(this.getId());
        if (qosLevel != null) {
            return qosLevel;
        }
        qosLevel = IFunctionNode.FDSQoSLevelEnum.UNSPECIFIED;
        if (this.poolNode == null) {
            return IFunctionNode.FDSQoSLevelEnum.OK;
        }
        qosLevel = IFunctionNode.FDSQoSLevelEnum.OK;
        IFunctionNode.FDSQoSLevelEnum computedQosLevel = IFunctionNode.FDSQoSLevelEnum.UNSPECIFIED;
        boolean computed = false;
        int filtersSize = 0;
        int matchCount = 0;
        block5: for (int i = 0; i < this.poolNode.gosRules.size(); ++i) {
            FunctionPoolNode.QosRule rule = this.poolNode.gosRules.get(i);
            if (rule == null) {
                return qosLevel;
            }
            switch (rule.getQosRuleType()) {
                case eRDefault: {
                    qosLevel = rule.getQosRuleValue();
                    continue block5;
                }
                case eRDatasourceQueryType: {
                    filtersSize = this.functionDefinition.modelDatasourceQueryTypeFilters.size();
                    if (filtersSize == 0) {
                        computedQosLevel = IFunctionDefinition.Util.consolidateQosLevels(computedQosLevel, rule.getQosRuleValue());
                        computed = true;
                        continue block5;
                    }
                    for (String key : this.functionDefinition.modelDatasourceQueryTypeFilters) {
                        if (!key.equals(rule.getQosRuleKey())) continue;
                        computedQosLevel = IFunctionDefinition.Util.consolidateQosLevels(computedQosLevel, rule.getQosRuleValue());
                        ++matchCount;
                        computed = true;
                        continue block5;
                    }
                    continue block5;
                }
                case eRDatasourceInterfaceID: {
                    filtersSize = this.functionDefinition.modelDatasourceInterfaceIDFilters.size();
                    if (filtersSize == 0) {
                        computedQosLevel = IFunctionDefinition.Util.consolidateQosLevels(computedQosLevel, rule.getQosRuleValue());
                        computed = true;
                        continue block5;
                    }
                    for (String key : this.functionDefinition.modelDatasourceInterfaceIDFilters) {
                        if (!key.equals(rule.getQosRuleKey())) continue;
                        computedQosLevel = IFunctionDefinition.Util.consolidateQosLevels(computedQosLevel, rule.getQosRuleValue());
                        ++matchCount;
                        computed = true;
                        continue block5;
                    }
                    continue block5;
                }
            }
        }
        if (filtersSize > matchCount) {
            computedQosLevel = IFunctionDefinition.Util.consolidateQosLevels(computedQosLevel, qosLevel);
            computed = true;
        }
        if (computed) {
            return computedQosLevel;
        }
        return qosLevel;
    }

    @Override
    public boolean mayBeSupportedByAnotherModelDatasourceInterfaceID(String interfaceID) {
        if (!IFunctionDefinition.Util.isInterfaceIDSupported(IFunctionDefinition.InterfaceIDType.eRelationalInterfaceIDs, interfaceID)) {
            return false;
        }
        if (this.poolNode != null) {
            return this.poolNode.mayBeSupportedByAnotherModelDatasourceInterfaceID();
        }
        return false;
    }

    @Override
    public boolean isMemberRelativeFunction() {
        if (this.poolNode != null) {
            return this.poolNode.isMemberRelativeFunction();
        }
        return false;
    }

    @Override
    public boolean isSupportedByModelDatasourceInterfaceID(String inputInterfaceID) {
        if (this.poolNode == null) {
            return false;
        }
        String interfaceID = inputInterfaceID;
        String upperCaseInterfaceID = interfaceID.toUpperCase();
        ArrayList<String> interfaceIDs = this.poolNode.getModelDatasourceInterfaceIDs();
        if (interfaceIDs.contains(upperCaseInterfaceID)) {
            return true;
        }
        if (interfaceIDs.size() != 0) {
            return false;
        }
        for (FunctionPoolNode currentNode = this.poolNode.getParent(); currentNode != null; currentNode = currentNode.getParent()) {
            ArrayList<String> grpInterfaceIDs = currentNode.getModelDatasourceInterfaceIDs();
            if (grpInterfaceIDs.contains(upperCaseInterfaceID)) {
                return true;
            }
            if (grpInterfaceIDs.size() == 0) continue;
            return false;
        }
        TreeSet<String> allInterfaceIDs = this.poolNode.thePool.getModelDataSourceInterfaceIDs();
        return allInterfaceIDs.contains(upperCaseInterfaceID);
    }

    @Override
    public IFunctionNode addAppGroup(String id, String name) {
        IFunctionNode fnode = this.functionDefinition.findById(id);
        if (fnode != null) {
            return fnode;
        }
        fnode = new FunctionNode(this.functionDefinition, id, name);
        this.functionDefinition.addAppGroup(id, fnode);
        this.children.add(fnode);
        return fnode;
    }

    @Override
    public IFunctionNode addAppFunction(String id, String name, IFunctionNode node) {
        this.functionDefinition.addAppFunction(id, name, node);
        this.children.add(node);
        return null;
    }

    void setPoolNode(FunctionPoolNode node) {
        this.poolNode = node;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public List<IFunctionDefinition.ParameterMismatch> matchParameters(List<FDSDataTypeEnum> theParameterTypes) {
        ArrayList<IFunctionDefinition.ParameterMismatch> mismatches = null;
        int parameterIdx = 0;
        if (theParameterTypes.size() == 0) {
            return null;
        }
        for (IFunctionParameter functionParameter : this.getParameters()) {
            List<FDSDataTypeEnum> types = functionParameter.getTypes();
            if (types.size() == 1 && types.get(0) == FDSDataTypeEnum.KEYWORD) continue;
            int maxOccurs = functionParameter.getMaxOccurs();
            for (int occursIdx = 0; occursIdx < maxOccurs || maxOccurs == -1 && parameterIdx < theParameterTypes.size(); ++parameterIdx, ++occursIdx) {
                FDSDataTypeEnum typeToMatch = theParameterTypes.get(parameterIdx);
                boolean matchFound = false;
                boolean isOLAPParameter = true;
                for (FDSDataTypeEnum expectedType : types) {
                    if (expectedType.isEquivalent(typeToMatch)) {
                        matchFound = true;
                        break;
                    }
                    isOLAPParameter = isOLAPParameter && expectedType.isOLAP();
                }
                if (matchFound) continue;
                if (mismatches == null) {
                    mismatches = new ArrayList<IFunctionDefinition.ParameterMismatch>();
                }
                mismatches.add(new IFunctionDefinition.ParameterMismatch(parameterIdx, functionParameter, isOLAPParameter));
            }
            if (parameterIdx < theParameterTypes.size()) continue;
            break;
        }
        return mismatches;
    }

    @Override
    public boolean hasSameParameters(IFunctionNode theTargetFunction) {
        ArrayList<FunctionPoolParameter> thisParams = this.poolNode.getParameters();
        ArrayList<IFunctionParameter> targetParams = theTargetFunction.getParameters();
        if (thisParams.size() != targetParams.size()) {
            return false;
        }
        for (int i = 0; i < thisParams.size(); ++i) {
            FunctionPoolParameter thisParam = thisParams.get(i);
            IFunctionParameter targetParam = targetParams.get(i);
            if (thisParam.getMinOccurs() != targetParam.getMinOccurs() || thisParam.getMaxOccurs() != targetParam.getMaxOccurs()) {
                return false;
            }
            List<FDSDataTypeEnum> thisTypes = thisParam.getTypes();
            List<FDSDataTypeEnum> targetTypes = targetParam.getTypes();
            if (thisTypes.size() != targetTypes.size()) {
                return false;
            }
            for (FDSDataTypeEnum thisType : thisTypes) {
                if (targetTypes.contains((Object)thisType)) continue;
                return false;
            }
        }
        return true;
    }
}

