/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.fds;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.util.JarManifestResourceMatcher;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.ResourceLocator;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import com.cognos.xqe.util.fds.FDSException;
import com.cognos.xqe.util.fds.FunctionPoolDLL;
import com.cognos.xqe.util.fds.FunctionPoolNode;
import com.cognos.xqe.util.fds.FunctionPoolParameter;
import com.cognos.xqe.util.fds.IFunctionNode;
import com.cognos.xqe.util.fds.MultiTreeMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class FunctionPool {
    public static final String DEV_FUNCTION_DIR = "../../src/prod/Utility/FDS";
    public static final String FUNCTION_DIR = "/functions";
    public static final String FUNCTION_DIR_SEPARATOR = "/";
    private static final String FILE_LIST = "FileList.xml";
    private static final String TYPE = "type";
    private static final String FORMAT = "format";
    private static final String CONTEXT = "context";
    private static final String QUERYMODE = "queryMode";
    private static final String VENDOR = "vendor";
    private static final String OPTIONAL = "optional";
    private static final String TRUE = "true";
    private static final String ID = "id";
    private static final String INTERFACE = "interface";
    private static final String MAY_BE_SUPPORTED_BY_ANOTHER_INTERFACE = "mayBeSupportedByAnotherInterface";
    private static final String MEMBER_RELATIVE_FUNCTION = "memberRelativeFunction";
    private String dirPath;
    private static SingletonHelper<FunctionPool> singletonHelper = new SingletonHelper<FunctionPool>(){

        @Override
        protected FunctionPool newInstance() {
            return new FunctionPool();
        }

        @Override
        protected void releaseImpl(FunctionPool theInstance) {
        }

        @Override
        protected void initializeImpl(FunctionPool theInstance) {
        }
    };
    private List<ResourceLocator.IResourceMatcher> resourceSearchPath;
    private boolean sgInDevMode = false;
    private ArrayList<String> definitionFiles = new ArrayList();
    private TreeMap<String, ArrayList<String>> descriptionFiles = new TreeMap();
    private ArrayList<Locale> loadedLocales = new ArrayList();
    private ArrayList<String> vendorFunctionSetIds = new ArrayList();
    private TreeSet<String> modelDatasourceInterfaceIDs = new TreeSet();
    private FunctionPoolNode root;
    private TreeMap<String, FunctionPoolNode> idToFunction = new TreeMap();
    private MultiTreeMap<String, FunctionPoolNode> nameToFunctions = new MultiTreeMap();
    private TreeMap<String, TreeMap<String, String>> localeToStringMap = new TreeMap();
    private TreeMap<String, FunctionPoolDLL> dllInfo = new TreeMap();

    public static FunctionPool getInstance() {
        return singletonHelper.getInstance();
    }

    FunctionPoolNode findById(String functionId) {
        FunctionPoolNode fNode = null;
        if (this.idToFunction.containsKey(functionId)) {
            fNode = this.idToFunction.get(functionId);
        }
        return fNode;
    }

    public ArrayList<FunctionPoolNode> findByName(String funcName) {
        ArrayList<FunctionPoolNode> fpList = new ArrayList<FunctionPoolNode>();
        List list = new ArrayList();
        String lcaseFuncName = funcName;
        if (this.nameToFunctions.containsKey(lcaseFuncName = lcaseFuncName.toLowerCase())) {
            list = (List)this.nameToFunctions.get(lcaseFuncName);
            Iterator fpIter = list.iterator();
            while (fpIter.hasNext()) {
                fpList.add((FunctionPoolNode)fpIter.next());
            }
        }
        return fpList;
    }

    FunctionPoolNode findFirstByName(String funcName) {
        String lcaseFuncName = funcName;
        lcaseFuncName = lcaseFuncName.toLowerCase();
        FunctionPoolNode fNode = null;
        if (this.nameToFunctions.containsKey(lcaseFuncName)) {
            fNode = this.idToFunction.get(lcaseFuncName);
        }
        return fNode;
    }

    Map<String, FunctionPoolDLL> getDLLs() {
        return this.dllInfo;
    }

    ArrayList<FunctionPoolNode> getFunctionIds() {
        return null;
    }

    FunctionPoolNode getRoot() {
        return this.root;
    }

    String getString(Locale locale, String stringId) {
        TreeMap<String, String> idToStringMap;
        String localeName;
        if (this.isLocaleLoaded(locale) && this.localeToStringMap.containsKey(localeName = LocaleConverter.toString(locale)) && (idToStringMap = this.localeToStringMap.get(localeName)).containsKey(stringId)) {
            String str = idToStringMap.get(stringId);
            return str;
        }
        return "";
    }

    TreeSet<String> getSupportedLocaleNames() {
        TreeSet<String> suppLocaleNames = new TreeSet<String>();
        for (Map.Entry<String, ArrayList<String>> pairs : this.descriptionFiles.entrySet()) {
            suppLocaleNames.add(pairs.getKey());
        }
        return suppLocaleNames;
    }

    void getVendorFunctionSets(Locale locale, ArrayList<String> vendorFunctSetIds, ArrayList<String> vendorFuctNames) {
        int i = 0;
        for (i = 0; i < this.vendorFunctionSetIds.size(); ++i) {
            vendorFunctSetIds.add(this.vendorFunctionSetIds.get(i));
            vendorFuctNames.add(this.getString(locale, this.vendorFunctionSetIds.get(i)));
        }
    }

    void getVendorFunctionSetIds(ArrayList<String> vendorFunctSetIds) {
        int i = 0;
        for (i = 0; i < this.vendorFunctionSetIds.size(); ++i) {
            vendorFunctSetIds.add(this.vendorFunctionSetIds.get(i));
        }
    }

    ArrayList<String> getSupportedModelDatasourceInterfaceIDs() {
        ArrayList<String> interfaceIDs = new ArrayList<String>();
        for (String id : this.modelDatasourceInterfaceIDs) {
            interfaceIDs.add(id);
        }
        return interfaceIDs;
    }

    protected void loadFunctionDescriptionStrings(Locale locale) {
        block7: {
            if (this.isLocaleLoaded(locale)) break block7;
            this.loadedLocales.add(locale);
            if (!this.descriptionFiles.containsKey(LocaleConverter.toString(locale))) {
                if (this.descriptionFiles.size() == 0) {
                    String availLocales = "no locales are available";
                } else {
                    String availLocales = "Available locales: ";
                    Iterator<Map.Entry<String, ArrayList<String>>> it = this.descriptionFiles.entrySet().iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Map.Entry<String, ArrayList<String>> pairs = it.next();
                        String theLocale = pairs.getKey();
                        if (i != 0) {
                            availLocales = availLocales + ", ";
                        }
                        availLocales = availLocales + theLocale;
                        ++i;
                    }
                }
            } else {
                ArrayList<String> fileList = this.descriptionFiles.get(LocaleConverter.toString(locale));
                for (String fileName : fileList) {
                    URL url = ResourceLocator.findURL(fileName, this.resourceSearchPath);
                    this.loadTextStrings(locale, url);
                }
            }
        }
    }

    void registerVendorFunctionSetId(String theVendorFunctionSetId) {
        if (!this.vendorFunctionSetIds.contains(theVendorFunctionSetId)) {
            this.vendorFunctionSetIds.add(theVendorFunctionSetId);
        }
    }

    void registerModelDatasourceInterfaceID(String theInterfaceID) {
        String theInterfaceIDUC = theInterfaceID;
        theInterfaceIDUC = theInterfaceIDUC.toUpperCase();
        this.modelDatasourceInterfaceIDs.add(theInterfaceIDUC);
    }

    void setInDevMode() {
        this.sgInDevMode = true;
    }

    private FunctionPool() {
        this.loadedLocales = new ArrayList();
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.root = null;
        this.dirPath = this.sgInDevMode ? DEV_FUNCTION_DIR : xqeConfig.getConfigDirectory() + FUNCTION_DIR;
        ICCLConfiguration config = XQECCLConfigurationFactory.getInstance();
        this.dirPath = config.resolveEffectivePath(this.dirPath);
        this.resourceSearchPath = new ArrayList<ResourceLocator.IResourceMatcher>();
        this.resourceSearchPath.add(new ResourceLocator.DirectoryResourceMatcher(new File(this.dirPath)));
        this.resourceSearchPath.add(new ResourceLocator.ClassResourceMatcher(this.getClass(), "/META-INF/xqe/configuration/functions"));
        List<URL> fileListResources = FunctionPool.discoverFileLists(this.resourceSearchPath);
        if (fileListResources.isEmpty()) {
            throw new FDSException("FDS: missing, empty or inaccessible directory: " + this.dirPath);
        }
        for (URL url : fileListResources) {
            this.loadFileList(url);
        }
        this.loadFunctions();
        this.loadAllFunctionDescriptionStrings();
    }

    private static List<URL> discoverFileLists(List<ResourceLocator.IResourceMatcher> path) {
        ArrayList<ResourceLocator.IResourceMatcher> paths = new ArrayList<ResourceLocator.IResourceMatcher>(path);
        ClassLoader loader = FunctionPool.class.getClassLoader();
        paths.add(new JarManifestResourceMatcher(loader, "com/cognos/xqe/util/fds/filelist", "XX-FileList"));
        Iterable<URL> fileListResourceUrls = ResourceLocator.findMatchingURLs("FileList*.xml", paths);
        ArrayList<URL> answer = new ArrayList<URL>(IteratorUtils.toList(fileListResourceUrls.iterator()));
        Collections.sort(answer, new Comparator<URL>(){

            @Override
            public int compare(URL o1, URL o2) {
                if (FilenameUtils.getBaseName((String)o1.getFile()).compareToIgnoreCase(FunctionPool.FILE_LIST) == 0) {
                    return -1;
                }
                return 0;
            }
        });
        return answer;
    }

    public String getDirectoryPath() {
        return this.dirPath;
    }

    private void loadAllFunctionDescriptionStrings() {
        TreeSet<String> locList = this.getSupportedLocaleNames();
        Iterator it = locList.iterator();
        while (it.hasNext()) {
            Locale theLocale = new Locale((String)it.next());
            this.loadFunctionDescriptionStrings(theLocale);
        }
    }

    private boolean isLocaleLoaded(Locale locale) {
        return this.loadedLocales.contains(locale);
    }

    public static Document parseXmlFile(URL url) {
        InputStream input = null;
        Document document = null;
        try {
            input = url.openStream();
            document = FunctionPool.parseXmlFile(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        return document;
    }

    public static Document parseXmlFile(InputStream input) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = docBuilderFactory.newDocumentBuilder();
            doc = builder.parse(input);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce.getMessage());
        }
        catch (SAXException se) {
            throw new RuntimeException(se.getMessage());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        return doc;
    }

    private void recursiveAddTextContent(Node n, StringBuilder buffer) {
        if (n != null) {
            if (n.getNodeType() == 3 || n.getNodeType() == 4) {
                buffer.append(n.getNodeValue());
            }
            NodeList nodes = n.getChildNodes();
            int ct = nodes.getLength();
            for (int i = 0; i < ct; ++i) {
                Node child = nodes.item(i);
                this.recursiveAddTextContent(child, buffer);
            }
        }
    }

    private String getTextContent(Element e) {
        StringBuilder buffer = new StringBuilder();
        this.recursiveAddTextContent(e, buffer);
        return buffer.toString();
    }

    private void loadFileList(URL fileName) {
        ICCLConfiguration config = CCLConfigurationFactory.getInstance();
        Document doc = FunctionPool.parseXmlFile(fileName);
        NodeList domDefinitionList = doc.getElementsByTagName("definition");
        for (int i = 0; i < domDefinitionList.getLength(); ++i) {
            Element elem;
            String defFile;
            Node node = domDefinitionList.item(i);
            if (1 != node.getNodeType() || (defFile = this.getTextContent(elem = (Element)node)).length() == 0) continue;
            this.definitionFiles.add(defFile);
        }
        NodeList domDescriptionList = doc.getElementsByTagName("description");
        for (int i = 0; i < domDescriptionList.getLength(); ++i) {
            Node node = domDescriptionList.item(i);
            if (1 != node.getNodeType()) continue;
            Element elem = (Element)node;
            Element descriptionNode = (Element)domDescriptionList.item(0);
            Node languageNode = descriptionNode.getElementsByTagName("language").item(0);
            String language = null;
            try {
                language = config.normalizeLocale(this.getTextContent((Element)languageNode));
            }
            catch (DOMException de) {
                throw new RuntimeException(de.getMessage());
            }
            catch (CCLConfigurationException ce) {
                throw new RuntimeException(ce.getMessage());
            }
            NodeList domFileList = elem.getElementsByTagName("file");
            ArrayList<String> descFiles = this.descriptionFiles.get(language);
            if (descFiles == null) {
                descFiles = new ArrayList();
                this.descriptionFiles.put(language, descFiles);
            }
            for (int j = 0; j < domFileList.getLength(); ++j) {
                Element fElem;
                String descrFile;
                Node fnode = domFileList.item(j);
                if (1 != fnode.getNodeType() || (descrFile = this.getTextContent(fElem = (Element)fnode)).length() == 0) continue;
                descFiles.add(descrFile);
            }
        }
    }

    private void loadFunctions() {
        this.root = new FunctionPoolNode(this, IFunctionNode.FDSFunctionTypeEnum.GROUP);
        this.root.setId(FUNCTION_DIR_SEPARATOR);
        for (String name : this.definitionFiles) {
            URL url = ResourceLocator.findURL(name, this.resourceSearchPath);
            this.loadFunctionDefinitionFile(url);
        }
        TreeSet<String> locList = this.getSupportedLocaleNames();
        Iterator<String> locIter = locList.iterator();
        while (locIter.hasNext()) {
            TreeMap<String, String> lsMap;
            Locale theLocale = new Locale(locIter.next());
            String key = LocaleConverter.toString(theLocale);
            if (!this.localeToStringMap.containsKey(key)) {
                lsMap = new TreeMap();
                this.localeToStringMap.put(key, lsMap);
            } else {
                lsMap = this.localeToStringMap.get(key);
            }
            for (Map.Entry<String, FunctionPoolNode> pairs : this.idToFunction.entrySet()) {
                FunctionPoolNode fnode = pairs.getValue();
                String fNodeName = fnode.getNameForLabel();
                if (fNodeName == null || fNodeName.length() == 0) continue;
                this.registerNameToIdMapping(fNodeName, fnode.getId(), theLocale, lsMap);
            }
        }
    }

    private void loadFunctionDefinitionFile(URL functionResource) {
        Node node;
        boolean exists;
        boolean bl = exists = functionResource != null;
        if (!exists) {
            return;
        }
        Document doc = FunctionPool.parseXmlFile(functionResource);
        NodeList domFunctionsRootNodes = doc.getElementsByTagName("functionsRoot");
        if (domFunctionsRootNodes.getLength() > 0 && (node = domFunctionsRootNodes.item(0)) != null && 1 == node.getNodeType()) {
            Element elem = (Element)node;
            this.processFunctionDefinitionGroup(this.root, elem, true);
        }
    }

    private void processFunctionDefinitionGroup(FunctionPoolNode parent, Element group, boolean isFunctionsRoot) {
        FunctionPoolNode groupFPNode;
        if (isFunctionsRoot) {
            groupFPNode = this.root;
        } else {
            Node node;
            String groupId = "";
            NodeList groupIdNodes = group.getElementsByTagName(ID);
            if (groupIdNodes.getLength() > 0 && (node = groupIdNodes.item(0)) != null && 1 == node.getNodeType()) {
                Element elem = (Element)node;
                groupId = this.getTextContent(elem);
            }
            if ((groupFPNode = parent.getSubgroupById(groupId)) == null) {
                groupFPNode = new FunctionPoolNode(this, parent, IFunctionNode.FDSFunctionTypeEnum.GROUP);
                groupFPNode.setId(groupId);
            }
        }
        for (Node iter = group.getFirstChild(); iter != null; iter = iter.getNextSibling()) {
            String text;
            if (1 != iter.getNodeType()) continue;
            Element asElem = (Element)iter;
            String elemName = asElem.getTagName();
            IFunctionNode.FDSFunctionTypeEnum ft = IFunctionNode.FDSFunctionTypeEnum.lookup(elemName);
            if (ft == IFunctionNode.FDSFunctionTypeEnum.GROUP) {
                this.processFunctionDefinitionGroup(groupFPNode, asElem, false);
                continue;
            }
            if (ft != IFunctionNode.FDSFunctionTypeEnum.UNKNOWN) {
                this.processFunctionDefinition(groupFPNode, asElem, ft);
                continue;
            }
            if (CONTEXT.equals(elemName)) {
                text = this.getTextContent(asElem);
                groupFPNode.addContext(text);
                continue;
            }
            if (VENDOR.equals(elemName)) {
                text = this.getTextContent(asElem);
                groupFPNode.addVendorFunctionSetId(text);
                continue;
            }
            if (INTERFACE.equals(elemName)) {
                text = this.getTextContent(asElem);
                groupFPNode.addModelDatasourceInterfaceID(text);
                continue;
            }
            if (MAY_BE_SUPPORTED_BY_ANOTHER_INTERFACE.equals(elemName)) {
                groupFPNode.mayBeSupportedByAnotherModelDatasourceInterfaceID = true;
                continue;
            }
            if (MEMBER_RELATIVE_FUNCTION.equals(elemName)) {
                groupFPNode.isMemberRelativeFunction = true;
                continue;
            }
            if (!QUERYMODE.equals(elemName)) continue;
            text = this.getTextContent(asElem);
            groupFPNode.addQueryMode(text);
        }
    }

    private void processFunctionDefinition(FunctionPoolNode group, Element function, IFunctionNode.FDSFunctionTypeEnum fType) {
        FunctionPoolParameter valueParam;
        Node node;
        String functionId = "";
        NodeList functionIdElems = function.getElementsByTagName(ID);
        if (functionIdElems.getLength() > 0 && (node = functionIdElems.item(0)) != null && 1 == node.getNodeType()) {
            Element elem = (Element)node;
            functionId = this.getTextContent(elem);
        }
        if (functionId.equals("")) {
            return;
        }
        if (this.idToFunction.containsKey(functionId)) {
            return;
        }
        FunctionPoolNode fp = new FunctionPoolNode(this, group, fType);
        fp.setId(functionId);
        String currentDLLName = "";
        for (Node iter = function.getFirstChild(); iter != null; iter = iter.getNextSibling()) {
            if (1 != iter.getNodeType()) continue;
            Element asElem = (Element)iter;
            String elemName = asElem.getTagName();
            Node firstChild = asElem.getFirstChild();
            String text = "";
            if (firstChild != null && firstChild.getNodeType() == 3) {
                text = asElem.getTextContent();
            } else if (firstChild != null && firstChild.getNodeType() == 4) {
                CDATASection child = (CDATASection)firstChild;
                text = child.getNodeValue();
            }
            if ("name".equals(elemName)) {
                fp.setName(text);
                continue;
            }
            if ("formatType".equals(elemName)) {
                fp.setFormatType(text);
                continue;
            }
            if (FORMAT.equals(elemName)) {
                fp.setFormatType(text);
                continue;
            }
            if ("returnType".equals(elemName)) {
                fp.setReturnType(FDSDataTypeEnum.fromFDS(text));
                continue;
            }
            if ("parameterType".equals(elemName)) {
                fp.addParameterType(FDSDataTypeEnum.fromFDS(text));
                continue;
            }
            if ("canonical".equals(elemName)) {
                fp.setCanonical(text);
                continue;
            }
            if ("canonicalExpression".equals(elemName)) {
                fp.setCanonicalExpression(text);
                continue;
            }
            if ("dll".equals(elemName)) {
                currentDLLName = this.getTextContent(asElem);
                continue;
            }
            if ("parameter".equals(elemName)) {
                this.processFunctionParameter(fp, asElem);
                continue;
            }
            if (CONTEXT.equals(elemName)) {
                fp.addContext(text);
                continue;
            }
            if (VENDOR.equals(elemName)) {
                text = this.getTextContent(asElem);
                fp.addVendorFunctionSetId(text);
                continue;
            }
            if ("qosLevel".equals(elemName)) {
                this.processQosLevel(fp, asElem);
                continue;
            }
            if (INTERFACE.equals(elemName)) {
                text = this.getTextContent(asElem);
                fp.addModelDatasourceInterfaceID(text);
                continue;
            }
            if ("hidden".equals(elemName)) {
                fp.isHidden = true;
                continue;
            }
            if (MAY_BE_SUPPORTED_BY_ANOTHER_INTERFACE.equals(elemName)) {
                fp.mayBeSupportedByAnotherModelDatasourceInterfaceID = true;
                continue;
            }
            if (MEMBER_RELATIVE_FUNCTION.equals(elemName)) {
                fp.isMemberRelativeFunction = true;
                continue;
            }
            if ("dimensional".equals(elemName)) {
                fp.dimensional = true;
                continue;
            }
            if (QUERYMODE.equals(elemName)) {
                fp.addQueryMode(text);
                continue;
            }
            if ("usage".equals(elemName)) {
                fp.setUsage(text);
                continue;
            }
            fp.addProperty(elemName, text);
        }
        if (functionId.equals("olap_filter")) {
            FunctionPoolParameter filterCond = fp.getParameters().get(1);
            filterCond.setType(FDSDataTypeEnum.BOOLEAN);
        }
        if (functionId.equals("olap_isempty")) {
            fp.setReturnType(FDSDataTypeEnum.BOOLEAN);
        }
        if (functionId.equals("olap_openingperiod")) {
            FunctionPoolParameter secondParam = fp.getParameters().get(1);
            secondParam.setIsOptional(true);
        }
        if (functionId.equals("olap_bottomcount")) {
            valueParam = fp.getParameters().get(2);
            valueParam.setType(FDSDataTypeEnum.ANY_VALUE);
        }
        if (functionId.equals("olap_topcount")) {
            valueParam = fp.getParameters().get(2);
            valueParam.setType(FDSDataTypeEnum.ANY_VALUE);
        }
        if (functionId.equals("olap_order")) {
            valueParam = fp.getParameters().get(1);
            valueParam.setType(FDSDataTypeEnum.ANY_VALUE);
        }
        if (functionId.equals("olap_member")) {
            valueParam = fp.getParameters().get(0);
            valueParam.setType(FDSDataTypeEnum.ANY_VALUE);
        }
        this.idToFunction.put(functionId, fp);
        if (currentDLLName.length() > 0) {
            if (!this.dllInfo.containsKey(currentDLLName)) {
                FunctionPoolDLL newDll = new FunctionPoolDLL(currentDLLName, this);
                this.dllInfo.put(currentDLLName, newDll);
            }
            FunctionPoolDLL theDLL = this.dllInfo.get(currentDLLName);
            theDLL.addFunction(fp);
            fp.setDLL(theDLL);
        }
    }

    private void processFunctionParameter(FunctionPoolNode theFunction, Element theParmElem) {
        String optionalValue;
        FunctionPoolParameter fpParm = new FunctionPoolParameter(this, theFunction);
        theFunction.addParameter(fpParm);
        for (Node iter = theParmElem.getFirstChild(); iter != null; iter = iter.getNextSibling()) {
            if (1 != iter.getNodeType()) continue;
            Element asElem = (Element)iter;
            String elemName = asElem.getTagName();
            String text = this.getTextContent(asElem);
            if (TYPE.equals(elemName)) {
                fpParm.addType(FDSDataTypeEnum.fromFDS(text));
                continue;
            }
            if (OPTIONAL.equals(elemName)) {
                fpParm.setIsOptional(text.equals(TRUE));
                continue;
            }
            if ("minOccurs".equals(elemName)) {
                int min = Integer.parseInt(text);
                fpParm.setMinOccurs(min);
                continue;
            }
            if ("maxOccurs".equals(elemName)) {
                int max = Integer.parseInt(text);
                fpParm.setMaxOccurs(max);
                continue;
            }
            if (!"nullable".equals(elemName)) continue;
            if (text.equals(TRUE)) {
                fpParm.setIsNullable(FunctionPoolParameter.ENullableValue.kTrue);
                continue;
            }
            fpParm.setIsNullable(FunctionPoolParameter.ENullableValue.kFalse);
        }
        String typeValue = theParmElem.getAttribute(TYPE);
        if (typeValue.length() > 0) {
            fpParm.setType(FDSDataTypeEnum.fromFDS(typeValue));
        }
        if ((optionalValue = theParmElem.getAttribute(OPTIONAL)).length() > 0) {
            fpParm.setIsOptional(optionalValue.equals(TRUE));
        }
    }

    private void processQosLevel(FunctionPoolNode theFunction, Element theQosLevel) {
        int ruleNumber = 1;
        for (Node iter = theQosLevel.getFirstChild(); iter != null; iter = iter.getNextSibling()) {
            Element asElem;
            String elemName;
            if (1 != iter.getNodeType() || !"rule".equals(elemName = (asElem = (Element)iter).getTagName())) continue;
            this.processQosRule(theFunction, asElem, ruleNumber);
            ++ruleNumber;
        }
    }

    private void processQosRule(FunctionPoolNode theFunction, Element theQosRule, int ruleNumber) {
        String ruleKey = "";
        FunctionPoolNode.QosRuleType ruleType = null;
        IFunctionNode.FDSQoSLevelEnum qosValue = null;
        boolean validRuleKey = false;
        boolean validRuleType = false;
        boolean validQosValue = false;
        for (Node iter = theQosRule.getFirstChild(); iter != null; iter = iter.getNextSibling()) {
            if (1 != iter.getNodeType()) continue;
            Element asElem = (Element)iter;
            String elemName = asElem.getTagName();
            String text = this.getTextContent(asElem);
            if ("value".equals(elemName)) {
                validQosValue = true;
                if ("unavailable".equals(text)) {
                    qosValue = IFunctionNode.FDSQoSLevelEnum.UNAVAILABLE;
                    continue;
                }
                if ("restricted".equals(text)) {
                    qosValue = IFunctionNode.FDSQoSLevelEnum.RESTRICTED;
                    continue;
                }
                if ("limited".equals(text)) {
                    qosValue = IFunctionNode.FDSQoSLevelEnum.LIMITED;
                    continue;
                }
                if ("ok".equals(text)) {
                    qosValue = IFunctionNode.FDSQoSLevelEnum.OK;
                    continue;
                }
                validQosValue = false;
                continue;
            }
            if ("default".equals(elemName)) {
                ruleType = FunctionPoolNode.QosRuleType.eRDefault;
                validRuleType = true;
                ruleKey = "";
                validRuleKey = true;
                continue;
            }
            if ("datasourceQueryType".equals(elemName)) {
                ruleType = FunctionPoolNode.QosRuleType.eRDatasourceQueryType;
                validRuleType = true;
                ruleKey = text;
                if (ruleKey.length() <= 0) continue;
                validRuleKey = true;
                continue;
            }
            if (!INTERFACE.equals(elemName)) continue;
            ruleType = FunctionPoolNode.QosRuleType.eRDatasourceInterfaceID;
            validRuleType = true;
            ruleKey = text;
            if (ruleKey.length() > 0) {
                validRuleKey = true;
            }
            if (!validRuleKey) continue;
            this.registerModelDatasourceInterfaceID(ruleKey);
        }
        if (!(validRuleKey && validRuleType && validQosValue)) {
            return;
        }
        FunctionPoolNode functionPoolNode = theFunction;
        functionPoolNode.getClass();
        FunctionPoolNode.QosRule fpRule = new FunctionPoolNode.QosRule(functionPoolNode, ruleType, ruleKey, qosValue);
        theFunction.addQosRule(fpRule);
    }

    private void loadTextStrings(Locale locale, URL textStringResource) {
        TreeMap<String, String> lsMap;
        boolean fileExists;
        boolean bl = fileExists = textStringResource != null;
        if (!fileExists) {
            return;
        }
        String localeName = LocaleConverter.toString(locale);
        if (!this.localeToStringMap.containsKey(localeName)) {
            lsMap = new TreeMap();
            this.localeToStringMap.put(localeName, lsMap);
        } else {
            lsMap = this.localeToStringMap.get(LocaleConverter.toString(locale));
        }
        Document doc = FunctionPool.parseXmlFile(textStringResource);
        NodeList domComponentList = doc.getElementsByTagName("component");
        for (int c = 0; c < domComponentList.getLength(); ++c) {
            Node cnode = domComponentList.item(c);
            if (1 != cnode.getNodeType()) continue;
            Element celem = (Element)cnode;
            NodeList domSectionList = celem.getElementsByTagName("section");
            for (int s = 0; s < domSectionList.getLength(); ++s) {
                Node snode = domSectionList.item(s);
                if (1 != snode.getNodeType()) continue;
                Element selem = (Element)snode;
                for (Node siter = selem.getFirstChild(); siter != null; siter = siter.getNextSibling()) {
                    Element asElem;
                    if (1 != siter.getNodeType() || !(asElem = (Element)siter).getNodeName().equals("string")) continue;
                    String id = asElem.getAttribute(ID);
                    String text = this.getTextContent(asElem);
                    this.registerNameToIdMapping(text, id, locale, lsMap);
                }
            }
        }
    }

    private void registerNameToIdMapping(String theName, String theId, Locale theLocale, TreeMap<String, String> lsMap) {
        if (lsMap != null && lsMap.containsKey(theId)) {
            return;
        }
        lsMap.put(theId, theName);
        if (!this.idToFunction.containsKey(theId)) {
            return;
        }
        FunctionPoolNode fpNode = this.idToFunction.get(theId);
        String lcaseName = theName;
        if (this.nameToFunctions.containsKey(lcaseName = lcaseName.toLowerCase())) {
            List list = (List)this.nameToFunctions.get(lcaseName);
            IFunctionNode.FDSFunctionTypeEnum idFtype = fpNode.getType();
            for (FunctionPoolNode existingFunction : list) {
                if (existingFunction == fpNode) {
                    return;
                }
                IFunctionNode.FDSFunctionTypeEnum existingFtype = existingFunction.getType();
                if (existingFtype == IFunctionNode.FDSFunctionTypeEnum.LITERAL || existingFtype == IFunctionNode.FDSFunctionTypeEnum.OPERATOR || idFtype == IFunctionNode.FDSFunctionTypeEnum.LITERAL || idFtype == IFunctionNode.FDSFunctionTypeEnum.OPERATOR) continue;
                switch (idFtype) {
                    case FUNCTION: {
                        break;
                    }
                    case SUMMARY: {
                        break;
                    }
                    case OPERATION: {
                        break;
                    }
                    case FORMAT: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (existingFunction.getType() != fpNode.getType()) {
                    return;
                }
                if (idFtype != IFunctionNode.FDSFunctionTypeEnum.FUNCTION) continue;
                FunctionPoolDLL exDll = existingFunction.getDLL();
                FunctionPoolDLL idDll = fpNode.getDLL();
                if (exDll != null && idDll != null) {
                    return;
                }
                if (existingFunction.getCanonical().equals(fpNode.getCanonical()) || null != exDll || null != idDll) continue;
                return;
            }
            this.nameToFunctions.putValue(lcaseName, fpNode);
        } else {
            this.nameToFunctions.putValue(lcaseName, fpNode);
        }
    }

    TreeSet<String> getModelDataSourceInterfaceIDs() {
        return this.modelDatasourceInterfaceIDs;
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }
}

