/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.io;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ByteBufferOutputStream
extends OutputStream {
    public static final String CONFIG_BUFFER_TUNING_SIZE = "general.bufferTuning[@size]";
    public static final String CONFIG_BUFFER_TUNING_MAX = "general.bufferTuning[@max]";
    public static final String DYNAMIC_OUTPUT_BUFFERS_USED = "XqeOutputBuffers.DynamicUsed";
    public static final String STATIC_OUTPUT_BUFFERS_IN_USE = "XqeOutputBuffers.StaticInUse";
    private static final int DEFAULT_BUFFER_SIZE = 64;
    private static final int DEFAULT_MAX_BUFFERS = 4000;
    private static int bufferSize = 64;
    private static int maxBuffers = 4000;
    public static final boolean METRICS_ENABLED = false;
    private static final ConcurrentLinkedQueue<ByteBuffer> BUFFER_POOL = new ConcurrentLinkedQueue();
    private static final AtomicInteger BUFFER_POOL_COUNT = new AtomicInteger();
    private static final AtomicBoolean BUFFER_POOL_INITED = new AtomicBoolean(false);
    private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private ByteBuffer bbf = ByteBufferOutputStream.acquireBuffer();
    private static final int INTEGER_SIZE = 4;

    public ByteBufferOutputStream() {
        this.buffers.add(this.bbf);
    }

    private void releaseBuffers() {
        int approxPoolSize;
        int numStaticReleased = 0;
        if (BUFFER_POOL_COUNT.get() < maxBuffers) {
            for (ByteBuffer buf : this.buffers) {
                buf.clear();
                BUFFER_POOL.add(buf);
                BUFFER_POOL_COUNT.incrementAndGet();
                ++numStaticReleased;
            }
        }
        if ((approxPoolSize = BUFFER_POOL_COUNT.get()) > maxBuffers) {
            int excess = approxPoolSize - maxBuffers;
            for (int i = 0; i < excess; ++i) {
                if (BUFFER_POOL.poll() == null) continue;
                BUFFER_POOL_COUNT.decrementAndGet();
            }
        }
        this.buffers.clear();
    }

    protected void finalize() throws Throwable {
        try {
            this.releaseBuffers();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bbf.remaining() > 4) {
            this.bbf.put((byte)b);
        } else {
            this.bbf = ByteBufferOutputStream.acquireBuffer();
            this.buffers.add(this.bbf);
            this.bbf.put((byte)b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int curPos = off;
        int remaining = len;
        while (remaining > 0) {
            int curBufSize = this.bbf.remaining();
            if (curBufSize > remaining) {
                this.bbf.put(b, curPos, remaining);
                remaining = 0;
                continue;
            }
            this.bbf.put(b, curPos, curBufSize);
            remaining -= curBufSize;
            curPos += curBufSize;
            this.bbf = ByteBufferOutputStream.acquireBuffer();
            this.buffers.add(this.bbf);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this.releaseBuffers();
        super.close();
    }

    public byte[] getBuf() {
        return this.getByteBuffer().array();
    }

    public ByteBuffer getByteBuffer() {
        int size = 0;
        for (ByteBuffer buf : this.buffers) {
            size += buf.position();
        }
        ByteBuffer bytes = ByteBuffer.allocate(size);
        for (ByteBuffer buf : this.buffers) {
            if (buf.remaining() > 0) {
                buf.limit(buf.limit() - buf.remaining());
            }
            buf.rewind();
            bytes.put(buf);
        }
        this.releaseBuffers();
        return bytes;
    }

    private static void initBufferPool() {
        if (BUFFER_POOL_INITED.compareAndSet(false, true)) {
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            maxBuffers = configuration.getIntProperty(CONFIG_BUFFER_TUNING_MAX, 4000);
            bufferSize = configuration.getIntProperty(CONFIG_BUFFER_TUNING_SIZE, 64);
            for (int i = 0; i < maxBuffers; ++i) {
                BUFFER_POOL.add(ByteBuffer.allocate(bufferSize));
            }
            BUFFER_POOL_COUNT.set(maxBuffers);
        }
    }

    private static ByteBuffer acquireBuffer() {
        ByteBufferOutputStream.initBufferPool();
        ByteBuffer buf = null;
        buf = BUFFER_POOL.poll();
        if (buf == null) {
            buf = ByteBuffer.allocate(bufferSize);
        } else {
            BUFFER_POOL_COUNT.decrementAndGet();
            buf.clear();
        }
        return buf;
    }

    class ByteBufferOutputStreamConfigurationListener
    implements XQEConfigurationListener {
        ByteBufferOutputStreamConfigurationListener() {
        }

        @Override
        public void configurationChanged(XQEConfigurationEvent event) {
            if (event.getPropertyName() == ByteBufferOutputStream.CONFIG_BUFFER_TUNING_MAX) {
                bufferSize = Integer.parseInt((String)event.getPropertyValue());
            } else if (event.getPropertyName() == ByteBufferOutputStream.CONFIG_BUFFER_TUNING_SIZE) {
                maxBuffers = Integer.parseInt((String)event.getPropertyValue());
            }
        }
    }
}

