/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.io;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class TempFileUtil {
    private static final String HYPHEN = "-";
    private static final String UNDERSCORE = "_";
    private static File tmpDir;
    private static ArrayList<File> cleanupList;
    private static int counter;

    public static File createTempDir(String dirName) throws IOException {
        if (dirName == null) {
            throw new IllegalArgumentException();
        }
        File dir = new File(tmpDir, dirName);
        dir.mkdirs();
        return dir;
    }

    public static File createTempFile(String className) throws IOException {
        return TempFileUtil.createTempFile(className, null);
    }

    public static File createTempFile(String className, String suffix) throws IOException {
        File tempFile;
        TempFileUtil.performCleanup();
        if (suffix == null) {
            suffix = ".tmp";
        }
        while (!(tempFile = TempFileUtil.getTempFile(className, suffix)).createNewFile()) {
        }
        return tempFile;
    }

    public static File getTempFile(String className, String suffix) {
        StringBuilder path = new StringBuilder();
        path.append("xqe");
        path.append(UNDERSCORE);
        path.append(className);
        path.append(UNDERSCORE);
        path.append(System.currentTimeMillis());
        path.append(UNDERSCORE);
        path.append(TempFileUtil.getId());
        path.append(suffix);
        return new File(tmpDir, path.toString());
    }

    public static File createTempFile(String dirName, String prefix, String suffix) throws IOException {
        StringBuilder path;
        File tempFile;
        TempFileUtil.performCleanup();
        if (dirName == null) {
            dirName = "files";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        File dir = new File(tmpDir, dirName);
        dir.mkdirs();
        do {
            path = new StringBuilder();
            int n = TempFileUtil.getId();
            path.append(prefix);
            path.append(n);
            path.append(suffix);
        } while (!(tempFile = new File(dir, path.toString())).createNewFile());
        return tempFile;
    }

    public static File createTempFile(String prefix, int fileId, int genId) throws IOException {
        TempFileUtil.performCleanup();
        StringBuilder path = new StringBuilder();
        path.append(prefix);
        path.append(fileId);
        path.append(HYPHEN);
        path.append(genId);
        File tempFile = new File(tmpDir, path.toString());
        tempFile.createNewFile();
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTempFile(File tempFile) {
        TempFileUtil.performCleanup();
        if (!tempFile.delete() && tempFile.exists()) {
            ArrayList<File> arrayList = cleanupList;
            synchronized (arrayList) {
                cleanupList.add(tempFile);
            }
        }
    }

    public static String createTempDirectory(String dirName) {
        File d = new File(tmpDir, dirName);
        d.mkdirs();
        return d.getPath();
    }

    public static void clearTempDirectory(String dirName) {
        String[] children;
        File d = new File(tmpDir, dirName);
        if (d.isDirectory() && (children = d.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                TempFileUtil.deleteFileOrDir(new File(d, children[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFileOrDir(File d) {
        String[] children;
        if (d.isDirectory() && (children = d.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                TempFileUtil.deleteFileOrDir(new File(d, children[i]));
            }
        }
        if (!d.delete() && d.exists()) {
            ArrayList<File> arrayList = cleanupList;
            synchronized (arrayList) {
                cleanupList.add(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCleanup() {
        if (cleanupList.size() == 0) {
            return;
        }
        ArrayList<File> arrayList = cleanupList;
        synchronized (arrayList) {
            int i = 0;
            while (i < cleanupList.size()) {
                File f = cleanupList.get(i);
                if (!f.delete() && f.exists()) {
                    ++i;
                    continue;
                }
                cleanupList.remove(i);
            }
        }
    }

    private static synchronized int getId() {
        return ++counter;
    }

    public static void deleteTempFile(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
    }

    public static String[] getFileList(String subdir) {
        File d = new File(tmpDir, subdir);
        if (d.isDirectory()) {
            return d.list();
        }
        return new String[0];
    }

    static {
        cleanupList = new ArrayList();
        counter = 0;
        try {
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            String dirName = configuration.getXqeTempDirectory();
            tmpDir = new File(dirName);
            tmpDir.mkdir();
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }
}

