/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.memory;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.util.memory.IMemoryMonitor;
import com.cognos.xqe.util.memory.IMemoryNotificationListener;
import com.cognos.xqe.util.memory.MemoryNotification;
import com.cognos.xqe.util.memory.MemoryStateEnum;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public final class MemoryMonitor
implements IMemoryMonitor,
Runnable,
NotificationListener,
IMemoryNotificationListener,
XQEConfigurationListener {
    static final int THREAD_PRIORITY = 10;
    static final Set<String> GC_MEMORY_MANAGER = new HashSet<String>(){
        {
            this.add("MarkSweepCompact");
            this.add("PS MarkSweep");
            this.add("ConcurrentMarkSweep");
            this.add("G1 Mixed Generation");
        }
    };
    boolean memoryMonitorStatistics = false;
    boolean memoryMonitorNotifications = false;
    XQEConfiguration.ConfigurationChangeListener xqeConfigurationListener = null;
    static final long HUNDRED = 100L;
    final long highThresholdBytes = (long)MemoryStateEnum.HIGH.getPercentThreshold() * Runtime.getRuntime().maxMemory() / 100L;
    MemoryPoolMXBean heapMemoryPoolMXBean = null;
    GarbageCollectorMXBean garbageCollectorMXBean = null;
    long garbageCollectorCount = 0L;
    MemoryStateEnum memoryState = MemoryStateEnum.NORMAL;
    long memoryStateTime = 0L;
    long addNotificationListenerTime = 0L;
    static final long ADD_NOTIFICATION_DELAY = 1000L;
    static MemoryMonitor instance = new MemoryMonitor();
    Thread thread = null;
    AtomicInteger initialized = new AtomicInteger(0);
    ConcurrentLinkedQueue<IMemoryNotificationListener> listeners = new ConcurrentLinkedQueue();
    ConcurrentLinkedQueue<MemoryNotification> memoryNotificationQueue = new ConcurrentLinkedQueue();
    volatile MemoryUsage memoryUsageReportedByGC = null;

    public static IMemoryMonitor getInstance() {
        return instance;
    }

    private static MemoryMonitor getThisInstance() {
        return instance;
    }

    private MemoryMonitor() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MemoryMonitor.getThisInstance().release();
            }
        });
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String memoryMonitorStatisticsString = System.getProperty("general.memoryMonitor.statistics");
        this.memoryMonitorStatistics = memoryMonitorStatisticsString == null ? config.getBooleanProperty("general.memoryMonitor.statistics", false) : Boolean.parseBoolean(memoryMonitorStatisticsString);
        String memoryMonitorNotificationsString = System.getProperty("general.memoryMonitor.notifications");
        this.memoryMonitorNotifications = memoryMonitorNotificationsString == null ? config.getBooleanProperty("general.memoryMonitor.notifications", false) : Boolean.parseBoolean(memoryMonitorNotificationsString);
        if (ResourceMonitor.isEnabled()) {
            this.memoryMonitorNotifications = true;
        }
        this.initialize();
        this.xqeConfigurationListener = config.registerConfigurationListener(this);
    }

    @Override
    public boolean addNotificationListener(IMemoryNotificationListener listener) {
        boolean success = this.listeners.add(listener);
        if (success) {
            this.addNotificationListenerTime = System.currentTimeMillis();
        }
        return success;
    }

    @Override
    public boolean removeNotificationListener(IMemoryNotificationListener listener) {
        return this.listeners.remove(listener);
    }

    public MemoryStateEnum getMemoryState() {
        return this.memoryState;
    }

    public MemoryUsage getMemoryUsageReportedByGC() {
        return this.memoryUsageReportedByGC;
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.thread == thisThread) {
            try {
                Thread.sleep(this.threadSleepTime());
                this.setMemoryNotificationThreshold(1L);
            }
            catch (InterruptedException interruptedException) {
                if (this.thread != thisThread) break;
                MemoryNotification memoryNotification = this.getMemoryNotification();
                if (this.isMemoryMonitorStatistics()) {
                    this.handleNotification(memoryNotification);
                }
                if (!this.isMemoryMonitorNotifications()) continue;
                for (IMemoryNotificationListener listener : this.listeners) {
                    try {
                        listener.handleNotification(memoryNotification);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    private long threadSleepTime() {
        long sleepTime = Long.MAX_VALUE;
        if (this.isMemoryMonitorEnabled()) {
            sleepTime = MemoryStateEnum.NORMAL.getTimeThreshold();
        }
        return sleepTime;
    }

    private MemoryNotification getMemoryNotification() {
        MemoryNotification memoryNotification = null;
        MemoryNotification mem = this.memoryNotificationQueue.poll();
        while (mem != null) {
            memoryNotification = mem;
            mem = this.memoryNotificationQueue.poll();
        }
        return memoryNotification;
    }

    static int getMemoryUsed() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        int memoryUsed = (int)((allocatedMemory - freeMemory) * 100L / maxMemory);
        return memoryUsed;
    }

    static int getMemoryUsedPct(MemoryUsage memoryUsage) {
        int memoryUsed = (int)(memoryUsage.getUsed() * 100L / memoryUsage.getMax());
        return memoryUsed;
    }

    private static MemoryUsage getMemoryUsage(Notification notification) {
        CompositeData compositeData = (CompositeData)notification.getUserData();
        MemoryNotificationInfo memoryInfo = MemoryNotificationInfo.from(compositeData);
        MemoryUsage memoryUsage = memoryInfo.getUsage();
        return memoryUsage;
    }

    private void initialize() {
        int newValue = this.initialized.incrementAndGet();
        if (newValue == 1) {
            this.initializeBeans();
            this.initializeThread();
        }
    }

    public void release() {
        int newValue = this.initialized.decrementAndGet();
        if (newValue == 0) {
            this.terminateThread();
            this.terminateBeans();
        }
    }

    private void terminateBeans() {
        try {
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this, null, null);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }

    private void terminateThread() {
        Thread memoryMonitorThread = this.thread;
        this.listeners.clear();
        this.thread = null;
        memoryMonitorThread.interrupt();
    }

    private void initializeThread() {
        this.thread = new Thread((Runnable)this, "MemoryMonitor");
        try {
            this.thread.setPriority(10);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void initializeBeans() {
        for (GarbageCollectorMXBean gcMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!GC_MEMORY_MANAGER.contains(gcMXBean.getName())) continue;
            this.garbageCollectorMXBean = gcMXBean;
            break;
        }
        if (this.garbageCollectorMXBean != null) {
            block1: for (MemoryPoolMXBean mpMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
                if (mpMXBean.getType() != MemoryType.HEAP || !mpMXBean.isCollectionUsageThresholdSupported() || !mpMXBean.isUsageThresholdSupported()) continue;
                for (String memoryManager : mpMXBean.getMemoryManagerNames()) {
                    if (!this.garbageCollectorMXBean.getName().equals(memoryManager)) continue;
                    this.heapMemoryPoolMXBean = mpMXBean;
                    break block1;
                }
            }
        }
        if (this.heapMemoryPoolMXBean != null) {
            NotificationEmitter notificationEmmiter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
            notificationEmmiter.addNotificationListener(this, null, null);
            this.setMemoryNotificationThreshold(1L);
        }
    }

    private boolean setMemoryNotificationThreshold(long threshold) {
        if (this.heapMemoryPoolMXBean == null) {
            return false;
        }
        if (!this.isMemoryMonitorEnabled()) {
            threshold = 0L;
        }
        this.heapMemoryPoolMXBean.setCollectionUsageThreshold(threshold);
        return threshold != 0L;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if ("java.management.memory.collection.threshold.exceeded".equals(notification.getType())) {
            boolean addUpdate;
            this.memoryUsageReportedByGC = MemoryMonitor.getMemoryUsage(notification);
            int usedMemoryPercentage = MemoryMonitor.getMemoryUsed();
            MemoryStateEnum memoryStateFromNotification = MemoryStateEnum.fromMemoryLevel(usedMemoryPercentage);
            long timestampFromNotification = notification.getTimeStamp();
            long threshold = 1L;
            long currentGarbageCollectorCount = this.garbageCollectorMXBean.getCollectionCount();
            boolean bl = addUpdate = System.currentTimeMillis() - this.addNotificationListenerTime > 1000L;
            if ((currentGarbageCollectorCount != this.garbageCollectorCount || memoryStateFromNotification != this.memoryState) && addUpdate) {
                this.garbageCollectorCount = currentGarbageCollectorCount;
                boolean update = memoryStateFromNotification != this.memoryState || timestampFromNotification - this.memoryStateTime > this.memoryState.getTimeThreshold();
                Thread thisThread = this.thread;
                if (update && thisThread != null) {
                    if (this.memoryStateTime == 0L) {
                        this.memoryStateTime = timestampFromNotification;
                    }
                    int percUsageReportedByGC = MemoryMonitor.getMemoryUsedPct(this.memoryUsageReportedByGC);
                    MemoryNotification memoryNotification = new MemoryNotification(memoryStateFromNotification, timestampFromNotification, this.memoryState, this.memoryStateTime, this.memoryUsageReportedByGC, percUsageReportedByGC);
                    this.memoryNotificationQueue.add(memoryNotification);
                    this.memoryState = memoryStateFromNotification;
                    this.memoryStateTime = timestampFromNotification;
                    thisThread.interrupt();
                    if (memoryStateFromNotification == MemoryStateEnum.NORMAL) {
                        threshold = this.highThresholdBytes;
                    }
                }
            }
            this.setMemoryNotificationThreshold(1L);
        }
    }

    @Override
    public void handleNotification(MemoryNotification memoryNotification) {
        long timeDifference = memoryNotification.getTimestamp() - memoryNotification.getPreviousTimestamp();
        memoryNotification.getPreviousMemoryState().updateStatistics(timeDifference);
    }

    static String time() {
        return MemoryMonitor.time(System.currentTimeMillis());
    }

    static String time(long timestamp) {
        return new SimpleDateFormat("HH:mm:ss:SSS").format(new Date(timestamp));
    }

    @Override
    public void configurationChanged(XQEConfigurationEvent event) {
        String eventName = event.getPropertyName();
        if ("general.memoryMonitor.statistics".equals(eventName)) {
            this.memoryMonitorStatistics = Boolean.parseBoolean((String)event.getPropertyValue());
            if (this.memoryMonitorStatistics) {
                this.memoryStateTime = 0L;
                this.memoryState = MemoryStateEnum.NORMAL;
                MemoryStateEnum.resetStatistics();
            }
            this.setMemoryNotificationThreshold(1L);
        } else if ("general.memoryMonitor.notifications".equals(eventName)) {
            this.memoryMonitorNotifications = Boolean.parseBoolean((String)event.getPropertyValue());
            this.setMemoryNotificationThreshold(1L);
        }
    }

    boolean isMemoryMonitorEnabled() {
        return this.isMemoryMonitorNotifications() || this.isMemoryMonitorStatistics();
    }

    boolean isMemoryMonitorNotifications() {
        return this.memoryMonitorNotifications;
    }

    boolean isMemoryMonitorStatistics() {
        return this.memoryMonitorStatistics;
    }
}

