/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.monitor;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelableRequestRegistry;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.RequestMetrics;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.management.XqeMBeanServer;
import com.cognos.xqe.query.engine.SessionContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.JVMUtil;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.memory.MemoryNotification;
import com.cognos.xqe.util.memory.MemoryNotificationListener;
import com.cognos.xqe.util.memory.MemoryStateEnum;
import com.cognos.xqe.util.monitor.CancelRequestSelectionMethod;
import com.cognos.xqe.util.monitor.ResourceMonitorMBean;
import com.cognos.xqe.util.monitor.ResourceMonitorRegistry;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;

public class ResourceMonitor
extends MemoryNotificationListener
implements ResourceMonitorMBean,
IReleasable {
    private static final String NEW_LINE = "\n";
    private static final String TAB = "\t";
    private static final String ENTERING_OVERLOADED = "Entering OVERLOADED state (%s)";
    private static final String ENTERING_NORMAL = "Entering NORMAL state (%s)";
    private static final String FINISHED_CANCELING_NORMAL_STAGE_REACHED = "Finished canceling requests due to OVERLOADED state (NORMAL state reached)";
    private static final String FINISHED_CANCELING_NO_MORE_REQUESTS = "Finished canceling requests due to OVERLOADED state (No more requests)";
    private static final String MBEAN_NAME = "com.cognos.xqe:name=Resource Monitor";
    private static final String MB_FORMAT = "%,d MB";
    private static final String NOT_ENOUGH_INITIAL_FREE_MEM = "Cannot allocate %d bytes with only %d bytes of initial free memory.";
    private static final String NOT_ENOUGH_MEM = "Cannot allocate %d bytes with only %d bytes of free memory. Used memory can not exceed %d bytes.";
    private static final long SLEEP_PERIOD = 1000L;
    private static final int MAX_REGISTERED_REQUESTS_LOGGED = 50;
    private static final XQELogger LOGGER = ROLAPLog.getLogger("Resources.Monitor");
    private AtomicBoolean mNormalState = new AtomicBoolean(true);
    private long mWarmFreeHeap;
    private AtomicLong mCurrentClaimedMemory = new AtomicLong(0L);
    private ArrayList<byte[]> mArtificallyReservedMemoryBlocks = new ArrayList();
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int BLOCK_SIZE = 0xA00000;
    private static final int CALC_MEM_BALLAST_SIZE = 0x1400000;
    private BallastMonitorThread ballastThread;
    private OverloadedStateMonitorThread overloadedStateMonitorThread;
    private MemoryStateChangeHandlerThread memoryStateChangeHandlerThread;
    private static final double NINETY_PERCENT = 0.9;
    private static final boolean DEFAULT_RESOURCE_MONITOR_ENABLED = true;
    private static volatile AtomicBoolean mEnableResourceMonitor = null;
    private static final boolean DEFAULT_BALLAST_ENABLED = true;
    private static boolean mEnableBallast = true;
    private static final boolean DEFAULT_GC_ENABLED = true;
    private static boolean mEnableGC = true;
    private static final boolean DEFAULT_MEMORY_COUNTING_ENABLED = false;
    private static boolean mEnableMemoryCounting = false;
    private static final boolean DEFAULT_CACHE_CLEARING_ENABLED = false;
    private static boolean mEnableCacheClearing = false;
    private static final int HUNDRED_PERCENT = 100;
    private static int mOverloadedMemoryPercentage = 90;
    private static long mOverloadedMemoryThreshold;
    private static long mAjustedMaxMemory;
    public static final String PARAM_ERROR = "The value for parameter '%s' - '%s' is not in the range [%d, %d]; the default value '%d' will be used.";
    private ResourceMonitorRegistry sessionRegistry;
    private volatile ArrayList<byte[]> mHardBallast = new ArrayList();
    private static final int MIN_BALLAST_PERCENTAGE = 1;
    private static final int MAX_BALLAST_PERCENTAGE = 10;
    private static final int DEFAULT_BALLAST_PERCENTAGE = 2;
    private static int mBallastPercentage;
    private static final int HARD_BALLAST_CHUNK_SIZE = 0x100000;
    private static final boolean DEFAULT_BALANCED_GC_ENABLED = true;
    private static boolean mEnableBalancedGC;
    private static final boolean DEFAULT_ORACLE_JVM_ENABLED = false;
    private static boolean mEnableOracleJVM;
    private static final int DEFAULT_GC_ITERATIONS = 1;
    private static final int MIN_GC_ITERATIONS = 1;
    private static final int MAX_GC_ITERATIONS = 10;
    private static int mGCIterations;
    private static final int DEFAULT_GC_RETRY_PERIOD = 120;
    private static final int MIN_GC_RETRY_PERIOD = 10;
    private static final int MAX_GC_RETRY_PERIOD = 3600;
    private static int mGCRetryPeriod;
    private static final int DEFAULT_CANCEL_RAMPUP_PERCENTAGE = 30;
    private static final int MIN_CANCEL_RAMPUP_PERCENTAGE = 1;
    private static final int MAX_CANCEL_RAMPUP_PERCENTAGE = 100;
    private static int mCancelRampupPercentage;
    private static final int DEFAULT_CANCEL_DELAY = 10;
    private static final int MIN_CANCEL_DELAY = 1;
    private static final int MAX_CANCEL_DELAY = 600;
    private static int mCancelDelay;
    private static final int DEFAULT_MAX_QUERIES = 100000;
    private static final int MIN_MAX_QUERIES = 1;
    private static final int MAX_MAX_QUERIES = 10000000;
    private static int mMaxQueries;
    private static long mHardBallastSize;
    private static final String IBM_BALANCED = "-Xgcpolicy:balanced";
    private static final String IBM_GENERATIONAL = "-Xgcpolicy:gencon";
    private static SingletonHelper<ResourceMonitor> singletonHelper;

    private void reserveHardBallast() {
        if (!mEnableBallast) {
            return;
        }
        int chunks = (int)(mHardBallastSize / 0x100000L);
        this.freeHardBallast();
        LOGGER.log(LogLevel.INFO, String.format("Reserving ballast (%s)", ResourceMonitor.toMB((long)chunks * 0x100000L)));
        ArrayList<byte[]> hardBallast = new ArrayList<byte[]>(chunks);
        for (int i = 0; i < chunks; ++i) {
            hardBallast.add(i, new byte[0x100000]);
        }
        this.mHardBallast = hardBallast;
        LOGGER.log(LogLevel.INFO, "Done reserving ballast");
    }

    private void clearHardBallast() {
        if (!mEnableBallast) {
            return;
        }
        LOGGER.log(LogLevel.INFO, "Releasing ballast");
        this.freeHardBallast();
    }

    private void freeHardBallast() {
        ArrayList<byte[]> hardBallast = this.mHardBallast;
        if (hardBallast != null) {
            for (int i = 0; i < hardBallast.size(); ++i) {
                hardBallast.set(i, null);
            }
            hardBallast.clear();
        }
        this.mHardBallast = null;
    }

    public static ResourceMonitor getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEnabled() {
        if (mEnableResourceMonitor != null) return mEnableResourceMonitor.get();
        Class<ResourceMonitor> clazz = ResourceMonitor.class;
        synchronized (ResourceMonitor.class) {
            if (mEnableResourceMonitor != null) return mEnableResourceMonitor.get();
            boolean enabledDefault = ResourceMonitor.getBooleanProperty("general.standAloneMode[@enabled]", true);
            mEnableResourceMonitor = new AtomicBoolean(ResourceMonitor.getBooleanProperty("resourceMonitor.enabled", enabledDefault));
            if (!mEnableResourceMonitor.get()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return false;
            }
            mEnableBalancedGC = ResourceMonitor.getBooleanProperty("resourceMonitor.balancedGCEnabled", true);
            boolean defaultOracleEnabled = false;
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.indexOf("sunos") >= 0 || osName.indexOf("solaris") >= 0) {
                defaultOracleEnabled = true;
            }
            mEnableOracleJVM = ResourceMonitor.getBooleanProperty("resourceMonitor.oracleJVMEnabled", defaultOracleEnabled);
            if (JVMUtil.isIBMJava()) {
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                List<String> jvmArgs = runtimeMXBean.getInputArguments();
                for (String arg : jvmArgs) {
                    if (arg.indexOf("-Xgcpolicy") < 0) continue;
                    if (arg.indexOf(IBM_GENERATIONAL) >= 0) break;
                    if (arg.indexOf(IBM_BALANCED) >= 0) {
                        if (!mEnableBalancedGC) {
                            LOGGER.log(LogLevel.ERROR, "Resource Monitor is disabled because of balanced GC policy");
                            mEnableResourceMonitor.set(false);
                        }
                    } else {
                        LOGGER.log(LogLevel.ERROR, "Resource Monitor is disabled because of unsupported GC policy");
                        mEnableResourceMonitor.set(false);
                    }
                    break;
                }
            } else if (!mEnableOracleJVM) {
                LOGGER.log(LogLevel.ERROR, "Resource Monitor is disabled on Oracle JVM");
                mEnableResourceMonitor.set(false);
            }
            mEnableBallast = ResourceMonitor.getBooleanProperty("resourceMonitor.ballastEnabled", true);
            mEnableGC = ResourceMonitor.getBooleanProperty("resourceMonitor.gcEnabled", true);
            mEnableMemoryCounting = ResourceMonitor.getBooleanProperty("resourceMonitor.memoryCountingEnabled", false);
            mEnableCacheClearing = ResourceMonitor.getBooleanProperty("resourceMonitor.cacheClearingEnabled", false);
            mOverloadedMemoryPercentage = ResourceMonitor.getIntProperty("resourceMonitor.overloadedPercent", 90, 75, 100);
            if (mOverloadedMemoryPercentage != 90) {
                MemoryStateEnum.adjustRange(mOverloadedMemoryPercentage);
            }
            mMaxQueries = ResourceMonitor.getIntProperty("resourceMonitor.maxQueries", 100000, 1, 10000000);
            mCancelDelay = ResourceMonitor.getIntProperty("resourceMonitor.cancelDelay", 10, 1, 600);
            mCancelRampupPercentage = ResourceMonitor.getIntProperty("resourceMonitor.cancelRampupPercentage", 30, 1, 100);
            mBallastPercentage = ResourceMonitor.getIntProperty("resourceMonitor.ballastPercentage", 2, 1, 10);
            mHardBallastSize = Runtime.getRuntime().maxMemory() / 100L * (long)mBallastPercentage;
            mAjustedMaxMemory = Runtime.getRuntime().maxMemory() - mHardBallastSize;
            mOverloadedMemoryThreshold = mAjustedMaxMemory / 100L * (long)mOverloadedMemoryPercentage;
            mGCRetryPeriod = ResourceMonitor.getIntProperty("resourceMonitor.gcRetryPeriod", 120, 10, 3600);
            mGCIterations = ResourceMonitor.getIntProperty("resourceMonitor.gcIterations", 1, 1, 10);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mEnableResourceMonitor.get();
        }
    }

    private void initialize() {
        if (!ResourceMonitor.isEnabled()) {
            LOGGER.log(LogLevel.ERROR, "Resource Monitor is disabled");
            return;
        }
        try {
            XqeMBeanServer mbs = XqeMBeanServer.getInstance();
            ObjectName name = new ObjectName(MBEAN_NAME);
            if (!mbs.isRegistered(name)) {
                mbs.registerMBean(this, name);
            }
        }
        catch (Throwable ex) {
            LOGGER.log(LogLevel.ERROR, ex);
        }
        this.sessionRegistry = new ResourceMonitorRegistry();
        this.mWarmFreeHeap = ResourceMonitor.calcFreeMemory();
        this.memoryStateChangeHandlerThread = new MemoryStateChangeHandlerThread();
        this.memoryStateChangeHandlerThread.start();
        this.overloadedStateMonitorThread = new OverloadedStateMonitorThread();
        this.overloadedStateMonitorThread.start();
        this.reserveHardBallast();
        LOGGER.log(LogLevel.ERROR, String.format("Resource Monitor is enabled (ballast = %s, ballast percentage = %d, GC in overloaded state = %s, GC retry period = %d, GC iterations = %d, memory counting = %s, cache clearing = %s, overloaded percentage = %d, balanced GC = %s, Oracle = %s, max queries = %d, cancel delay = %d, cancel rampup percentage = %d, ballast size = %s (reduces the max reported JVM memory), %s)", ResourceMonitor.onOff(mEnableBallast), mBallastPercentage, ResourceMonitor.onOff(mEnableGC), mGCRetryPeriod, mGCIterations, ResourceMonitor.onOff(mEnableMemoryCounting), ResourceMonitor.onOff(mEnableCacheClearing), mOverloadedMemoryPercentage, ResourceMonitor.onOff(mEnableBalancedGC), ResourceMonitor.onOff(mEnableOracleJVM), mMaxQueries, mCancelDelay, mCancelRampupPercentage, ResourceMonitor.toMB(mHardBallastSize), this.getGlobalMemState()));
    }

    private static void gc() {
        LOGGER.log(LogLevel.INFO, "Requesting GC");
        for (int i = 0; i < mGCIterations; ++i) {
            System.gc();
        }
    }

    @Override
    public void release() {
        if (!ResourceMonitor.isEnabled()) {
            return;
        }
        super.release();
        if (this.ballastThread != null) {
            this.ballastThread.release();
            this.ballastThread = null;
        }
        if (this.overloadedStateMonitorThread != null) {
            this.overloadedStateMonitorThread.release();
            this.overloadedStateMonitorThread = null;
        }
        if (this.memoryStateChangeHandlerThread != null) {
            this.memoryStateChangeHandlerThread.release();
            this.memoryStateChangeHandlerThread = null;
        }
        try {
            XqeMBeanServer mbs = XqeMBeanServer.getInstance();
            ObjectName name = new ObjectName(MBEAN_NAME);
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
        }
        catch (Throwable ex) {
            LOGGER.log(LogLevel.ERROR, ex);
        }
    }

    public boolean isNormalState() {
        return this.mNormalState.get();
    }

    @Override
    public boolean getNormalState() {
        return this.isNormalState();
    }

    @Override
    public void setNormalState(boolean isNormal) {
        boolean prevValue = this.mNormalState.getAndSet(isNormal);
        if (prevValue != isNormal) {
            if (isNormal) {
                LOGGER.log(LogLevel.ERROR, String.format(ENTERING_NORMAL, this.getGlobalMemState()));
            } else {
                LOGGER.log(LogLevel.ERROR, String.format(ENTERING_OVERLOADED, this.getGlobalMemState()));
            }
            this.memoryStateChangeHandlerThread.reportStateChange(isNormal);
        }
    }

    @Override
    public void handleNotification(MemoryNotification memoryNotification) {
        if (!ResourceMonitor.isEnabled()) {
            return;
        }
        MemoryStateEnum memState = memoryNotification.getMemoryState();
        if (LOGGER.isOn(LogLevel.INFO)) {
            String notificationDetail = "";
            if (LOGGER.isOn(LogLevel.TRACE)) {
                notificationDetail = String.format("('%s', %s)", memState.toString(), ResourceMonitor.getNotifMemState(memoryNotification.getMemoryUsage()));
            }
            LOGGER.log(LogLevel.INFO, String.format("Memory notification received (%s) %s", this.getGlobalMemState(), notificationDetail));
        }
        if (this.isMemoryCritical()) {
            this.setNormalState(false);
        } else {
            this.setNormalState(true);
        }
    }

    private static long calcPercentage(long memory, long maxMemory) {
        return memory * 100L / maxMemory;
    }

    private CancelStage cancelRegisteredSessions(CancelStage cancelStage, boolean prevStateNormal) {
        if (!prevStateNormal && this.sessionRegistry.size() == 0) {
            return cancelStage;
        }
        List<SessionContext> sessions = this.sessionRegistry.getSessionsToCancelRequest(CancelRequestSelectionMethod.MULTIPLE_METRICS);
        LOGGER.log(LogLevel.ERROR, String.format("Canceling requests due to OVERLOADED state (%d requests available)", sessions.size()));
        if (LOGGER.isOn(LogLevel.TRACE) && sessions.size() > 0) {
            StringBuilder sessionsStr = new StringBuilder();
            sessionsStr.append("Registered requests: ");
            for (int i = 0; i < sessions.size(); ++i) {
                if (i < 50) {
                    sessionsStr.append(NEW_LINE).append(sessions.get(i).getIDSString());
                    continue;
                }
                sessionsStr.append(NEW_LINE).append(String.format("...%d more registered requests.", sessions.size() - i));
            }
            LOGGER.log(LogLevel.TRACE, sessionsStr.toString());
        }
        if (cancelStage == CancelStage.HEAVIEST) {
            cancelStage = CancelStage.HEAVY;
            if (sessions.isEmpty()) {
                LOGGER.log(LogLevel.ERROR, FINISHED_CANCELING_NO_MORE_REQUESTS);
                return CancelStage.HEAVIEST;
            }
            SessionContext session = sessions.remove(0);
            LOGGER.log(LogLevel.ERROR, "Canceling the heaviest request");
            this.cancelSession(session);
            if (this.waitForNormalMemory()) {
                LOGGER.log(LogLevel.ERROR, FINISHED_CANCELING_NORMAL_STAGE_REACHED);
                return CancelStage.HEAVY;
            }
        }
        if (cancelStage == CancelStage.HEAVY) {
            cancelStage = CancelStage.REMAINING;
            long selectedCount = 0L;
            selectedCount = sessions.size() > 1 ? Math.round((double)sessions.size() / 100.0 * (double)mCancelRampupPercentage) : (long)sessions.size();
            if (selectedCount == 0L) {
                LOGGER.log(LogLevel.ERROR, FINISHED_CANCELING_NO_MORE_REQUESTS);
                return CancelStage.HEAVIEST;
            }
            ArrayList<SessionContext> selectedSessions = new ArrayList<SessionContext>();
            int i = 0;
            while ((long)i < selectedCount) {
                selectedSessions.add(sessions.remove(0));
                ++i;
            }
            LOGGER.log(LogLevel.ERROR, String.format("Canceling top %d%% of remaining requests (%d of %d)", mCancelRampupPercentage, selectedSessions.size(), selectedSessions.size() + sessions.size()));
            for (SessionContext sessionContext : selectedSessions) {
                this.cancelSession(sessionContext);
                if (!this.isNormalState()) continue;
                LOGGER.log(LogLevel.ERROR, FINISHED_CANCELING_NORMAL_STAGE_REACHED);
                return cancelStage;
            }
            if (this.waitForNormalMemory()) {
                LOGGER.log(LogLevel.ERROR, FINISHED_CANCELING_NORMAL_STAGE_REACHED);
                return cancelStage;
            }
        }
        if (cancelStage == CancelStage.REMAINING) {
            LOGGER.log(LogLevel.ERROR, String.format("Canceling %d remaining requests", sessions.size()));
            for (SessionContext sessionContext : sessions) {
                this.cancelSession(sessionContext);
                if (!this.isNormalState()) continue;
                LOGGER.log(LogLevel.ERROR, FINISHED_CANCELING_NORMAL_STAGE_REACHED);
                return cancelStage;
            }
        }
        LOGGER.log(LogLevel.ERROR, "Finished canceling requests due to OVERLOADED state (NORMAL state not yet reached)");
        return cancelStage;
    }

    private boolean waitForNormalMemory() {
        for (int i = 0; i < mCancelDelay; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isNormalState()) continue;
            return true;
        }
        return false;
    }

    private void cancelSession(SessionContext sessionContext) {
        String requestID = sessionContext.getRequestID();
        String sessionID = sessionContext.getIDSString();
        String requestMetricStr = "";
        RequestEnvironment reqEnv = sessionContext.getRequestEnvironment();
        if (reqEnv != null) {
            RequestMetrics reqMetrics = reqEnv.getRequestMetrics();
            BigInteger biggestSetSize = reqMetrics.getBiggestSetSize();
            long cubeletsValueCount = reqMetrics.getCubeletsValueCount();
            long duration0 = 0L;
            HighPrecisionStopWatch timer0 = reqMetrics.getRequestTimer();
            if (timer0 != null) {
                duration0 = timer0.getElapsedTimeInMilliseconds();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(NEW_LINE).append("Report name: ").append(sessionContext.getReportName());
            sb.append(NEW_LINE).append("Request metrics used:");
            sb.append(NEW_LINE).append(TAB).append("Biggest set size: ").append(biggestSetSize.toString());
            String format = "\n\t%s: %d";
            sb.append(String.format(format, "Number of values added to cubelets", cubeletsValueCount));
            sb.append(String.format(format, "Request duration (ms)", duration0)).append(NEW_LINE);
            requestMetricStr = sb.toString();
        }
        LOGGER.log(LogLevel.ERROR, "Attempting to cancel request " + sessionID);
        int cancelResult = 0;
        try {
            CancelableRequestRegistry cancelableRequestRegistry = sessionContext.getCancelableRequestRegistry();
            if (null == cancelableRequestRegistry) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "null == cancelableRequestRegistry");
            }
            cancelResult = cancelableRequestRegistry.cancel(requestID, CancelRequestSourceEnum.RESOURCE_MONITOR);
        }
        catch (Throwable e) {
            LOGGER.log(LogLevel.ERROR, "Unabled to issue cancel command for request  " + sessionID + requestMetricStr);
            LOGGER.log(LogLevel.ERROR, e);
        }
        if (cancelResult > 0) {
            LOGGER.log(LogLevel.ERROR, "Successfully issued cancel command for request " + sessionID + requestMetricStr);
        } else {
            LOGGER.log(LogLevel.ERROR, "Unabled to issue cancel command for request " + sessionID + requestMetricStr);
        }
    }

    public static void register(SessionContext sessionContext) {
        if (!ResourceMonitor.isEnabled()) {
            return;
        }
        ResourceMonitor.getInstance().registerImpl(sessionContext);
    }

    private void registerImpl(SessionContext sessionContext) {
        this.sessionRegistry.register(sessionContext);
    }

    public static long calcFreeMemory() {
        boolean ballastFreed;
        long reportedFree;
        if (!mEnableMemoryCounting) {
            return Runtime.getRuntime().freeMemory();
        }
        if (Runtime.getRuntime().freeMemory() < 0x1400000L) {
            return Runtime.getRuntime().freeMemory();
        }
        SoftReference<byte[]> ballast = new SoftReference<byte[]>(new byte[0x1400000]);
        ArrayList<byte[]> used = new ArrayList<byte[]>();
        long freeMemory = 0L;
        do {
            int allocSize = 0xA00000;
            used.add(new byte[allocSize]);
            freeMemory += (long)allocSize;
            ballastFreed = ballast.get() == null;
        } while ((reportedFree = Runtime.getRuntime().freeMemory()) >= 0x1400000L && !ballastFreed);
        ballast = null;
        if (!ballastFreed) {
            freeMemory += 0x1400000L;
        }
        used.clear();
        used = null;
        return freeMemory += reportedFree;
    }

    public static String toMB(long memory) {
        return String.format(MB_FORMAT, memory / 0x100000L);
    }

    public static boolean beginRequest(String reqType, SessionContext sessionContext) {
        if (!ResourceMonitor.isEnabled()) {
            return true;
        }
        return ResourceMonitor.getInstance().beginRequestImpl(reqType, sessionContext);
    }

    private boolean beginRequestImpl(String reqType, SessionContext sessionContext) {
        if (!this.getNormalState() && (reqType.equals("execute") || reqType.equals("validate") || reqType.equals("Metadata"))) {
            LOGGER.log(LogLevel.ERROR, "Rejecting request " + sessionContext.getIDSString() + " because the system is in OVERLOADED state");
            return false;
        }
        return true;
    }

    public static void endRequest(SessionContext sessionContext) {
        if (!ResourceMonitor.isEnabled()) {
            return;
        }
        ResourceMonitor.getInstance().endRequestImpl(sessionContext);
    }

    private void endRequestImpl(SessionContext sessionContext) {
    }

    public static void claimMemory(String reqId, long mem) {
        if (!ResourceMonitor.isEnabled()) {
            return;
        }
        ResourceMonitor.getInstance().claimMemoryImpl(reqId, mem);
    }

    private void claimMemoryImpl(String reqId, long mem) {
        long claimedMemory = this.mCurrentClaimedMemory.addAndGet(mem);
        long initialFreeMemory = this.getInitialFreeHeap();
        double percentUsed = new Double(claimedMemory) / new Double(initialFreeMemory);
        if (percentUsed >= 0.9) {
            ResourceMonitor.releaseMemory("", claimedMemory);
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format(NOT_ENOUGH_INITIAL_FREE_MEM, claimedMemory, initialFreeMemory));
        }
    }

    public static void releaseMemory(String reqId, long mem) {
        if (!ResourceMonitor.isEnabled()) {
            return;
        }
        ResourceMonitor.getInstance().releaseMemoryImpl(reqId, mem);
    }

    private void releaseMemoryImpl(String reqId, long mem) {
        this.mCurrentClaimedMemory.addAndGet(-mem);
    }

    private long getInitialFreeHeap() {
        return this.mWarmFreeHeap;
    }

    @Override
    public String getInitialFreeMemory() {
        return ResourceMonitor.toMB(this.getInitialFreeHeap());
    }

    @Override
    public String getCurrentClaimedMemory() {
        return ResourceMonitor.toMB(this.mCurrentClaimedMemory.get());
    }

    @Override
    public void artificallyReserveMemoryMB(int mem) {
        this.mArtificallyReservedMemoryBlocks.clear();
        this.mArtificallyReservedMemoryBlocks.ensureCapacity(mem);
        for (int i = 0; i < mem; ++i) {
            this.mArtificallyReservedMemoryBlocks.add(new byte[0x100000]);
        }
    }

    @Override
    public void cancelRequest(String reqID) {
    }

    @Override
    public String estimateFreeMemory() {
        return ResourceMonitor.toMB(ResourceMonitor.calcFreeMemory());
    }

    @Override
    public String getJVMMemorySize() {
        return ResourceMonitor.toMB(Runtime.getRuntime().maxMemory());
    }

    @Override
    public String getJVMFreeMemory() {
        return ResourceMonitor.toMB(Runtime.getRuntime().freeMemory());
    }

    @Override
    public String getArtificallyReservedMemory() {
        return String.format(MB_FORMAT, this.mArtificallyReservedMemoryBlocks.size());
    }

    public static boolean checkAvailableMemory(long mem) throws XQERuntimeException {
        if (!ResourceMonitor.isEnabled()) {
            return true;
        }
        if (mem >= mOverloadedMemoryThreshold) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format(NOT_ENOUGH_MEM, mem, Runtime.getRuntime().maxMemory(), mOverloadedMemoryThreshold));
        }
        return true;
    }

    public static boolean checkNumberOfDBQueries(int numberOfQueries) throws XQERuntimeException {
        if (!ResourceMonitor.isEnabled()) {
            return true;
        }
        if (numberOfQueries > mMaxQueries) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_MaxNumberOfSQLQueriesExcedded, numberOfQueries, (Object)mMaxQueries);
        }
        return true;
    }

    private static String onOff(boolean val) {
        if (val) {
            return "on";
        }
        return "off";
    }

    private static String getNotifMemState(MemoryUsage memUsage) {
        return String.format("notification heap info: max %s, used %s (%d%%), free %s (%d%%)", ResourceMonitor.toMB(memUsage.getMax()), ResourceMonitor.toMB(memUsage.getUsed()), ResourceMonitor.calcPercentage(memUsage.getUsed(), memUsage.getMax()), ResourceMonitor.toMB(memUsage.getMax() - memUsage.getUsed()), ResourceMonitor.calcPercentage(memUsage.getMax() - memUsage.getUsed(), memUsage.getMax()));
    }

    private String getGlobalMemState() {
        long freeMem = this.getGlobalFreeMemory();
        return String.format("heap size %s, used %s (%d%%), free %s (%d%%)", ResourceMonitor.toMB(mAjustedMaxMemory), ResourceMonitor.toMB(mAjustedMaxMemory - freeMem), ResourceMonitor.calcPercentage(mAjustedMaxMemory - freeMem, mAjustedMaxMemory), ResourceMonitor.toMB(freeMem), ResourceMonitor.calcPercentage(freeMem, mAjustedMaxMemory));
    }

    public static void checkMaxSetSize(long actualSize, QueryContext queryContext, IMessageKey.Param3 messageKey) throws XQERuntimeException {
        String queryName = null;
        boolean isInteractive = false;
        if (queryContext != null) {
            queryName = queryContext.getQueryName();
            isInteractive = queryContext.isInteractive();
        } else {
            queryName = "";
        }
        if (isInteractive) {
            ResourceMonitor.checkInteractiveSetSize(actualSize, queryName);
        } else {
            ResourceMonitor.checkMaxSetSize(actualSize, queryName, messageKey);
        }
    }

    private static void checkMaxSetSize(long actualSize, String queryName, IMessageKey.Param3 messageKey) throws XQERuntimeException {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        Integer maxCrossjoinOrderOfMagnatude = configuration.getIntegerProperty("qsMaxCrossjoinOrderOfMagnitude", 8);
        if (maxCrossjoinOrderOfMagnatude == 0) {
            return;
        }
        if (maxCrossjoinOrderOfMagnatude < 0 || maxCrossjoinOrderOfMagnatude > 10) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidMaxCrossjoinSetting);
        }
        if ((double)actualSize > Math.pow(10.0, maxCrossjoinOrderOfMagnatude.intValue())) {
            throw new XQERuntimeException(messageKey, (Object)queryName, (Object)maxCrossjoinOrderOfMagnatude, (Object)((double)Math.round(Math.log10(actualSize) * 10.0) / 10.0));
        }
    }

    private static void checkInteractiveSetSize(long actualSize, String queryName) throws XQERuntimeException {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        Integer interactiveCrossjoinOrderOfMagnatude = configuration.getIntegerProperty("qsMaxCrossjoinInteractiveOrderOfMagnitude", 5);
        if (interactiveCrossjoinOrderOfMagnatude == 0) {
            return;
        }
        if (interactiveCrossjoinOrderOfMagnatude < 0 || interactiveCrossjoinOrderOfMagnatude > 10) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidInteractiveCrossjoinSetting);
        }
        long allowableValue = (long)Math.pow(10.0, interactiveCrossjoinOrderOfMagnatude.intValue());
        if (actualSize > allowableValue) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidInteractiveCrossjoinSize, (Object)queryName, (Object)actualSize, (Object)allowableValue);
        }
    }

    private long getGlobalFreeMemory() {
        return mAjustedMaxMemory - Runtime.getRuntime().totalMemory() + this.getAdjustedFreeMemory();
    }

    private long getAdjustedFreeMemory() {
        long freeMemory = Runtime.getRuntime().freeMemory();
        if (mHardBallastSize > 0L && this.mHardBallast != null) {
            freeMemory += mHardBallastSize;
        }
        return freeMemory;
    }

    private static boolean getBooleanProperty(String name, boolean def) {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String propValue = System.getProperty(name);
        if (propValue == null) {
            return config.getBooleanProperty(name, def);
        }
        return Boolean.parseBoolean(propValue);
    }

    private static int getIntProperty(String name, int def, int min, int max) {
        int val;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String propValue = System.getProperty(name);
        try {
            val = propValue == null ? config.getIntProperty(name, def) : Integer.parseInt(propValue);
            if (val > max || val < min) {
                LOGGER.log(LogLevel.ERROR, String.format(PARAM_ERROR, name, propValue, min, max, def));
                val = def;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(LogLevel.ERROR, String.format(PARAM_ERROR, name, propValue, min, max, def));
            val = def;
        }
        return val;
    }

    private boolean isMemoryCritical() {
        long currentFreeMem = this.getGlobalFreeMemory();
        long currentUsedPct = ResourceMonitor.calcPercentage(mAjustedMaxMemory - currentFreeMem, mAjustedMaxMemory);
        return currentUsedPct >= (long)mOverloadedMemoryPercentage;
    }

    static {
        mBallastPercentage = 2;
        mEnableBalancedGC = true;
        mEnableOracleJVM = false;
        mGCIterations = 1;
        mGCRetryPeriod = 120;
        mCancelRampupPercentage = 30;
        mCancelDelay = 10;
        mMaxQueries = 100000;
        mHardBallastSize = 0L;
        singletonHelper = new SingletonHelper<ResourceMonitor>(){

            @Override
            protected ResourceMonitor newInstance() {
                return new ResourceMonitor();
            }

            @Override
            protected void initializeImpl(ResourceMonitor theInstance) {
                theInstance.initialize();
            }

            @Override
            protected void releaseImpl(ResourceMonitor theInstance) {
                theInstance.release();
            }
        };
    }

    private class MemoryStateChangeHandlerThread
    extends Thread
    implements IReleasable {
        private volatile boolean keepRunning;
        LinkedBlockingQueue<Boolean> normalStateChangeQueue;

        MemoryStateChangeHandlerThread() {
            super("ResourceMonitor-MemoryStateChangeHandlerThread");
            this.keepRunning = true;
            this.normalStateChangeQueue = new LinkedBlockingQueue();
            this.setPriority(10);
            this.setDaemon(true);
        }

        public void reportStateChange(boolean toNormal) {
            try {
                this.normalStateChangeQueue.put(toNormal);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private boolean drainQueue() {
            Boolean toNormalState;
            do {
                toNormalState = null;
                try {
                    toNormalState = this.normalStateChangeQueue.poll(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.keepRunning) continue;
                return true;
            } while (toNormalState == null);
            Boolean val = null;
            while ((val = this.normalStateChangeQueue.poll()) != null) {
                toNormalState = val;
            }
            return toNormalState;
        }

        @Override
        public void run() {
            boolean prevStateNormal = true;
            CancelStage cancelStage = CancelStage.HEAVIEST;
            while (this.keepRunning) {
                boolean toNormalState = this.drainQueue();
                if (!this.keepRunning) break;
                if (!toNormalState) {
                    if (prevStateNormal) {
                        ResourceMonitor.this.clearHardBallast();
                        this.clearCaches();
                        cancelStage = CancelStage.HEAVIEST;
                    }
                    cancelStage = ResourceMonitor.this.cancelRegisteredSessions(cancelStage, prevStateNormal);
                    if (prevStateNormal) {
                        ResourceMonitor.this.overloadedStateMonitorThread.setNudgeGC(true);
                    }
                } else if (!prevStateNormal) {
                    ResourceMonitor.this.overloadedStateMonitorThread.setNudgeGC(false);
                    ResourceMonitor.this.reserveHardBallast();
                }
                prevStateNormal = toNormalState;
            }
        }

        private void clearCaches() {
            if (mEnableCacheClearing) {
                LOGGER.log(LogLevel.INFO, "Clearing caches");
                ROLAPCubeManager.getInstance().clearCaches();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            this.keepRunning = false;
            try {
                MemoryStateChangeHandlerThread memoryStateChangeHandlerThread = this;
                synchronized (memoryStateChangeHandlerThread) {
                    this.notify();
                }
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class BallastMonitorThread
    extends Thread
    implements IReleasable {
        private static final long MAX_BALLAST_SIZE = 0x6400000L;
        private static final double BALLAST_SIZE_PERCENTAGE = 0.01;
        private SoftReference<byte[]> memoryLimitBallast;
        private ReferenceQueue<byte[]> ballastQueue;
        private volatile boolean keepRunning;
        private long ballastSize;

        BallastMonitorThread() {
            super("ResourceMonitor-BallastThread");
            this.ballastQueue = new ReferenceQueue();
            this.keepRunning = true;
            this.setDaemon(true);
            this.ballastSize = Math.round((double)Runtime.getRuntime().maxMemory() * 0.01);
            if (this.ballastSize > 0x6400000L) {
                this.ballastSize = 0x6400000L;
            }
        }

        public long getBallastSize() {
            return this.ballastSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            this.keepRunning = false;
            try {
                BallastMonitorThread ballastMonitorThread = this;
                synchronized (ballastMonitorThread) {
                    this.notify();
                }
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.memoryLimitBallast = null;
        }

        private boolean acquireBallast() {
            try {
                this.memoryLimitBallast = new SoftReference<byte[]>(new byte[(int)this.ballastSize], this.ballastQueue);
                LOGGER.log(LogLevel.ERROR, String.format("Allocated ballast of size %s (%s)", ResourceMonitor.toMB(this.ballastSize), ResourceMonitor.this.getGlobalMemState()));
            }
            catch (OutOfMemoryError e) {
                LOGGER.log(LogLevel.ERROR, "We ran out of memory when trying to allocate ballast of " + this.ballastSize / 0x100000L + " Mb, but this error and core dump can be ignored", (Throwable)e);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!ResourceMonitor.isEnabled()) {
                return;
            }
            while (this.keepRunning) {
                while (!this.acquireBallast()) {
                    try {
                        BallastMonitorThread ballastMonitorThread = this;
                        synchronized (ballastMonitorThread) {
                            this.wait(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.keepRunning) continue;
                    return;
                }
                Reference<byte[]> ballast = null;
                while (ballast == null) {
                    try {
                        ballast = this.ballastQueue.remove(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.keepRunning) continue;
                    return;
                }
                LOGGER.log(LogLevel.ERROR, String.format("Ballast was released (%s)", ResourceMonitor.this.getGlobalMemState()));
                ResourceMonitor.this.setNormalState(false);
                while (!ResourceMonitor.this.isNormalState()) {
                    try {
                        BallastMonitorThread ballastMonitorThread = this;
                        synchronized (ballastMonitorThread) {
                            this.wait(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.keepRunning) continue;
                    return;
                }
            }
        }
    }

    private class OverloadedStateMonitorThread
    extends Thread
    implements IReleasable {
        private volatile boolean keepRunning;
        private volatile boolean nudgeGC;
        private int nudgeSleepCount;

        OverloadedStateMonitorThread() {
            super("ResourceMonitor-CriticalStateMonitorThread");
            this.keepRunning = true;
            this.nudgeGC = false;
            this.setDaemon(true);
        }

        public void setNudgeGC(boolean nudge) {
            this.nudgeGC = nudge;
            if (nudge) {
                this.nudgeSleepCount = mGCRetryPeriod;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.keepRunning) {
                try {
                    OverloadedStateMonitorThread overloadedStateMonitorThread = this;
                    synchronized (overloadedStateMonitorThread) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.keepRunning) {
                    return;
                }
                if (!ResourceMonitor.this.isNormalState() && !ResourceMonitor.this.isMemoryCritical()) {
                    LOGGER.log(LogLevel.ERROR, String.format("Memory has reached normal levels before receiving GC notification, changing state to NORMAL (%s)", ResourceMonitor.this.getGlobalMemState()));
                    ResourceMonitor.this.setNormalState(true);
                }
                if (!this.nudgeGC) continue;
                --this.nudgeSleepCount;
                if (this.nudgeSleepCount != 0) continue;
                this.nudgeSleepCount = mGCRetryPeriod;
                if (!mEnableGC) continue;
                LOGGER.log(LogLevel.ERROR, String.format("The server has been in OVERLOADED state for at least %,d sec, requesting garbage collection (%s)", TimeUnit.MILLISECONDS.toSeconds(1000L * (long)mGCRetryPeriod), ResourceMonitor.this.getGlobalMemState()));
                ResourceMonitor.gc();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            this.keepRunning = false;
            try {
                OverloadedStateMonitorThread overloadedStateMonitorThread = this;
                synchronized (overloadedStateMonitorThread) {
                    this.notify();
                }
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static enum CancelStage {
        HEAVIEST,
        HEAVY,
        REMAINING;

    }
}

