/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.pool;

import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.SoftReferenceObjectPool;

public final class XQESAXParserPool {
    private static final String SAX_VALIDATION_NAMESPACE = "http://xml.org/sax/features/validation";
    private static final String STATUS_MSG_FRAGMENT = ", # of idle: ";
    private static final String NEW_LINE = "\n";
    private static XQESAXParserPool instance = new XQESAXParserPool();
    private ObjectPool saxParserPool = new SoftReferenceObjectPool((PoolableObjectFactory)new SAXParserPoolableFactory());

    private XQESAXParserPool() {
    }

    public static XQESAXParserPool getInstance() {
        return instance;
    }

    public SAXParser borrowParser() throws Exception {
        return (SAXParser)this.saxParserPool.borrowObject();
    }

    public SAXParser borrowValidatingParser() throws Exception {
        SAXParser aParser = (SAXParser)this.saxParserPool.borrowObject();
        aParser.getXMLReader().setFeature(SAX_VALIDATION_NAMESPACE, true);
        return aParser;
    }

    public void returnParser(SAXParser aParser) throws Exception {
        aParser.getXMLReader().setFeature(SAX_VALIDATION_NAMESPACE, false);
        this.saxParserPool.returnObject((Object)aParser);
    }

    public void clear() throws Exception {
        this.saxParserPool.clear();
    }

    public void showStatus(Writer aWriter) throws IOException {
        aWriter.write(NEW_LINE);
        aWriter.write("SAXParser pool ->\t# in use: ");
        aWriter.write(String.valueOf(this.saxParserPool.getNumActive()));
        aWriter.write(STATUS_MSG_FRAGMENT);
        aWriter.write(String.valueOf(this.saxParserPool.getNumIdle()));
        aWriter.write(NEW_LINE);
        aWriter.flush();
    }

    private static class SAXParserPoolableFactory
    implements PoolableObjectFactory {
        private static SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();

        private SAXParserPoolableFactory() {
        }

        public void activateObject(Object arg0) throws Exception {
        }

        public void destroyObject(Object arg0) throws Exception {
        }

        public Object makeObject() throws Exception {
            return saxParserFactory.newSAXParser();
        }

        public void passivateObject(Object arg0) throws Exception {
        }

        public boolean validateObject(Object arg0) {
            return true;
        }
    }
}

