/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.pool;

import java.lang.ref.SoftReference;

public class XQESoftLongPool {
    private static final int NUM_BLOCKS = 1000;
    private static final int BLOCK_SIZE = 1000;
    public static final long SIZE = 1000000L;
    private static volatile SoftBlock[] pool = new SoftBlock[1000];

    public static Long getLong(long value) {
        if (value >= 1000000L || value < 0L) {
            return new Long(value);
        }
        Long[] block = null;
        int key = (int)value / 1000;
        SoftBlock softRef = pool[key];
        if (softRef != null && (block = (Long[])softRef.get()) != null) {
            return block[(int)value % 1000];
        }
        block = new Long[1000];
        long start = key * 1000;
        for (int i = 0; i < 1000; ++i) {
            block[i] = new Long(start + (long)i);
        }
        XQESoftLongPool.pool[key] = new SoftBlock(block, key);
        return block[(int)value % 1000];
    }

    private static final class SoftBlock
    extends SoftReference {
        private final int key;

        private SoftBlock(Long[] k, int keyValue) {
            super(k);
            this.key = keyValue;
        }
    }
}

