/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive;

import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.primitive.ByteList;
import java.util.Arrays;

public class ByteArrayList
implements ByteList {
    private int elementCount;
    private byte[] elements;
    private static final int MAX_ARRAY_INDEX = 0x7FFFFFFA;
    private static final int CHUNK_SIZE = 0x8000000;
    private static final String CAPACITY_EXCEEDS_MSG_FORMAT = "Requested capacity %d exceeds the maximum allowed size %d.";

    public ByteArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException(String.format("The capacity is invalid: %d.  It must be >= 0.", capacity));
        }
        if (capacity > 0x7FFFFFFB) {
            throw new IllegalArgumentException(String.format(CAPACITY_EXCEEDS_MSG_FORMAT, capacity, 0x7FFFFFFB));
        }
        this.elements = new byte[capacity];
    }

    @Override
    public void add(byte element) {
        this.ensureCapacity(this.elementCount + 1);
        this.elements[this.elementCount++] = element;
    }

    public void add(byte[] element) {
        this.ensureCapacity(this.elementCount + element.length);
        System.arraycopy(element, 0, this.elements, this.elementCount, element.length);
        this.elementCount += element.length;
    }

    @Override
    public void pad(byte element, int size) {
        if (this.elementCount >= size) {
            return;
        }
        this.ensureCapacity(size);
        Arrays.fill(this.elements, this.elementCount, size, element);
        this.elementCount = size;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public byte[] toArray() {
        byte[] arrayToReturn = new byte[this.elementCount];
        System.arraycopy(this.elements, 0, arrayToReturn, 0, this.elementCount);
        return arrayToReturn;
    }

    public byte get(int index) {
        return this.elements[index];
    }

    public byte[] get(int index, int numBytes, byte[] output) {
        if (output == null || output.length < numBytes) {
            output = new byte[numBytes];
        }
        System.arraycopy(this.elements, index, output, 0, numBytes);
        return output;
    }

    public byte set(int index, byte newValue) {
        byte origValue = this.elements[index];
        this.elements[index] = newValue;
        return origValue;
    }

    public byte[] set(int index, byte[] bytes, byte[] output) {
        this.ensureCapacity(index + bytes.length);
        output = this.get(index, bytes.length, output);
        System.arraycopy(bytes, 0, this.elements, index, bytes.length);
        return output;
    }

    public void trim() {
        if (this.elementCount != this.elements.length) {
            byte[] newElements = new byte[this.elementCount];
            System.arraycopy(this.elements, 0, newElements, 0, this.elementCount);
            this.elements = newElements;
        }
    }

    private void ensureCapacity(int capacity) {
        if (this.elements.length < capacity) {
            if (capacity > 0x7FFFFFFB) {
                throw new IllegalArgumentException(String.format(CAPACITY_EXCEEDS_MSG_FORMAT, capacity, 0x7FFFFFFB));
            }
            int inflateTo = 0;
            inflateTo = this.elements.length < 0x1FFFFFFE ? this.elements.length << 1 : (this.elements.length < 0x77FFFFFA ? this.elements.length + 0x8000000 : 0x7FFFFFFB);
            int newCapacity = Math.max(capacity, inflateTo);
            XQEDebugLog.out.printf("Inflate array from %d to %d elements real %d\n", this.elements.length, inflateTo, newCapacity);
            byte[] newElements = new byte[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
            this.elements = newElements;
        }
    }

    public long estimateMemoryUsage() {
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectShallowSize(this.getClass());
        return estimatedSize += JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(1, this.elements.length);
    }
}

