/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive;

import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.primitive.IteratorInt;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;

public class HashMapIntObject<V> {
    private static final int TINT_OBJECT_HASH_MAP_SMALL_SIZE = 128;
    private static final double TINT_OBJECT_HASH_MAP_SMALL_SIZE_MULTIPLIER = 3.0;
    private static final double TINT_OBJECT_HASH_MAP_LARGE_SIZE_MULTIPLIER = 2.25;
    private final TIntObjectHashMap<V> intToObjectHashMap;

    public HashMapIntObject() {
        this.intToObjectHashMap = new TIntObjectHashMap();
    }

    public HashMapIntObject(int initialCapacity) {
        this.intToObjectHashMap = new TIntObjectHashMap(initialCapacity);
    }

    public V put(int key, V value) {
        return (V)this.intToObjectHashMap.put(key, value);
    }

    public V get(int key) {
        return (V)this.intToObjectHashMap.get(key);
    }

    public void remove(int key) {
        this.intToObjectHashMap.remove(key);
    }

    public boolean containsKey(int key) {
        return this.intToObjectHashMap.containsKey(key);
    }

    public boolean isEmpty() {
        return this.intToObjectHashMap.isEmpty();
    }

    public int size() {
        return this.intToObjectHashMap.size();
    }

    public void clear() {
        this.intToObjectHashMap.clear();
    }

    public String toString() {
        return this.intToObjectHashMap.toString();
    }

    public IteratorInt keySetIterator() {
        return new IteratorInt(this.intToObjectHashMap.keySet().iterator());
    }

    public Collection<V> values() {
        return this.intToObjectHashMap.valueCollection();
    }

    public long estimateMemoryUsage() {
        return HashMapIntObject.estimateMemoryUsage(this.size());
    }

    public static long estimateMemoryUsage(int hashMapIntObjectSize) {
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectShallowSize(HashMapIntObject.class);
        return estimatedSize += HashMapIntObject.estimateMemoryUsageOfIntToObjectHashMap(hashMapIntObjectSize);
    }

    private static long estimateMemoryUsageOfIntToObjectHashMap(int hashMapIntObjectSize) {
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectShallowSize(TIntObjectHashMap.class);
        double hashMapIntObjectSizeMultiplier = 0.0;
        hashMapIntObjectSizeMultiplier = hashMapIntObjectSize <= 128 ? 3.0 : 2.25;
        long tIntObjectHashMapCapacity = (long)Math.ceil((double)hashMapIntObjectSize * hashMapIntObjectSizeMultiplier);
        long tIntObjectHashMapFieldValuesSize = JavaObjectMemorySize.getEstimatedJavaObjectArraySize(tIntObjectHashMapCapacity);
        estimatedSize += tIntObjectHashMapFieldValuesSize;
        long tIntObjectHashMapFieldSetSize = JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(4, tIntObjectHashMapCapacity);
        estimatedSize += tIntObjectHashMapFieldSetSize;
        long tIntObjectHashMapFieldStatesSize = JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(1, tIntObjectHashMapCapacity);
        return estimatedSize += tIntObjectHashMapFieldStatesSize;
    }
}

