/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.primitive;

import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.primitive.ShortList;
import java.util.Arrays;

public class ShortArrayList
implements ShortList {
    private int elementCount;
    private short[] elements;
    private static final int MAX_ARRAY_INDEX = 0x7FFFFFFA;
    private static final int CHUNK_SIZE = 0x8000000;
    private static final String CAPACITY_EXCEEDS_MSG_FORMAT = "Requested capacity %d exceeds the maximum allowed size %d.";

    public ShortArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException(String.format("The capacity is invalid: %d.  It must be >= 0.", capacity));
        }
        if (capacity > 0x7FFFFFFB) {
            throw new IllegalArgumentException(String.format(CAPACITY_EXCEEDS_MSG_FORMAT, capacity, 0x7FFFFFFB));
        }
        this.elements = new short[capacity];
    }

    @Override
    public void add(short element) {
        this.ensureCapacity(this.elementCount + 1);
        this.elements[this.elementCount++] = element;
    }

    @Override
    public void pad(short element, int size) {
        if (this.elementCount >= size) {
            return;
        }
        this.ensureCapacity(size);
        Arrays.fill(this.elements, this.elementCount, size, element);
        this.elementCount = size;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public short[] toArray() {
        short[] arrayToReturn = new short[this.elementCount];
        System.arraycopy(this.elements, 0, arrayToReturn, 0, this.elementCount);
        return arrayToReturn;
    }

    public short get(int index) {
        return this.elements[index];
    }

    public short set(int index, short newValue) {
        short origValue = this.elements[index];
        this.elements[index] = newValue;
        return origValue;
    }

    public void trim() {
        if (this.elementCount != this.elements.length) {
            short[] newElements = new short[this.elementCount];
            System.arraycopy(this.elements, 0, newElements, 0, this.elementCount);
            this.elements = newElements;
        }
    }

    private void ensureCapacity(int capacity) {
        if (this.elements.length < capacity) {
            if (capacity > 0x7FFFFFFB) {
                throw new IllegalArgumentException(String.format(CAPACITY_EXCEEDS_MSG_FORMAT, capacity, 0x7FFFFFFB));
            }
            int inflateTo = 0;
            inflateTo = this.elements.length < 0x1FFFFFFE ? this.elements.length << 1 : (this.elements.length < 0x77FFFFFA ? this.elements.length + 0x8000000 : 0x7FFFFFFB);
            int newCapacity = Math.max(capacity, inflateTo);
            XQEDebugLog.out.printf("Inflate array from %d to %d elements real %d\n", this.elements.length, inflateTo, newCapacity);
            short[] newElements = new short[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
            this.elements = newElements;
        }
    }

    public long estimateMemoryUsage() {
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectShallowSize(this.getClass());
        return estimatedSize += JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(2, this.elements.length);
    }
}

